# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.auth_context import AuthContext
from solomonai_backend_client_sdk.models.auth_error_code import AuthErrorCode
from solomonai_backend_client_sdk.models.error_response import ErrorResponse
from solomonai_backend_client_sdk.models.mfa_info import MFAInfo
from solomonai_backend_client_sdk.models.session_info import SessionInfo
from solomonai_backend_client_sdk.models.token_info import TokenInfo
from typing import Optional, Set
from typing_extensions import Self

class AuthenticationErrorMessageResponse(BaseModel):
    """
    Represents authentication and authorization failures
    """ # noqa: E501
    code: Optional[AuthErrorCode] = AuthErrorCode.NO_AUTH_ERROR
    message: Optional[StrictStr] = None
    token_info: Optional[TokenInfo] = Field(default=None, alias="tokenInfo")
    auth_context: Optional[AuthContext] = Field(default=None, alias="authContext")
    session_info: Optional[SessionInfo] = Field(default=None, alias="sessionInfo")
    mfa_info: Optional[MFAInfo] = Field(default=None, alias="mfaInfo")
    error_response: Optional[ErrorResponse] = Field(default=None, alias="errorResponse")
    __properties: ClassVar[List[str]] = ["code", "message", "tokenInfo", "authContext", "sessionInfo", "mfaInfo", "errorResponse"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuthenticationErrorMessageResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of token_info
        if self.token_info:
            _dict['tokenInfo'] = self.token_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of auth_context
        if self.auth_context:
            _dict['authContext'] = self.auth_context.to_dict()
        # override the default output from pydantic by calling `to_dict()` of session_info
        if self.session_info:
            _dict['sessionInfo'] = self.session_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mfa_info
        if self.mfa_info:
            _dict['mfaInfo'] = self.mfa_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of error_response
        if self.error_response:
            _dict['errorResponse'] = self.error_response.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuthenticationErrorMessageResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "code": obj.get("code") if obj.get("code") is not None else AuthErrorCode.NO_AUTH_ERROR,
            "message": obj.get("message"),
            "tokenInfo": TokenInfo.from_dict(obj["tokenInfo"]) if obj.get("tokenInfo") is not None else None,
            "authContext": AuthContext.from_dict(obj["authContext"]) if obj.get("authContext") is not None else None,
            "sessionInfo": SessionInfo.from_dict(obj["sessionInfo"]) if obj.get("sessionInfo") is not None else None,
            "mfaInfo": MFAInfo.from_dict(obj["mfaInfo"]) if obj.get("mfaInfo") is not None else None,
            "errorResponse": ErrorResponse.from_dict(obj["errorResponse"]) if obj.get("errorResponse") is not None else None
        })
        return _obj


