# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.actor_type import ActorType
from solomonai_backend_client_sdk.models.audit_event_type import AuditEventType
from solomonai_backend_client_sdk.models.entity_type import EntityType
from solomonai_backend_client_sdk.models.severity_level import SeverityLevel
from typing import Optional, Set
from typing_extensions import Self

class AuditLog(BaseModel):
    """
    AuditLog
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the audit log event.")
    actor_type: Optional[ActorType] = Field(default=ActorType.UNSPECIFIED, alias="actorType")
    event_type: Optional[AuditEventType] = Field(default=AuditEventType.UNSPECIFIED, alias="eventType")
    entity_type: Optional[EntityType] = Field(default=EntityType.UNSPECIFIED, alias="entityType")
    entity_id: Optional[StrictStr] = Field(default=None, description="ID of the entity affected.", alias="entityId")
    change_summary: Optional[Dict[str, Any]] = Field(default=None, description="Summary of the changes in structured format.", alias="changeSummary")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Additional metadata in structured format.")
    ip_address: Optional[StrictStr] = Field(default=None, description="IP address from where the action was performed.", alias="ipAddress")
    user_agent: Optional[StrictStr] = Field(default=None, description="User agent string.", alias="userAgent")
    geo_location: Optional[StrictStr] = Field(default=None, description="Geolocation information.", alias="geoLocation")
    session_id: Optional[StrictStr] = Field(default=None, description="Session ID associated with the action.", alias="sessionId")
    created_at: Optional[datetime] = Field(default=None, description="Timestamp when the log was created.", alias="createdAt")
    severity: Optional[SeverityLevel] = SeverityLevel.UNSPECIFIED
    request_id: Optional[StrictStr] = Field(default=None, description="Unique request ID for correlating logs.", alias="requestId")
    device_info: Optional[StrictStr] = Field(default=None, description="Device information from where the action was performed.", alias="deviceInfo")
    platform: Optional[StrictStr] = Field(default=None, description="Platform or OS of the device.")
    user_account_actor_auth0_user_id: Optional[StrictStr] = Field(default=None, description="Actor (could be UserAccount or BusinessAccount based on actor_type).", alias="userAccountActorAuth0UserId")
    business_account_actor_auth0_user_id: Optional[StrictStr] = Field(default=None, alias="businessAccountActorAuth0UserId")
    team_actor_auth0_user_id: Optional[StrictStr] = Field(default=None, alias="teamActorAuth0UserId")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "actorType", "eventType", "entityType", "entityId", "changeSummary", "metadata", "ipAddress", "userAgent", "geoLocation", "sessionId", "createdAt", "severity", "requestId", "deviceInfo", "platform", "userAccountActorAuth0UserId", "businessAccountActorAuth0UserId", "teamActorAuth0UserId", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuditLog from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuditLog from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "actorType": obj.get("actorType") if obj.get("actorType") is not None else ActorType.UNSPECIFIED,
            "eventType": obj.get("eventType") if obj.get("eventType") is not None else AuditEventType.UNSPECIFIED,
            "entityType": obj.get("entityType") if obj.get("entityType") is not None else EntityType.UNSPECIFIED,
            "entityId": obj.get("entityId"),
            "changeSummary": obj.get("changeSummary"),
            "metadata": obj.get("metadata"),
            "ipAddress": obj.get("ipAddress"),
            "userAgent": obj.get("userAgent"),
            "geoLocation": obj.get("geoLocation"),
            "sessionId": obj.get("sessionId"),
            "createdAt": obj.get("createdAt"),
            "severity": obj.get("severity") if obj.get("severity") is not None else SeverityLevel.UNSPECIFIED,
            "requestId": obj.get("requestId"),
            "deviceInfo": obj.get("deviceInfo"),
            "platform": obj.get("platform"),
            "userAccountActorAuth0UserId": obj.get("userAccountActorAuth0UserId"),
            "businessAccountActorAuth0UserId": obj.get("businessAccountActorAuth0UserId"),
            "teamActorAuth0UserId": obj.get("teamActorAuth0UserId"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


