# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBytes, StrictInt, StrictStr, field_validator
from typing import Optional, Union
from typing_extensions import Annotated
from solomonai_backend_client_sdk.models.workspaceservicehttp_file_upload_response import WorkspaceservicehttpFileUploadResponse
from solomonai_backend_client_sdk.models.workspaceservicehttp_tus_response import WorkspaceservicehttpTusResponse

from solomonai_backend_client_sdk.api_client import ApiClient, RequestSerialized
from solomonai_backend_client_sdk.api_response import ApiResponse
from solomonai_backend_client_sdk.rest import RESTResponseType


class WorkspaceServiceRestApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def workspace_microservice_rest_api_v1_file_resumable_id_delete(
        self,
        tus_resumable: Annotated[StrictStr, Field(description="TUS protocol version (must be 1.0.0)")],
        grpc_metadata_x_organization_id: Annotated[StrictStr, Field(description="Unique identifier for the organization making the request")],
        grpc_metadata_x_tenant_id: Annotated[StrictStr, Field(description="Unique identifier for the tenant within the organization")],
        grpc_metadata_x_user_id: Annotated[StrictStr, Field(description="Unique identifier for the user performing the upload")],
        grpc_metadata_x_workspace_id: Annotated[StrictStr, Field(description="Unique identifier for the workspace where the file will be stored")],
        grpc_metadata_x_folder_id: Annotated[StrictStr, Field(description="Unique identifier for the folder within the workspace")],
        upload_metadata: Annotated[StrictStr, Field(description="Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId)")],
        id: Annotated[StrictStr, Field(description="Upload ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> WorkspaceservicehttpTusResponse:
        """Delete an incomplete or completed file upload


        :param tus_resumable: TUS protocol version (must be 1.0.0) (required)
        :type tus_resumable: str
        :param grpc_metadata_x_organization_id: Unique identifier for the organization making the request (required)
        :type grpc_metadata_x_organization_id: str
        :param grpc_metadata_x_tenant_id: Unique identifier for the tenant within the organization (required)
        :type grpc_metadata_x_tenant_id: str
        :param grpc_metadata_x_user_id: Unique identifier for the user performing the upload (required)
        :type grpc_metadata_x_user_id: str
        :param grpc_metadata_x_workspace_id: Unique identifier for the workspace where the file will be stored (required)
        :type grpc_metadata_x_workspace_id: str
        :param grpc_metadata_x_folder_id: Unique identifier for the folder within the workspace (required)
        :type grpc_metadata_x_folder_id: str
        :param upload_metadata: Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId) (required)
        :type upload_metadata: str
        :param id: Upload ID (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._workspace_microservice_rest_api_v1_file_resumable_id_delete_serialize(
            tus_resumable=tus_resumable,
            grpc_metadata_x_organization_id=grpc_metadata_x_organization_id,
            grpc_metadata_x_tenant_id=grpc_metadata_x_tenant_id,
            grpc_metadata_x_user_id=grpc_metadata_x_user_id,
            grpc_metadata_x_workspace_id=grpc_metadata_x_workspace_id,
            grpc_metadata_x_folder_id=grpc_metadata_x_folder_id,
            upload_metadata=upload_metadata,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': "WorkspaceservicehttpTusResponse",
            '401': "WorkspaceservicehttpErrorResponse",
            '403': "WorkspaceservicehttpErrorResponse",
            '404': "WorkspaceservicehttpErrorResponse",
            '412': "WorkspaceservicehttpErrorResponse",
            '422': "WorkspaceservicehttpErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def workspace_microservice_rest_api_v1_file_resumable_id_delete_with_http_info(
        self,
        tus_resumable: Annotated[StrictStr, Field(description="TUS protocol version (must be 1.0.0)")],
        grpc_metadata_x_organization_id: Annotated[StrictStr, Field(description="Unique identifier for the organization making the request")],
        grpc_metadata_x_tenant_id: Annotated[StrictStr, Field(description="Unique identifier for the tenant within the organization")],
        grpc_metadata_x_user_id: Annotated[StrictStr, Field(description="Unique identifier for the user performing the upload")],
        grpc_metadata_x_workspace_id: Annotated[StrictStr, Field(description="Unique identifier for the workspace where the file will be stored")],
        grpc_metadata_x_folder_id: Annotated[StrictStr, Field(description="Unique identifier for the folder within the workspace")],
        upload_metadata: Annotated[StrictStr, Field(description="Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId)")],
        id: Annotated[StrictStr, Field(description="Upload ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[WorkspaceservicehttpTusResponse]:
        """Delete an incomplete or completed file upload


        :param tus_resumable: TUS protocol version (must be 1.0.0) (required)
        :type tus_resumable: str
        :param grpc_metadata_x_organization_id: Unique identifier for the organization making the request (required)
        :type grpc_metadata_x_organization_id: str
        :param grpc_metadata_x_tenant_id: Unique identifier for the tenant within the organization (required)
        :type grpc_metadata_x_tenant_id: str
        :param grpc_metadata_x_user_id: Unique identifier for the user performing the upload (required)
        :type grpc_metadata_x_user_id: str
        :param grpc_metadata_x_workspace_id: Unique identifier for the workspace where the file will be stored (required)
        :type grpc_metadata_x_workspace_id: str
        :param grpc_metadata_x_folder_id: Unique identifier for the folder within the workspace (required)
        :type grpc_metadata_x_folder_id: str
        :param upload_metadata: Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId) (required)
        :type upload_metadata: str
        :param id: Upload ID (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._workspace_microservice_rest_api_v1_file_resumable_id_delete_serialize(
            tus_resumable=tus_resumable,
            grpc_metadata_x_organization_id=grpc_metadata_x_organization_id,
            grpc_metadata_x_tenant_id=grpc_metadata_x_tenant_id,
            grpc_metadata_x_user_id=grpc_metadata_x_user_id,
            grpc_metadata_x_workspace_id=grpc_metadata_x_workspace_id,
            grpc_metadata_x_folder_id=grpc_metadata_x_folder_id,
            upload_metadata=upload_metadata,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': "WorkspaceservicehttpTusResponse",
            '401': "WorkspaceservicehttpErrorResponse",
            '403': "WorkspaceservicehttpErrorResponse",
            '404': "WorkspaceservicehttpErrorResponse",
            '412': "WorkspaceservicehttpErrorResponse",
            '422': "WorkspaceservicehttpErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def workspace_microservice_rest_api_v1_file_resumable_id_delete_without_preload_content(
        self,
        tus_resumable: Annotated[StrictStr, Field(description="TUS protocol version (must be 1.0.0)")],
        grpc_metadata_x_organization_id: Annotated[StrictStr, Field(description="Unique identifier for the organization making the request")],
        grpc_metadata_x_tenant_id: Annotated[StrictStr, Field(description="Unique identifier for the tenant within the organization")],
        grpc_metadata_x_user_id: Annotated[StrictStr, Field(description="Unique identifier for the user performing the upload")],
        grpc_metadata_x_workspace_id: Annotated[StrictStr, Field(description="Unique identifier for the workspace where the file will be stored")],
        grpc_metadata_x_folder_id: Annotated[StrictStr, Field(description="Unique identifier for the folder within the workspace")],
        upload_metadata: Annotated[StrictStr, Field(description="Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId)")],
        id: Annotated[StrictStr, Field(description="Upload ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete an incomplete or completed file upload


        :param tus_resumable: TUS protocol version (must be 1.0.0) (required)
        :type tus_resumable: str
        :param grpc_metadata_x_organization_id: Unique identifier for the organization making the request (required)
        :type grpc_metadata_x_organization_id: str
        :param grpc_metadata_x_tenant_id: Unique identifier for the tenant within the organization (required)
        :type grpc_metadata_x_tenant_id: str
        :param grpc_metadata_x_user_id: Unique identifier for the user performing the upload (required)
        :type grpc_metadata_x_user_id: str
        :param grpc_metadata_x_workspace_id: Unique identifier for the workspace where the file will be stored (required)
        :type grpc_metadata_x_workspace_id: str
        :param grpc_metadata_x_folder_id: Unique identifier for the folder within the workspace (required)
        :type grpc_metadata_x_folder_id: str
        :param upload_metadata: Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId) (required)
        :type upload_metadata: str
        :param id: Upload ID (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._workspace_microservice_rest_api_v1_file_resumable_id_delete_serialize(
            tus_resumable=tus_resumable,
            grpc_metadata_x_organization_id=grpc_metadata_x_organization_id,
            grpc_metadata_x_tenant_id=grpc_metadata_x_tenant_id,
            grpc_metadata_x_user_id=grpc_metadata_x_user_id,
            grpc_metadata_x_workspace_id=grpc_metadata_x_workspace_id,
            grpc_metadata_x_folder_id=grpc_metadata_x_folder_id,
            upload_metadata=upload_metadata,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': "WorkspaceservicehttpTusResponse",
            '401': "WorkspaceservicehttpErrorResponse",
            '403': "WorkspaceservicehttpErrorResponse",
            '404': "WorkspaceservicehttpErrorResponse",
            '412': "WorkspaceservicehttpErrorResponse",
            '422': "WorkspaceservicehttpErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _workspace_microservice_rest_api_v1_file_resumable_id_delete_serialize(
        self,
        tus_resumable,
        grpc_metadata_x_organization_id,
        grpc_metadata_x_tenant_id,
        grpc_metadata_x_user_id,
        grpc_metadata_x_workspace_id,
        grpc_metadata_x_folder_id,
        upload_metadata,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        if tus_resumable is not None:
            _header_params['Tus-Resumable'] = tus_resumable
        if grpc_metadata_x_organization_id is not None:
            _header_params['Grpc-Metadata-X-Organization-ID'] = grpc_metadata_x_organization_id
        if grpc_metadata_x_tenant_id is not None:
            _header_params['Grpc-Metadata-X-Tenant-ID'] = grpc_metadata_x_tenant_id
        if grpc_metadata_x_user_id is not None:
            _header_params['Grpc-Metadata-X-User-ID'] = grpc_metadata_x_user_id
        if grpc_metadata_x_workspace_id is not None:
            _header_params['Grpc-Metadata-X-Workspace-ID'] = grpc_metadata_x_workspace_id
        if grpc_metadata_x_folder_id is not None:
            _header_params['Grpc-Metadata-X-Folder-ID'] = grpc_metadata_x_folder_id
        if upload_metadata is not None:
            _header_params['Upload-Metadata'] = upload_metadata
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/workspace-microservice/rest-api/v1/file/resumable/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def workspace_microservice_rest_api_v1_file_resumable_id_patch(
        self,
        tus_resumable: Annotated[StrictStr, Field(description="TUS protocol version (must be 1.0.0)")],
        grpc_metadata_x_organization_id: Annotated[StrictStr, Field(description="Unique identifier for the organization making the request")],
        grpc_metadata_x_tenant_id: Annotated[StrictStr, Field(description="Unique identifier for the tenant within the organization")],
        grpc_metadata_x_user_id: Annotated[StrictStr, Field(description="Unique identifier for the user performing the upload")],
        grpc_metadata_x_workspace_id: Annotated[StrictStr, Field(description="Unique identifier for the workspace where the file will be stored")],
        grpc_metadata_x_folder_id: Annotated[StrictStr, Field(description="Unique identifier for the folder within the workspace")],
        upload_offset: Annotated[int, Field(strict=True, ge=0, description="Current byte offset for the upload")],
        content_length: Annotated[int, Field(strict=True, ge=1, description="Length of the chunk being uploaded")],
        upload_metadata: Annotated[StrictStr, Field(description="Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId)")],
        id: Annotated[StrictStr, Field(description="Upload ID")],
        upload_checksum: Annotated[Optional[StrictStr], Field(description="Checksum of the current chunk")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> WorkspaceservicehttpTusResponse:
        """Upload chunks to an existing file upload using the TUS protocol


        :param tus_resumable: TUS protocol version (must be 1.0.0) (required)
        :type tus_resumable: str
        :param grpc_metadata_x_organization_id: Unique identifier for the organization making the request (required)
        :type grpc_metadata_x_organization_id: str
        :param grpc_metadata_x_tenant_id: Unique identifier for the tenant within the organization (required)
        :type grpc_metadata_x_tenant_id: str
        :param grpc_metadata_x_user_id: Unique identifier for the user performing the upload (required)
        :type grpc_metadata_x_user_id: str
        :param grpc_metadata_x_workspace_id: Unique identifier for the workspace where the file will be stored (required)
        :type grpc_metadata_x_workspace_id: str
        :param grpc_metadata_x_folder_id: Unique identifier for the folder within the workspace (required)
        :type grpc_metadata_x_folder_id: str
        :param upload_offset: Current byte offset for the upload (required)
        :type upload_offset: int
        :param content_length: Length of the chunk being uploaded (required)
        :type content_length: int
        :param upload_metadata: Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId) (required)
        :type upload_metadata: str
        :param id: Upload ID (required)
        :type id: str
        :param upload_checksum: Checksum of the current chunk
        :type upload_checksum: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._workspace_microservice_rest_api_v1_file_resumable_id_patch_serialize(
            tus_resumable=tus_resumable,
            grpc_metadata_x_organization_id=grpc_metadata_x_organization_id,
            grpc_metadata_x_tenant_id=grpc_metadata_x_tenant_id,
            grpc_metadata_x_user_id=grpc_metadata_x_user_id,
            grpc_metadata_x_workspace_id=grpc_metadata_x_workspace_id,
            grpc_metadata_x_folder_id=grpc_metadata_x_folder_id,
            upload_offset=upload_offset,
            content_length=content_length,
            upload_metadata=upload_metadata,
            id=id,
            upload_checksum=upload_checksum,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': "WorkspaceservicehttpTusResponse",
            '400': "WorkspaceservicehttpErrorResponse",
            '401': "WorkspaceservicehttpErrorResponse",
            '403': "WorkspaceservicehttpErrorResponse",
            '404': "WorkspaceservicehttpErrorResponse",
            '409': "WorkspaceservicehttpErrorResponse",
            '412': "WorkspaceservicehttpErrorResponse",
            '415': "WorkspaceservicehttpErrorResponse",
            '422': "WorkspaceservicehttpErrorResponse",
            '460': "WorkspaceservicehttpErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def workspace_microservice_rest_api_v1_file_resumable_id_patch_with_http_info(
        self,
        tus_resumable: Annotated[StrictStr, Field(description="TUS protocol version (must be 1.0.0)")],
        grpc_metadata_x_organization_id: Annotated[StrictStr, Field(description="Unique identifier for the organization making the request")],
        grpc_metadata_x_tenant_id: Annotated[StrictStr, Field(description="Unique identifier for the tenant within the organization")],
        grpc_metadata_x_user_id: Annotated[StrictStr, Field(description="Unique identifier for the user performing the upload")],
        grpc_metadata_x_workspace_id: Annotated[StrictStr, Field(description="Unique identifier for the workspace where the file will be stored")],
        grpc_metadata_x_folder_id: Annotated[StrictStr, Field(description="Unique identifier for the folder within the workspace")],
        upload_offset: Annotated[int, Field(strict=True, ge=0, description="Current byte offset for the upload")],
        content_length: Annotated[int, Field(strict=True, ge=1, description="Length of the chunk being uploaded")],
        upload_metadata: Annotated[StrictStr, Field(description="Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId)")],
        id: Annotated[StrictStr, Field(description="Upload ID")],
        upload_checksum: Annotated[Optional[StrictStr], Field(description="Checksum of the current chunk")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[WorkspaceservicehttpTusResponse]:
        """Upload chunks to an existing file upload using the TUS protocol


        :param tus_resumable: TUS protocol version (must be 1.0.0) (required)
        :type tus_resumable: str
        :param grpc_metadata_x_organization_id: Unique identifier for the organization making the request (required)
        :type grpc_metadata_x_organization_id: str
        :param grpc_metadata_x_tenant_id: Unique identifier for the tenant within the organization (required)
        :type grpc_metadata_x_tenant_id: str
        :param grpc_metadata_x_user_id: Unique identifier for the user performing the upload (required)
        :type grpc_metadata_x_user_id: str
        :param grpc_metadata_x_workspace_id: Unique identifier for the workspace where the file will be stored (required)
        :type grpc_metadata_x_workspace_id: str
        :param grpc_metadata_x_folder_id: Unique identifier for the folder within the workspace (required)
        :type grpc_metadata_x_folder_id: str
        :param upload_offset: Current byte offset for the upload (required)
        :type upload_offset: int
        :param content_length: Length of the chunk being uploaded (required)
        :type content_length: int
        :param upload_metadata: Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId) (required)
        :type upload_metadata: str
        :param id: Upload ID (required)
        :type id: str
        :param upload_checksum: Checksum of the current chunk
        :type upload_checksum: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._workspace_microservice_rest_api_v1_file_resumable_id_patch_serialize(
            tus_resumable=tus_resumable,
            grpc_metadata_x_organization_id=grpc_metadata_x_organization_id,
            grpc_metadata_x_tenant_id=grpc_metadata_x_tenant_id,
            grpc_metadata_x_user_id=grpc_metadata_x_user_id,
            grpc_metadata_x_workspace_id=grpc_metadata_x_workspace_id,
            grpc_metadata_x_folder_id=grpc_metadata_x_folder_id,
            upload_offset=upload_offset,
            content_length=content_length,
            upload_metadata=upload_metadata,
            id=id,
            upload_checksum=upload_checksum,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': "WorkspaceservicehttpTusResponse",
            '400': "WorkspaceservicehttpErrorResponse",
            '401': "WorkspaceservicehttpErrorResponse",
            '403': "WorkspaceservicehttpErrorResponse",
            '404': "WorkspaceservicehttpErrorResponse",
            '409': "WorkspaceservicehttpErrorResponse",
            '412': "WorkspaceservicehttpErrorResponse",
            '415': "WorkspaceservicehttpErrorResponse",
            '422': "WorkspaceservicehttpErrorResponse",
            '460': "WorkspaceservicehttpErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def workspace_microservice_rest_api_v1_file_resumable_id_patch_without_preload_content(
        self,
        tus_resumable: Annotated[StrictStr, Field(description="TUS protocol version (must be 1.0.0)")],
        grpc_metadata_x_organization_id: Annotated[StrictStr, Field(description="Unique identifier for the organization making the request")],
        grpc_metadata_x_tenant_id: Annotated[StrictStr, Field(description="Unique identifier for the tenant within the organization")],
        grpc_metadata_x_user_id: Annotated[StrictStr, Field(description="Unique identifier for the user performing the upload")],
        grpc_metadata_x_workspace_id: Annotated[StrictStr, Field(description="Unique identifier for the workspace where the file will be stored")],
        grpc_metadata_x_folder_id: Annotated[StrictStr, Field(description="Unique identifier for the folder within the workspace")],
        upload_offset: Annotated[int, Field(strict=True, ge=0, description="Current byte offset for the upload")],
        content_length: Annotated[int, Field(strict=True, ge=1, description="Length of the chunk being uploaded")],
        upload_metadata: Annotated[StrictStr, Field(description="Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId)")],
        id: Annotated[StrictStr, Field(description="Upload ID")],
        upload_checksum: Annotated[Optional[StrictStr], Field(description="Checksum of the current chunk")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Upload chunks to an existing file upload using the TUS protocol


        :param tus_resumable: TUS protocol version (must be 1.0.0) (required)
        :type tus_resumable: str
        :param grpc_metadata_x_organization_id: Unique identifier for the organization making the request (required)
        :type grpc_metadata_x_organization_id: str
        :param grpc_metadata_x_tenant_id: Unique identifier for the tenant within the organization (required)
        :type grpc_metadata_x_tenant_id: str
        :param grpc_metadata_x_user_id: Unique identifier for the user performing the upload (required)
        :type grpc_metadata_x_user_id: str
        :param grpc_metadata_x_workspace_id: Unique identifier for the workspace where the file will be stored (required)
        :type grpc_metadata_x_workspace_id: str
        :param grpc_metadata_x_folder_id: Unique identifier for the folder within the workspace (required)
        :type grpc_metadata_x_folder_id: str
        :param upload_offset: Current byte offset for the upload (required)
        :type upload_offset: int
        :param content_length: Length of the chunk being uploaded (required)
        :type content_length: int
        :param upload_metadata: Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId) (required)
        :type upload_metadata: str
        :param id: Upload ID (required)
        :type id: str
        :param upload_checksum: Checksum of the current chunk
        :type upload_checksum: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._workspace_microservice_rest_api_v1_file_resumable_id_patch_serialize(
            tus_resumable=tus_resumable,
            grpc_metadata_x_organization_id=grpc_metadata_x_organization_id,
            grpc_metadata_x_tenant_id=grpc_metadata_x_tenant_id,
            grpc_metadata_x_user_id=grpc_metadata_x_user_id,
            grpc_metadata_x_workspace_id=grpc_metadata_x_workspace_id,
            grpc_metadata_x_folder_id=grpc_metadata_x_folder_id,
            upload_offset=upload_offset,
            content_length=content_length,
            upload_metadata=upload_metadata,
            id=id,
            upload_checksum=upload_checksum,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': "WorkspaceservicehttpTusResponse",
            '400': "WorkspaceservicehttpErrorResponse",
            '401': "WorkspaceservicehttpErrorResponse",
            '403': "WorkspaceservicehttpErrorResponse",
            '404': "WorkspaceservicehttpErrorResponse",
            '409': "WorkspaceservicehttpErrorResponse",
            '412': "WorkspaceservicehttpErrorResponse",
            '415': "WorkspaceservicehttpErrorResponse",
            '422': "WorkspaceservicehttpErrorResponse",
            '460': "WorkspaceservicehttpErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _workspace_microservice_rest_api_v1_file_resumable_id_patch_serialize(
        self,
        tus_resumable,
        grpc_metadata_x_organization_id,
        grpc_metadata_x_tenant_id,
        grpc_metadata_x_user_id,
        grpc_metadata_x_workspace_id,
        grpc_metadata_x_folder_id,
        upload_offset,
        content_length,
        upload_metadata,
        id,
        upload_checksum,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        if tus_resumable is not None:
            _header_params['Tus-Resumable'] = tus_resumable
        if grpc_metadata_x_organization_id is not None:
            _header_params['Grpc-Metadata-X-Organization-ID'] = grpc_metadata_x_organization_id
        if grpc_metadata_x_tenant_id is not None:
            _header_params['Grpc-Metadata-X-Tenant-ID'] = grpc_metadata_x_tenant_id
        if grpc_metadata_x_user_id is not None:
            _header_params['Grpc-Metadata-X-User-ID'] = grpc_metadata_x_user_id
        if grpc_metadata_x_workspace_id is not None:
            _header_params['Grpc-Metadata-X-Workspace-ID'] = grpc_metadata_x_workspace_id
        if grpc_metadata_x_folder_id is not None:
            _header_params['Grpc-Metadata-X-Folder-ID'] = grpc_metadata_x_folder_id
        if upload_offset is not None:
            _header_params['Upload-Offset'] = upload_offset
        if content_length is not None:
            _header_params['Content-Length'] = content_length
        if upload_metadata is not None:
            _header_params['Upload-Metadata'] = upload_metadata
        if upload_checksum is not None:
            _header_params['Upload-Checksum'] = upload_checksum
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/workspace-microservice/rest-api/v1/file/resumable/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def workspace_microservice_rest_api_v1_file_resumable_post(
        self,
        tus_resumable: Annotated[StrictStr, Field(description="TUS protocol version (must be 1.0.0)")],
        grpc_metadata_x_organization_id: Annotated[StrictStr, Field(description="Unique identifier for the organization making the request")],
        grpc_metadata_x_tenant_id: Annotated[StrictStr, Field(description="Unique identifier for the tenant within the organization")],
        grpc_metadata_x_user_id: Annotated[StrictStr, Field(description="Unique identifier for the user performing the upload")],
        grpc_metadata_x_workspace_id: Annotated[StrictStr, Field(description="Unique identifier for the workspace where the file will be stored")],
        grpc_metadata_x_folder_id: Annotated[StrictStr, Field(description="Unique identifier for the folder within the workspace")],
        upload_metadata: Annotated[StrictStr, Field(description="Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId)")],
        content_length: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Length of the body in bytes (must be 0 for creation; required for `Creation With Upload`)")] = None,
        upload_length: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Total size of the file in bytes (required for POST requests)")] = None,
        upload_defer_length: Annotated[Optional[StrictInt], Field(description="Set to 1 if Upload-Length is not known at creation")] = None,
        upload_offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Current byte offset for resuming upload (required for PATCH requests)")] = None,
        upload_content_type: Annotated[Optional[StrictStr], Field(description="Must be application/offset+octet-stream for PATCH requests")] = None,
        upload_checksum: Annotated[Optional[StrictStr], Field(description="Checksum of the current chunk in specified algorithm")] = None,
        upload_concat: Annotated[Optional[StrictStr], Field(description="Indicates concatenation mode for multiple uploads (partial or final)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> WorkspaceservicehttpTusResponse:
        """Upload a file to the workspace using the TUS protocol


        :param tus_resumable: TUS protocol version (must be 1.0.0) (required)
        :type tus_resumable: str
        :param grpc_metadata_x_organization_id: Unique identifier for the organization making the request (required)
        :type grpc_metadata_x_organization_id: str
        :param grpc_metadata_x_tenant_id: Unique identifier for the tenant within the organization (required)
        :type grpc_metadata_x_tenant_id: str
        :param grpc_metadata_x_user_id: Unique identifier for the user performing the upload (required)
        :type grpc_metadata_x_user_id: str
        :param grpc_metadata_x_workspace_id: Unique identifier for the workspace where the file will be stored (required)
        :type grpc_metadata_x_workspace_id: str
        :param grpc_metadata_x_folder_id: Unique identifier for the folder within the workspace (required)
        :type grpc_metadata_x_folder_id: str
        :param upload_metadata: Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId) (required)
        :type upload_metadata: str
        :param content_length: Length of the body in bytes (must be 0 for creation; required for `Creation With Upload`)
        :type content_length: int
        :param upload_length: Total size of the file in bytes (required for POST requests)
        :type upload_length: int
        :param upload_defer_length: Set to 1 if Upload-Length is not known at creation
        :type upload_defer_length: int
        :param upload_offset: Current byte offset for resuming upload (required for PATCH requests)
        :type upload_offset: int
        :param upload_content_type: Must be application/offset+octet-stream for PATCH requests
        :type upload_content_type: str
        :param upload_checksum: Checksum of the current chunk in specified algorithm
        :type upload_checksum: str
        :param upload_concat: Indicates concatenation mode for multiple uploads (partial or final)
        :type upload_concat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._workspace_microservice_rest_api_v1_file_resumable_post_serialize(
            tus_resumable=tus_resumable,
            grpc_metadata_x_organization_id=grpc_metadata_x_organization_id,
            grpc_metadata_x_tenant_id=grpc_metadata_x_tenant_id,
            grpc_metadata_x_user_id=grpc_metadata_x_user_id,
            grpc_metadata_x_workspace_id=grpc_metadata_x_workspace_id,
            grpc_metadata_x_folder_id=grpc_metadata_x_folder_id,
            upload_metadata=upload_metadata,
            content_length=content_length,
            upload_length=upload_length,
            upload_defer_length=upload_defer_length,
            upload_offset=upload_offset,
            upload_content_type=upload_content_type,
            upload_checksum=upload_checksum,
            upload_concat=upload_concat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "WorkspaceservicehttpTusResponse",
            '204': "WorkspaceservicehttpTusResponse",
            '400': "WorkspaceservicehttpErrorResponse",
            '401': "WorkspaceservicehttpErrorResponse",
            '403': "WorkspaceservicehttpErrorResponse",
            '404': "WorkspaceservicehttpErrorResponse",
            '409': "WorkspaceservicehttpErrorResponse",
            '412': "WorkspaceservicehttpErrorResponse",
            '413': "WorkspaceservicehttpErrorResponse",
            '415': "WorkspaceservicehttpErrorResponse",
            '422': "WorkspaceservicehttpErrorResponse",
            '460': "WorkspaceservicehttpErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def workspace_microservice_rest_api_v1_file_resumable_post_with_http_info(
        self,
        tus_resumable: Annotated[StrictStr, Field(description="TUS protocol version (must be 1.0.0)")],
        grpc_metadata_x_organization_id: Annotated[StrictStr, Field(description="Unique identifier for the organization making the request")],
        grpc_metadata_x_tenant_id: Annotated[StrictStr, Field(description="Unique identifier for the tenant within the organization")],
        grpc_metadata_x_user_id: Annotated[StrictStr, Field(description="Unique identifier for the user performing the upload")],
        grpc_metadata_x_workspace_id: Annotated[StrictStr, Field(description="Unique identifier for the workspace where the file will be stored")],
        grpc_metadata_x_folder_id: Annotated[StrictStr, Field(description="Unique identifier for the folder within the workspace")],
        upload_metadata: Annotated[StrictStr, Field(description="Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId)")],
        content_length: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Length of the body in bytes (must be 0 for creation; required for `Creation With Upload`)")] = None,
        upload_length: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Total size of the file in bytes (required for POST requests)")] = None,
        upload_defer_length: Annotated[Optional[StrictInt], Field(description="Set to 1 if Upload-Length is not known at creation")] = None,
        upload_offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Current byte offset for resuming upload (required for PATCH requests)")] = None,
        upload_content_type: Annotated[Optional[StrictStr], Field(description="Must be application/offset+octet-stream for PATCH requests")] = None,
        upload_checksum: Annotated[Optional[StrictStr], Field(description="Checksum of the current chunk in specified algorithm")] = None,
        upload_concat: Annotated[Optional[StrictStr], Field(description="Indicates concatenation mode for multiple uploads (partial or final)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[WorkspaceservicehttpTusResponse]:
        """Upload a file to the workspace using the TUS protocol


        :param tus_resumable: TUS protocol version (must be 1.0.0) (required)
        :type tus_resumable: str
        :param grpc_metadata_x_organization_id: Unique identifier for the organization making the request (required)
        :type grpc_metadata_x_organization_id: str
        :param grpc_metadata_x_tenant_id: Unique identifier for the tenant within the organization (required)
        :type grpc_metadata_x_tenant_id: str
        :param grpc_metadata_x_user_id: Unique identifier for the user performing the upload (required)
        :type grpc_metadata_x_user_id: str
        :param grpc_metadata_x_workspace_id: Unique identifier for the workspace where the file will be stored (required)
        :type grpc_metadata_x_workspace_id: str
        :param grpc_metadata_x_folder_id: Unique identifier for the folder within the workspace (required)
        :type grpc_metadata_x_folder_id: str
        :param upload_metadata: Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId) (required)
        :type upload_metadata: str
        :param content_length: Length of the body in bytes (must be 0 for creation; required for `Creation With Upload`)
        :type content_length: int
        :param upload_length: Total size of the file in bytes (required for POST requests)
        :type upload_length: int
        :param upload_defer_length: Set to 1 if Upload-Length is not known at creation
        :type upload_defer_length: int
        :param upload_offset: Current byte offset for resuming upload (required for PATCH requests)
        :type upload_offset: int
        :param upload_content_type: Must be application/offset+octet-stream for PATCH requests
        :type upload_content_type: str
        :param upload_checksum: Checksum of the current chunk in specified algorithm
        :type upload_checksum: str
        :param upload_concat: Indicates concatenation mode for multiple uploads (partial or final)
        :type upload_concat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._workspace_microservice_rest_api_v1_file_resumable_post_serialize(
            tus_resumable=tus_resumable,
            grpc_metadata_x_organization_id=grpc_metadata_x_organization_id,
            grpc_metadata_x_tenant_id=grpc_metadata_x_tenant_id,
            grpc_metadata_x_user_id=grpc_metadata_x_user_id,
            grpc_metadata_x_workspace_id=grpc_metadata_x_workspace_id,
            grpc_metadata_x_folder_id=grpc_metadata_x_folder_id,
            upload_metadata=upload_metadata,
            content_length=content_length,
            upload_length=upload_length,
            upload_defer_length=upload_defer_length,
            upload_offset=upload_offset,
            upload_content_type=upload_content_type,
            upload_checksum=upload_checksum,
            upload_concat=upload_concat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "WorkspaceservicehttpTusResponse",
            '204': "WorkspaceservicehttpTusResponse",
            '400': "WorkspaceservicehttpErrorResponse",
            '401': "WorkspaceservicehttpErrorResponse",
            '403': "WorkspaceservicehttpErrorResponse",
            '404': "WorkspaceservicehttpErrorResponse",
            '409': "WorkspaceservicehttpErrorResponse",
            '412': "WorkspaceservicehttpErrorResponse",
            '413': "WorkspaceservicehttpErrorResponse",
            '415': "WorkspaceservicehttpErrorResponse",
            '422': "WorkspaceservicehttpErrorResponse",
            '460': "WorkspaceservicehttpErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def workspace_microservice_rest_api_v1_file_resumable_post_without_preload_content(
        self,
        tus_resumable: Annotated[StrictStr, Field(description="TUS protocol version (must be 1.0.0)")],
        grpc_metadata_x_organization_id: Annotated[StrictStr, Field(description="Unique identifier for the organization making the request")],
        grpc_metadata_x_tenant_id: Annotated[StrictStr, Field(description="Unique identifier for the tenant within the organization")],
        grpc_metadata_x_user_id: Annotated[StrictStr, Field(description="Unique identifier for the user performing the upload")],
        grpc_metadata_x_workspace_id: Annotated[StrictStr, Field(description="Unique identifier for the workspace where the file will be stored")],
        grpc_metadata_x_folder_id: Annotated[StrictStr, Field(description="Unique identifier for the folder within the workspace")],
        upload_metadata: Annotated[StrictStr, Field(description="Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId)")],
        content_length: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Length of the body in bytes (must be 0 for creation; required for `Creation With Upload`)")] = None,
        upload_length: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Total size of the file in bytes (required for POST requests)")] = None,
        upload_defer_length: Annotated[Optional[StrictInt], Field(description="Set to 1 if Upload-Length is not known at creation")] = None,
        upload_offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Current byte offset for resuming upload (required for PATCH requests)")] = None,
        upload_content_type: Annotated[Optional[StrictStr], Field(description="Must be application/offset+octet-stream for PATCH requests")] = None,
        upload_checksum: Annotated[Optional[StrictStr], Field(description="Checksum of the current chunk in specified algorithm")] = None,
        upload_concat: Annotated[Optional[StrictStr], Field(description="Indicates concatenation mode for multiple uploads (partial or final)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Upload a file to the workspace using the TUS protocol


        :param tus_resumable: TUS protocol version (must be 1.0.0) (required)
        :type tus_resumable: str
        :param grpc_metadata_x_organization_id: Unique identifier for the organization making the request (required)
        :type grpc_metadata_x_organization_id: str
        :param grpc_metadata_x_tenant_id: Unique identifier for the tenant within the organization (required)
        :type grpc_metadata_x_tenant_id: str
        :param grpc_metadata_x_user_id: Unique identifier for the user performing the upload (required)
        :type grpc_metadata_x_user_id: str
        :param grpc_metadata_x_workspace_id: Unique identifier for the workspace where the file will be stored (required)
        :type grpc_metadata_x_workspace_id: str
        :param grpc_metadata_x_folder_id: Unique identifier for the folder within the workspace (required)
        :type grpc_metadata_x_folder_id: str
        :param upload_metadata: Base64 encoded metadata (e.g., workspaceId,folderId,filename,userId) (required)
        :type upload_metadata: str
        :param content_length: Length of the body in bytes (must be 0 for creation; required for `Creation With Upload`)
        :type content_length: int
        :param upload_length: Total size of the file in bytes (required for POST requests)
        :type upload_length: int
        :param upload_defer_length: Set to 1 if Upload-Length is not known at creation
        :type upload_defer_length: int
        :param upload_offset: Current byte offset for resuming upload (required for PATCH requests)
        :type upload_offset: int
        :param upload_content_type: Must be application/offset+octet-stream for PATCH requests
        :type upload_content_type: str
        :param upload_checksum: Checksum of the current chunk in specified algorithm
        :type upload_checksum: str
        :param upload_concat: Indicates concatenation mode for multiple uploads (partial or final)
        :type upload_concat: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._workspace_microservice_rest_api_v1_file_resumable_post_serialize(
            tus_resumable=tus_resumable,
            grpc_metadata_x_organization_id=grpc_metadata_x_organization_id,
            grpc_metadata_x_tenant_id=grpc_metadata_x_tenant_id,
            grpc_metadata_x_user_id=grpc_metadata_x_user_id,
            grpc_metadata_x_workspace_id=grpc_metadata_x_workspace_id,
            grpc_metadata_x_folder_id=grpc_metadata_x_folder_id,
            upload_metadata=upload_metadata,
            content_length=content_length,
            upload_length=upload_length,
            upload_defer_length=upload_defer_length,
            upload_offset=upload_offset,
            upload_content_type=upload_content_type,
            upload_checksum=upload_checksum,
            upload_concat=upload_concat,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "WorkspaceservicehttpTusResponse",
            '204': "WorkspaceservicehttpTusResponse",
            '400': "WorkspaceservicehttpErrorResponse",
            '401': "WorkspaceservicehttpErrorResponse",
            '403': "WorkspaceservicehttpErrorResponse",
            '404': "WorkspaceservicehttpErrorResponse",
            '409': "WorkspaceservicehttpErrorResponse",
            '412': "WorkspaceservicehttpErrorResponse",
            '413': "WorkspaceservicehttpErrorResponse",
            '415': "WorkspaceservicehttpErrorResponse",
            '422': "WorkspaceservicehttpErrorResponse",
            '460': "WorkspaceservicehttpErrorResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _workspace_microservice_rest_api_v1_file_resumable_post_serialize(
        self,
        tus_resumable,
        grpc_metadata_x_organization_id,
        grpc_metadata_x_tenant_id,
        grpc_metadata_x_user_id,
        grpc_metadata_x_workspace_id,
        grpc_metadata_x_folder_id,
        upload_metadata,
        content_length,
        upload_length,
        upload_defer_length,
        upload_offset,
        upload_content_type,
        upload_checksum,
        upload_concat,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if tus_resumable is not None:
            _header_params['Tus-Resumable'] = tus_resumable
        if grpc_metadata_x_organization_id is not None:
            _header_params['Grpc-Metadata-X-Organization-ID'] = grpc_metadata_x_organization_id
        if grpc_metadata_x_tenant_id is not None:
            _header_params['Grpc-Metadata-X-Tenant-ID'] = grpc_metadata_x_tenant_id
        if grpc_metadata_x_user_id is not None:
            _header_params['Grpc-Metadata-X-User-ID'] = grpc_metadata_x_user_id
        if grpc_metadata_x_workspace_id is not None:
            _header_params['Grpc-Metadata-X-Workspace-ID'] = grpc_metadata_x_workspace_id
        if grpc_metadata_x_folder_id is not None:
            _header_params['Grpc-Metadata-X-Folder-ID'] = grpc_metadata_x_folder_id
        if upload_metadata is not None:
            _header_params['Upload-Metadata'] = upload_metadata
        if content_length is not None:
            _header_params['Content-Length'] = content_length
        if upload_length is not None:
            _header_params['Upload-Length'] = upload_length
        if upload_defer_length is not None:
            _header_params['Upload-Defer-Length'] = upload_defer_length
        if upload_offset is not None:
            _header_params['Upload-Offset'] = upload_offset
        if upload_content_type is not None:
            _header_params['Upload-Content-Type'] = upload_content_type
        if upload_checksum is not None:
            _header_params['Upload-Checksum'] = upload_checksum
        if upload_concat is not None:
            _header_params['Upload-Concat'] = upload_concat
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/workspace-microservice/rest-api/v1/file/resumable',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def workspace_microservice_rest_api_v1_file_upload_post(
        self,
        workspace_id: Annotated[StrictStr, Field(description="Identifier of the workspace where the file will be uploaded")],
        folder_id: Annotated[StrictStr, Field(description="Identifier of the folder within the workspace where the file will be stored")],
        user_id: Annotated[StrictStr, Field(description="Identifier of the user uploading the file")],
        attachment: Annotated[Union[StrictBytes, StrictStr], Field(description="The file to be uploaded")],
        filename: Annotated[Optional[StrictStr], Field(description="The name of the file to be saved (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> WorkspaceservicehttpFileUploadResponse:
        """Uploads a file to the server

        This endpoint allows for the uploading of a file to the server. Upon successful upload,

        :param workspace_id: Identifier of the workspace where the file will be uploaded (required)
        :type workspace_id: str
        :param folder_id: Identifier of the folder within the workspace where the file will be stored (required)
        :type folder_id: str
        :param user_id: Identifier of the user uploading the file (required)
        :type user_id: str
        :param attachment: The file to be uploaded (required)
        :type attachment: bytearray
        :param filename: The name of the file to be saved (optional)
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._workspace_microservice_rest_api_v1_file_upload_post_serialize(
            workspace_id=workspace_id,
            folder_id=folder_id,
            user_id=user_id,
            attachment=attachment,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WorkspaceservicehttpFileUploadResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def workspace_microservice_rest_api_v1_file_upload_post_with_http_info(
        self,
        workspace_id: Annotated[StrictStr, Field(description="Identifier of the workspace where the file will be uploaded")],
        folder_id: Annotated[StrictStr, Field(description="Identifier of the folder within the workspace where the file will be stored")],
        user_id: Annotated[StrictStr, Field(description="Identifier of the user uploading the file")],
        attachment: Annotated[Union[StrictBytes, StrictStr], Field(description="The file to be uploaded")],
        filename: Annotated[Optional[StrictStr], Field(description="The name of the file to be saved (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[WorkspaceservicehttpFileUploadResponse]:
        """Uploads a file to the server

        This endpoint allows for the uploading of a file to the server. Upon successful upload,

        :param workspace_id: Identifier of the workspace where the file will be uploaded (required)
        :type workspace_id: str
        :param folder_id: Identifier of the folder within the workspace where the file will be stored (required)
        :type folder_id: str
        :param user_id: Identifier of the user uploading the file (required)
        :type user_id: str
        :param attachment: The file to be uploaded (required)
        :type attachment: bytearray
        :param filename: The name of the file to be saved (optional)
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._workspace_microservice_rest_api_v1_file_upload_post_serialize(
            workspace_id=workspace_id,
            folder_id=folder_id,
            user_id=user_id,
            attachment=attachment,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WorkspaceservicehttpFileUploadResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def workspace_microservice_rest_api_v1_file_upload_post_without_preload_content(
        self,
        workspace_id: Annotated[StrictStr, Field(description="Identifier of the workspace where the file will be uploaded")],
        folder_id: Annotated[StrictStr, Field(description="Identifier of the folder within the workspace where the file will be stored")],
        user_id: Annotated[StrictStr, Field(description="Identifier of the user uploading the file")],
        attachment: Annotated[Union[StrictBytes, StrictStr], Field(description="The file to be uploaded")],
        filename: Annotated[Optional[StrictStr], Field(description="The name of the file to be saved (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Uploads a file to the server

        This endpoint allows for the uploading of a file to the server. Upon successful upload,

        :param workspace_id: Identifier of the workspace where the file will be uploaded (required)
        :type workspace_id: str
        :param folder_id: Identifier of the folder within the workspace where the file will be stored (required)
        :type folder_id: str
        :param user_id: Identifier of the user uploading the file (required)
        :type user_id: str
        :param attachment: The file to be uploaded (required)
        :type attachment: bytearray
        :param filename: The name of the file to be saved (optional)
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._workspace_microservice_rest_api_v1_file_upload_post_serialize(
            workspace_id=workspace_id,
            folder_id=folder_id,
            user_id=user_id,
            attachment=attachment,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WorkspaceservicehttpFileUploadResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _workspace_microservice_rest_api_v1_file_upload_post_serialize(
        self,
        workspace_id,
        folder_id,
        user_id,
        attachment,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if workspace_id is not None:
            _form_params.append(('workspaceId', workspace_id))
        if folder_id is not None:
            _form_params.append(('folderId', folder_id))
        if filename is not None:
            _form_params.append(('filename', filename))
        if user_id is not None:
            _form_params.append(('userId', user_id))
        if attachment is not None:
            _files['attachment'] = attachment
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/workspace-microservice/rest-api/v1/file/upload',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


