# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from solomonai_backend_client_sdk.models.accept_team_member_invitation_body import AcceptTeamMemberInvitationBody
from solomonai_backend_client_sdk.models.accept_team_member_invitation_response import AcceptTeamMemberInvitationResponse
from solomonai_backend_client_sdk.models.add_organization_member_to_organization_body import AddOrganizationMemberToOrganizationBody
from solomonai_backend_client_sdk.models.add_organization_member_to_organization_response import AddOrganizationMemberToOrganizationResponse
from solomonai_backend_client_sdk.models.add_role_to_tenant_team_body import AddRoleToTenantTeamBody
from solomonai_backend_client_sdk.models.add_role_to_tenant_team_response import AddRoleToTenantTeamResponse
from solomonai_backend_client_sdk.models.add_tenant_member_body import AddTenantMemberBody
from solomonai_backend_client_sdk.models.add_tenant_member_response import AddTenantMemberResponse
from solomonai_backend_client_sdk.models.add_user_to_team_body import AddUserToTeamBody
from solomonai_backend_client_sdk.models.add_user_to_team_response import AddUserToTeamResponse
from solomonai_backend_client_sdk.models.bulk_add_team_members_body import BulkAddTeamMembersBody
from solomonai_backend_client_sdk.models.bulk_add_team_members_response import BulkAddTeamMembersResponse
from solomonai_backend_client_sdk.models.bulk_remove_team_members_body import BulkRemoveTeamMembersBody
from solomonai_backend_client_sdk.models.bulk_remove_team_members_response import BulkRemoveTeamMembersResponse
from solomonai_backend_client_sdk.models.bulk_revoke_org_api_keys_request import BulkRevokeOrgAPIKeysRequest
from solomonai_backend_client_sdk.models.bulk_revoke_org_api_keys_response import BulkRevokeOrgAPIKeysResponse
from solomonai_backend_client_sdk.models.check_email_and_auth0_user_id_exists_response import CheckEmailAndAuth0UserIdExistsResponse
from solomonai_backend_client_sdk.models.check_email_exists_v2_response import CheckEmailExistsV2Response
from solomonai_backend_client_sdk.models.check_username_exists_v2_response import CheckUsernameExistsV2Response
from solomonai_backend_client_sdk.models.create_organization_api_key_request import CreateOrganizationApiKeyRequest
from solomonai_backend_client_sdk.models.create_organization_api_key_response import CreateOrganizationApiKeyResponse
from solomonai_backend_client_sdk.models.create_organization_request import CreateOrganizationRequest
from solomonai_backend_client_sdk.models.create_organization_response import CreateOrganizationResponse
from solomonai_backend_client_sdk.models.create_role_response import CreateRoleResponse
from solomonai_backend_client_sdk.models.create_team_request import CreateTeamRequest
from solomonai_backend_client_sdk.models.create_team_response import CreateTeamResponse
from solomonai_backend_client_sdk.models.create_tenant_api_key_request import CreateTenantApiKeyRequest
from solomonai_backend_client_sdk.models.create_tenant_api_key_response import CreateTenantApiKeyResponse
from solomonai_backend_client_sdk.models.create_tenant_request import CreateTenantRequest
from solomonai_backend_client_sdk.models.create_tenant_response import CreateTenantResponse
from solomonai_backend_client_sdk.models.create_tenant_team_request import CreateTenantTeamRequest
from solomonai_backend_client_sdk.models.create_tenant_team_response import CreateTenantTeamResponse
from solomonai_backend_client_sdk.models.create_user_v2_request import CreateUserV2Request
from solomonai_backend_client_sdk.models.create_user_v2_response import CreateUserV2Response
from solomonai_backend_client_sdk.models.delete_organization_api_key_response import DeleteOrganizationApiKeyResponse
from solomonai_backend_client_sdk.models.delete_organization_response import DeleteOrganizationResponse
from solomonai_backend_client_sdk.models.delete_role_from_tenant_team_response import DeleteRoleFromTenantTeamResponse
from solomonai_backend_client_sdk.models.delete_role_response import DeleteRoleResponse
from solomonai_backend_client_sdk.models.delete_team_response import DeleteTeamResponse
from solomonai_backend_client_sdk.models.delete_tenant_api_key_response import DeleteTenantApiKeyResponse
from solomonai_backend_client_sdk.models.delete_tenant_response import DeleteTenantResponse
from solomonai_backend_client_sdk.models.delete_tenant_team_response import DeleteTenantTeamResponse
from solomonai_backend_client_sdk.models.delete_user_v2_response import DeleteUserV2Response
from solomonai_backend_client_sdk.models.get_business_settings_response import GetBusinessSettingsResponse
from solomonai_backend_client_sdk.models.get_canny_user_sso_token_response import GetCannyUserSSOTokenResponse
from solomonai_backend_client_sdk.models.get_org_api_key_permissions_response import GetOrgAPIKeyPermissionsResponse
from solomonai_backend_client_sdk.models.get_organization_member_response import GetOrganizationMemberResponse
from solomonai_backend_client_sdk.models.get_organization_response import GetOrganizationResponse
from solomonai_backend_client_sdk.models.get_role_response import GetRoleResponse
from solomonai_backend_client_sdk.models.get_team_response import GetTeamResponse
from solomonai_backend_client_sdk.models.get_tenant_response import GetTenantResponse
from solomonai_backend_client_sdk.models.get_tenant_team_response import GetTenantTeamResponse
from solomonai_backend_client_sdk.models.get_user_by_auth0_id_response import GetUserByAuth0IDResponse
from solomonai_backend_client_sdk.models.get_user_by_authn_idv2_response import GetUserByAuthnIDV2Response
from solomonai_backend_client_sdk.models.get_user_by_email_or_username_v2_response import GetUserByEmailOrUsernameV2Response
from solomonai_backend_client_sdk.models.get_user_by_email_v2_response import GetUserByEmailV2Response
from solomonai_backend_client_sdk.models.get_user_by_username_v2_response import GetUserByUsernameV2Response
from solomonai_backend_client_sdk.models.get_user_id_v2_response import GetUserIdV2Response
from solomonai_backend_client_sdk.models.get_user_v2_response import GetUserV2Response
from solomonai_backend_client_sdk.models.health_check_response import HealthCheckResponse
from solomonai_backend_client_sdk.models.invite_team_member_body import InviteTeamMemberBody
from solomonai_backend_client_sdk.models.invite_team_member_response import InviteTeamMemberResponse
from solomonai_backend_client_sdk.models.list_organization_api_keys_response import ListOrganizationApiKeysResponse
from solomonai_backend_client_sdk.models.list_organization_audit_logs_response import ListOrganizationAuditLogsResponse
from solomonai_backend_client_sdk.models.list_organization_members_response import ListOrganizationMembersResponse
from solomonai_backend_client_sdk.models.list_organizations_response import ListOrganizationsResponse
from solomonai_backend_client_sdk.models.list_roles_from_tenant_team_response import ListRolesFromTenantTeamResponse
from solomonai_backend_client_sdk.models.list_roles_response import ListRolesResponse
from solomonai_backend_client_sdk.models.list_team_invites_response import ListTeamInvitesResponse
from solomonai_backend_client_sdk.models.list_tenant_api_keys_response import ListTenantApiKeysResponse
from solomonai_backend_client_sdk.models.list_tenant_audit_logs_response import ListTenantAuditLogsResponse
from solomonai_backend_client_sdk.models.list_tenant_team_members_response import ListTenantTeamMembersResponse
from solomonai_backend_client_sdk.models.list_tenants_response import ListTenantsResponse
from solomonai_backend_client_sdk.models.organization import Organization
from solomonai_backend_client_sdk.models.password_reset_webhook_v2_response import PasswordResetWebhookV2Response
from solomonai_backend_client_sdk.models.readyness_check_response import ReadynessCheckResponse
from solomonai_backend_client_sdk.models.reject_team_member_invitation_body import RejectTeamMemberInvitationBody
from solomonai_backend_client_sdk.models.reject_team_member_invitation_response import RejectTeamMemberInvitationResponse
from solomonai_backend_client_sdk.models.remove_organization_member_from_organization_response import RemoveOrganizationMemberFromOrganizationResponse
from solomonai_backend_client_sdk.models.remove_tenant_team_member_response import RemoveTenantTeamMemberResponse
from solomonai_backend_client_sdk.models.remove_user_from_team_response import RemoveUserFromTeamResponse
from solomonai_backend_client_sdk.models.role import Role
from solomonai_backend_client_sdk.models.rotate_org_api_key_response import RotateOrgAPIKeyResponse
from solomonai_backend_client_sdk.models.team import Team
from solomonai_backend_client_sdk.models.update_organization_response import UpdateOrganizationResponse
from solomonai_backend_client_sdk.models.update_role_response import UpdateRoleResponse
from solomonai_backend_client_sdk.models.update_team_response import UpdateTeamResponse
from solomonai_backend_client_sdk.models.update_tenant_request import UpdateTenantRequest
from solomonai_backend_client_sdk.models.update_tenant_response import UpdateTenantResponse
from solomonai_backend_client_sdk.models.update_tenant_team_member_request import UpdateTenantTeamMemberRequest
from solomonai_backend_client_sdk.models.update_tenant_team_member_response import UpdateTenantTeamMemberResponse
from solomonai_backend_client_sdk.models.update_tenant_team_response import UpdateTenantTeamResponse
from solomonai_backend_client_sdk.models.update_user_v2_request import UpdateUserV2Request
from solomonai_backend_client_sdk.models.update_user_v2_response import UpdateUserV2Response
from solomonai_backend_client_sdk.models.verify_org_api_key_request import VerifyOrgAPIKeyRequest
from solomonai_backend_client_sdk.models.verify_org_api_key_response import VerifyOrgAPIKeyResponse
from solomonai_backend_client_sdk.models.verify_user_v2_response import VerifyUserV2Response

from solomonai_backend_client_sdk.api_client import ApiClient, RequestSerialized
from solomonai_backend_client_sdk.api_response import ApiResponse
from solomonai_backend_client_sdk.rest import RESTResponseType


class UserServiceV2Api:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def accept_team_member_invitation(
        self,
        tenant_id: StrictStr,
        accept_team_member_invitation_body: AcceptTeamMemberInvitationBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AcceptTeamMemberInvitationResponse:
        """Accepts a team member invitation

        This endpoint accepts an invitation for a member to join a tenant based on the provided tenant ID and member email.The acceptance process ensures that the member is properly associated with the tenant.

        :param tenant_id: (required)
        :type tenant_id: str
        :param accept_team_member_invitation_body: (required)
        :type accept_team_member_invitation_body: AcceptTeamMemberInvitationBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._accept_team_member_invitation_serialize(
            tenant_id=tenant_id,
            accept_team_member_invitation_body=accept_team_member_invitation_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AcceptTeamMemberInvitationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def accept_team_member_invitation_with_http_info(
        self,
        tenant_id: StrictStr,
        accept_team_member_invitation_body: AcceptTeamMemberInvitationBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AcceptTeamMemberInvitationResponse]:
        """Accepts a team member invitation

        This endpoint accepts an invitation for a member to join a tenant based on the provided tenant ID and member email.The acceptance process ensures that the member is properly associated with the tenant.

        :param tenant_id: (required)
        :type tenant_id: str
        :param accept_team_member_invitation_body: (required)
        :type accept_team_member_invitation_body: AcceptTeamMemberInvitationBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._accept_team_member_invitation_serialize(
            tenant_id=tenant_id,
            accept_team_member_invitation_body=accept_team_member_invitation_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AcceptTeamMemberInvitationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def accept_team_member_invitation_without_preload_content(
        self,
        tenant_id: StrictStr,
        accept_team_member_invitation_body: AcceptTeamMemberInvitationBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Accepts a team member invitation

        This endpoint accepts an invitation for a member to join a tenant based on the provided tenant ID and member email.The acceptance process ensures that the member is properly associated with the tenant.

        :param tenant_id: (required)
        :type tenant_id: str
        :param accept_team_member_invitation_body: (required)
        :type accept_team_member_invitation_body: AcceptTeamMemberInvitationBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._accept_team_member_invitation_serialize(
            tenant_id=tenant_id,
            accept_team_member_invitation_body=accept_team_member_invitation_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AcceptTeamMemberInvitationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _accept_team_member_invitation_serialize(
        self,
        tenant_id,
        accept_team_member_invitation_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_id is not None:
            _path_params['tenantId'] = tenant_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if accept_team_member_invitation_body is not None:
            _body_params = accept_team_member_invitation_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/tenant/{tenantId}/accept-teammember-invitation',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def add_organization_member_to_organization(
        self,
        organization_id: StrictStr,
        add_organization_member_to_organization_body: AddOrganizationMemberToOrganizationBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AddOrganizationMemberToOrganizationResponse:
        """Adds a member to an organization

        This endpoint adds a member to an organization based on the provided organization ID and member ID.The addition process ensures that the member is properly associated with the organization.

        :param organization_id: (required)
        :type organization_id: str
        :param add_organization_member_to_organization_body: (required)
        :type add_organization_member_to_organization_body: AddOrganizationMemberToOrganizationBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_organization_member_to_organization_serialize(
            organization_id=organization_id,
            add_organization_member_to_organization_body=add_organization_member_to_organization_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddOrganizationMemberToOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_organization_member_to_organization_with_http_info(
        self,
        organization_id: StrictStr,
        add_organization_member_to_organization_body: AddOrganizationMemberToOrganizationBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AddOrganizationMemberToOrganizationResponse]:
        """Adds a member to an organization

        This endpoint adds a member to an organization based on the provided organization ID and member ID.The addition process ensures that the member is properly associated with the organization.

        :param organization_id: (required)
        :type organization_id: str
        :param add_organization_member_to_organization_body: (required)
        :type add_organization_member_to_organization_body: AddOrganizationMemberToOrganizationBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_organization_member_to_organization_serialize(
            organization_id=organization_id,
            add_organization_member_to_organization_body=add_organization_member_to_organization_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddOrganizationMemberToOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_organization_member_to_organization_without_preload_content(
        self,
        organization_id: StrictStr,
        add_organization_member_to_organization_body: AddOrganizationMemberToOrganizationBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Adds a member to an organization

        This endpoint adds a member to an organization based on the provided organization ID and member ID.The addition process ensures that the member is properly associated with the organization.

        :param organization_id: (required)
        :type organization_id: str
        :param add_organization_member_to_organization_body: (required)
        :type add_organization_member_to_organization_body: AddOrganizationMemberToOrganizationBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_organization_member_to_organization_serialize(
            organization_id=organization_id,
            add_organization_member_to_organization_body=add_organization_member_to_organization_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddOrganizationMemberToOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_organization_member_to_organization_serialize(
        self,
        organization_id,
        add_organization_member_to_organization_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if organization_id is not None:
            _path_params['organizationId'] = organization_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if add_organization_member_to_organization_body is not None:
            _body_params = add_organization_member_to_organization_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/organization/{organizationId}/add-new-member',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def add_role_to_tenant_team(
        self,
        tenant_id: StrictStr,
        team_id: StrictStr,
        add_role_to_tenant_team_body: AddRoleToTenantTeamBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AddRoleToTenantTeamResponse:
        """Adds a role to a team

        This endpoint adds a role to a team based on the provided tenant ID, team ID, and role details.The addition process ensures that the role is properly associated with the team.

        :param tenant_id: (required)
        :type tenant_id: str
        :param team_id: (required)
        :type team_id: str
        :param add_role_to_tenant_team_body: (required)
        :type add_role_to_tenant_team_body: AddRoleToTenantTeamBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_role_to_tenant_team_serialize(
            tenant_id=tenant_id,
            team_id=team_id,
            add_role_to_tenant_team_body=add_role_to_tenant_team_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddRoleToTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_role_to_tenant_team_with_http_info(
        self,
        tenant_id: StrictStr,
        team_id: StrictStr,
        add_role_to_tenant_team_body: AddRoleToTenantTeamBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AddRoleToTenantTeamResponse]:
        """Adds a role to a team

        This endpoint adds a role to a team based on the provided tenant ID, team ID, and role details.The addition process ensures that the role is properly associated with the team.

        :param tenant_id: (required)
        :type tenant_id: str
        :param team_id: (required)
        :type team_id: str
        :param add_role_to_tenant_team_body: (required)
        :type add_role_to_tenant_team_body: AddRoleToTenantTeamBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_role_to_tenant_team_serialize(
            tenant_id=tenant_id,
            team_id=team_id,
            add_role_to_tenant_team_body=add_role_to_tenant_team_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddRoleToTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_role_to_tenant_team_without_preload_content(
        self,
        tenant_id: StrictStr,
        team_id: StrictStr,
        add_role_to_tenant_team_body: AddRoleToTenantTeamBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Adds a role to a team

        This endpoint adds a role to a team based on the provided tenant ID, team ID, and role details.The addition process ensures that the role is properly associated with the team.

        :param tenant_id: (required)
        :type tenant_id: str
        :param team_id: (required)
        :type team_id: str
        :param add_role_to_tenant_team_body: (required)
        :type add_role_to_tenant_team_body: AddRoleToTenantTeamBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_role_to_tenant_team_serialize(
            tenant_id=tenant_id,
            team_id=team_id,
            add_role_to_tenant_team_body=add_role_to_tenant_team_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddRoleToTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_role_to_tenant_team_serialize(
        self,
        tenant_id,
        team_id,
        add_role_to_tenant_team_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_id is not None:
            _path_params['tenantId'] = tenant_id
        if team_id is not None:
            _path_params['teamId'] = team_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if add_role_to_tenant_team_body is not None:
            _body_params = add_role_to_tenant_team_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/tenant/{tenantId}/team/{teamId}/add-role',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def add_tenant_member(
        self,
        tenant_id: StrictStr,
        add_tenant_member_body: AddTenantMemberBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AddTenantMemberResponse:
        """Adds a member to a tenant

        This endpoint adds a member to a tenant based on the provided tenant ID and member ID.The addition process ensures that the member is properly associated with the tenant.

        :param tenant_id: (required)
        :type tenant_id: str
        :param add_tenant_member_body: (required)
        :type add_tenant_member_body: AddTenantMemberBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_tenant_member_serialize(
            tenant_id=tenant_id,
            add_tenant_member_body=add_tenant_member_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddTenantMemberResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_tenant_member_with_http_info(
        self,
        tenant_id: StrictStr,
        add_tenant_member_body: AddTenantMemberBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AddTenantMemberResponse]:
        """Adds a member to a tenant

        This endpoint adds a member to a tenant based on the provided tenant ID and member ID.The addition process ensures that the member is properly associated with the tenant.

        :param tenant_id: (required)
        :type tenant_id: str
        :param add_tenant_member_body: (required)
        :type add_tenant_member_body: AddTenantMemberBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_tenant_member_serialize(
            tenant_id=tenant_id,
            add_tenant_member_body=add_tenant_member_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddTenantMemberResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_tenant_member_without_preload_content(
        self,
        tenant_id: StrictStr,
        add_tenant_member_body: AddTenantMemberBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Adds a member to a tenant

        This endpoint adds a member to a tenant based on the provided tenant ID and member ID.The addition process ensures that the member is properly associated with the tenant.

        :param tenant_id: (required)
        :type tenant_id: str
        :param add_tenant_member_body: (required)
        :type add_tenant_member_body: AddTenantMemberBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_tenant_member_serialize(
            tenant_id=tenant_id,
            add_tenant_member_body=add_tenant_member_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddTenantMemberResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_tenant_member_serialize(
        self,
        tenant_id,
        add_tenant_member_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_id is not None:
            _path_params['tenantId'] = tenant_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if add_tenant_member_body is not None:
            _body_params = add_tenant_member_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/tenant/{tenantId}/add-new-teammember',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def add_user_to_team(
        self,
        team_id: StrictStr,
        add_user_to_team_body: AddUserToTeamBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AddUserToTeamResponse:
        """Adds a user to a team

        This endpoint adds a user to a team based on the provided team ID and user ID.The addition process ensures that the user is properly associated with the team.

        :param team_id: (required)
        :type team_id: str
        :param add_user_to_team_body: (required)
        :type add_user_to_team_body: AddUserToTeamBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_user_to_team_serialize(
            team_id=team_id,
            add_user_to_team_body=add_user_to_team_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddUserToTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_user_to_team_with_http_info(
        self,
        team_id: StrictStr,
        add_user_to_team_body: AddUserToTeamBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AddUserToTeamResponse]:
        """Adds a user to a team

        This endpoint adds a user to a team based on the provided team ID and user ID.The addition process ensures that the user is properly associated with the team.

        :param team_id: (required)
        :type team_id: str
        :param add_user_to_team_body: (required)
        :type add_user_to_team_body: AddUserToTeamBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_user_to_team_serialize(
            team_id=team_id,
            add_user_to_team_body=add_user_to_team_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddUserToTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_user_to_team_without_preload_content(
        self,
        team_id: StrictStr,
        add_user_to_team_body: AddUserToTeamBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Adds a user to a team

        This endpoint adds a user to a team based on the provided team ID and user ID.The addition process ensures that the user is properly associated with the team.

        :param team_id: (required)
        :type team_id: str
        :param add_user_to_team_body: (required)
        :type add_user_to_team_body: AddUserToTeamBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_user_to_team_serialize(
            team_id=team_id,
            add_user_to_team_body=add_user_to_team_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddUserToTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_user_to_team_serialize(
        self,
        team_id,
        add_user_to_team_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if team_id is not None:
            _path_params['teamId'] = team_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if add_user_to_team_body is not None:
            _body_params = add_user_to_team_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/team/{teamId}/add-new-user',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def bulk_add_team_members(
        self,
        team_id: Annotated[StrictStr, Field(description="Team identifier (required)")],
        bulk_add_team_members_body: BulkAddTeamMembersBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BulkAddTeamMembersResponse:
        """Bulk add team members

        Adds multiple members to a team in a single operation

        :param team_id: Team identifier (required) (required)
        :type team_id: str
        :param bulk_add_team_members_body: (required)
        :type bulk_add_team_members_body: BulkAddTeamMembersBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_add_team_members_serialize(
            team_id=team_id,
            bulk_add_team_members_body=bulk_add_team_members_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkAddTeamMembersResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def bulk_add_team_members_with_http_info(
        self,
        team_id: Annotated[StrictStr, Field(description="Team identifier (required)")],
        bulk_add_team_members_body: BulkAddTeamMembersBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BulkAddTeamMembersResponse]:
        """Bulk add team members

        Adds multiple members to a team in a single operation

        :param team_id: Team identifier (required) (required)
        :type team_id: str
        :param bulk_add_team_members_body: (required)
        :type bulk_add_team_members_body: BulkAddTeamMembersBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_add_team_members_serialize(
            team_id=team_id,
            bulk_add_team_members_body=bulk_add_team_members_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkAddTeamMembersResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def bulk_add_team_members_without_preload_content(
        self,
        team_id: Annotated[StrictStr, Field(description="Team identifier (required)")],
        bulk_add_team_members_body: BulkAddTeamMembersBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Bulk add team members

        Adds multiple members to a team in a single operation

        :param team_id: Team identifier (required) (required)
        :type team_id: str
        :param bulk_add_team_members_body: (required)
        :type bulk_add_team_members_body: BulkAddTeamMembersBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_add_team_members_serialize(
            team_id=team_id,
            bulk_add_team_members_body=bulk_add_team_members_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkAddTeamMembersResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _bulk_add_team_members_serialize(
        self,
        team_id,
        bulk_add_team_members_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if team_id is not None:
            _path_params['teamId'] = team_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if bulk_add_team_members_body is not None:
            _body_params = bulk_add_team_members_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/team/{teamId}/members/bulk-add',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def bulk_remove_team_members(
        self,
        team_id: Annotated[StrictStr, Field(description="Team identifier (required)")],
        bulk_remove_team_members_body: BulkRemoveTeamMembersBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BulkRemoveTeamMembersResponse:
        """Bulk remove team members

        Removes multiple members from a team in a single operation

        :param team_id: Team identifier (required) (required)
        :type team_id: str
        :param bulk_remove_team_members_body: (required)
        :type bulk_remove_team_members_body: BulkRemoveTeamMembersBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_remove_team_members_serialize(
            team_id=team_id,
            bulk_remove_team_members_body=bulk_remove_team_members_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkRemoveTeamMembersResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def bulk_remove_team_members_with_http_info(
        self,
        team_id: Annotated[StrictStr, Field(description="Team identifier (required)")],
        bulk_remove_team_members_body: BulkRemoveTeamMembersBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BulkRemoveTeamMembersResponse]:
        """Bulk remove team members

        Removes multiple members from a team in a single operation

        :param team_id: Team identifier (required) (required)
        :type team_id: str
        :param bulk_remove_team_members_body: (required)
        :type bulk_remove_team_members_body: BulkRemoveTeamMembersBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_remove_team_members_serialize(
            team_id=team_id,
            bulk_remove_team_members_body=bulk_remove_team_members_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkRemoveTeamMembersResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def bulk_remove_team_members_without_preload_content(
        self,
        team_id: Annotated[StrictStr, Field(description="Team identifier (required)")],
        bulk_remove_team_members_body: BulkRemoveTeamMembersBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Bulk remove team members

        Removes multiple members from a team in a single operation

        :param team_id: Team identifier (required) (required)
        :type team_id: str
        :param bulk_remove_team_members_body: (required)
        :type bulk_remove_team_members_body: BulkRemoveTeamMembersBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_remove_team_members_serialize(
            team_id=team_id,
            bulk_remove_team_members_body=bulk_remove_team_members_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkRemoveTeamMembersResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _bulk_remove_team_members_serialize(
        self,
        team_id,
        bulk_remove_team_members_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if team_id is not None:
            _path_params['teamId'] = team_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if bulk_remove_team_members_body is not None:
            _body_params = bulk_remove_team_members_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/team/{teamId}/members/bulk-remove',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def bulk_revoke_org_api_keys(
        self,
        bulk_revoke_org_api_keys_request: BulkRevokeOrgAPIKeysRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BulkRevokeOrgAPIKeysResponse:
        """Revokes multiple API keys

        This endpoint revokes (deletes) multiple API keys in a single operation. It accepts a list of key IDs to be revoked.

        :param bulk_revoke_org_api_keys_request: (required)
        :type bulk_revoke_org_api_keys_request: BulkRevokeOrgAPIKeysRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_revoke_org_api_keys_serialize(
            bulk_revoke_org_api_keys_request=bulk_revoke_org_api_keys_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkRevokeOrgAPIKeysResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def bulk_revoke_org_api_keys_with_http_info(
        self,
        bulk_revoke_org_api_keys_request: BulkRevokeOrgAPIKeysRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BulkRevokeOrgAPIKeysResponse]:
        """Revokes multiple API keys

        This endpoint revokes (deletes) multiple API keys in a single operation. It accepts a list of key IDs to be revoked.

        :param bulk_revoke_org_api_keys_request: (required)
        :type bulk_revoke_org_api_keys_request: BulkRevokeOrgAPIKeysRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_revoke_org_api_keys_serialize(
            bulk_revoke_org_api_keys_request=bulk_revoke_org_api_keys_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkRevokeOrgAPIKeysResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def bulk_revoke_org_api_keys_without_preload_content(
        self,
        bulk_revoke_org_api_keys_request: BulkRevokeOrgAPIKeysRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Revokes multiple API keys

        This endpoint revokes (deletes) multiple API keys in a single operation. It accepts a list of key IDs to be revoked.

        :param bulk_revoke_org_api_keys_request: (required)
        :type bulk_revoke_org_api_keys_request: BulkRevokeOrgAPIKeysRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_revoke_org_api_keys_serialize(
            bulk_revoke_org_api_keys_request=bulk_revoke_org_api_keys_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkRevokeOrgAPIKeysResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _bulk_revoke_org_api_keys_serialize(
        self,
        bulk_revoke_org_api_keys_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if bulk_revoke_org_api_keys_request is not None:
            _body_params = bulk_revoke_org_api_keys_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/api-keys/bulk-revoke',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def check_email_and_auth0_user_id_exists(
        self,
        email: Annotated[StrictStr, Field(description="The email of the user of interest")],
        supabase_auth0_user_id: Annotated[StrictStr, Field(description="The auth0 user id of the user")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CheckEmailAndAuth0UserIdExistsResponse:
        """Checks that an email and auth0 user id exists or not

        Checks if an email and auth0 user id exists or not

        :param email: The email of the user of interest (required)
        :type email: str
        :param supabase_auth0_user_id: The auth0 user id of the user (required)
        :type supabase_auth0_user_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_email_and_auth0_user_id_exists_serialize(
            email=email,
            supabase_auth0_user_id=supabase_auth0_user_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckEmailAndAuth0UserIdExistsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def check_email_and_auth0_user_id_exists_with_http_info(
        self,
        email: Annotated[StrictStr, Field(description="The email of the user of interest")],
        supabase_auth0_user_id: Annotated[StrictStr, Field(description="The auth0 user id of the user")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CheckEmailAndAuth0UserIdExistsResponse]:
        """Checks that an email and auth0 user id exists or not

        Checks if an email and auth0 user id exists or not

        :param email: The email of the user of interest (required)
        :type email: str
        :param supabase_auth0_user_id: The auth0 user id of the user (required)
        :type supabase_auth0_user_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_email_and_auth0_user_id_exists_serialize(
            email=email,
            supabase_auth0_user_id=supabase_auth0_user_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckEmailAndAuth0UserIdExistsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def check_email_and_auth0_user_id_exists_without_preload_content(
        self,
        email: Annotated[StrictStr, Field(description="The email of the user of interest")],
        supabase_auth0_user_id: Annotated[StrictStr, Field(description="The auth0 user id of the user")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Checks that an email and auth0 user id exists or not

        Checks if an email and auth0 user id exists or not

        :param email: The email of the user of interest (required)
        :type email: str
        :param supabase_auth0_user_id: The auth0 user id of the user (required)
        :type supabase_auth0_user_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_email_and_auth0_user_id_exists_serialize(
            email=email,
            supabase_auth0_user_id=supabase_auth0_user_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckEmailAndAuth0UserIdExistsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _check_email_and_auth0_user_id_exists_serialize(
        self,
        email,
        supabase_auth0_user_id,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if email is not None:
            _path_params['email'] = email
        if supabase_auth0_user_id is not None:
            _path_params['supabaseAuth0UserId'] = supabase_auth0_user_id
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user/email/{email}/auth0/{supabaseAuth0UserId}/exists',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def check_email_exists_v2(
        self,
        email: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CheckEmailExistsV2Response:
        """Validate email existence

        Checks if an email exists in the system with comprehensive validation

        :param email: (required)
        :type email: str
        :param profile_type: the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_email_exists_v2_serialize(
            email=email,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckEmailExistsV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def check_email_exists_v2_with_http_info(
        self,
        email: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CheckEmailExistsV2Response]:
        """Validate email existence

        Checks if an email exists in the system with comprehensive validation

        :param email: (required)
        :type email: str
        :param profile_type: the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_email_exists_v2_serialize(
            email=email,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckEmailExistsV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def check_email_exists_v2_without_preload_content(
        self,
        email: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Validate email existence

        Checks if an email exists in the system with comprehensive validation

        :param email: (required)
        :type email: str
        :param profile_type: the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_email_exists_v2_serialize(
            email=email,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckEmailExistsV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _check_email_exists_v2_serialize(
        self,
        email,
        profile_type,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if email is not None:
            _path_params['email'] = email
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/email/{email}/exists',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def check_username_exists_v2(
        self,
        username: Annotated[StrictStr, Field(description="The username of the user of interest")],
        profile_type: Annotated[StrictStr, Field(description="the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CheckUsernameExistsV2Response:
        """Validate username existence

        Checks if a username exists in the system with comprehensive validation

        :param username: The username of the user of interest (required)
        :type username: str
        :param profile_type: the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_username_exists_v2_serialize(
            username=username,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckUsernameExistsV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def check_username_exists_v2_with_http_info(
        self,
        username: Annotated[StrictStr, Field(description="The username of the user of interest")],
        profile_type: Annotated[StrictStr, Field(description="the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CheckUsernameExistsV2Response]:
        """Validate username existence

        Checks if a username exists in the system with comprehensive validation

        :param username: The username of the user of interest (required)
        :type username: str
        :param profile_type: the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_username_exists_v2_serialize(
            username=username,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckUsernameExistsV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def check_username_exists_v2_without_preload_content(
        self,
        username: Annotated[StrictStr, Field(description="The username of the user of interest")],
        profile_type: Annotated[StrictStr, Field(description="the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Validate username existence

        Checks if a username exists in the system with comprehensive validation

        :param username: The username of the user of interest (required)
        :type username: str
        :param profile_type: the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_username_exists_v2_serialize(
            username=username,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckUsernameExistsV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _check_username_exists_v2_serialize(
        self,
        username,
        profile_type,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if username is not None:
            _path_params['username'] = username
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/username/{username}/exists',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_organization(
        self,
        create_organization_request: CreateOrganizationRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateOrganizationResponse:
        """Creates a new organization

        This endpoint adds a new organization to the system. It requires organization details such as name, description, and members.The creation process involves adding the organization to the database and initializing its members.

        :param create_organization_request: (required)
        :type create_organization_request: CreateOrganizationRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_organization_serialize(
            create_organization_request=create_organization_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_organization_with_http_info(
        self,
        create_organization_request: CreateOrganizationRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateOrganizationResponse]:
        """Creates a new organization

        This endpoint adds a new organization to the system. It requires organization details such as name, description, and members.The creation process involves adding the organization to the database and initializing its members.

        :param create_organization_request: (required)
        :type create_organization_request: CreateOrganizationRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_organization_serialize(
            create_organization_request=create_organization_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_organization_without_preload_content(
        self,
        create_organization_request: CreateOrganizationRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Creates a new organization

        This endpoint adds a new organization to the system. It requires organization details such as name, description, and members.The creation process involves adding the organization to the database and initializing its members.

        :param create_organization_request: (required)
        :type create_organization_request: CreateOrganizationRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_organization_serialize(
            create_organization_request=create_organization_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_organization_serialize(
        self,
        create_organization_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_organization_request is not None:
            _body_params = create_organization_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/organization',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_organization_api_key(
        self,
        create_organization_api_key_request: CreateOrganizationApiKeyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateOrganizationApiKeyResponse:
        """Creates a new organization API key

        This endpoint creates a new API key for an organization. It requires details such as name, expiration, and permissions.

        :param create_organization_api_key_request: (required)
        :type create_organization_api_key_request: CreateOrganizationApiKeyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_organization_api_key_serialize(
            create_organization_api_key_request=create_organization_api_key_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateOrganizationApiKeyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_organization_api_key_with_http_info(
        self,
        create_organization_api_key_request: CreateOrganizationApiKeyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateOrganizationApiKeyResponse]:
        """Creates a new organization API key

        This endpoint creates a new API key for an organization. It requires details such as name, expiration, and permissions.

        :param create_organization_api_key_request: (required)
        :type create_organization_api_key_request: CreateOrganizationApiKeyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_organization_api_key_serialize(
            create_organization_api_key_request=create_organization_api_key_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateOrganizationApiKeyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_organization_api_key_without_preload_content(
        self,
        create_organization_api_key_request: CreateOrganizationApiKeyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Creates a new organization API key

        This endpoint creates a new API key for an organization. It requires details such as name, expiration, and permissions.

        :param create_organization_api_key_request: (required)
        :type create_organization_api_key_request: CreateOrganizationApiKeyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_organization_api_key_serialize(
            create_organization_api_key_request=create_organization_api_key_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateOrganizationApiKeyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_organization_api_key_serialize(
        self,
        create_organization_api_key_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_organization_api_key_request is not None:
            _body_params = create_organization_api_key_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/organization-api-key',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_role(
        self,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        role: Role,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateRoleResponse:
        """Creates a new role

        This endpoint adds a new role to the system. It requires role details such as name, type, and permissions.The creation process involves adding the role to the database and initializing its permissions.

        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param role: (required)
        :type role: Role
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_role_serialize(
            organization_id=organization_id,
            tenant_id=tenant_id,
            role=role,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateRoleResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_role_with_http_info(
        self,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        role: Role,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateRoleResponse]:
        """Creates a new role

        This endpoint adds a new role to the system. It requires role details such as name, type, and permissions.The creation process involves adding the role to the database and initializing its permissions.

        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param role: (required)
        :type role: Role
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_role_serialize(
            organization_id=organization_id,
            tenant_id=tenant_id,
            role=role,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateRoleResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_role_without_preload_content(
        self,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        role: Role,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Creates a new role

        This endpoint adds a new role to the system. It requires role details such as name, type, and permissions.The creation process involves adding the role to the database and initializing its permissions.

        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param role: (required)
        :type role: Role
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_role_serialize(
            organization_id=organization_id,
            tenant_id=tenant_id,
            role=role,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateRoleResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_role_serialize(
        self,
        organization_id,
        tenant_id,
        role,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if role is not None:
            _body_params = role


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/role',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_team(
        self,
        create_team_request: CreateTeamRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateTeamResponse:
        """Creates a new team

        This endpoint adds a new team to the system. It requires team details such as name, description, and members.The creation process involves adding the team to the database and initializing its members.

        :param create_team_request: (required)
        :type create_team_request: CreateTeamRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_team_serialize(
            create_team_request=create_team_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_team_with_http_info(
        self,
        create_team_request: CreateTeamRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateTeamResponse]:
        """Creates a new team

        This endpoint adds a new team to the system. It requires team details such as name, description, and members.The creation process involves adding the team to the database and initializing its members.

        :param create_team_request: (required)
        :type create_team_request: CreateTeamRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_team_serialize(
            create_team_request=create_team_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_team_without_preload_content(
        self,
        create_team_request: CreateTeamRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Creates a new team

        This endpoint adds a new team to the system. It requires team details such as name, description, and members.The creation process involves adding the team to the database and initializing its members.

        :param create_team_request: (required)
        :type create_team_request: CreateTeamRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_team_serialize(
            create_team_request=create_team_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_team_serialize(
        self,
        create_team_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_team_request is not None:
            _body_params = create_team_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/team',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_tenant(
        self,
        create_tenant_request: CreateTenantRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateTenantResponse:
        """Creates a new tenant

        This endpoint adds a new tenant to the system. It requires tenant details such as name, description, and members.The creation process involves adding the tenant to the database and initializing its members.

        :param create_tenant_request: (required)
        :type create_tenant_request: CreateTenantRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_tenant_serialize(
            create_tenant_request=create_tenant_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateTenantResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_tenant_with_http_info(
        self,
        create_tenant_request: CreateTenantRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateTenantResponse]:
        """Creates a new tenant

        This endpoint adds a new tenant to the system. It requires tenant details such as name, description, and members.The creation process involves adding the tenant to the database and initializing its members.

        :param create_tenant_request: (required)
        :type create_tenant_request: CreateTenantRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_tenant_serialize(
            create_tenant_request=create_tenant_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateTenantResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_tenant_without_preload_content(
        self,
        create_tenant_request: CreateTenantRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Creates a new tenant

        This endpoint adds a new tenant to the system. It requires tenant details such as name, description, and members.The creation process involves adding the tenant to the database and initializing its members.

        :param create_tenant_request: (required)
        :type create_tenant_request: CreateTenantRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_tenant_serialize(
            create_tenant_request=create_tenant_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateTenantResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_tenant_serialize(
        self,
        create_tenant_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_tenant_request is not None:
            _body_params = create_tenant_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/tenant',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_tenant_api_key(
        self,
        create_tenant_api_key_request: CreateTenantApiKeyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateTenantApiKeyResponse:
        """Creates a new tenant API key

        This endpoint creates a new API key for a tenant. It requires details such as name, expiration, and permissions.

        :param create_tenant_api_key_request: (required)
        :type create_tenant_api_key_request: CreateTenantApiKeyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_tenant_api_key_serialize(
            create_tenant_api_key_request=create_tenant_api_key_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateTenantApiKeyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_tenant_api_key_with_http_info(
        self,
        create_tenant_api_key_request: CreateTenantApiKeyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateTenantApiKeyResponse]:
        """Creates a new tenant API key

        This endpoint creates a new API key for a tenant. It requires details such as name, expiration, and permissions.

        :param create_tenant_api_key_request: (required)
        :type create_tenant_api_key_request: CreateTenantApiKeyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_tenant_api_key_serialize(
            create_tenant_api_key_request=create_tenant_api_key_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateTenantApiKeyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_tenant_api_key_without_preload_content(
        self,
        create_tenant_api_key_request: CreateTenantApiKeyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Creates a new tenant API key

        This endpoint creates a new API key for a tenant. It requires details such as name, expiration, and permissions.

        :param create_tenant_api_key_request: (required)
        :type create_tenant_api_key_request: CreateTenantApiKeyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_tenant_api_key_serialize(
            create_tenant_api_key_request=create_tenant_api_key_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateTenantApiKeyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_tenant_api_key_serialize(
        self,
        create_tenant_api_key_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_tenant_api_key_request is not None:
            _body_params = create_tenant_api_key_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/tenant-api-key',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_tenant_team(
        self,
        create_tenant_team_request: CreateTenantTeamRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateTenantTeamResponse:
        """Creates a new team

        This endpoint adds a new team to the system. It requires team details such as name, description, and members.The creation process involves adding the team to the database and initializing its members.

        :param create_tenant_team_request: (required)
        :type create_tenant_team_request: CreateTenantTeamRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_tenant_team_serialize(
            create_tenant_team_request=create_tenant_team_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_tenant_team_with_http_info(
        self,
        create_tenant_team_request: CreateTenantTeamRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateTenantTeamResponse]:
        """Creates a new team

        This endpoint adds a new team to the system. It requires team details such as name, description, and members.The creation process involves adding the team to the database and initializing its members.

        :param create_tenant_team_request: (required)
        :type create_tenant_team_request: CreateTenantTeamRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_tenant_team_serialize(
            create_tenant_team_request=create_tenant_team_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_tenant_team_without_preload_content(
        self,
        create_tenant_team_request: CreateTenantTeamRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Creates a new team

        This endpoint adds a new team to the system. It requires team details such as name, description, and members.The creation process involves adding the team to the database and initializing its members.

        :param create_tenant_team_request: (required)
        :type create_tenant_team_request: CreateTenantTeamRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_tenant_team_serialize(
            create_tenant_team_request=create_tenant_team_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_tenant_team_serialize(
        self,
        create_tenant_team_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_tenant_team_request is not None:
            _body_params = create_tenant_team_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/tenant-team',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_user_v2(
        self,
        create_user_v2_request: Annotated[CreateUserV2Request, Field(description="CreateUserV2Request represents the request object for creating a user account in the user service (version 2). This message encapsulates all necessary information to create a user account, including authentication details, contact information, and profile preferences.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateUserV2Response:
        """Create new user account

        Creates a new user account with comprehensive setup across multiple services. Handles different account types and ensures proper initialization of all components. Includes security measures and validation.

        :param create_user_v2_request: CreateUserV2Request represents the request object for creating a user account in the user service (version 2). This message encapsulates all necessary information to create a user account, including authentication details, contact information, and profile preferences. (required)
        :type create_user_v2_request: CreateUserV2Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_user_v2_serialize(
            create_user_v2_request=create_user_v2_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateUserV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_user_v2_with_http_info(
        self,
        create_user_v2_request: Annotated[CreateUserV2Request, Field(description="CreateUserV2Request represents the request object for creating a user account in the user service (version 2). This message encapsulates all necessary information to create a user account, including authentication details, contact information, and profile preferences.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateUserV2Response]:
        """Create new user account

        Creates a new user account with comprehensive setup across multiple services. Handles different account types and ensures proper initialization of all components. Includes security measures and validation.

        :param create_user_v2_request: CreateUserV2Request represents the request object for creating a user account in the user service (version 2). This message encapsulates all necessary information to create a user account, including authentication details, contact information, and profile preferences. (required)
        :type create_user_v2_request: CreateUserV2Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_user_v2_serialize(
            create_user_v2_request=create_user_v2_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateUserV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_user_v2_without_preload_content(
        self,
        create_user_v2_request: Annotated[CreateUserV2Request, Field(description="CreateUserV2Request represents the request object for creating a user account in the user service (version 2). This message encapsulates all necessary information to create a user account, including authentication details, contact information, and profile preferences.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create new user account

        Creates a new user account with comprehensive setup across multiple services. Handles different account types and ensures proper initialization of all components. Includes security measures and validation.

        :param create_user_v2_request: CreateUserV2Request represents the request object for creating a user account in the user service (version 2). This message encapsulates all necessary information to create a user account, including authentication details, contact information, and profile preferences. (required)
        :type create_user_v2_request: CreateUserV2Request
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_user_v2_serialize(
            create_user_v2_request=create_user_v2_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateUserV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_user_v2_serialize(
        self,
        create_user_v2_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_user_v2_request is not None:
            _body_params = create_user_v2_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_organization(
        self,
        organization_id: StrictStr,
        owner_supabase_auth_user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteOrganizationResponse:
        """Deletes an organization

        This endpoint deletes an organization from the system based on the provided organization ID.The deletion process ensures that all related data and members are properly removed.

        :param organization_id: (required)
        :type organization_id: str
        :param owner_supabase_auth_user_id: (required)
        :type owner_supabase_auth_user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_organization_serialize(
            organization_id=organization_id,
            owner_supabase_auth_user_id=owner_supabase_auth_user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_organization_with_http_info(
        self,
        organization_id: StrictStr,
        owner_supabase_auth_user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteOrganizationResponse]:
        """Deletes an organization

        This endpoint deletes an organization from the system based on the provided organization ID.The deletion process ensures that all related data and members are properly removed.

        :param organization_id: (required)
        :type organization_id: str
        :param owner_supabase_auth_user_id: (required)
        :type owner_supabase_auth_user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_organization_serialize(
            organization_id=organization_id,
            owner_supabase_auth_user_id=owner_supabase_auth_user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_organization_without_preload_content(
        self,
        organization_id: StrictStr,
        owner_supabase_auth_user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Deletes an organization

        This endpoint deletes an organization from the system based on the provided organization ID.The deletion process ensures that all related data and members are properly removed.

        :param organization_id: (required)
        :type organization_id: str
        :param owner_supabase_auth_user_id: (required)
        :type owner_supabase_auth_user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_organization_serialize(
            organization_id=organization_id,
            owner_supabase_auth_user_id=owner_supabase_auth_user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_organization_serialize(
        self,
        organization_id,
        owner_supabase_auth_user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if organization_id is not None:
            _path_params['organizationId'] = organization_id
        if owner_supabase_auth_user_id is not None:
            _path_params['ownerSupabaseAuthUserId'] = owner_supabase_auth_user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/user-microservice/api/v2/user-service/user/organization/{organizationId}/admin/{ownerSupabaseAuthUserId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_organization_api_key(
        self,
        organization_api_key_id: StrictStr,
        organization_id: StrictStr,
        owner_supabase_auth_user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteOrganizationApiKeyResponse:
        """Deletes an organization API key

        This endpoint deletes an organization API key based on the provided key ID.

        :param organization_api_key_id: (required)
        :type organization_api_key_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param owner_supabase_auth_user_id: (required)
        :type owner_supabase_auth_user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_organization_api_key_serialize(
            organization_api_key_id=organization_api_key_id,
            organization_id=organization_id,
            owner_supabase_auth_user_id=owner_supabase_auth_user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteOrganizationApiKeyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_organization_api_key_with_http_info(
        self,
        organization_api_key_id: StrictStr,
        organization_id: StrictStr,
        owner_supabase_auth_user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteOrganizationApiKeyResponse]:
        """Deletes an organization API key

        This endpoint deletes an organization API key based on the provided key ID.

        :param organization_api_key_id: (required)
        :type organization_api_key_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param owner_supabase_auth_user_id: (required)
        :type owner_supabase_auth_user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_organization_api_key_serialize(
            organization_api_key_id=organization_api_key_id,
            organization_id=organization_id,
            owner_supabase_auth_user_id=owner_supabase_auth_user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteOrganizationApiKeyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_organization_api_key_without_preload_content(
        self,
        organization_api_key_id: StrictStr,
        organization_id: StrictStr,
        owner_supabase_auth_user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Deletes an organization API key

        This endpoint deletes an organization API key based on the provided key ID.

        :param organization_api_key_id: (required)
        :type organization_api_key_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param owner_supabase_auth_user_id: (required)
        :type owner_supabase_auth_user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_organization_api_key_serialize(
            organization_api_key_id=organization_api_key_id,
            organization_id=organization_id,
            owner_supabase_auth_user_id=owner_supabase_auth_user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteOrganizationApiKeyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_organization_api_key_serialize(
        self,
        organization_api_key_id,
        organization_id,
        owner_supabase_auth_user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if organization_api_key_id is not None:
            _path_params['organizationApiKeyId'] = organization_api_key_id
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if owner_supabase_auth_user_id is not None:
            
            _query_params.append(('ownerSupabaseAuthUserId', owner_supabase_auth_user_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/user-microservice/api/v2/user-service/user/organization-api-key/{organizationApiKeyId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_role(
        self,
        id: StrictStr,
        role_id: StrictStr,
        member_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteRoleResponse:
        """Deletes a role

        This endpoint deletes a role from the system based on the provided role ID.The deletion process ensures that all related data and permissions are properly removed.

        :param id: (required)
        :type id: str
        :param role_id: (required)
        :type role_id: str
        :param member_id: (required)
        :type member_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_role_serialize(
            id=id,
            role_id=role_id,
            member_id=member_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteRoleResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_role_with_http_info(
        self,
        id: StrictStr,
        role_id: StrictStr,
        member_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteRoleResponse]:
        """Deletes a role

        This endpoint deletes a role from the system based on the provided role ID.The deletion process ensures that all related data and permissions are properly removed.

        :param id: (required)
        :type id: str
        :param role_id: (required)
        :type role_id: str
        :param member_id: (required)
        :type member_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_role_serialize(
            id=id,
            role_id=role_id,
            member_id=member_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteRoleResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_role_without_preload_content(
        self,
        id: StrictStr,
        role_id: StrictStr,
        member_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Deletes a role

        This endpoint deletes a role from the system based on the provided role ID.The deletion process ensures that all related data and permissions are properly removed.

        :param id: (required)
        :type id: str
        :param role_id: (required)
        :type role_id: str
        :param member_id: (required)
        :type member_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_role_serialize(
            id=id,
            role_id=role_id,
            member_id=member_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteRoleResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_role_serialize(
        self,
        id,
        role_id,
        member_id,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if role_id is not None:
            
            _query_params.append(('roleId', role_id))
            
        if member_id is not None:
            
            _query_params.append(('memberId', member_id))
            
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/user-microservice/api/v2/user-service/user/role/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_role_from_tenant_team(
        self,
        tenant_id: StrictStr,
        team_id: StrictStr,
        organization_id: StrictStr,
        role_id: StrictStr,
        member_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteRoleFromTenantTeamResponse:
        """Deletes a role from a team

        This endpoint deletes a role from a team based on the provided tenant ID, team ID, and role ID.The deletion process ensures that the role is properly disassociated from the team.

        :param tenant_id: (required)
        :type tenant_id: str
        :param team_id: (required)
        :type team_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param role_id: (required)
        :type role_id: str
        :param member_id: (required)
        :type member_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_role_from_tenant_team_serialize(
            tenant_id=tenant_id,
            team_id=team_id,
            organization_id=organization_id,
            role_id=role_id,
            member_id=member_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteRoleFromTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_role_from_tenant_team_with_http_info(
        self,
        tenant_id: StrictStr,
        team_id: StrictStr,
        organization_id: StrictStr,
        role_id: StrictStr,
        member_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteRoleFromTenantTeamResponse]:
        """Deletes a role from a team

        This endpoint deletes a role from a team based on the provided tenant ID, team ID, and role ID.The deletion process ensures that the role is properly disassociated from the team.

        :param tenant_id: (required)
        :type tenant_id: str
        :param team_id: (required)
        :type team_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param role_id: (required)
        :type role_id: str
        :param member_id: (required)
        :type member_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_role_from_tenant_team_serialize(
            tenant_id=tenant_id,
            team_id=team_id,
            organization_id=organization_id,
            role_id=role_id,
            member_id=member_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteRoleFromTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_role_from_tenant_team_without_preload_content(
        self,
        tenant_id: StrictStr,
        team_id: StrictStr,
        organization_id: StrictStr,
        role_id: StrictStr,
        member_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Deletes a role from a team

        This endpoint deletes a role from a team based on the provided tenant ID, team ID, and role ID.The deletion process ensures that the role is properly disassociated from the team.

        :param tenant_id: (required)
        :type tenant_id: str
        :param team_id: (required)
        :type team_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param role_id: (required)
        :type role_id: str
        :param member_id: (required)
        :type member_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_role_from_tenant_team_serialize(
            tenant_id=tenant_id,
            team_id=team_id,
            organization_id=organization_id,
            role_id=role_id,
            member_id=member_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteRoleFromTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_role_from_tenant_team_serialize(
        self,
        tenant_id,
        team_id,
        organization_id,
        role_id,
        member_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_id is not None:
            _path_params['tenantId'] = tenant_id
        if team_id is not None:
            _path_params['teamId'] = team_id
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if role_id is not None:
            
            _query_params.append(('roleId', role_id))
            
        if member_id is not None:
            
            _query_params.append(('memberId', member_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/user-microservice/api/v2/user-service/user/tenant/{tenantId}/team/{teamId}/delete-role',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_team(
        self,
        team_id: StrictStr,
        admin_supabase_auth0_user_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteTeamResponse:
        """Deletes a team

        This endpoint deletes a team from the system based on the provided team ID.The deletion process ensures that all related data and members are properly removed.

        :param team_id: (required)
        :type team_id: str
        :param admin_supabase_auth0_user_id: (required)
        :type admin_supabase_auth0_user_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_team_serialize(
            team_id=team_id,
            admin_supabase_auth0_user_id=admin_supabase_auth0_user_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_team_with_http_info(
        self,
        team_id: StrictStr,
        admin_supabase_auth0_user_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteTeamResponse]:
        """Deletes a team

        This endpoint deletes a team from the system based on the provided team ID.The deletion process ensures that all related data and members are properly removed.

        :param team_id: (required)
        :type team_id: str
        :param admin_supabase_auth0_user_id: (required)
        :type admin_supabase_auth0_user_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_team_serialize(
            team_id=team_id,
            admin_supabase_auth0_user_id=admin_supabase_auth0_user_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_team_without_preload_content(
        self,
        team_id: StrictStr,
        admin_supabase_auth0_user_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Deletes a team

        This endpoint deletes a team from the system based on the provided team ID.The deletion process ensures that all related data and members are properly removed.

        :param team_id: (required)
        :type team_id: str
        :param admin_supabase_auth0_user_id: (required)
        :type admin_supabase_auth0_user_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_team_serialize(
            team_id=team_id,
            admin_supabase_auth0_user_id=admin_supabase_auth0_user_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_team_serialize(
        self,
        team_id,
        admin_supabase_auth0_user_id,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if team_id is not None:
            _path_params['teamId'] = team_id
        if admin_supabase_auth0_user_id is not None:
            _path_params['adminSupabaseAuth0UserId'] = admin_supabase_auth0_user_id
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/user-microservice/api/v2/user-service/user/team/{teamId}/admin/{adminSupabaseAuth0UserId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_tenant(
        self,
        tenant_id: StrictStr,
        organization_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteTenantResponse:
        """Deletes a tenant

        This endpoint deletes a tenant from the system based on the provided tenant ID.The deletion process ensures that all related data and members are properly removed.

        :param tenant_id: (required)
        :type tenant_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tenant_serialize(
            tenant_id=tenant_id,
            organization_id=organization_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteTenantResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_tenant_with_http_info(
        self,
        tenant_id: StrictStr,
        organization_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteTenantResponse]:
        """Deletes a tenant

        This endpoint deletes a tenant from the system based on the provided tenant ID.The deletion process ensures that all related data and members are properly removed.

        :param tenant_id: (required)
        :type tenant_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tenant_serialize(
            tenant_id=tenant_id,
            organization_id=organization_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteTenantResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_tenant_without_preload_content(
        self,
        tenant_id: StrictStr,
        organization_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Deletes a tenant

        This endpoint deletes a tenant from the system based on the provided tenant ID.The deletion process ensures that all related data and members are properly removed.

        :param tenant_id: (required)
        :type tenant_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tenant_serialize(
            tenant_id=tenant_id,
            organization_id=organization_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteTenantResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_tenant_serialize(
        self,
        tenant_id,
        organization_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_id is not None:
            _path_params['tenantId'] = tenant_id
        if organization_id is not None:
            _path_params['organizationId'] = organization_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/user-microservice/api/v2/user-service/user/tenant/{tenantId}/organization/{organizationId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_tenant_api_key(
        self,
        tenant_api_key_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteTenantApiKeyResponse:
        """Deletes a tenant API key

        This endpoint deletes a tenant API key based on the provided key ID.

        :param tenant_api_key_id: (required)
        :type tenant_api_key_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tenant_api_key_serialize(
            tenant_api_key_id=tenant_api_key_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteTenantApiKeyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_tenant_api_key_with_http_info(
        self,
        tenant_api_key_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteTenantApiKeyResponse]:
        """Deletes a tenant API key

        This endpoint deletes a tenant API key based on the provided key ID.

        :param tenant_api_key_id: (required)
        :type tenant_api_key_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tenant_api_key_serialize(
            tenant_api_key_id=tenant_api_key_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteTenantApiKeyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_tenant_api_key_without_preload_content(
        self,
        tenant_api_key_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Deletes a tenant API key

        This endpoint deletes a tenant API key based on the provided key ID.

        :param tenant_api_key_id: (required)
        :type tenant_api_key_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tenant_api_key_serialize(
            tenant_api_key_id=tenant_api_key_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteTenantApiKeyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_tenant_api_key_serialize(
        self,
        tenant_api_key_id,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_api_key_id is not None:
            _path_params['tenantApiKeyId'] = tenant_api_key_id
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/user-microservice/api/v2/user-service/user/tenant-api-key/{tenantApiKeyId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_tenant_team(
        self,
        team_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteTenantTeamResponse:
        """Deletes a team

        This endpoint deletes a team from the system based on the provided team ID.The deletion process ensures that all related data and members are properly removed.

        :param team_id: (required)
        :type team_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tenant_team_serialize(
            team_id=team_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_tenant_team_with_http_info(
        self,
        team_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteTenantTeamResponse]:
        """Deletes a team

        This endpoint deletes a team from the system based on the provided team ID.The deletion process ensures that all related data and members are properly removed.

        :param team_id: (required)
        :type team_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tenant_team_serialize(
            team_id=team_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_tenant_team_without_preload_content(
        self,
        team_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Deletes a team

        This endpoint deletes a team from the system based on the provided team ID.The deletion process ensures that all related data and members are properly removed.

        :param team_id: (required)
        :type team_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tenant_team_serialize(
            team_id=team_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_tenant_team_serialize(
        self,
        team_id,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if team_id is not None:
            _path_params['teamId'] = team_id
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/user-microservice/api/v2/user-service/user/tenant-team/{teamId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_user_v2(
        self,
        user_id: Annotated[StrictStr, Field(description="The account ID associated with the user to delete Validations: - user_id must be greater than 0")],
        profile_type: Annotated[StrictStr, Field(description="the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteUserV2Response:
        """Delete user account and associated data

        Performs a complete deletion of a user account and associated data across all services. This operation is atomic and ensures consistency across all affected services. Includes comprehensive cleanup and audit trail creation.

        :param user_id: The account ID associated with the user to delete Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_v2_serialize(
            user_id=user_id,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteUserV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_user_v2_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="The account ID associated with the user to delete Validations: - user_id must be greater than 0")],
        profile_type: Annotated[StrictStr, Field(description="the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteUserV2Response]:
        """Delete user account and associated data

        Performs a complete deletion of a user account and associated data across all services. This operation is atomic and ensures consistency across all affected services. Includes comprehensive cleanup and audit trail creation.

        :param user_id: The account ID associated with the user to delete Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_v2_serialize(
            user_id=user_id,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteUserV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_user_v2_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="The account ID associated with the user to delete Validations: - user_id must be greater than 0")],
        profile_type: Annotated[StrictStr, Field(description="the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete user account and associated data

        Performs a complete deletion of a user account and associated data across all services. This operation is atomic and ensures consistency across all affected services. Includes comprehensive cleanup and audit trail creation.

        :param user_id: The account ID associated with the user to delete Validations: - user_id must be greater than 0 (required)
        :type user_id: str
        :param profile_type: the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_v2_serialize(
            user_id=user_id,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteUserV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_user_v2_serialize(
        self,
        user_id,
        profile_type,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/user-microservice/api/v2/user-service/user/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_canny_user_sso_token(
        self,
        user_id: Annotated[StrictStr, Field(description="The account ID associated with the user")],
        profile_type: Annotated[StrictStr, Field(description="Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetCannyUserSSOTokenResponse:
        """Retrieves user sso token for canny

        Fetches a user sso token for canny

        :param user_id: The account ID associated with the user (required)
        :type user_id: str
        :param profile_type: Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_canny_user_sso_token_serialize(
            user_id=user_id,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCannyUserSSOTokenResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_canny_user_sso_token_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="The account ID associated with the user")],
        profile_type: Annotated[StrictStr, Field(description="Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetCannyUserSSOTokenResponse]:
        """Retrieves user sso token for canny

        Fetches a user sso token for canny

        :param user_id: The account ID associated with the user (required)
        :type user_id: str
        :param profile_type: Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_canny_user_sso_token_serialize(
            user_id=user_id,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCannyUserSSOTokenResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_canny_user_sso_token_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="The account ID associated with the user")],
        profile_type: Annotated[StrictStr, Field(description="Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves user sso token for canny

        Fetches a user sso token for canny

        :param user_id: The account ID associated with the user (required)
        :type user_id: str
        :param profile_type: Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_canny_user_sso_token_serialize(
            user_id=user_id,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCannyUserSSOTokenResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_canny_user_sso_token_serialize(
        self,
        user_id,
        profile_type,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/canny/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_org_api_key_permissions(
        self,
        key_id: Annotated[StrictStr, Field(description="The unique identifier of the API key whose permissions are being requested")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetOrgAPIKeyPermissionsResponse:
        """Retrieves permissions for an API key

        This endpoint fetches the permissions associated with a specific API key using the key ID.

        :param key_id: The unique identifier of the API key whose permissions are being requested (required)
        :type key_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_org_api_key_permissions_serialize(
            key_id=key_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetOrgAPIKeyPermissionsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_org_api_key_permissions_with_http_info(
        self,
        key_id: Annotated[StrictStr, Field(description="The unique identifier of the API key whose permissions are being requested")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetOrgAPIKeyPermissionsResponse]:
        """Retrieves permissions for an API key

        This endpoint fetches the permissions associated with a specific API key using the key ID.

        :param key_id: The unique identifier of the API key whose permissions are being requested (required)
        :type key_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_org_api_key_permissions_serialize(
            key_id=key_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetOrgAPIKeyPermissionsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_org_api_key_permissions_without_preload_content(
        self,
        key_id: Annotated[StrictStr, Field(description="The unique identifier of the API key whose permissions are being requested")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves permissions for an API key

        This endpoint fetches the permissions associated with a specific API key using the key ID.

        :param key_id: The unique identifier of the API key whose permissions are being requested (required)
        :type key_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_org_api_key_permissions_serialize(
            key_id=key_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetOrgAPIKeyPermissionsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_org_api_key_permissions_serialize(
        self,
        key_id,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if key_id is not None:
            _path_params['keyId'] = key_id
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/api-keys/{keyId}/permissions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_organization(
        self,
        organization_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetOrganizationResponse:
        """Retrieves an organization

        This endpoint fetches details of a specific organization using the organization ID.It retrieves the organization's name, description, members, and audit history.

        :param organization_id: (required)
        :type organization_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_organization_serialize(
            organization_id=organization_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_organization_with_http_info(
        self,
        organization_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetOrganizationResponse]:
        """Retrieves an organization

        This endpoint fetches details of a specific organization using the organization ID.It retrieves the organization's name, description, members, and audit history.

        :param organization_id: (required)
        :type organization_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_organization_serialize(
            organization_id=organization_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_organization_without_preload_content(
        self,
        organization_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves an organization

        This endpoint fetches details of a specific organization using the organization ID.It retrieves the organization's name, description, members, and audit history.

        :param organization_id: (required)
        :type organization_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_organization_serialize(
            organization_id=organization_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_organization_serialize(
        self,
        organization_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if organization_id is not None:
            _path_params['organizationId'] = organization_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/organization/{organizationId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_organization_member(
        self,
        organization_id: StrictStr,
        organization_member_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetOrganizationMemberResponse:
        """Retrieves a member of an organization

        This endpoint fetches details of a specific member in an organization using the organization ID and member ID.It retrieves the member's name, email, role, and audit history.

        :param organization_id: (required)
        :type organization_id: str
        :param organization_member_id: (required)
        :type organization_member_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_organization_member_serialize(
            organization_id=organization_id,
            organization_member_id=organization_member_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetOrganizationMemberResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_organization_member_with_http_info(
        self,
        organization_id: StrictStr,
        organization_member_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetOrganizationMemberResponse]:
        """Retrieves a member of an organization

        This endpoint fetches details of a specific member in an organization using the organization ID and member ID.It retrieves the member's name, email, role, and audit history.

        :param organization_id: (required)
        :type organization_id: str
        :param organization_member_id: (required)
        :type organization_member_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_organization_member_serialize(
            organization_id=organization_id,
            organization_member_id=organization_member_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetOrganizationMemberResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_organization_member_without_preload_content(
        self,
        organization_id: StrictStr,
        organization_member_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves a member of an organization

        This endpoint fetches details of a specific member in an organization using the organization ID and member ID.It retrieves the member's name, email, role, and audit history.

        :param organization_id: (required)
        :type organization_id: str
        :param organization_member_id: (required)
        :type organization_member_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_organization_member_serialize(
            organization_id=organization_id,
            organization_member_id=organization_member_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetOrganizationMemberResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_organization_member_serialize(
        self,
        organization_id,
        organization_member_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if organization_id is not None:
            _path_params['organizationId'] = organization_id
        if organization_member_id is not None:
            _path_params['organizationMemberId'] = organization_member_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/organization/{organizationId}/member/{organizationMemberId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_role(
        self,
        id: StrictStr,
        role_id: StrictStr,
        member_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        team_id: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetRoleResponse:
        """Retrieves a role

        This endpoint fetches details of a specific role using the role ID.It retrieves the role's name, type, permissions, and audit history.

        :param id: (required)
        :type id: str
        :param role_id: (required)
        :type role_id: str
        :param member_id: (required)
        :type member_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param team_id:
        :type team_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_role_serialize(
            id=id,
            role_id=role_id,
            member_id=member_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            team_id=team_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetRoleResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_role_with_http_info(
        self,
        id: StrictStr,
        role_id: StrictStr,
        member_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        team_id: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetRoleResponse]:
        """Retrieves a role

        This endpoint fetches details of a specific role using the role ID.It retrieves the role's name, type, permissions, and audit history.

        :param id: (required)
        :type id: str
        :param role_id: (required)
        :type role_id: str
        :param member_id: (required)
        :type member_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param team_id:
        :type team_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_role_serialize(
            id=id,
            role_id=role_id,
            member_id=member_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            team_id=team_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetRoleResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_role_without_preload_content(
        self,
        id: StrictStr,
        role_id: StrictStr,
        member_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        team_id: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves a role

        This endpoint fetches details of a specific role using the role ID.It retrieves the role's name, type, permissions, and audit history.

        :param id: (required)
        :type id: str
        :param role_id: (required)
        :type role_id: str
        :param member_id: (required)
        :type member_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param team_id:
        :type team_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_role_serialize(
            id=id,
            role_id=role_id,
            member_id=member_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            team_id=team_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetRoleResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_role_serialize(
        self,
        id,
        role_id,
        member_id,
        organization_id,
        tenant_id,
        team_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if role_id is not None:
            
            _query_params.append(('roleId', role_id))
            
        if member_id is not None:
            
            _query_params.append(('memberId', member_id))
            
        if team_id is not None:
            
            _query_params.append(('teamId', team_id))
            
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/role/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_team(
        self,
        team_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetTeamResponse:
        """Retrieves a team

        This endpoint fetches details of a specific team using the team ID.It retrieves the team's name, description, members, and audit history.

        :param team_id: (required)
        :type team_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_team_serialize(
            team_id=team_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_team_with_http_info(
        self,
        team_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetTeamResponse]:
        """Retrieves a team

        This endpoint fetches details of a specific team using the team ID.It retrieves the team's name, description, members, and audit history.

        :param team_id: (required)
        :type team_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_team_serialize(
            team_id=team_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_team_without_preload_content(
        self,
        team_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves a team

        This endpoint fetches details of a specific team using the team ID.It retrieves the team's name, description, members, and audit history.

        :param team_id: (required)
        :type team_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_team_serialize(
            team_id=team_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_team_serialize(
        self,
        team_id,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if team_id is not None:
            _path_params['teamId'] = team_id
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/team/{teamId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_tenant(
        self,
        tenant_id: StrictStr,
        organization_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetTenantResponse:
        """Retrieves a tenant

        This endpoint fetches details of a specific tenant using the tenant ID.It retrieves the tenant's name, description, members, and audit history.

        :param tenant_id: (required)
        :type tenant_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tenant_serialize(
            tenant_id=tenant_id,
            organization_id=organization_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTenantResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_tenant_with_http_info(
        self,
        tenant_id: StrictStr,
        organization_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetTenantResponse]:
        """Retrieves a tenant

        This endpoint fetches details of a specific tenant using the tenant ID.It retrieves the tenant's name, description, members, and audit history.

        :param tenant_id: (required)
        :type tenant_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tenant_serialize(
            tenant_id=tenant_id,
            organization_id=organization_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTenantResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_tenant_without_preload_content(
        self,
        tenant_id: StrictStr,
        organization_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves a tenant

        This endpoint fetches details of a specific tenant using the tenant ID.It retrieves the tenant's name, description, members, and audit history.

        :param tenant_id: (required)
        :type tenant_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tenant_serialize(
            tenant_id=tenant_id,
            organization_id=organization_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTenantResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_tenant_serialize(
        self,
        tenant_id,
        organization_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_id is not None:
            _path_params['tenantId'] = tenant_id
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/tenant/{tenantId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_tenant_team(
        self,
        team_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetTenantTeamResponse:
        """Retrieves a team

        This endpoint fetches details of a specific team using the team ID.It retrieves the team's name, description, members, and audit history.

        :param team_id: (required)
        :type team_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tenant_team_serialize(
            team_id=team_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_tenant_team_with_http_info(
        self,
        team_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetTenantTeamResponse]:
        """Retrieves a team

        This endpoint fetches details of a specific team using the team ID.It retrieves the team's name, description, members, and audit history.

        :param team_id: (required)
        :type team_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tenant_team_serialize(
            team_id=team_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_tenant_team_without_preload_content(
        self,
        team_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves a team

        This endpoint fetches details of a specific team using the team ID.It retrieves the team's name, description, members, and audit history.

        :param team_id: (required)
        :type team_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tenant_team_serialize(
            team_id=team_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_tenant_team_serialize(
        self,
        team_id,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if team_id is not None:
            _path_params['teamId'] = team_id
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/tenant-team/{teamId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_user_by_auth0_id(
        self,
        supabase_auth0_user_id: Annotated[StrictStr, Field(description="The account ID associated with the user")],
        profile_type: Annotated[StrictStr, Field(description="Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetUserByAuth0IDResponse:
        """Retrieve user account details by auth0 id and profile type

        Fetches detailed information about a user account based on the specified authn ID.

        :param supabase_auth0_user_id: The account ID associated with the user (required)
        :type supabase_auth0_user_id: str
        :param profile_type: Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_auth0_id_serialize(
            supabase_auth0_user_id=supabase_auth0_user_id,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserByAuth0IDResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_user_by_auth0_id_with_http_info(
        self,
        supabase_auth0_user_id: Annotated[StrictStr, Field(description="The account ID associated with the user")],
        profile_type: Annotated[StrictStr, Field(description="Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetUserByAuth0IDResponse]:
        """Retrieve user account details by auth0 id and profile type

        Fetches detailed information about a user account based on the specified authn ID.

        :param supabase_auth0_user_id: The account ID associated with the user (required)
        :type supabase_auth0_user_id: str
        :param profile_type: Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_auth0_id_serialize(
            supabase_auth0_user_id=supabase_auth0_user_id,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserByAuth0IDResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_user_by_auth0_id_without_preload_content(
        self,
        supabase_auth0_user_id: Annotated[StrictStr, Field(description="The account ID associated with the user")],
        profile_type: Annotated[StrictStr, Field(description="Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve user account details by auth0 id and profile type

        Fetches detailed information about a user account based on the specified authn ID.

        :param supabase_auth0_user_id: The account ID associated with the user (required)
        :type supabase_auth0_user_id: str
        :param profile_type: Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_auth0_id_serialize(
            supabase_auth0_user_id=supabase_auth0_user_id,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserByAuth0IDResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_user_by_auth0_id_serialize(
        self,
        supabase_auth0_user_id,
        profile_type,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if supabase_auth0_user_id is not None:
            _path_params['supabaseAuth0UserId'] = supabase_auth0_user_id
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/auth-zero/{supabaseAuth0UserId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_user_by_authn_idv2(
        self,
        authn_id: Annotated[StrictStr, Field(description="Specifies the user's authn account ID.  Validations: - Must be greater than 0.")],
        profile_type: Annotated[StrictStr, Field(description="Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetUserByAuthnIDV2Response:
        """Retrieve user details by authentication ID

        Fetches user information using authentication system identifiers. Includes security validation and data privacy controls.

        :param authn_id: Specifies the user's authn account ID.  Validations: - Must be greater than 0. (required)
        :type authn_id: str
        :param profile_type: Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_authn_idv2_serialize(
            authn_id=authn_id,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserByAuthnIDV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_user_by_authn_idv2_with_http_info(
        self,
        authn_id: Annotated[StrictStr, Field(description="Specifies the user's authn account ID.  Validations: - Must be greater than 0.")],
        profile_type: Annotated[StrictStr, Field(description="Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetUserByAuthnIDV2Response]:
        """Retrieve user details by authentication ID

        Fetches user information using authentication system identifiers. Includes security validation and data privacy controls.

        :param authn_id: Specifies the user's authn account ID.  Validations: - Must be greater than 0. (required)
        :type authn_id: str
        :param profile_type: Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_authn_idv2_serialize(
            authn_id=authn_id,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserByAuthnIDV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_user_by_authn_idv2_without_preload_content(
        self,
        authn_id: Annotated[StrictStr, Field(description="Specifies the user's authn account ID.  Validations: - Must be greater than 0.")],
        profile_type: Annotated[StrictStr, Field(description="Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve user details by authentication ID

        Fetches user information using authentication system identifiers. Includes security validation and data privacy controls.

        :param authn_id: Specifies the user's authn account ID.  Validations: - Must be greater than 0. (required)
        :type authn_id: str
        :param profile_type: Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_authn_idv2_serialize(
            authn_id=authn_id,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserByAuthnIDV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_user_by_authn_idv2_serialize(
        self,
        authn_id,
        profile_type,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if authn_id is not None:
            _path_params['authnId'] = authn_id
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/authn/{authnId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_user_by_email_or_username_v2(
        self,
        profile_type: Annotated[StrictStr, Field(description="The profile type of the user   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        email: Annotated[Optional[StrictStr], Field(description="The email of the user of interest")] = None,
        username: Annotated[Optional[StrictStr], Field(description="The username of the user of interest")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetUserByEmailOrUsernameV2Response:
        """Retrieve user account by email or username

        Fetches a user account using the provided email or username. Performs validation and security checks.

        :param profile_type: The profile type of the user   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param email: The email of the user of interest
        :type email: str
        :param username: The username of the user of interest
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_email_or_username_v2_serialize(
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            email=email,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserByEmailOrUsernameV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_user_by_email_or_username_v2_with_http_info(
        self,
        profile_type: Annotated[StrictStr, Field(description="The profile type of the user   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        email: Annotated[Optional[StrictStr], Field(description="The email of the user of interest")] = None,
        username: Annotated[Optional[StrictStr], Field(description="The username of the user of interest")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetUserByEmailOrUsernameV2Response]:
        """Retrieve user account by email or username

        Fetches a user account using the provided email or username. Performs validation and security checks.

        :param profile_type: The profile type of the user   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param email: The email of the user of interest
        :type email: str
        :param username: The username of the user of interest
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_email_or_username_v2_serialize(
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            email=email,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserByEmailOrUsernameV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_user_by_email_or_username_v2_without_preload_content(
        self,
        profile_type: Annotated[StrictStr, Field(description="The profile type of the user   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        email: Annotated[Optional[StrictStr], Field(description="The email of the user of interest")] = None,
        username: Annotated[Optional[StrictStr], Field(description="The username of the user of interest")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve user account by email or username

        Fetches a user account using the provided email or username. Performs validation and security checks.

        :param profile_type: The profile type of the user   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param email: The email of the user of interest
        :type email: str
        :param username: The username of the user of interest
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_email_or_username_v2_serialize(
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            email=email,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserByEmailOrUsernameV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_user_by_email_or_username_v2_serialize(
        self,
        profile_type,
        organization_id,
        tenant_id,
        email,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if email is not None:
            
            _query_params.append(('email', email))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/account/query-by-email-or-username',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_user_by_email_v2(
        self,
        email: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetUserByEmailV2Response:
        """Retrieve user details by email

        Provides detailed information of a user based on the given email.

        :param email: (required)
        :type email: str
        :param profile_type: the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_email_v2_serialize(
            email=email,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserByEmailV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_user_by_email_v2_with_http_info(
        self,
        email: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetUserByEmailV2Response]:
        """Retrieve user details by email

        Provides detailed information of a user based on the given email.

        :param email: (required)
        :type email: str
        :param profile_type: the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_email_v2_serialize(
            email=email,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserByEmailV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_user_by_email_v2_without_preload_content(
        self,
        email: StrictStr,
        profile_type: Annotated[StrictStr, Field(description="the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve user details by email

        Provides detailed information of a user based on the given email.

        :param email: (required)
        :type email: str
        :param profile_type: the profile type of the given user we hope to query   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_email_v2_serialize(
            email=email,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserByEmailV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_user_by_email_v2_serialize(
        self,
        email,
        profile_type,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if email is not None:
            _path_params['email'] = email
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/email/{email}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_user_by_username_v2(
        self,
        username: Annotated[StrictStr, Field(description="The username of the user of interest")],
        profile_type: Annotated[StrictStr, Field(description="The profile type of the user   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetUserByUsernameV2Response:
        """Retrieve user details by username

        Provides detailed information of a user based on the given username.

        :param username: The username of the user of interest (required)
        :type username: str
        :param profile_type: The profile type of the user   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_username_v2_serialize(
            username=username,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserByUsernameV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_user_by_username_v2_with_http_info(
        self,
        username: Annotated[StrictStr, Field(description="The username of the user of interest")],
        profile_type: Annotated[StrictStr, Field(description="The profile type of the user   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetUserByUsernameV2Response]:
        """Retrieve user details by username

        Provides detailed information of a user based on the given username.

        :param username: The username of the user of interest (required)
        :type username: str
        :param profile_type: The profile type of the user   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_username_v2_serialize(
            username=username,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserByUsernameV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_user_by_username_v2_without_preload_content(
        self,
        username: Annotated[StrictStr, Field(description="The username of the user of interest")],
        profile_type: Annotated[StrictStr, Field(description="The profile type of the user   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve user details by username

        Provides detailed information of a user based on the given username.

        :param username: The username of the user of interest (required)
        :type username: str
        :param profile_type: The profile type of the user   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_by_username_v2_serialize(
            username=username,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserByUsernameV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_user_by_username_v2_serialize(
        self,
        username,
        profile_type,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if username is not None:
            _path_params['username'] = username
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/username/{username}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_user_id_v2(
        self,
        profile_type: Annotated[StrictStr, Field(description=" - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        email: Annotated[Optional[StrictStr], Field(description="The email of the user of interest")] = None,
        username: Annotated[Optional[StrictStr], Field(description="The username of the user of interest")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetUserIdV2Response:
        """Retrieve user ID by search criteria

        Looks up user ID using flexible search criteria with comprehensive validation. Supports multiple search parameters and ensures accurate results.

        :param profile_type:  - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param email: The email of the user of interest
        :type email: str
        :param username: The username of the user of interest
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_id_v2_serialize(
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            email=email,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserIdV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_user_id_v2_with_http_info(
        self,
        profile_type: Annotated[StrictStr, Field(description=" - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        email: Annotated[Optional[StrictStr], Field(description="The email of the user of interest")] = None,
        username: Annotated[Optional[StrictStr], Field(description="The username of the user of interest")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetUserIdV2Response]:
        """Retrieve user ID by search criteria

        Looks up user ID using flexible search criteria with comprehensive validation. Supports multiple search parameters and ensures accurate results.

        :param profile_type:  - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param email: The email of the user of interest
        :type email: str
        :param username: The username of the user of interest
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_id_v2_serialize(
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            email=email,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserIdV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_user_id_v2_without_preload_content(
        self,
        profile_type: Annotated[StrictStr, Field(description=" - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        email: Annotated[Optional[StrictStr], Field(description="The email of the user of interest")] = None,
        username: Annotated[Optional[StrictStr], Field(description="The username of the user of interest")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve user ID by search criteria

        Looks up user ID using flexible search criteria with comprehensive validation. Supports multiple search parameters and ensures accurate results.

        :param profile_type:  - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param email: The email of the user of interest
        :type email: str
        :param username: The username of the user of interest
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_id_v2_serialize(
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            email=email,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserIdV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_user_id_v2_serialize(
        self,
        profile_type,
        organization_id,
        tenant_id,
        email,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if email is not None:
            
            _query_params.append(('email', email))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/query-id',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_user_v2(
        self,
        user_id: Annotated[StrictStr, Field(description="Specifies the user's account ID.  Validations: - Must be greater than 0.")],
        profile_type: Annotated[StrictStr, Field(description="Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetUserV2Response:
        """Retrieve user account details

        Fetches detailed information about a user account based on the specified user ID.

        :param user_id: Specifies the user's account ID.  Validations: - Must be greater than 0. (required)
        :type user_id: str
        :param profile_type: Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_v2_serialize(
            user_id=user_id,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_user_v2_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="Specifies the user's account ID.  Validations: - Must be greater than 0.")],
        profile_type: Annotated[StrictStr, Field(description="Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetUserV2Response]:
        """Retrieve user account details

        Fetches detailed information about a user account based on the specified user ID.

        :param user_id: Specifies the user's account ID.  Validations: - Must be greater than 0. (required)
        :type user_id: str
        :param profile_type: Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_v2_serialize(
            user_id=user_id,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_user_v2_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="Specifies the user's account ID.  Validations: - Must be greater than 0.")],
        profile_type: Annotated[StrictStr, Field(description="Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve user account details

        Fetches detailed information about a user account based on the specified user ID.

        :param user_id: Specifies the user's account ID.  Validations: - Must be greater than 0. (required)
        :type user_id: str
        :param profile_type: Indicates the profile type to be queried. For example: \"username:testuser\"   - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile. (required)
        :type profile_type: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_v2_serialize(
            user_id=user_id,
            profile_type=profile_type,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_user_v2_serialize(
        self,
        user_id,
        profile_type,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def health_check(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> HealthCheckResponse:
        """health check

        This endpoint performs a healc check on the service

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._health_check_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HealthCheckResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def health_check_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[HealthCheckResponse]:
        """health check

        This endpoint performs a healc check on the service

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._health_check_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HealthCheckResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def health_check_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """health check

        This endpoint performs a healc check on the service

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._health_check_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HealthCheckResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _health_check_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/health',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def invite_team_member(
        self,
        tenant_id: StrictStr,
        invite_team_member_body: InviteTeamMemberBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> InviteTeamMemberResponse:
        """Invites a member to a tenant

        This endpoint sends an invitation to a member to join a tenant based on the provided tenant ID and member email.The invitation process ensures that the member receives an email with the invitation details.

        :param tenant_id: (required)
        :type tenant_id: str
        :param invite_team_member_body: (required)
        :type invite_team_member_body: InviteTeamMemberBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._invite_team_member_serialize(
            tenant_id=tenant_id,
            invite_team_member_body=invite_team_member_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InviteTeamMemberResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def invite_team_member_with_http_info(
        self,
        tenant_id: StrictStr,
        invite_team_member_body: InviteTeamMemberBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[InviteTeamMemberResponse]:
        """Invites a member to a tenant

        This endpoint sends an invitation to a member to join a tenant based on the provided tenant ID and member email.The invitation process ensures that the member receives an email with the invitation details.

        :param tenant_id: (required)
        :type tenant_id: str
        :param invite_team_member_body: (required)
        :type invite_team_member_body: InviteTeamMemberBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._invite_team_member_serialize(
            tenant_id=tenant_id,
            invite_team_member_body=invite_team_member_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InviteTeamMemberResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def invite_team_member_without_preload_content(
        self,
        tenant_id: StrictStr,
        invite_team_member_body: InviteTeamMemberBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Invites a member to a tenant

        This endpoint sends an invitation to a member to join a tenant based on the provided tenant ID and member email.The invitation process ensures that the member receives an email with the invitation details.

        :param tenant_id: (required)
        :type tenant_id: str
        :param invite_team_member_body: (required)
        :type invite_team_member_body: InviteTeamMemberBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._invite_team_member_serialize(
            tenant_id=tenant_id,
            invite_team_member_body=invite_team_member_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "InviteTeamMemberResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _invite_team_member_serialize(
        self,
        tenant_id,
        invite_team_member_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_id is not None:
            _path_params['tenantId'] = tenant_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if invite_team_member_body is not None:
            _body_params = invite_team_member_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/tenant/{tenantId}/invite-teammember',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_organization_api_keys(
        self,
        organization_id: StrictStr,
        owner_supabase_auth_user_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListOrganizationApiKeysResponse:
        """Lists all organization API keys

        This endpoint retrieves a list of all API keys for an organization. It supports pagination to handle large sets of data.

        :param organization_id: (required)
        :type organization_id: str
        :param owner_supabase_auth_user_id: (required)
        :type owner_supabase_auth_user_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_organization_api_keys_serialize(
            organization_id=organization_id,
            owner_supabase_auth_user_id=owner_supabase_auth_user_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListOrganizationApiKeysResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_organization_api_keys_with_http_info(
        self,
        organization_id: StrictStr,
        owner_supabase_auth_user_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListOrganizationApiKeysResponse]:
        """Lists all organization API keys

        This endpoint retrieves a list of all API keys for an organization. It supports pagination to handle large sets of data.

        :param organization_id: (required)
        :type organization_id: str
        :param owner_supabase_auth_user_id: (required)
        :type owner_supabase_auth_user_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_organization_api_keys_serialize(
            organization_id=organization_id,
            owner_supabase_auth_user_id=owner_supabase_auth_user_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListOrganizationApiKeysResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_organization_api_keys_without_preload_content(
        self,
        organization_id: StrictStr,
        owner_supabase_auth_user_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Lists all organization API keys

        This endpoint retrieves a list of all API keys for an organization. It supports pagination to handle large sets of data.

        :param organization_id: (required)
        :type organization_id: str
        :param owner_supabase_auth_user_id: (required)
        :type owner_supabase_auth_user_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_organization_api_keys_serialize(
            organization_id=organization_id,
            owner_supabase_auth_user_id=owner_supabase_auth_user_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListOrganizationApiKeysResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_organization_api_keys_serialize(
        self,
        organization_id,
        owner_supabase_auth_user_id,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if owner_supabase_auth_user_id is not None:
            
            _query_params.append(('ownerSupabaseAuthUserId', owner_supabase_auth_user_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/organization-api-keys',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_organization_audit_logs(
        self,
        organization_id: StrictStr,
        owner_supabase_auth_user_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListOrganizationAuditLogsResponse:
        """Lists all organization audit logs

        This endpoint retrieves a list of all audit logs for an organization. It supports pagination to handle large sets of data.

        :param organization_id: (required)
        :type organization_id: str
        :param owner_supabase_auth_user_id: (required)
        :type owner_supabase_auth_user_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_organization_audit_logs_serialize(
            organization_id=organization_id,
            owner_supabase_auth_user_id=owner_supabase_auth_user_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListOrganizationAuditLogsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_organization_audit_logs_with_http_info(
        self,
        organization_id: StrictStr,
        owner_supabase_auth_user_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListOrganizationAuditLogsResponse]:
        """Lists all organization audit logs

        This endpoint retrieves a list of all audit logs for an organization. It supports pagination to handle large sets of data.

        :param organization_id: (required)
        :type organization_id: str
        :param owner_supabase_auth_user_id: (required)
        :type owner_supabase_auth_user_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_organization_audit_logs_serialize(
            organization_id=organization_id,
            owner_supabase_auth_user_id=owner_supabase_auth_user_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListOrganizationAuditLogsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_organization_audit_logs_without_preload_content(
        self,
        organization_id: StrictStr,
        owner_supabase_auth_user_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Lists all organization audit logs

        This endpoint retrieves a list of all audit logs for an organization. It supports pagination to handle large sets of data.

        :param organization_id: (required)
        :type organization_id: str
        :param owner_supabase_auth_user_id: (required)
        :type owner_supabase_auth_user_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_organization_audit_logs_serialize(
            organization_id=organization_id,
            owner_supabase_auth_user_id=owner_supabase_auth_user_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListOrganizationAuditLogsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_organization_audit_logs_serialize(
        self,
        organization_id,
        owner_supabase_auth_user_id,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if owner_supabase_auth_user_id is not None:
            
            _query_params.append(('ownerSupabaseAuthUserId', owner_supabase_auth_user_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/organization-audit-logs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_organization_members(
        self,
        organization_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListOrganizationMembersResponse:
        """Lists all members of an organization

        This endpoint retrieves a list of all members in an organization based on the provided organization ID.It supports pagination to handle large sets of data.

        :param organization_id: (required)
        :type organization_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_organization_members_serialize(
            organization_id=organization_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListOrganizationMembersResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_organization_members_with_http_info(
        self,
        organization_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListOrganizationMembersResponse]:
        """Lists all members of an organization

        This endpoint retrieves a list of all members in an organization based on the provided organization ID.It supports pagination to handle large sets of data.

        :param organization_id: (required)
        :type organization_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_organization_members_serialize(
            organization_id=organization_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListOrganizationMembersResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_organization_members_without_preload_content(
        self,
        organization_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Lists all members of an organization

        This endpoint retrieves a list of all members in an organization based on the provided organization ID.It supports pagination to handle large sets of data.

        :param organization_id: (required)
        :type organization_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_organization_members_serialize(
            organization_id=organization_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListOrganizationMembersResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_organization_members_serialize(
        self,
        organization_id,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if organization_id is not None:
            _path_params['organizationId'] = organization_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/organization/{organizationId}/members',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_organizations(
        self,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListOrganizationsResponse:
        """Lists all organizations

        This endpoint retrieves a list of all organizations in the system. It supports pagination to handle large sets of data.Each organization in the list includes details like name, description, and members.

        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_organizations_serialize(
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListOrganizationsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_organizations_with_http_info(
        self,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListOrganizationsResponse]:
        """Lists all organizations

        This endpoint retrieves a list of all organizations in the system. It supports pagination to handle large sets of data.Each organization in the list includes details like name, description, and members.

        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_organizations_serialize(
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListOrganizationsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_organizations_without_preload_content(
        self,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Lists all organizations

        This endpoint retrieves a list of all organizations in the system. It supports pagination to handle large sets of data.Each organization in the list includes details like name, description, and members.

        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_organizations_serialize(
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListOrganizationsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_organizations_serialize(
        self,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/organizations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_roles(
        self,
        page: StrictInt,
        page_size: StrictInt,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListRolesResponse:
        """Lists all roles

        This endpoint retrieves a list of all roles in the system. It supports pagination to handle large sets of data.Each role in the list includes details like name, type, and permissions.

        :param page: (required)
        :type page: int
        :param page_size: (required)
        :type page_size: int
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_roles_serialize(
            page=page,
            page_size=page_size,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListRolesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_roles_with_http_info(
        self,
        page: StrictInt,
        page_size: StrictInt,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListRolesResponse]:
        """Lists all roles

        This endpoint retrieves a list of all roles in the system. It supports pagination to handle large sets of data.Each role in the list includes details like name, type, and permissions.

        :param page: (required)
        :type page: int
        :param page_size: (required)
        :type page_size: int
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_roles_serialize(
            page=page,
            page_size=page_size,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListRolesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_roles_without_preload_content(
        self,
        page: StrictInt,
        page_size: StrictInt,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Lists all roles

        This endpoint retrieves a list of all roles in the system. It supports pagination to handle large sets of data.Each role in the list includes details like name, type, and permissions.

        :param page: (required)
        :type page: int
        :param page_size: (required)
        :type page_size: int
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_roles_serialize(
            page=page,
            page_size=page_size,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListRolesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_roles_serialize(
        self,
        page,
        page_size,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/roles',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_roles_from_tenant_team(
        self,
        tenant_id: StrictStr,
        team_id: StrictStr,
        organization_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListRolesFromTenantTeamResponse:
        """Lists all roles from a team

        This endpoint retrieves a list of all roles in a team based on the provided tenant ID and team ID.It supports pagination to handle large sets of data.

        :param tenant_id: (required)
        :type tenant_id: str
        :param team_id: (required)
        :type team_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_roles_from_tenant_team_serialize(
            tenant_id=tenant_id,
            team_id=team_id,
            organization_id=organization_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListRolesFromTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_roles_from_tenant_team_with_http_info(
        self,
        tenant_id: StrictStr,
        team_id: StrictStr,
        organization_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListRolesFromTenantTeamResponse]:
        """Lists all roles from a team

        This endpoint retrieves a list of all roles in a team based on the provided tenant ID and team ID.It supports pagination to handle large sets of data.

        :param tenant_id: (required)
        :type tenant_id: str
        :param team_id: (required)
        :type team_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_roles_from_tenant_team_serialize(
            tenant_id=tenant_id,
            team_id=team_id,
            organization_id=organization_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListRolesFromTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_roles_from_tenant_team_without_preload_content(
        self,
        tenant_id: StrictStr,
        team_id: StrictStr,
        organization_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Lists all roles from a team

        This endpoint retrieves a list of all roles in a team based on the provided tenant ID and team ID.It supports pagination to handle large sets of data.

        :param tenant_id: (required)
        :type tenant_id: str
        :param team_id: (required)
        :type team_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_roles_from_tenant_team_serialize(
            tenant_id=tenant_id,
            team_id=team_id,
            organization_id=organization_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListRolesFromTenantTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_roles_from_tenant_team_serialize(
        self,
        tenant_id,
        team_id,
        organization_id,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_id is not None:
            _path_params['tenantId'] = tenant_id
        if team_id is not None:
            _path_params['teamId'] = team_id
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/tenant/{tenantId}/team/{teamId}/roles',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_team_invites(
        self,
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier (required)")],
        organization_id: Annotated[StrictStr, Field(description="Organization identifier (required)")],
        team_id: Annotated[StrictStr, Field(description="Team identifier (required)")],
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of items per page")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListTeamInvitesResponse:
        """Lists all team invites

        This endpoint retrieves a list of all team invites for a tenant based on the provided tenant ID.It supports pagination to handle large sets of data.

        :param tenant_id: Tenant identifier (required) (required)
        :type tenant_id: str
        :param organization_id: Organization identifier (required) (required)
        :type organization_id: str
        :param team_id: Team identifier (required) (required)
        :type team_id: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of items per page
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_team_invites_serialize(
            tenant_id=tenant_id,
            organization_id=organization_id,
            team_id=team_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTeamInvitesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_team_invites_with_http_info(
        self,
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier (required)")],
        organization_id: Annotated[StrictStr, Field(description="Organization identifier (required)")],
        team_id: Annotated[StrictStr, Field(description="Team identifier (required)")],
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of items per page")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListTeamInvitesResponse]:
        """Lists all team invites

        This endpoint retrieves a list of all team invites for a tenant based on the provided tenant ID.It supports pagination to handle large sets of data.

        :param tenant_id: Tenant identifier (required) (required)
        :type tenant_id: str
        :param organization_id: Organization identifier (required) (required)
        :type organization_id: str
        :param team_id: Team identifier (required) (required)
        :type team_id: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of items per page
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_team_invites_serialize(
            tenant_id=tenant_id,
            organization_id=organization_id,
            team_id=team_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTeamInvitesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_team_invites_without_preload_content(
        self,
        tenant_id: Annotated[StrictStr, Field(description="Tenant identifier (required)")],
        organization_id: Annotated[StrictStr, Field(description="Organization identifier (required)")],
        team_id: Annotated[StrictStr, Field(description="Team identifier (required)")],
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of items per page")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Lists all team invites

        This endpoint retrieves a list of all team invites for a tenant based on the provided tenant ID.It supports pagination to handle large sets of data.

        :param tenant_id: Tenant identifier (required) (required)
        :type tenant_id: str
        :param organization_id: Organization identifier (required) (required)
        :type organization_id: str
        :param team_id: Team identifier (required) (required)
        :type team_id: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of items per page
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_team_invites_serialize(
            tenant_id=tenant_id,
            organization_id=organization_id,
            team_id=team_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTeamInvitesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_team_invites_serialize(
        self,
        tenant_id,
        organization_id,
        team_id,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_id is not None:
            _path_params['tenantId'] = tenant_id
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if team_id is not None:
            
            _query_params.append(('teamId', team_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/tenant/{tenantId}/team-invites',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_tenant_api_keys(
        self,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListTenantApiKeysResponse:
        """Lists all tenant API keys

        This endpoint retrieves a list of all API keys for a tenant. It supports pagination to handle large sets of data.

        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_tenant_api_keys_serialize(
            organization_id=organization_id,
            tenant_id=tenant_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTenantApiKeysResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_tenant_api_keys_with_http_info(
        self,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListTenantApiKeysResponse]:
        """Lists all tenant API keys

        This endpoint retrieves a list of all API keys for a tenant. It supports pagination to handle large sets of data.

        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_tenant_api_keys_serialize(
            organization_id=organization_id,
            tenant_id=tenant_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTenantApiKeysResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_tenant_api_keys_without_preload_content(
        self,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Lists all tenant API keys

        This endpoint retrieves a list of all API keys for a tenant. It supports pagination to handle large sets of data.

        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_tenant_api_keys_serialize(
            organization_id=organization_id,
            tenant_id=tenant_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTenantApiKeysResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_tenant_api_keys_serialize(
        self,
        organization_id,
        tenant_id,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/tenant-api-keys',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_tenant_audit_logs(
        self,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListTenantAuditLogsResponse:
        """Lists all tenant audit logs

        This endpoint retrieves a list of all audit logs for a tenant. It supports pagination to handle large sets of data.

        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_tenant_audit_logs_serialize(
            organization_id=organization_id,
            tenant_id=tenant_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTenantAuditLogsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_tenant_audit_logs_with_http_info(
        self,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListTenantAuditLogsResponse]:
        """Lists all tenant audit logs

        This endpoint retrieves a list of all audit logs for a tenant. It supports pagination to handle large sets of data.

        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_tenant_audit_logs_serialize(
            organization_id=organization_id,
            tenant_id=tenant_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTenantAuditLogsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_tenant_audit_logs_without_preload_content(
        self,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Lists all tenant audit logs

        This endpoint retrieves a list of all audit logs for a tenant. It supports pagination to handle large sets of data.

        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_tenant_audit_logs_serialize(
            organization_id=organization_id,
            tenant_id=tenant_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTenantAuditLogsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_tenant_audit_logs_serialize(
        self,
        organization_id,
        tenant_id,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/tenant-audit-logs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_tenant_team_members(
        self,
        tenant_id: StrictStr,
        organization_id: StrictStr,
        team_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListTenantTeamMembersResponse:
        """Lists all members of a tenant

        This endpoint retrieves a list of all members in a tenant based on the provided tenant ID.It supports pagination to handle large sets of data.

        :param tenant_id: (required)
        :type tenant_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param team_id: (required)
        :type team_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_tenant_team_members_serialize(
            tenant_id=tenant_id,
            organization_id=organization_id,
            team_id=team_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTenantTeamMembersResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_tenant_team_members_with_http_info(
        self,
        tenant_id: StrictStr,
        organization_id: StrictStr,
        team_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListTenantTeamMembersResponse]:
        """Lists all members of a tenant

        This endpoint retrieves a list of all members in a tenant based on the provided tenant ID.It supports pagination to handle large sets of data.

        :param tenant_id: (required)
        :type tenant_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param team_id: (required)
        :type team_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_tenant_team_members_serialize(
            tenant_id=tenant_id,
            organization_id=organization_id,
            team_id=team_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTenantTeamMembersResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_tenant_team_members_without_preload_content(
        self,
        tenant_id: StrictStr,
        organization_id: StrictStr,
        team_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Lists all members of a tenant

        This endpoint retrieves a list of all members in a tenant based on the provided tenant ID.It supports pagination to handle large sets of data.

        :param tenant_id: (required)
        :type tenant_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param team_id: (required)
        :type team_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_tenant_team_members_serialize(
            tenant_id=tenant_id,
            organization_id=organization_id,
            team_id=team_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTenantTeamMembersResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_tenant_team_members_serialize(
        self,
        tenant_id,
        organization_id,
        team_id,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_id is not None:
            _path_params['tenantId'] = tenant_id
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if team_id is not None:
            
            _query_params.append(('teamId', team_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/tenant/{tenantId}/team-members',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_tenants(
        self,
        organization_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListTenantsResponse:
        """Lists all tenants

        This endpoint retrieves a list of all tenants in the system. It supports pagination to handle large sets of data.Each tenant in the list includes details like name, description, and members.

        :param organization_id: (required)
        :type organization_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_tenants_serialize(
            organization_id=organization_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTenantsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_tenants_with_http_info(
        self,
        organization_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListTenantsResponse]:
        """Lists all tenants

        This endpoint retrieves a list of all tenants in the system. It supports pagination to handle large sets of data.Each tenant in the list includes details like name, description, and members.

        :param organization_id: (required)
        :type organization_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_tenants_serialize(
            organization_id=organization_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTenantsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_tenants_without_preload_content(
        self,
        organization_id: StrictStr,
        page: Optional[StrictInt] = None,
        page_size: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Lists all tenants

        This endpoint retrieves a list of all tenants in the system. It supports pagination to handle large sets of data.Each tenant in the list includes details like name, description, and members.

        :param organization_id: (required)
        :type organization_id: str
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_tenants_serialize(
            organization_id=organization_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListTenantsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_tenants_serialize(
        self,
        organization_id,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/tenants',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def password_reset_webhook_v2(
        self,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        account_id: Optional[StrictStr] = None,
        token: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PasswordResetWebhookV2Response:
        """Process password reset via webhook

        Handles secure password reset operations through webhook integration. Includes comprehensive security measures and validation.

        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param account_id:
        :type account_id: str
        :param token:
        :type token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._password_reset_webhook_v2_serialize(
            organization_id=organization_id,
            tenant_id=tenant_id,
            account_id=account_id,
            token=token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PasswordResetWebhookV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def password_reset_webhook_v2_with_http_info(
        self,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        account_id: Optional[StrictStr] = None,
        token: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PasswordResetWebhookV2Response]:
        """Process password reset via webhook

        Handles secure password reset operations through webhook integration. Includes comprehensive security measures and validation.

        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param account_id:
        :type account_id: str
        :param token:
        :type token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._password_reset_webhook_v2_serialize(
            organization_id=organization_id,
            tenant_id=tenant_id,
            account_id=account_id,
            token=token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PasswordResetWebhookV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def password_reset_webhook_v2_without_preload_content(
        self,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        account_id: Optional[StrictStr] = None,
        token: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Process password reset via webhook

        Handles secure password reset operations through webhook integration. Includes comprehensive security measures and validation.

        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param account_id:
        :type account_id: str
        :param token:
        :type token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._password_reset_webhook_v2_serialize(
            organization_id=organization_id,
            tenant_id=tenant_id,
            account_id=account_id,
            token=token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PasswordResetWebhookV2Response",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _password_reset_webhook_v2_serialize(
        self,
        organization_id,
        tenant_id,
        account_id,
        token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if account_id is not None:
            
            _query_params.append(('accountId', account_id))
            
        if token is not None:
            
            _query_params.append(('token', token))
            
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/webhook/password-reset',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def readyness_check(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ReadynessCheckResponse:
        """readyness check

        This endpoint performs a readiness check on the service

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._readyness_check_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadynessCheckResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def readyness_check_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ReadynessCheckResponse]:
        """readyness check

        This endpoint performs a readiness check on the service

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._readyness_check_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadynessCheckResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def readyness_check_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """readyness check

        This endpoint performs a readiness check on the service

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._readyness_check_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadynessCheckResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _readyness_check_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/ready',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def reject_team_member_invitation(
        self,
        tenant_id: StrictStr,
        reject_team_member_invitation_body: RejectTeamMemberInvitationBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RejectTeamMemberInvitationResponse:
        """Rejects a team member invitation

        This endpoint rejects an invitation for a member to join a tenant based on the provided tenant ID and member email.The rejection process ensures that the member is not associated with the tenant.

        :param tenant_id: (required)
        :type tenant_id: str
        :param reject_team_member_invitation_body: (required)
        :type reject_team_member_invitation_body: RejectTeamMemberInvitationBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._reject_team_member_invitation_serialize(
            tenant_id=tenant_id,
            reject_team_member_invitation_body=reject_team_member_invitation_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RejectTeamMemberInvitationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def reject_team_member_invitation_with_http_info(
        self,
        tenant_id: StrictStr,
        reject_team_member_invitation_body: RejectTeamMemberInvitationBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RejectTeamMemberInvitationResponse]:
        """Rejects a team member invitation

        This endpoint rejects an invitation for a member to join a tenant based on the provided tenant ID and member email.The rejection process ensures that the member is not associated with the tenant.

        :param tenant_id: (required)
        :type tenant_id: str
        :param reject_team_member_invitation_body: (required)
        :type reject_team_member_invitation_body: RejectTeamMemberInvitationBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._reject_team_member_invitation_serialize(
            tenant_id=tenant_id,
            reject_team_member_invitation_body=reject_team_member_invitation_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RejectTeamMemberInvitationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def reject_team_member_invitation_without_preload_content(
        self,
        tenant_id: StrictStr,
        reject_team_member_invitation_body: RejectTeamMemberInvitationBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Rejects a team member invitation

        This endpoint rejects an invitation for a member to join a tenant based on the provided tenant ID and member email.The rejection process ensures that the member is not associated with the tenant.

        :param tenant_id: (required)
        :type tenant_id: str
        :param reject_team_member_invitation_body: (required)
        :type reject_team_member_invitation_body: RejectTeamMemberInvitationBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._reject_team_member_invitation_serialize(
            tenant_id=tenant_id,
            reject_team_member_invitation_body=reject_team_member_invitation_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RejectTeamMemberInvitationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _reject_team_member_invitation_serialize(
        self,
        tenant_id,
        reject_team_member_invitation_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_id is not None:
            _path_params['tenantId'] = tenant_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if reject_team_member_invitation_body is not None:
            _body_params = reject_team_member_invitation_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/user/tenant/{tenantId}/reject-teammember-invitation',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def remove_organization_member_from_organization(
        self,
        organization_id: StrictStr,
        owner_supabase_auth_user_id: StrictStr,
        organization_member_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RemoveOrganizationMemberFromOrganizationResponse:
        """Removes a member from an organization

        This endpoint removes a member from an organization based on the provided organization ID and member ID.The removal process ensures that the member is properly disassociated from the organization.

        :param organization_id: (required)
        :type organization_id: str
        :param owner_supabase_auth_user_id: (required)
        :type owner_supabase_auth_user_id: str
        :param organization_member_id: (required)
        :type organization_member_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remove_organization_member_from_organization_serialize(
            organization_id=organization_id,
            owner_supabase_auth_user_id=owner_supabase_auth_user_id,
            organization_member_id=organization_member_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RemoveOrganizationMemberFromOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def remove_organization_member_from_organization_with_http_info(
        self,
        organization_id: StrictStr,
        owner_supabase_auth_user_id: StrictStr,
        organization_member_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RemoveOrganizationMemberFromOrganizationResponse]:
        """Removes a member from an organization

        This endpoint removes a member from an organization based on the provided organization ID and member ID.The removal process ensures that the member is properly disassociated from the organization.

        :param organization_id: (required)
        :type organization_id: str
        :param owner_supabase_auth_user_id: (required)
        :type owner_supabase_auth_user_id: str
        :param organization_member_id: (required)
        :type organization_member_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remove_organization_member_from_organization_serialize(
            organization_id=organization_id,
            owner_supabase_auth_user_id=owner_supabase_auth_user_id,
            organization_member_id=organization_member_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RemoveOrganizationMemberFromOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def remove_organization_member_from_organization_without_preload_content(
        self,
        organization_id: StrictStr,
        owner_supabase_auth_user_id: StrictStr,
        organization_member_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Removes a member from an organization

        This endpoint removes a member from an organization based on the provided organization ID and member ID.The removal process ensures that the member is properly disassociated from the organization.

        :param organization_id: (required)
        :type organization_id: str
        :param owner_supabase_auth_user_id: (required)
        :type owner_supabase_auth_user_id: str
        :param organization_member_id: (required)
        :type organization_member_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remove_organization_member_from_organization_serialize(
            organization_id=organization_id,
            owner_supabase_auth_user_id=owner_supabase_auth_user_id,
            organization_member_id=organization_member_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RemoveOrganizationMemberFromOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _remove_organization_member_from_organization_serialize(
        self,
        organization_id,
        owner_supabase_auth_user_id,
        organization_member_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if organization_id is not None:
            _path_params['organizationId'] = organization_id
        # process the query parameters
        if owner_supabase_auth_user_id is not None:
            
            _query_params.append(('ownerSupabaseAuthUserId', owner_supabase_auth_user_id))
            
        if organization_member_id is not None:
            
            _query_params.append(('organizationMemberId', organization_member_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/user-microservice/api/v2/user-service/user/organization/{organizationId}/remove-member',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def remove_tenant_team_member(
        self,
        tenant_id: StrictStr,
        organization_id: StrictStr,
        tenant_team_id: StrictStr,
        tenant_team_member_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RemoveTenantTeamMemberResponse:
        """Removes a member from a tenant

        This endpoint removes a member from a tenant based on the provided tenant ID and member ID.The removal process ensures that the member is properly disassociated from the tenant.

        :param tenant_id: (required)
        :type tenant_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_team_id: (required)
        :type tenant_team_id: str
        :param tenant_team_member_id: (required)
        :type tenant_team_member_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remove_tenant_team_member_serialize(
            tenant_id=tenant_id,
            organization_id=organization_id,
            tenant_team_id=tenant_team_id,
            tenant_team_member_id=tenant_team_member_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RemoveTenantTeamMemberResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def remove_tenant_team_member_with_http_info(
        self,
        tenant_id: StrictStr,
        organization_id: StrictStr,
        tenant_team_id: StrictStr,
        tenant_team_member_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RemoveTenantTeamMemberResponse]:
        """Removes a member from a tenant

        This endpoint removes a member from a tenant based on the provided tenant ID and member ID.The removal process ensures that the member is properly disassociated from the tenant.

        :param tenant_id: (required)
        :type tenant_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_team_id: (required)
        :type tenant_team_id: str
        :param tenant_team_member_id: (required)
        :type tenant_team_member_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remove_tenant_team_member_serialize(
            tenant_id=tenant_id,
            organization_id=organization_id,
            tenant_team_id=tenant_team_id,
            tenant_team_member_id=tenant_team_member_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RemoveTenantTeamMemberResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def remove_tenant_team_member_without_preload_content(
        self,
        tenant_id: StrictStr,
        organization_id: StrictStr,
        tenant_team_id: StrictStr,
        tenant_team_member_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Removes a member from a tenant

        This endpoint removes a member from a tenant based on the provided tenant ID and member ID.The removal process ensures that the member is properly disassociated from the tenant.

        :param tenant_id: (required)
        :type tenant_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_team_id: (required)
        :type tenant_team_id: str
        :param tenant_team_member_id: (required)
        :type tenant_team_member_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remove_tenant_team_member_serialize(
            tenant_id=tenant_id,
            organization_id=organization_id,
            tenant_team_id=tenant_team_id,
            tenant_team_member_id=tenant_team_member_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RemoveTenantTeamMemberResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _remove_tenant_team_member_serialize(
        self,
        tenant_id,
        organization_id,
        tenant_team_id,
        tenant_team_member_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tenant_id is not None:
            _path_params['tenantId'] = tenant_id
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_team_id is not None:
            
            _query_params.append(('tenantTeamId', tenant_team_id))
            
        if tenant_team_member_id is not None:
            
            _query_params.append(('tenantTeamMemberId', tenant_team_member_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/user-microservice/api/v2/user-service/user/tenant/{tenantId}/remove-teammember',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def remove_user_from_team(
        self,
        team_id: StrictStr,
        admin_supabase_auth0_user_id: StrictStr,
        user_supabase_auth0_user_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        profile_type: Annotated[Optional[StrictStr], Field(description=" - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RemoveUserFromTeamResponse:
        """Removes a user from a team

        This endpoint removes a user from a team based on the provided team ID and user ID.The removal process ensures that the user is properly disassociated from the team.

        :param team_id: (required)
        :type team_id: str
        :param admin_supabase_auth0_user_id: (required)
        :type admin_supabase_auth0_user_id: str
        :param user_supabase_auth0_user_id: (required)
        :type user_supabase_auth0_user_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param profile_type:  - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remove_user_from_team_serialize(
            team_id=team_id,
            admin_supabase_auth0_user_id=admin_supabase_auth0_user_id,
            user_supabase_auth0_user_id=user_supabase_auth0_user_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RemoveUserFromTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def remove_user_from_team_with_http_info(
        self,
        team_id: StrictStr,
        admin_supabase_auth0_user_id: StrictStr,
        user_supabase_auth0_user_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        profile_type: Annotated[Optional[StrictStr], Field(description=" - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RemoveUserFromTeamResponse]:
        """Removes a user from a team

        This endpoint removes a user from a team based on the provided team ID and user ID.The removal process ensures that the user is properly disassociated from the team.

        :param team_id: (required)
        :type team_id: str
        :param admin_supabase_auth0_user_id: (required)
        :type admin_supabase_auth0_user_id: str
        :param user_supabase_auth0_user_id: (required)
        :type user_supabase_auth0_user_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param profile_type:  - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remove_user_from_team_serialize(
            team_id=team_id,
            admin_supabase_auth0_user_id=admin_supabase_auth0_user_id,
            user_supabase_auth0_user_id=user_supabase_auth0_user_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RemoveUserFromTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def remove_user_from_team_without_preload_content(
        self,
        team_id: StrictStr,
        admin_supabase_auth0_user_id: StrictStr,
        user_supabase_auth0_user_id: StrictStr,
        organization_id: StrictStr,
        tenant_id: StrictStr,
        profile_type: Annotated[Optional[StrictStr], Field(description=" - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Removes a user from a team

        This endpoint removes a user from a team based on the provided team ID and user ID.The removal process ensures that the user is properly disassociated from the team.

        :param team_id: (required)
        :type team_id: str
        :param admin_supabase_auth0_user_id: (required)
        :type admin_supabase_auth0_user_id: str
        :param user_supabase_auth0_user_id: (required)
        :type user_supabase_auth0_user_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param profile_type:  - PROFILE_TYPE_UNSPECIFIED: Default unspecified profile type.  - PROFILE_TYPE_USER: Individual user profile.  - PROFILE_TYPE_BUSINESS: Business profile.
        :type profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remove_user_from_team_serialize(
            team_id=team_id,
            admin_supabase_auth0_user_id=admin_supabase_auth0_user_id,
            user_supabase_auth0_user_id=user_supabase_auth0_user_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            profile_type=profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RemoveUserFromTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _remove_user_from_team_serialize(
        self,
        team_id,
        admin_supabase_auth0_user_id,
        user_supabase_auth0_user_id,
        organization_id,
        tenant_id,
        profile_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if team_id is not None:
            _path_params['teamId'] = team_id
        # process the query parameters
        if admin_supabase_auth0_user_id is not None:
            
            _query_params.append(('adminSupabaseAuth0UserId', admin_supabase_auth0_user_id))
            
        if user_supabase_auth0_user_id is not None:
            
            _query_params.append(('userSupabaseAuth0UserId', user_supabase_auth0_user_id))
            
        if profile_type is not None:
            
            _query_params.append(('profileType', profile_type))
            
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/user-microservice/api/v2/user-service/user/team/{teamId}/remove-user',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def retrieve_business_settings(
        self,
        user_id: Annotated[StrictStr, Field(description="The account ID associated with the user (business)")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetBusinessSettingsResponse:
        """Retrieve business account settings

        Fetches business-specific account settings with authorization validation. Provides comprehensive configuration data for business accounts.

        :param user_id: The account ID associated with the user (business) (required)
        :type user_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_business_settings_serialize(
            user_id=user_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBusinessSettingsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def retrieve_business_settings_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="The account ID associated with the user (business)")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetBusinessSettingsResponse]:
        """Retrieve business account settings

        Fetches business-specific account settings with authorization validation. Provides comprehensive configuration data for business accounts.

        :param user_id: The account ID associated with the user (business) (required)
        :type user_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_business_settings_serialize(
            user_id=user_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBusinessSettingsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def retrieve_business_settings_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="The account ID associated with the user (business)")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve business account settings

        Fetches business-specific account settings with authorization validation. Provides comprehensive configuration data for business accounts.

        :param user_id: The account ID associated with the user (business) (required)
        :type user_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._retrieve_business_settings_serialize(
            user_id=user_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBusinessSettingsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _retrieve_business_settings_serialize(
        self,
        user_id,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/user-microservice/api/v2/user-service/user/business/settings/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def rotate_org_api_key(
        self,
        key_id: Annotated[StrictStr, Field(description="The unique identifier of the API key to rotate")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RotateOrgAPIKeyResponse:
        """Rotates an API key

        This endpoint rotates (replaces) an existing API key with a new one. The old key is invalidated, and a new key is generated with the same permissions and settings.

        :param key_id: The unique identifier of the API key to rotate (required)
        :type key_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._rotate_org_api_key_serialize(
            key_id=key_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RotateOrgAPIKeyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def rotate_org_api_key_with_http_info(
        self,
        key_id: Annotated[StrictStr, Field(description="The unique identifier of the API key to rotate")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RotateOrgAPIKeyResponse]:
        """Rotates an API key

        This endpoint rotates (replaces) an existing API key with a new one. The old key is invalidated, and a new key is generated with the same permissions and settings.

        :param key_id: The unique identifier of the API key to rotate (required)
        :type key_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._rotate_org_api_key_serialize(
            key_id=key_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RotateOrgAPIKeyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def rotate_org_api_key_without_preload_content(
        self,
        key_id: Annotated[StrictStr, Field(description="The unique identifier of the API key to rotate")],
        organization_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Rotates an API key

        This endpoint rotates (replaces) an existing API key with a new one. The old key is invalidated, and a new key is generated with the same permissions and settings.

        :param key_id: The unique identifier of the API key to rotate (required)
        :type key_id: str
        :param organization_id: (required)
        :type organization_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._rotate_org_api_key_serialize(
            key_id=key_id,
            organization_id=organization_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RotateOrgAPIKeyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _rotate_org_api_key_serialize(
        self,
        key_id,
        organization_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if key_id is not None:
            _path_params['keyId'] = key_id
        # process the query parameters
        if organization_id is not None:
            
            _query_params.append(('organizationId', organization_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/user-microservice/api/v2/user-service/api-keys/{keyId}/rotate',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def update_organization(
        self,
        organization: Organization,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UpdateOrganizationResponse:
        """Updates an existing organization

        This endpoint updates the details of an existing organization. The organization ID is used to identify the organization to be updated.The update operation can modify the organization's name, description, and members.

        :param organization: (required)
        :type organization: Organization
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_organization_serialize(
            organization=organization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def update_organization_with_http_info(
        self,
        organization: Organization,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UpdateOrganizationResponse]:
        """Updates an existing organization

        This endpoint updates the details of an existing organization. The organization ID is used to identify the organization to be updated.The update operation can modify the organization's name, description, and members.

        :param organization: (required)
        :type organization: Organization
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_organization_serialize(
            organization=organization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def update_organization_without_preload_content(
        self,
        organization: Organization,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Updates an existing organization

        This endpoint updates the details of an existing organization. The organization ID is used to identify the organization to be updated.The update operation can modify the organization's name, description, and members.

        :param organization: (required)
        :type organization: Organization
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_organization_serialize(
            organization=organization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateOrganizationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_organization_serialize(
        self,
        organization,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if organization is not None:
            _body_params = organization


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/user-microservice/api/v2/user-service/user/organization',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def update_role(
        self,
        role: Role,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UpdateRoleResponse:
        """Updates an existing role

        This endpoint updates the details of an existing role. The role ID is used to identify the role to be updated.The update operation can modify the role's name, type, and permissions.

        :param role: (required)
        :type role: Role
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_role_serialize(
            role=role,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateRoleResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def update_role_with_http_info(
        self,
        role: Role,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UpdateRoleResponse]:
        """Updates an existing role

        This endpoint updates the details of an existing role. The role ID is used to identify the role to be updated.The update operation can modify the role's name, type, and permissions.

        :param role: (required)
        :type role: Role
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_role_serialize(
            role=role,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateRoleResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def update_role_without_preload_content(
        self,
        role: Role,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Updates an existing role

        This endpoint updates the details of an existing role. The role ID is used to identify the role to be updated.The update operation can modify the role's name, type, and permissions.

        :param role: (required)
        :type role: Role
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_role_serialize(
            role=role,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateRoleResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_role_serialize(
        self,
        role,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if role is not None:
            _body_params = role


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/user-microservice/api/v2/user/role',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def update_team(
        self,
        team: Team,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UpdateTeamResponse:
        """Updates an existing team

        This endpoint updates the details of an existing team. The team ID is used to identify the team to be updated.The update operation can modify the team's name, description, and members.

        :param team: (required)
        :type team: Team
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_team_serialize(
            team=team,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def update_team_with_http_info(
        self,
        team: Team,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UpdateTeamResponse]:
        """Updates an existing team

        This endpoint updates the details of an existing team. The team ID is used to identify the team to be updated.The update operation can modify the team's name, description, and members.

        :param team: (required)
        :type team: Team
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_team_serialize(
            team=team,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateTeamResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def update_team_without_preload_content(
        self,
        team: Team,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Updates an existing team

        This endpoint updates the details of an existing team. The team ID is used to identify the team to be updated.The update operation can modify the team's name, description, and members.

        :param team: (required)
        :type team: Team
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also 