# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from solomonai_backend_client_sdk.models.accept_follow_profile_response import AcceptFollowProfileResponse
from solomonai_backend_client_sdk.models.add_comment_quality_score_response import AddCommentQualityScoreResponse
from solomonai_backend_client_sdk.models.add_post_quality_score_response import AddPostQualityScoreResponse
from solomonai_backend_client_sdk.models.add_post_to_publication_response import AddPostToPublicationResponse
from solomonai_backend_client_sdk.models.add_post_to_thread_response import AddPostToThreadResponse
from solomonai_backend_client_sdk.models.add_publication_editor_response import AddPublicationEditorResponse
from solomonai_backend_client_sdk.models.block_user_profile_response import BlockUserProfileResponse
from solomonai_backend_client_sdk.models.bookmark_post_response import BookmarkPostResponse
from solomonai_backend_client_sdk.models.bookmark_publication_response import BookmarkPublicationResponse
from solomonai_backend_client_sdk.models.comment import Comment
from solomonai_backend_client_sdk.models.community_profile import CommunityProfile
from solomonai_backend_client_sdk.models.create_comment_reply_body import CreateCommentReplyBody
from solomonai_backend_client_sdk.models.create_comment_reply_response import CreateCommentReplyResponse
from solomonai_backend_client_sdk.models.create_comment_response import CreateCommentResponse
from solomonai_backend_client_sdk.models.create_community_profile_body import CreateCommunityProfileBody
from solomonai_backend_client_sdk.models.create_community_profile_response import CreateCommunityProfileResponse
from solomonai_backend_client_sdk.models.create_note_body import CreateNoteBody
from solomonai_backend_client_sdk.models.create_note_response import CreateNoteResponse
from solomonai_backend_client_sdk.models.create_poll_response import CreatePollResponse
from solomonai_backend_client_sdk.models.create_post_response import CreatePostResponse
from solomonai_backend_client_sdk.models.create_publication_response import CreatePublicationResponse
from solomonai_backend_client_sdk.models.create_topic_response import CreateTopicResponse
from solomonai_backend_client_sdk.models.create_user_profile_request import CreateUserProfileRequest
from solomonai_backend_client_sdk.models.create_user_profile_response import CreateUserProfileResponse
from solomonai_backend_client_sdk.models.delete_comment_reply_response import DeleteCommentReplyResponse
from solomonai_backend_client_sdk.models.delete_community_profile_response import DeleteCommunityProfileResponse
from solomonai_backend_client_sdk.models.delete_note_response import DeleteNoteResponse
from solomonai_backend_client_sdk.models.delete_poll_response import DeletePollResponse
from solomonai_backend_client_sdk.models.delete_post_from_publication_response import DeletePostFromPublicationResponse
from solomonai_backend_client_sdk.models.delete_post_response import DeletePostResponse
from solomonai_backend_client_sdk.models.delete_publication_editor_response import DeletePublicationEditorResponse
from solomonai_backend_client_sdk.models.delete_publication_response import DeletePublicationResponse
from solomonai_backend_client_sdk.models.delete_user_profile_response import DeleteUserProfileResponse
from solomonai_backend_client_sdk.models.discover_profiles_response import DiscoverProfilesResponse
from solomonai_backend_client_sdk.models.edit_comment_reply_body import EditCommentReplyBody
from solomonai_backend_client_sdk.models.edit_comment_reply_response import EditCommentReplyResponse
from solomonai_backend_client_sdk.models.edit_community_profile_request import EditCommunityProfileRequest
from solomonai_backend_client_sdk.models.edit_note_response import EditNoteResponse
from solomonai_backend_client_sdk.models.edit_post_response import EditPostResponse
from solomonai_backend_client_sdk.models.edit_user_profile_response import EditUserProfileResponse
from solomonai_backend_client_sdk.models.follow_community_profile_response import FollowCommunityProfileResponse
from solomonai_backend_client_sdk.models.follow_profile_response import FollowProfileResponse
from solomonai_backend_client_sdk.models.get_accounts_following_response import GetAccountsFollowingResponse
from solomonai_backend_client_sdk.models.get_blog_posts_by_tag_response import GetBlogPostsByTagResponse
from solomonai_backend_client_sdk.models.get_bookmarked_posts_response import GetBookmarkedPostsResponse
from solomonai_backend_client_sdk.models.get_canny_user_sso_token_response import GetCannyUserSSOTokenResponse
from solomonai_backend_client_sdk.models.get_comment_replies_response import GetCommentRepliesResponse
from solomonai_backend_client_sdk.models.get_communities_user_follows_response import GetCommunitiesUserFollowsResponse
from solomonai_backend_client_sdk.models.get_community_blog_posts_response import GetCommunityBlogPostsResponse
from solomonai_backend_client_sdk.models.get_community_feed_response import GetCommunityFeedResponse
from solomonai_backend_client_sdk.models.get_community_profile_response import GetCommunityProfileResponse
from solomonai_backend_client_sdk.models.get_community_profiles_response import GetCommunityProfilesResponse
from solomonai_backend_client_sdk.models.get_followers_response import GetFollowersResponse
from solomonai_backend_client_sdk.models.get_pending_follows_response import GetPendingFollowsResponse
from solomonai_backend_client_sdk.models.get_poll_response import GetPollResponse
from solomonai_backend_client_sdk.models.get_polls_response import GetPollsResponse
from solomonai_backend_client_sdk.models.get_post_response import GetPostResponse
from solomonai_backend_client_sdk.models.get_post_thread_response import GetPostThreadResponse
from solomonai_backend_client_sdk.models.get_posts_by_category_response import GetPostsByCategoryResponse
from solomonai_backend_client_sdk.models.get_posts_by_topic_response import GetPostsByTopicResponse
from solomonai_backend_client_sdk.models.get_posts_response import GetPostsResponse
from solomonai_backend_client_sdk.models.get_publication_response import GetPublicationResponse
from solomonai_backend_client_sdk.models.get_topics_of_communities_user_follows_response import GetTopicsOfCommunitiesUserFollowsResponse
from solomonai_backend_client_sdk.models.get_user_feed_response import GetUserFeedResponse
from solomonai_backend_client_sdk.models.get_user_profile_response import GetUserProfileResponse
from solomonai_backend_client_sdk.models.get_user_profiles_response import GetUserProfilesResponse
from solomonai_backend_client_sdk.models.health_check_response1 import HealthCheckResponse1
from solomonai_backend_client_sdk.models.note import Note
from solomonai_backend_client_sdk.models.poll_post import PollPost
from solomonai_backend_client_sdk.models.post import Post
from solomonai_backend_client_sdk.models.publication import Publication
from solomonai_backend_client_sdk.models.react_to_comment_reply_response import ReactToCommentReplyResponse
from solomonai_backend_client_sdk.models.react_to_comment_response import ReactToCommentResponse
from solomonai_backend_client_sdk.models.react_to_post_response import ReactToPostResponse
from solomonai_backend_client_sdk.models.readyness_check_response1 import ReadynessCheckResponse1
from solomonai_backend_client_sdk.models.remove_bookmarked_post_response import RemoveBookmarkedPostResponse
from solomonai_backend_client_sdk.models.remove_post_from_thread_response import RemovePostFromThreadResponse
from solomonai_backend_client_sdk.models.report_comment_body import ReportCommentBody
from solomonai_backend_client_sdk.models.report_comment_reply_body import ReportCommentReplyBody
from solomonai_backend_client_sdk.models.report_comment_reply_response import ReportCommentReplyResponse
from solomonai_backend_client_sdk.models.report_comment_response import ReportCommentResponse
from solomonai_backend_client_sdk.models.report_post_response import ReportPostResponse
from solomonai_backend_client_sdk.models.respond_to_poll_body import RespondToPollBody
from solomonai_backend_client_sdk.models.respond_to_poll_response import RespondToPollResponse
from solomonai_backend_client_sdk.models.share_post_response import SharePostResponse
from solomonai_backend_client_sdk.models.topic import Topic
from solomonai_backend_client_sdk.models.user_profile import UserProfile

from solomonai_backend_client_sdk.api_client import ApiClient, RequestSerialized
from solomonai_backend_client_sdk.api_response import ApiResponse
from solomonai_backend_client_sdk.rest import RESTResponseType


class SocialServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def accept_follow_profile(
        self,
        follow_record_id: Annotated[StrictStr, Field(description="The id of the follow record | type: uint64")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AcceptFollowProfileResponse:
        """Accepts a user's follow request

        This endpoint enables a client to accept a follow request from a source a user profile

        :param follow_record_id: The id of the follow record | type: uint64 (required)
        :type follow_record_id: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._accept_follow_profile_serialize(
            follow_record_id=follow_record_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AcceptFollowProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def accept_follow_profile_with_http_info(
        self,
        follow_record_id: Annotated[StrictStr, Field(description="The id of the follow record | type: uint64")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AcceptFollowProfileResponse]:
        """Accepts a user's follow request

        This endpoint enables a client to accept a follow request from a source a user profile

        :param follow_record_id: The id of the follow record | type: uint64 (required)
        :type follow_record_id: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._accept_follow_profile_serialize(
            follow_record_id=follow_record_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AcceptFollowProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def accept_follow_profile_without_preload_content(
        self,
        follow_record_id: Annotated[StrictStr, Field(description="The id of the follow record | type: uint64")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Accepts a user's follow request

        This endpoint enables a client to accept a follow request from a source a user profile

        :param follow_record_id: The id of the follow record | type: uint64 (required)
        :type follow_record_id: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._accept_follow_profile_serialize(
            follow_record_id=follow_record_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AcceptFollowProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _accept_follow_profile_serialize(
        self,
        follow_record_id,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if follow_record_id is not None:
            _path_params['followRecordId'] = follow_record_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/follow-requests/{followRecordId}/accept',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def add_comment_quality_score(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        post_type: Annotated[StrictStr, Field(description="The type of post being reacted to | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        body: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AddCommentQualityScoreResponse:
        """Add Comment Quality Score

        This endpoint enables a client to add a quality score to a comment

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param post_type: The type of post being reacted to | type: string (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param body: (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_comment_quality_score_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddCommentQualityScoreResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_comment_quality_score_with_http_info(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        post_type: Annotated[StrictStr, Field(description="The type of post being reacted to | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        body: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AddCommentQualityScoreResponse]:
        """Add Comment Quality Score

        This endpoint enables a client to add a quality score to a comment

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param post_type: The type of post being reacted to | type: string (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param body: (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_comment_quality_score_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddCommentQualityScoreResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_comment_quality_score_without_preload_content(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        post_type: Annotated[StrictStr, Field(description="The type of post being reacted to | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        body: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add Comment Quality Score

        This endpoint enables a client to add a quality score to a comment

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param post_type: The type of post being reacted to | type: string (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param body: (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_comment_quality_score_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddCommentQualityScoreResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_comment_quality_score_serialize(
        self,
        user_id,
        post_id,
        comment_id,
        post_type,
        org_id,
        tenant_id,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        if comment_id is not None:
            _path_params['commentId'] = comment_id
        # process the query parameters
        if post_type is not None:
            
            _query_params.append(('postType', post_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/{userId}/post/{postId}/comment/{commentId}/quality',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def add_post_quality_score(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        post_type: Annotated[StrictStr, Field(description="The type of post being reacted to | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        body: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AddPostQualityScoreResponse:
        """Adds a quality score to a post

        This endpoint enables a client add a quality score to a post

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param post_type: The type of post being reacted to | type: string (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param body: (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_post_quality_score_serialize(
            user_id=user_id,
            post_id=post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddPostQualityScoreResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_post_quality_score_with_http_info(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        post_type: Annotated[StrictStr, Field(description="The type of post being reacted to | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        body: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AddPostQualityScoreResponse]:
        """Adds a quality score to a post

        This endpoint enables a client add a quality score to a post

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param post_type: The type of post being reacted to | type: string (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param body: (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_post_quality_score_serialize(
            user_id=user_id,
            post_id=post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddPostQualityScoreResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_post_quality_score_without_preload_content(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        post_type: Annotated[StrictStr, Field(description="The type of post being reacted to | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        body: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Adds a quality score to a post

        This endpoint enables a client add a quality score to a post

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param post_type: The type of post being reacted to | type: string (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param body: (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_post_quality_score_serialize(
            user_id=user_id,
            post_id=post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddPostQualityScoreResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_post_quality_score_serialize(
        self,
        user_id,
        post_id,
        post_type,
        org_id,
        tenant_id,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        # process the query parameters
        if post_type is not None:
            
            _query_params.append(('postType', post_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/{userId}/post/{postId}/quality',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def add_post_to_publication(
        self,
        editor_user_id: StrictStr,
        publication_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        post: Post,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AddPostToPublicationResponse:
        """Add a post to a publication

        This endpoint enables a client to add a post to a publication

        :param editor_user_id: (required)
        :type editor_user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param post: (required)
        :type post: Post
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_post_to_publication_serialize(
            editor_user_id=editor_user_id,
            publication_id=publication_id,
            org_id=org_id,
            tenant_id=tenant_id,
            post=post,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddPostToPublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_post_to_publication_with_http_info(
        self,
        editor_user_id: StrictStr,
        publication_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        post: Post,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AddPostToPublicationResponse]:
        """Add a post to a publication

        This endpoint enables a client to add a post to a publication

        :param editor_user_id: (required)
        :type editor_user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param post: (required)
        :type post: Post
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_post_to_publication_serialize(
            editor_user_id=editor_user_id,
            publication_id=publication_id,
            org_id=org_id,
            tenant_id=tenant_id,
            post=post,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddPostToPublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_post_to_publication_without_preload_content(
        self,
        editor_user_id: StrictStr,
        publication_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        post: Post,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add a post to a publication

        This endpoint enables a client to add a post to a publication

        :param editor_user_id: (required)
        :type editor_user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param post: (required)
        :type post: Post
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_post_to_publication_serialize(
            editor_user_id=editor_user_id,
            publication_id=publication_id,
            org_id=org_id,
            tenant_id=tenant_id,
            post=post,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddPostToPublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_post_to_publication_serialize(
        self,
        editor_user_id,
        publication_id,
        org_id,
        tenant_id,
        post,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if editor_user_id is not None:
            _path_params['editorUserId'] = editor_user_id
        if publication_id is not None:
            _path_params['publicationId'] = publication_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if post is not None:
            _body_params = post


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/editor/{editorUserId}/publication/{publicationId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def add_post_to_thread(
        self,
        user_id: StrictStr,
        parent_post_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        post: Post,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AddPostToThreadResponse:
        """Adds A Post To A Thread

        This endpoint enables a client to add a post to a thread

        :param user_id: (required)
        :type user_id: str
        :param parent_post_id: (required)
        :type parent_post_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param post: (required)
        :type post: Post
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_post_to_thread_serialize(
            user_id=user_id,
            parent_post_id=parent_post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            post=post,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddPostToThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_post_to_thread_with_http_info(
        self,
        user_id: StrictStr,
        parent_post_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        post: Post,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AddPostToThreadResponse]:
        """Adds A Post To A Thread

        This endpoint enables a client to add a post to a thread

        :param user_id: (required)
        :type user_id: str
        :param parent_post_id: (required)
        :type parent_post_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param post: (required)
        :type post: Post
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_post_to_thread_serialize(
            user_id=user_id,
            parent_post_id=parent_post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            post=post,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddPostToThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_post_to_thread_without_preload_content(
        self,
        user_id: StrictStr,
        parent_post_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        post: Post,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Adds A Post To A Thread

        This endpoint enables a client to add a post to a thread

        :param user_id: (required)
        :type user_id: str
        :param parent_post_id: (required)
        :type parent_post_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param post: (required)
        :type post: Post
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_post_to_thread_serialize(
            user_id=user_id,
            parent_post_id=parent_post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            post=post,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddPostToThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_post_to_thread_serialize(
        self,
        user_id,
        parent_post_id,
        post_type,
        org_id,
        tenant_id,
        post,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if parent_post_id is not None:
            _path_params['parentPostId'] = parent_post_id
        if post_type is not None:
            _path_params['postType'] = post_type
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if post is not None:
            _body_params = post


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/{userId}/post/thread/{parentPostId}/type/{postType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def add_publication_editor(
        self,
        admin_user_id: StrictStr,
        publication_id: StrictStr,
        editor_user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AddPublicationEditorResponse:
        """Adds an editor to a publication

        This endpoint enables a client to add an editor to a publication

        :param admin_user_id: (required)
        :type admin_user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param editor_user_id: (required)
        :type editor_user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_publication_editor_serialize(
            admin_user_id=admin_user_id,
            publication_id=publication_id,
            editor_user_id=editor_user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddPublicationEditorResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def add_publication_editor_with_http_info(
        self,
        admin_user_id: StrictStr,
        publication_id: StrictStr,
        editor_user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AddPublicationEditorResponse]:
        """Adds an editor to a publication

        This endpoint enables a client to add an editor to a publication

        :param admin_user_id: (required)
        :type admin_user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param editor_user_id: (required)
        :type editor_user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_publication_editor_serialize(
            admin_user_id=admin_user_id,
            publication_id=publication_id,
            editor_user_id=editor_user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddPublicationEditorResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def add_publication_editor_without_preload_content(
        self,
        admin_user_id: StrictStr,
        publication_id: StrictStr,
        editor_user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Adds an editor to a publication

        This endpoint enables a client to add an editor to a publication

        :param admin_user_id: (required)
        :type admin_user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param editor_user_id: (required)
        :type editor_user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_publication_editor_serialize(
            admin_user_id=admin_user_id,
            publication_id=publication_id,
            editor_user_id=editor_user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AddPublicationEditorResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_publication_editor_serialize(
        self,
        admin_user_id,
        publication_id,
        editor_user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if admin_user_id is not None:
            _path_params['adminUserId'] = admin_user_id
        if publication_id is not None:
            _path_params['publicationId'] = publication_id
        if editor_user_id is not None:
            _path_params['editorUserId'] = editor_user_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/social-microservice/api/v1/users/admin/{adminUserId}/publication/{publicationId}/editor/{editorUserId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def block_user_profile(
        self,
        source_user_id: Annotated[StrictStr, Field(description="the user ID trying to block another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        target_user_id: Annotated[StrictStr, Field(description="the user ID being blocked by another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BlockUserProfileResponse:
        """blocks a user profile

        This endpoint enables a client to block a user profile

        :param source_user_id: the user ID trying to block another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type source_user_id: str
        :param target_user_id: the user ID being blocked by another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type target_user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._block_user_profile_serialize(
            source_user_id=source_user_id,
            target_user_id=target_user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BlockUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def block_user_profile_with_http_info(
        self,
        source_user_id: Annotated[StrictStr, Field(description="the user ID trying to block another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        target_user_id: Annotated[StrictStr, Field(description="the user ID being blocked by another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BlockUserProfileResponse]:
        """blocks a user profile

        This endpoint enables a client to block a user profile

        :param source_user_id: the user ID trying to block another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type source_user_id: str
        :param target_user_id: the user ID being blocked by another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type target_user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._block_user_profile_serialize(
            source_user_id=source_user_id,
            target_user_id=target_user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BlockUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def block_user_profile_without_preload_content(
        self,
        source_user_id: Annotated[StrictStr, Field(description="the user ID trying to block another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        target_user_id: Annotated[StrictStr, Field(description="the user ID being blocked by another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """blocks a user profile

        This endpoint enables a client to block a user profile

        :param source_user_id: the user ID trying to block another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type source_user_id: str
        :param target_user_id: the user ID being blocked by another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type target_user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._block_user_profile_serialize(
            source_user_id=source_user_id,
            target_user_id=target_user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BlockUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _block_user_profile_serialize(
        self,
        source_user_id,
        target_user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if source_user_id is not None:
            _path_params['sourceUserId'] = source_user_id
        if target_user_id is not None:
            _path_params['targetUserId'] = target_user_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/source/{sourceUserId}/block/target/{targetUserId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def bookmark_post(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BookmarkPostResponse:
        """Bookmarks a post

        This endpoint enables a client to bookmark a post

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bookmark_post_serialize(
            user_id=user_id,
            post_id=post_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BookmarkPostResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def bookmark_post_with_http_info(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BookmarkPostResponse]:
        """Bookmarks a post

        This endpoint enables a client to bookmark a post

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bookmark_post_serialize(
            user_id=user_id,
            post_id=post_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BookmarkPostResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def bookmark_post_without_preload_content(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Bookmarks a post

        This endpoint enables a client to bookmark a post

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bookmark_post_serialize(
            user_id=user_id,
            post_id=post_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BookmarkPostResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _bookmark_post_serialize(
        self,
        user_id,
        post_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/{userId}/post/bookmark/{postId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def bookmark_publication(
        self,
        user_id: StrictStr,
        publication_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BookmarkPublicationResponse:
        """Bookmarks a publication

        This endpoint enables a client to bookmark a publication

        :param user_id: (required)
        :type user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bookmark_publication_serialize(
            user_id=user_id,
            publication_id=publication_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BookmarkPublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def bookmark_publication_with_http_info(
        self,
        user_id: StrictStr,
        publication_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BookmarkPublicationResponse]:
        """Bookmarks a publication

        This endpoint enables a client to bookmark a publication

        :param user_id: (required)
        :type user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bookmark_publication_serialize(
            user_id=user_id,
            publication_id=publication_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BookmarkPublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def bookmark_publication_without_preload_content(
        self,
        user_id: StrictStr,
        publication_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Bookmarks a publication

        This endpoint enables a client to bookmark a publication

        :param user_id: (required)
        :type user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bookmark_publication_serialize(
            user_id=user_id,
            publication_id=publication_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BookmarkPublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _bookmark_publication_serialize(
        self,
        user_id,
        publication_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if publication_id is not None:
            _path_params['publicationId'] = publication_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/{userId}/publication/{publicationId}/bookmark',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_comment(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to create a comment (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        post_id: Annotated[StrictStr, Field(description="The ID of the post to whom to add the comment | type: string")],
        account_type: Annotated[StrictStr, Field(description="The type of account making the request to create a comment | type: string")],
        post_type: Annotated[StrictStr, Field(description="The type of post being reacted to | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        comment: Annotated[Comment, Field(description="The actual comment payload | type: json_object")],
        community_profile_id: Annotated[Optional[StrictStr], Field(description="The ID of the community trying to create a comment | type: uint64")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateCommentResponse:
        """Create A Commnet

        This endpoint enables a client to create a comment

        :param user_id: the user ID trying to create a comment (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param post_id: The ID of the post to whom to add the comment | type: string (required)
        :type post_id: str
        :param account_type: The type of account making the request to create a comment | type: string (required)
        :type account_type: str
        :param post_type: The type of post being reacted to | type: string (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param comment: The actual comment payload | type: json_object (required)
        :type comment: Comment
        :param community_profile_id: The ID of the community trying to create a comment | type: uint64
        :type community_profile_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_comment_serialize(
            user_id=user_id,
            post_id=post_id,
            account_type=account_type,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            comment=comment,
            community_profile_id=community_profile_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_comment_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to create a comment (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        post_id: Annotated[StrictStr, Field(description="The ID of the post to whom to add the comment | type: string")],
        account_type: Annotated[StrictStr, Field(description="The type of account making the request to create a comment | type: string")],
        post_type: Annotated[StrictStr, Field(description="The type of post being reacted to | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        comment: Annotated[Comment, Field(description="The actual comment payload | type: json_object")],
        community_profile_id: Annotated[Optional[StrictStr], Field(description="The ID of the community trying to create a comment | type: uint64")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateCommentResponse]:
        """Create A Commnet

        This endpoint enables a client to create a comment

        :param user_id: the user ID trying to create a comment (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param post_id: The ID of the post to whom to add the comment | type: string (required)
        :type post_id: str
        :param account_type: The type of account making the request to create a comment | type: string (required)
        :type account_type: str
        :param post_type: The type of post being reacted to | type: string (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param comment: The actual comment payload | type: json_object (required)
        :type comment: Comment
        :param community_profile_id: The ID of the community trying to create a comment | type: uint64
        :type community_profile_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_comment_serialize(
            user_id=user_id,
            post_id=post_id,
            account_type=account_type,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            comment=comment,
            community_profile_id=community_profile_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_comment_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to create a comment (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        post_id: Annotated[StrictStr, Field(description="The ID of the post to whom to add the comment | type: string")],
        account_type: Annotated[StrictStr, Field(description="The type of account making the request to create a comment | type: string")],
        post_type: Annotated[StrictStr, Field(description="The type of post being reacted to | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        comment: Annotated[Comment, Field(description="The actual comment payload | type: json_object")],
        community_profile_id: Annotated[Optional[StrictStr], Field(description="The ID of the community trying to create a comment | type: uint64")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create A Commnet

        This endpoint enables a client to create a comment

        :param user_id: the user ID trying to create a comment (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param post_id: The ID of the post to whom to add the comment | type: string (required)
        :type post_id: str
        :param account_type: The type of account making the request to create a comment | type: string (required)
        :type account_type: str
        :param post_type: The type of post being reacted to | type: string (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param comment: The actual comment payload | type: json_object (required)
        :type comment: Comment
        :param community_profile_id: The ID of the community trying to create a comment | type: uint64
        :type community_profile_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_comment_serialize(
            user_id=user_id,
            post_id=post_id,
            account_type=account_type,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            comment=comment,
            community_profile_id=community_profile_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_comment_serialize(
        self,
        user_id,
        post_id,
        account_type,
        post_type,
        org_id,
        tenant_id,
        comment,
        community_profile_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        # process the query parameters
        if community_profile_id is not None:
            
            _query_params.append(('communityProfileId', community_profile_id))
            
        if account_type is not None:
            
            _query_params.append(('accountType', account_type))
            
        if post_type is not None:
            
            _query_params.append(('postType', post_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if comment is not None:
            _body_params = comment


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/{userId}/post/{postId}/comment',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_comment_reply(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        create_comment_reply_body: CreateCommentReplyBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateCommentReplyResponse:
        """Reply To A Comment

        This endpoint enables a client to reply to a comment

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param create_comment_reply_body: (required)
        :type create_comment_reply_body: CreateCommentReplyBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_comment_reply_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            create_comment_reply_body=create_comment_reply_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentReplyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_comment_reply_with_http_info(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        create_comment_reply_body: CreateCommentReplyBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateCommentReplyResponse]:
        """Reply To A Comment

        This endpoint enables a client to reply to a comment

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param create_comment_reply_body: (required)
        :type create_comment_reply_body: CreateCommentReplyBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_comment_reply_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            create_comment_reply_body=create_comment_reply_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentReplyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_comment_reply_without_preload_content(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        create_comment_reply_body: CreateCommentReplyBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Reply To A Comment

        This endpoint enables a client to reply to a comment

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param create_comment_reply_body: (required)
        :type create_comment_reply_body: CreateCommentReplyBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_comment_reply_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            create_comment_reply_body=create_comment_reply_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentReplyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_comment_reply_serialize(
        self,
        user_id,
        post_id,
        comment_id,
        create_comment_reply_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        if comment_id is not None:
            _path_params['commentId'] = comment_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_comment_reply_body is not None:
            _body_params = create_comment_reply_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/{userId}/post/{postId}/comment/{commentId}/reply',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_community_profile(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to create this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        create_community_profile_body: CreateCommunityProfileBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateCommunityProfileResponse:
        """Create a community Profile

        This endpoint enables a client to create a community profile

        :param user_id: the user ID trying to create this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param create_community_profile_body: (required)
        :type create_community_profile_body: CreateCommunityProfileBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_community_profile_serialize(
            user_id=user_id,
            create_community_profile_body=create_community_profile_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommunityProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_community_profile_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to create this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        create_community_profile_body: CreateCommunityProfileBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateCommunityProfileResponse]:
        """Create a community Profile

        This endpoint enables a client to create a community profile

        :param user_id: the user ID trying to create this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param create_community_profile_body: (required)
        :type create_community_profile_body: CreateCommunityProfileBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_community_profile_serialize(
            user_id=user_id,
            create_community_profile_body=create_community_profile_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommunityProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_community_profile_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to create this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        create_community_profile_body: CreateCommunityProfileBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a community Profile

        This endpoint enables a client to create a community profile

        :param user_id: the user ID trying to create this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param create_community_profile_body: (required)
        :type create_community_profile_body: CreateCommunityProfileBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_community_profile_serialize(
            user_id=user_id,
            create_community_profile_body=create_community_profile_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommunityProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_community_profile_serialize(
        self,
        user_id,
        create_community_profile_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_community_profile_body is not None:
            _body_params = create_community_profile_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/community-profiles/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_note(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        create_note_body: CreateNoteBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateNoteResponse:
        """Creates and associates a note to a given post

        This endpoint enables a client to create and associate a not to a post

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param create_note_body: (required)
        :type create_note_body: CreateNoteBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_note_serialize(
            user_id=user_id,
            post_id=post_id,
            create_note_body=create_note_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateNoteResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_note_with_http_info(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        create_note_body: CreateNoteBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateNoteResponse]:
        """Creates and associates a note to a given post

        This endpoint enables a client to create and associate a not to a post

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param create_note_body: (required)
        :type create_note_body: CreateNoteBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_note_serialize(
            user_id=user_id,
            post_id=post_id,
            create_note_body=create_note_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateNoteResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_note_without_preload_content(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        create_note_body: CreateNoteBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Creates and associates a note to a given post

        This endpoint enables a client to create and associate a not to a post

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param create_note_body: (required)
        :type create_note_body: CreateNoteBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_note_serialize(
            user_id=user_id,
            post_id=post_id,
            create_note_body=create_note_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateNoteResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_note_serialize(
        self,
        user_id,
        post_id,
        create_note_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_note_body is not None:
            _body_params = create_note_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/{userId}/post/{postId}/note',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_poll(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to create a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        poll_post: Annotated[PollPost, Field(description="The post payload | type: json_object")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreatePollResponse:
        """Create a poll

        This endpoint enables a client to create a poll

        :param user_id: the user ID trying to create a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param poll_post: The post payload | type: json_object (required)
        :type poll_post: PollPost
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_poll_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            poll_post=poll_post,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePollResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_poll_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to create a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        poll_post: Annotated[PollPost, Field(description="The post payload | type: json_object")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreatePollResponse]:
        """Create a poll

        This endpoint enables a client to create a poll

        :param user_id: the user ID trying to create a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param poll_post: The post payload | type: json_object (required)
        :type poll_post: PollPost
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_poll_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            poll_post=poll_post,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePollResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_poll_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to create a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        poll_post: Annotated[PollPost, Field(description="The post payload | type: json_object")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a poll

        This endpoint enables a client to create a poll

        :param user_id: the user ID trying to create a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param poll_post: The post payload | type: json_object (required)
        :type poll_post: PollPost
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_poll_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            poll_post=poll_post,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePollResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_poll_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        poll_post,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if poll_post is not None:
            _body_params = poll_post


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/{userId}/poll',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_post(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to create a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        account_type: Annotated[StrictStr, Field(description="The type of profile making the request | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        post: Annotated[Post, Field(description="The post payload | type: json_object")],
        community_profile_id: Annotated[Optional[StrictStr], Field(description="The ID of the community profile attempting to create the post  | type: uint64")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreatePostResponse:
        """Create a post

        This endpoint enables a client to create a post

        :param user_id: the user ID trying to create a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param account_type: The type of profile making the request | type: string (required)
        :type account_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param post: The post payload | type: json_object (required)
        :type post: Post
        :param community_profile_id: The ID of the community profile attempting to create the post  | type: uint64
        :type community_profile_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_post_serialize(
            user_id=user_id,
            account_type=account_type,
            org_id=org_id,
            tenant_id=tenant_id,
            post=post,
            community_profile_id=community_profile_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePostResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_post_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to create a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        account_type: Annotated[StrictStr, Field(description="The type of profile making the request | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        post: Annotated[Post, Field(description="The post payload | type: json_object")],
        community_profile_id: Annotated[Optional[StrictStr], Field(description="The ID of the community profile attempting to create the post  | type: uint64")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreatePostResponse]:
        """Create a post

        This endpoint enables a client to create a post

        :param user_id: the user ID trying to create a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param account_type: The type of profile making the request | type: string (required)
        :type account_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param post: The post payload | type: json_object (required)
        :type post: Post
        :param community_profile_id: The ID of the community profile attempting to create the post  | type: uint64
        :type community_profile_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_post_serialize(
            user_id=user_id,
            account_type=account_type,
            org_id=org_id,
            tenant_id=tenant_id,
            post=post,
            community_profile_id=community_profile_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePostResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_post_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to create a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        account_type: Annotated[StrictStr, Field(description="The type of profile making the request | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        post: Annotated[Post, Field(description="The post payload | type: json_object")],
        community_profile_id: Annotated[Optional[StrictStr], Field(description="The ID of the community profile attempting to create the post  | type: uint64")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a post

        This endpoint enables a client to create a post

        :param user_id: the user ID trying to create a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param account_type: The type of profile making the request | type: string (required)
        :type account_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param post: The post payload | type: json_object (required)
        :type post: Post
        :param community_profile_id: The ID of the community profile attempting to create the post  | type: uint64
        :type community_profile_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_post_serialize(
            user_id=user_id,
            account_type=account_type,
            org_id=org_id,
            tenant_id=tenant_id,
            post=post,
            community_profile_id=community_profile_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePostResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_post_serialize(
        self,
        user_id,
        account_type,
        org_id,
        tenant_id,
        post,
        community_profile_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if community_profile_id is not None:
            
            _query_params.append(('communityProfileId', community_profile_id))
            
        if account_type is not None:
            
            _query_params.append(('accountType', account_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if post is not None:
            _body_params = post


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/{userId}/post',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_publication(
        self,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        publication: Publication,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreatePublicationResponse:
        """Creates a publication

        This endpoint enables a client to creare a publication

        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param publication: (required)
        :type publication: Publication
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_publication_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            publication=publication,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_publication_with_http_info(
        self,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        publication: Publication,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreatePublicationResponse]:
        """Creates a publication

        This endpoint enables a client to creare a publication

        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param publication: (required)
        :type publication: Publication
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_publication_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            publication=publication,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_publication_without_preload_content(
        self,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        publication: Publication,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Creates a publication

        This endpoint enables a client to creare a publication

        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param publication: (required)
        :type publication: Publication
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_publication_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            publication=publication,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreatePublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_publication_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        publication,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if publication is not None:
            _body_params = publication


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/{userId}/publication',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_topic(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to whom the community is tied to (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        community_profile_id: Annotated[StrictStr, Field(description="the community profile to associate the topic to | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        topic: Annotated[Topic, Field(description="topic payload | type: json_object")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateTopicResponse:
        """Create A Topic

        This endpoint enables a client to create a topic

        :param user_id: the user ID trying to whom the community is tied to (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param community_profile_id: the community profile to associate the topic to | type: uint64 (required)
        :type community_profile_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param topic: topic payload | type: json_object (required)
        :type topic: Topic
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_topic_serialize(
            user_id=user_id,
            community_profile_id=community_profile_id,
            org_id=org_id,
            tenant_id=tenant_id,
            topic=topic,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateTopicResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_topic_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to whom the community is tied to (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        community_profile_id: Annotated[StrictStr, Field(description="the community profile to associate the topic to | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        topic: Annotated[Topic, Field(description="topic payload | type: json_object")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateTopicResponse]:
        """Create A Topic

        This endpoint enables a client to create a topic

        :param user_id: the user ID trying to whom the community is tied to (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param community_profile_id: the community profile to associate the topic to | type: uint64 (required)
        :type community_profile_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param topic: topic payload | type: json_object (required)
        :type topic: Topic
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_topic_serialize(
            user_id=user_id,
            community_profile_id=community_profile_id,
            org_id=org_id,
            tenant_id=tenant_id,
            topic=topic,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateTopicResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_topic_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to whom the community is tied to (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        community_profile_id: Annotated[StrictStr, Field(description="the community profile to associate the topic to | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        topic: Annotated[Topic, Field(description="topic payload | type: json_object")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create A Topic

        This endpoint enables a client to create a topic

        :param user_id: the user ID trying to whom the community is tied to (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param community_profile_id: the community profile to associate the topic to | type: uint64 (required)
        :type community_profile_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param topic: topic payload | type: json_object (required)
        :type topic: Topic
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_topic_serialize(
            user_id=user_id,
            community_profile_id=community_profile_id,
            org_id=org_id,
            tenant_id=tenant_id,
            topic=topic,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateTopicResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_topic_serialize(
        self,
        user_id,
        community_profile_id,
        org_id,
        tenant_id,
        topic,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if community_profile_id is not None:
            _path_params['communityProfileId'] = community_profile_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if topic is not None:
            _body_params = topic


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/{userId}/community/{communityProfileId}/topic',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_user_profile(
        self,
        create_user_profile_request: Annotated[CreateUserProfileRequest, Field(description="CreateUserProfileRequest represents the request object for creating a user profile in the social service. This message encapsulates the essential information needed to establish a new social user profile, including identification, contact details, and profile preferences.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateUserProfileResponse:
        """creates a user profile

        This endpoint enables a client to create a user profile

        :param create_user_profile_request: CreateUserProfileRequest represents the request object for creating a user profile in the social service. This message encapsulates the essential information needed to establish a new social user profile, including identification, contact details, and profile preferences. (required)
        :type create_user_profile_request: CreateUserProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_user_profile_serialize(
            create_user_profile_request=create_user_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_user_profile_with_http_info(
        self,
        create_user_profile_request: Annotated[CreateUserProfileRequest, Field(description="CreateUserProfileRequest represents the request object for creating a user profile in the social service. This message encapsulates the essential information needed to establish a new social user profile, including identification, contact details, and profile preferences.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateUserProfileResponse]:
        """creates a user profile

        This endpoint enables a client to create a user profile

        :param create_user_profile_request: CreateUserProfileRequest represents the request object for creating a user profile in the social service. This message encapsulates the essential information needed to establish a new social user profile, including identification, contact details, and profile preferences. (required)
        :type create_user_profile_request: CreateUserProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_user_profile_serialize(
            create_user_profile_request=create_user_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_user_profile_without_preload_content(
        self,
        create_user_profile_request: Annotated[CreateUserProfileRequest, Field(description="CreateUserProfileRequest represents the request object for creating a user profile in the social service. This message encapsulates the essential information needed to establish a new social user profile, including identification, contact details, and profile preferences.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """creates a user profile

        This endpoint enables a client to create a user profile

        :param create_user_profile_request: CreateUserProfileRequest represents the request object for creating a user profile in the social service. This message encapsulates the essential information needed to establish a new social user profile, including identification, contact details, and profile preferences. (required)
        :type create_user_profile_request: CreateUserProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_user_profile_serialize(
            create_user_profile_request=create_user_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_user_profile_serialize(
        self,
        create_user_profile_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_user_profile_request is not None:
            _body_params = create_user_profile_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_comment(
        self,
        post_id: Annotated[StrictStr, Field(description="The ID of the post trying to be deleted | type: string")],
        comment_id: Annotated[StrictStr, Field(description="The ID of the comment trying to be delete | type: string")],
        post_type: Annotated[StrictStr, Field(description="The type of post being reacted to | type: string")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateCommentResponse:
        """Delete A Comment

        This endpoint enables a client to delete a comment

        :param post_id: The ID of the post trying to be deleted | type: string (required)
        :type post_id: str
        :param comment_id: The ID of the comment trying to be delete | type: string (required)
        :type comment_id: str
        :param post_type: The type of post being reacted to | type: string (required)
        :type post_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_comment_serialize(
            post_id=post_id,
            comment_id=comment_id,
            post_type=post_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_comment_with_http_info(
        self,
        post_id: Annotated[StrictStr, Field(description="The ID of the post trying to be deleted | type: string")],
        comment_id: Annotated[StrictStr, Field(description="The ID of the comment trying to be delete | type: string")],
        post_type: Annotated[StrictStr, Field(description="The type of post being reacted to | type: string")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateCommentResponse]:
        """Delete A Comment

        This endpoint enables a client to delete a comment

        :param post_id: The ID of the post trying to be deleted | type: string (required)
        :type post_id: str
        :param comment_id: The ID of the comment trying to be delete | type: string (required)
        :type comment_id: str
        :param post_type: The type of post being reacted to | type: string (required)
        :type post_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_comment_serialize(
            post_id=post_id,
            comment_id=comment_id,
            post_type=post_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_comment_without_preload_content(
        self,
        post_id: Annotated[StrictStr, Field(description="The ID of the post trying to be deleted | type: string")],
        comment_id: Annotated[StrictStr, Field(description="The ID of the comment trying to be delete | type: string")],
        post_type: Annotated[StrictStr, Field(description="The type of post being reacted to | type: string")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete A Comment

        This endpoint enables a client to delete a comment

        :param post_id: The ID of the post trying to be deleted | type: string (required)
        :type post_id: str
        :param comment_id: The ID of the comment trying to be delete | type: string (required)
        :type comment_id: str
        :param post_type: The type of post being reacted to | type: string (required)
        :type post_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_comment_serialize(
            post_id=post_id,
            comment_id=comment_id,
            post_type=post_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_comment_serialize(
        self,
        post_id,
        comment_id,
        post_type,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if post_id is not None:
            _path_params['postId'] = post_id
        if comment_id is not None:
            _path_params['commentId'] = comment_id
        # process the query parameters
        if post_type is not None:
            
            _query_params.append(('postType', post_type))
            
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/social-microservice/api/v1/post/{postId}/comment/{commentId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_comment_reply(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        reply_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteCommentReplyResponse:
        """Delete A Comment Reply

        This endpoint enables a client to delete a comment reply

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param reply_id: (required)
        :type reply_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_comment_reply_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            reply_id=reply_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCommentReplyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_comment_reply_with_http_info(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        reply_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteCommentReplyResponse]:
        """Delete A Comment Reply

        This endpoint enables a client to delete a comment reply

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param reply_id: (required)
        :type reply_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_comment_reply_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            reply_id=reply_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCommentReplyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_comment_reply_without_preload_content(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        reply_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete A Comment Reply

        This endpoint enables a client to delete a comment reply

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param reply_id: (required)
        :type reply_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_comment_reply_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            reply_id=reply_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCommentReplyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_comment_reply_serialize(
        self,
        user_id,
        post_id,
        comment_id,
        reply_id,
        post_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        if comment_id is not None:
            _path_params['commentId'] = comment_id
        if reply_id is not None:
            _path_params['replyId'] = reply_id
        # process the query parameters
        if post_type is not None:
            
            _query_params.append(('postType', post_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/social-microservice/api/v1/users/{userId}/post/{postId}/comment/{commentId}/reply/{replyId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_community_profile(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        community_profile_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteCommunityProfileResponse:
        """Delete Community Profile

        This endpoint enables a client to delete a community profile

        :param user_id: the user ID trying to delete this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param community_profile_id: (required)
        :type community_profile_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_community_profile_serialize(
            user_id=user_id,
            community_profile_id=community_profile_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCommunityProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_community_profile_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        community_profile_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteCommunityProfileResponse]:
        """Delete Community Profile

        This endpoint enables a client to delete a community profile

        :param user_id: the user ID trying to delete this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param community_profile_id: (required)
        :type community_profile_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_community_profile_serialize(
            user_id=user_id,
            community_profile_id=community_profile_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCommunityProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_community_profile_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        community_profile_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Community Profile

        This endpoint enables a client to delete a community profile

        :param user_id: the user ID trying to delete this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param community_profile_id: (required)
        :type community_profile_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_community_profile_serialize(
            user_id=user_id,
            community_profile_id=community_profile_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCommunityProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_community_profile_serialize(
        self,
        user_id,
        community_profile_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if community_profile_id is not None:
            _path_params['communityProfileId'] = community_profile_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/social-microservice/api/v1/users/{userId}/community-profiles/{communityProfileId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_note(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        note_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteNoteResponse:
        """Delete a note

        This endpoint enables a client to delete a note

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param note_id: (required)
        :type note_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_note_serialize(
            user_id=user_id,
            post_id=post_id,
            note_id=note_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteNoteResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_note_with_http_info(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        note_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteNoteResponse]:
        """Delete a note

        This endpoint enables a client to delete a note

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param note_id: (required)
        :type note_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_note_serialize(
            user_id=user_id,
            post_id=post_id,
            note_id=note_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteNoteResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_note_without_preload_content(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        note_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a note

        This endpoint enables a client to delete a note

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param note_id: (required)
        :type note_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_note_serialize(
            user_id=user_id,
            post_id=post_id,
            note_id=note_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteNoteResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_note_serialize(
        self,
        user_id,
        post_id,
        note_id,
        post_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        if note_id is not None:
            _path_params['noteId'] = note_id
        # process the query parameters
        if post_type is not None:
            
            _query_params.append(('postType', post_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/social-microservice/api/v1/users/{userId}/post/{postId}/note/{noteId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_poll(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        post_id: Annotated[StrictStr, Field(description="The ID of the post attempted to be delete | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeletePollResponse:
        """Delete a poll

        This endpoint enables a client to delete a poll

        :param user_id: the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param post_id: The ID of the post attempted to be delete | type: string (required)
        :type post_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_poll_serialize(
            user_id=user_id,
            post_id=post_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePollResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_poll_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        post_id: Annotated[StrictStr, Field(description="The ID of the post attempted to be delete | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeletePollResponse]:
        """Delete a poll

        This endpoint enables a client to delete a poll

        :param user_id: the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param post_id: The ID of the post attempted to be delete | type: string (required)
        :type post_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_poll_serialize(
            user_id=user_id,
            post_id=post_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePollResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_poll_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        post_id: Annotated[StrictStr, Field(description="The ID of the post attempted to be delete | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a poll

        This endpoint enables a client to delete a poll

        :param user_id: the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param post_id: The ID of the post attempted to be delete | type: string (required)
        :type post_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_poll_serialize(
            user_id=user_id,
            post_id=post_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePollResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_poll_serialize(
        self,
        user_id,
        post_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/social-microservice/api/v1/users/{userId}/poll/{postId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_post(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        post_id: Annotated[StrictStr, Field(description="The ID of the post attempted to be delete | type: string")],
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeletePostResponse:
        """Delete a post

        This endpoint enables a client to delete a post

        :param user_id: the user ID trying to delete a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param post_id: The ID of the post attempted to be delete | type: string (required)
        :type post_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_post_serialize(
            user_id=user_id,
            post_id=post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePostResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_post_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        post_id: Annotated[StrictStr, Field(description="The ID of the post attempted to be delete | type: string")],
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeletePostResponse]:
        """Delete a post

        This endpoint enables a client to delete a post

        :param user_id: the user ID trying to delete a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param post_id: The ID of the post attempted to be delete | type: string (required)
        :type post_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_post_serialize(
            user_id=user_id,
            post_id=post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePostResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_post_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        post_id: Annotated[StrictStr, Field(description="The ID of the post attempted to be delete | type: string")],
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a post

        This endpoint enables a client to delete a post

        :param user_id: the user ID trying to delete a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param post_id: The ID of the post attempted to be delete | type: string (required)
        :type post_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_post_serialize(
            user_id=user_id,
            post_id=post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePostResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_post_serialize(
        self,
        user_id,
        post_id,
        post_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        if post_type is not None:
            _path_params['postType'] = post_type
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/social-microservice/api/v1/users/{userId}/post/{postId}/type/{postType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_post_from_publication(
        self,
        editor_user_id: StrictStr,
        publication_id: StrictStr,
        post_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeletePostFromPublicationResponse:
        """Deletes a post from a publication

        This endpoint enables a client to delete a post from a publication

        :param editor_user_id: (required)
        :type editor_user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param post_id: (required)
        :type post_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_post_from_publication_serialize(
            editor_user_id=editor_user_id,
            publication_id=publication_id,
            post_id=post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePostFromPublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_post_from_publication_with_http_info(
        self,
        editor_user_id: StrictStr,
        publication_id: StrictStr,
        post_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeletePostFromPublicationResponse]:
        """Deletes a post from a publication

        This endpoint enables a client to delete a post from a publication

        :param editor_user_id: (required)
        :type editor_user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param post_id: (required)
        :type post_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_post_from_publication_serialize(
            editor_user_id=editor_user_id,
            publication_id=publication_id,
            post_id=post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePostFromPublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_post_from_publication_without_preload_content(
        self,
        editor_user_id: StrictStr,
        publication_id: StrictStr,
        post_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Deletes a post from a publication

        This endpoint enables a client to delete a post from a publication

        :param editor_user_id: (required)
        :type editor_user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param post_id: (required)
        :type post_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_post_from_publication_serialize(
            editor_user_id=editor_user_id,
            publication_id=publication_id,
            post_id=post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePostFromPublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_post_from_publication_serialize(
        self,
        editor_user_id,
        publication_id,
        post_id,
        post_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if editor_user_id is not None:
            _path_params['editorUserId'] = editor_user_id
        if publication_id is not None:
            _path_params['publicationId'] = publication_id
        if post_id is not None:
            _path_params['postId'] = post_id
        # process the query parameters
        if post_type is not None:
            
            _query_params.append(('postType', post_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/social-microservice/api/v1/users/editor/{editorUserId}/publication/{publicationId}/post/{postId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_publication(
        self,
        admin_user_id: StrictStr,
        publication_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeletePublicationResponse:
        """Deletes a publication

        This endpoint enables a client to delete a publication

        :param admin_user_id: (required)
        :type admin_user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_publication_serialize(
            admin_user_id=admin_user_id,
            publication_id=publication_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_publication_with_http_info(
        self,
        admin_user_id: StrictStr,
        publication_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeletePublicationResponse]:
        """Deletes a publication

        This endpoint enables a client to delete a publication

        :param admin_user_id: (required)
        :type admin_user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_publication_serialize(
            admin_user_id=admin_user_id,
            publication_id=publication_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_publication_without_preload_content(
        self,
        admin_user_id: StrictStr,
        publication_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Deletes a publication

        This endpoint enables a client to delete a publication

        :param admin_user_id: (required)
        :type admin_user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_publication_serialize(
            admin_user_id=admin_user_id,
            publication_id=publication_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_publication_serialize(
        self,
        admin_user_id,
        publication_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if admin_user_id is not None:
            _path_params['adminUserId'] = admin_user_id
        if publication_id is not None:
            _path_params['publicationId'] = publication_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/social-microservice/api/v1/users/admin/{adminUserId}/publication/{publicationId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_publication_editor(
        self,
        admin_user_id: StrictStr,
        publication_id: StrictStr,
        editor_user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeletePublicationEditorResponse:
        """Deletes an editor to a publication

        This endpoint enables a client to add an editor to a publication

        :param admin_user_id: (required)
        :type admin_user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param editor_user_id: (required)
        :type editor_user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_publication_editor_serialize(
            admin_user_id=admin_user_id,
            publication_id=publication_id,
            editor_user_id=editor_user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePublicationEditorResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_publication_editor_with_http_info(
        self,
        admin_user_id: StrictStr,
        publication_id: StrictStr,
        editor_user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeletePublicationEditorResponse]:
        """Deletes an editor to a publication

        This endpoint enables a client to add an editor to a publication

        :param admin_user_id: (required)
        :type admin_user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param editor_user_id: (required)
        :type editor_user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_publication_editor_serialize(
            admin_user_id=admin_user_id,
            publication_id=publication_id,
            editor_user_id=editor_user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePublicationEditorResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_publication_editor_without_preload_content(
        self,
        admin_user_id: StrictStr,
        publication_id: StrictStr,
        editor_user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Deletes an editor to a publication

        This endpoint enables a client to add an editor to a publication

        :param admin_user_id: (required)
        :type admin_user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param editor_user_id: (required)
        :type editor_user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_publication_editor_serialize(
            admin_user_id=admin_user_id,
            publication_id=publication_id,
            editor_user_id=editor_user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeletePublicationEditorResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_publication_editor_serialize(
        self,
        admin_user_id,
        publication_id,
        editor_user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if admin_user_id is not None:
            _path_params['adminUserId'] = admin_user_id
        if publication_id is not None:
            _path_params['publicationId'] = publication_id
        if editor_user_id is not None:
            _path_params['editorUserId'] = editor_user_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/social-microservice/api/v1/users/admin/{adminUserId}/publication/{publicationId}/editor/{editorUserId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_user_profile(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteUserProfileResponse:
        """deletes a user profile

        This endpoint enables a client to delete a user profile

        :param user_id: the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_profile_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_user_profile_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteUserProfileResponse]:
        """deletes a user profile

        This endpoint enables a client to delete a user profile

        :param user_id: the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_profile_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_user_profile_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """deletes a user profile

        This endpoint enables a client to delete a user profile

        :param user_id: the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_profile_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_user_profile_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/social-microservice/api/v1/users/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def discover_profiles(
        self,
        user_id: StrictStr,
        limit: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DiscoverProfilesResponse:
        """Discover Profiles

        This endpoint enables a client to discover a set of profiles he/she does not follow

        :param user_id: (required)
        :type user_id: str
        :param limit: (required)
        :type limit: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._discover_profiles_serialize(
            user_id=user_id,
            limit=limit,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DiscoverProfilesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def discover_profiles_with_http_info(
        self,
        user_id: StrictStr,
        limit: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DiscoverProfilesResponse]:
        """Discover Profiles

        This endpoint enables a client to discover a set of profiles he/she does not follow

        :param user_id: (required)
        :type user_id: str
        :param limit: (required)
        :type limit: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._discover_profiles_serialize(
            user_id=user_id,
            limit=limit,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DiscoverProfilesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def discover_profiles_without_preload_content(
        self,
        user_id: StrictStr,
        limit: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Discover Profiles

        This endpoint enables a client to discover a set of profiles he/she does not follow

        :param user_id: (required)
        :type user_id: str
        :param limit: (required)
        :type limit: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._discover_profiles_serialize(
            user_id=user_id,
            limit=limit,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DiscoverProfilesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _discover_profiles_serialize(
        self,
        user_id,
        limit,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if limit is not None:
            _path_params['limit'] = limit
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/{userId}/discover/limit/{limit}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def edit_comment_reply(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        reply_id: StrictStr,
        edit_comment_reply_body: EditCommentReplyBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EditCommentReplyResponse:
        """Edit A Comment Reply

        This endpoint enables a client to edit a comment reply

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param reply_id: (required)
        :type reply_id: str
        :param edit_comment_reply_body: (required)
        :type edit_comment_reply_body: EditCommentReplyBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_comment_reply_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            reply_id=reply_id,
            edit_comment_reply_body=edit_comment_reply_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditCommentReplyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def edit_comment_reply_with_http_info(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        reply_id: StrictStr,
        edit_comment_reply_body: EditCommentReplyBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EditCommentReplyResponse]:
        """Edit A Comment Reply

        This endpoint enables a client to edit a comment reply

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param reply_id: (required)
        :type reply_id: str
        :param edit_comment_reply_body: (required)
        :type edit_comment_reply_body: EditCommentReplyBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_comment_reply_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            reply_id=reply_id,
            edit_comment_reply_body=edit_comment_reply_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditCommentReplyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def edit_comment_reply_without_preload_content(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        reply_id: StrictStr,
        edit_comment_reply_body: EditCommentReplyBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Edit A Comment Reply

        This endpoint enables a client to edit a comment reply

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param reply_id: (required)
        :type reply_id: str
        :param edit_comment_reply_body: (required)
        :type edit_comment_reply_body: EditCommentReplyBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_comment_reply_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            reply_id=reply_id,
            edit_comment_reply_body=edit_comment_reply_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditCommentReplyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _edit_comment_reply_serialize(
        self,
        user_id,
        post_id,
        comment_id,
        reply_id,
        edit_comment_reply_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        if comment_id is not None:
            _path_params['commentId'] = comment_id
        if reply_id is not None:
            _path_params['replyId'] = reply_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if edit_comment_reply_body is not None:
            _body_params = edit_comment_reply_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/social-microservice/api/v1/users/{userId}/post/{postId}/comment/{commentId}/reply/{replyId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def edit_community_profile(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to update this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        community_profile_id: Annotated[StrictStr, Field(description="The community profile ID of the community being updated | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        community_profile: Annotated[CommunityProfile, Field(description="The community profile being updated | type: json_object")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EditCommunityProfileRequest:
        """Edit a community Profile

        This endpoint enables a client to update a community profile

        :param user_id: the user ID trying to update this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param community_profile_id: The community profile ID of the community being updated | type: uint64 (required)
        :type community_profile_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param community_profile: The community profile being updated | type: json_object (required)
        :type community_profile: CommunityProfile
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_community_profile_serialize(
            user_id=user_id,
            community_profile_id=community_profile_id,
            org_id=org_id,
            tenant_id=tenant_id,
            community_profile=community_profile,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditCommunityProfileRequest",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def edit_community_profile_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to update this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        community_profile_id: Annotated[StrictStr, Field(description="The community profile ID of the community being updated | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        community_profile: Annotated[CommunityProfile, Field(description="The community profile being updated | type: json_object")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EditCommunityProfileRequest]:
        """Edit a community Profile

        This endpoint enables a client to update a community profile

        :param user_id: the user ID trying to update this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param community_profile_id: The community profile ID of the community being updated | type: uint64 (required)
        :type community_profile_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param community_profile: The community profile being updated | type: json_object (required)
        :type community_profile: CommunityProfile
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_community_profile_serialize(
            user_id=user_id,
            community_profile_id=community_profile_id,
            org_id=org_id,
            tenant_id=tenant_id,
            community_profile=community_profile,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditCommunityProfileRequest",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def edit_community_profile_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to update this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        community_profile_id: Annotated[StrictStr, Field(description="The community profile ID of the community being updated | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        community_profile: Annotated[CommunityProfile, Field(description="The community profile being updated | type: json_object")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Edit a community Profile

        This endpoint enables a client to update a community profile

        :param user_id: the user ID trying to update this community profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param community_profile_id: The community profile ID of the community being updated | type: uint64 (required)
        :type community_profile_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param community_profile: The community profile being updated | type: json_object (required)
        :type community_profile: CommunityProfile
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_community_profile_serialize(
            user_id=user_id,
            community_profile_id=community_profile_id,
            org_id=org_id,
            tenant_id=tenant_id,
            community_profile=community_profile,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditCommunityProfileRequest",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _edit_community_profile_serialize(
        self,
        user_id,
        community_profile_id,
        org_id,
        tenant_id,
        community_profile,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if community_profile_id is not None:
            _path_params['communityProfileId'] = community_profile_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if community_profile is not None:
            _body_params = community_profile


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/social-microservice/api/v1/users/{userId}/community-profiles/{communityProfileId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def edit_note(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        note_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        note: Note,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EditNoteResponse:
        """Update a note

        This endpoint enables a client to update a note

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param note_id: (required)
        :type note_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param note: (required)
        :type note: Note
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_note_serialize(
            user_id=user_id,
            post_id=post_id,
            note_id=note_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            note=note,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditNoteResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def edit_note_with_http_info(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        note_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        note: Note,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EditNoteResponse]:
        """Update a note

        This endpoint enables a client to update a note

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param note_id: (required)
        :type note_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param note: (required)
        :type note: Note
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_note_serialize(
            user_id=user_id,
            post_id=post_id,
            note_id=note_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            note=note,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditNoteResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def edit_note_without_preload_content(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        note_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        note: Note,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a note

        This endpoint enables a client to update a note

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param note_id: (required)
        :type note_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param note: (required)
        :type note: Note
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_note_serialize(
            user_id=user_id,
            post_id=post_id,
            note_id=note_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            note=note,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditNoteResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _edit_note_serialize(
        self,
        user_id,
        post_id,
        note_id,
        post_type,
        org_id,
        tenant_id,
        note,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        if note_id is not None:
            _path_params['noteId'] = note_id
        # process the query parameters
        if post_type is not None:
            
            _query_params.append(('postType', post_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if note is not None:
            _body_params = note


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/social-microservice/api/v1/users/{userId}/post/{postId}/note/{noteId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def edit_post(
        self,
        post_id: Annotated[StrictStr, Field(description="The ID of the post to be updated | type: string")],
        post_type: StrictStr,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        post: Annotated[Post, Field(description="The post payload | type: json_object")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EditPostResponse:
        """Edits a post by id

        This endpoint enables a client to edit a post by id

        :param post_id: The ID of the post to be updated | type: string (required)
        :type post_id: str
        :param post_type: (required)
        :type post_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param post: The post payload | type: json_object (required)
        :type post: Post
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_post_serialize(
            post_id=post_id,
            post_type=post_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            post=post,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditPostResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def edit_post_with_http_info(
        self,
        post_id: Annotated[StrictStr, Field(description="The ID of the post to be updated | type: string")],
        post_type: StrictStr,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        post: Annotated[Post, Field(description="The post payload | type: json_object")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EditPostResponse]:
        """Edits a post by id

        This endpoint enables a client to edit a post by id

        :param post_id: The ID of the post to be updated | type: string (required)
        :type post_id: str
        :param post_type: (required)
        :type post_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param post: The post payload | type: json_object (required)
        :type post: Post
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_post_serialize(
            post_id=post_id,
            post_type=post_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            post=post,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditPostResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def edit_post_without_preload_content(
        self,
        post_id: Annotated[StrictStr, Field(description="The ID of the post to be updated | type: string")],
        post_type: StrictStr,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        post: Annotated[Post, Field(description="The post payload | type: json_object")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Edits a post by id

        This endpoint enables a client to edit a post by id

        :param post_id: The ID of the post to be updated | type: string (required)
        :type post_id: str
        :param post_type: (required)
        :type post_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param post: The post payload | type: json_object (required)
        :type post: Post
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_post_serialize(
            post_id=post_id,
            post_type=post_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            post=post,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditPostResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _edit_post_serialize(
        self,
        post_id,
        post_type,
        user_id,
        org_id,
        tenant_id,
        post,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if post_id is not None:
            _path_params['postId'] = post_id
        if post_type is not None:
            _path_params['postType'] = post_type
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if post is not None:
            _body_params = post


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/social-microservice/api/v1/post/{postId}/type/{postType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def edit_user_profile(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to update this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        user_profile: Annotated[UserProfile, Field(description="the profile payload | type: json_object")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EditUserProfileResponse:
        """update a user profile

        This endpoint performs an updates operation on a user profile based on the provided parametersThis update operation can span multiple services on specific cases (such as when the client is explicitly attempting to update the email of the user)All update operations are atomic by nature hence we should not expect any form of divergent state

        :param user_id: the user ID trying to update this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param user_profile: the profile payload | type: json_object (required)
        :type user_profile: UserProfile
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_user_profile_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            user_profile=user_profile,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def edit_user_profile_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to update this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        user_profile: Annotated[UserProfile, Field(description="the profile payload | type: json_object")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EditUserProfileResponse]:
        """update a user profile

        This endpoint performs an updates operation on a user profile based on the provided parametersThis update operation can span multiple services on specific cases (such as when the client is explicitly attempting to update the email of the user)All update operations are atomic by nature hence we should not expect any form of divergent state

        :param user_id: the user ID trying to update this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param user_profile: the profile payload | type: json_object (required)
        :type user_profile: UserProfile
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_user_profile_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            user_profile=user_profile,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def edit_user_profile_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to update this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        user_profile: Annotated[UserProfile, Field(description="the profile payload | type: json_object")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """update a user profile

        This endpoint performs an updates operation on a user profile based on the provided parametersThis update operation can span multiple services on specific cases (such as when the client is explicitly attempting to update the email of the user)All update operations are atomic by nature hence we should not expect any form of divergent state

        :param user_id: the user ID trying to update this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param user_profile: the profile payload | type: json_object (required)
        :type user_profile: UserProfile
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_user_profile_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            user_profile=user_profile,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EditUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _edit_user_profile_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        user_profile,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if user_profile is not None:
            _body_params = user_profile


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/social-microservice/api/v1/users/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def follow_community_profile(
        self,
        source_user_id: Annotated[StrictStr, Field(description="the user ID trying to follow another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        target_community_profile_id: Annotated[StrictStr, Field(description="the targetCommunityProfileID ID being followed by another user")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FollowCommunityProfileResponse:
        """Follows A Community Profile

        This endpoint enables a client to follow a community profile

        :param source_user_id: the user ID trying to follow another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type source_user_id: str
        :param target_community_profile_id: the targetCommunityProfileID ID being followed by another user (required)
        :type target_community_profile_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._follow_community_profile_serialize(
            source_user_id=source_user_id,
            target_community_profile_id=target_community_profile_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FollowCommunityProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def follow_community_profile_with_http_info(
        self,
        source_user_id: Annotated[StrictStr, Field(description="the user ID trying to follow another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        target_community_profile_id: Annotated[StrictStr, Field(description="the targetCommunityProfileID ID being followed by another user")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FollowCommunityProfileResponse]:
        """Follows A Community Profile

        This endpoint enables a client to follow a community profile

        :param source_user_id: the user ID trying to follow another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type source_user_id: str
        :param target_community_profile_id: the targetCommunityProfileID ID being followed by another user (required)
        :type target_community_profile_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._follow_community_profile_serialize(
            source_user_id=source_user_id,
            target_community_profile_id=target_community_profile_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FollowCommunityProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def follow_community_profile_without_preload_content(
        self,
        source_user_id: Annotated[StrictStr, Field(description="the user ID trying to follow another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        target_community_profile_id: Annotated[StrictStr, Field(description="the targetCommunityProfileID ID being followed by another user")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Follows A Community Profile

        This endpoint enables a client to follow a community profile

        :param source_user_id: the user ID trying to follow another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type source_user_id: str
        :param target_community_profile_id: the targetCommunityProfileID ID being followed by another user (required)
        :type target_community_profile_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._follow_community_profile_serialize(
            source_user_id=source_user_id,
            target_community_profile_id=target_community_profile_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FollowCommunityProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _follow_community_profile_serialize(
        self,
        source_user_id,
        target_community_profile_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if source_user_id is not None:
            _path_params['sourceUserId'] = source_user_id
        if target_community_profile_id is not None:
            _path_params['targetCommunityProfileId'] = target_community_profile_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/source/{sourceUserId}/follow/community-profiles/{targetCommunityProfileId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def follow_profile(
        self,
        source_user_id: Annotated[StrictStr, Field(description="the user ID trying to follow another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        target_user_id: Annotated[StrictStr, Field(description="the user ID being followed by another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FollowProfileResponse:
        """follow a user profile

        This endpoint enables a client to follow a user profile

        :param source_user_id: the user ID trying to follow another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type source_user_id: str
        :param target_user_id: the user ID being followed by another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type target_user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._follow_profile_serialize(
            source_user_id=source_user_id,
            target_user_id=target_user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FollowProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def follow_profile_with_http_info(
        self,
        source_user_id: Annotated[StrictStr, Field(description="the user ID trying to follow another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        target_user_id: Annotated[StrictStr, Field(description="the user ID being followed by another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FollowProfileResponse]:
        """follow a user profile

        This endpoint enables a client to follow a user profile

        :param source_user_id: the user ID trying to follow another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type source_user_id: str
        :param target_user_id: the user ID being followed by another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type target_user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._follow_profile_serialize(
            source_user_id=source_user_id,
            target_user_id=target_user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FollowProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def follow_profile_without_preload_content(
        self,
        source_user_id: Annotated[StrictStr, Field(description="the user ID trying to follow another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        target_user_id: Annotated[StrictStr, Field(description="the user ID being followed by another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """follow a user profile

        This endpoint enables a client to follow a user profile

        :param source_user_id: the user ID trying to follow another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type source_user_id: str
        :param target_user_id: the user ID being followed by another user (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type target_user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._follow_profile_serialize(
            source_user_id=source_user_id,
            target_user_id=target_user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FollowProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _follow_profile_serialize(
        self,
        source_user_id,
        target_user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if source_user_id is not None:
            _path_params['sourceUserId'] = source_user_id
        if target_user_id is not None:
            _path_params['targetUserId'] = target_user_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/source/{sourceUserId}/follow/target/{targetUserId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_accounts_following(
        self,
        user_id: StrictStr,
        profile_id: StrictStr,
        account_type: Annotated[StrictStr, Field(description="the account type of the user whoses followers are being requested")],
        limit: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetAccountsFollowingResponse:
        """Get Communities and users you are following

        This endpoint enables a client to get all the accounts a given user follows

        :param user_id: (required)
        :type user_id: str
        :param profile_id: (required)
        :type profile_id: str
        :param account_type: the account type of the user whoses followers are being requested (required)
        :type account_type: str
        :param limit: (required)
        :type limit: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_accounts_following_serialize(
            user_id=user_id,
            profile_id=profile_id,
            account_type=account_type,
            limit=limit,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetAccountsFollowingResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_accounts_following_with_http_info(
        self,
        user_id: StrictStr,
        profile_id: StrictStr,
        account_type: Annotated[StrictStr, Field(description="the account type of the user whoses followers are being requested")],
        limit: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetAccountsFollowingResponse]:
        """Get Communities and users you are following

        This endpoint enables a client to get all the accounts a given user follows

        :param user_id: (required)
        :type user_id: str
        :param profile_id: (required)
        :type profile_id: str
        :param account_type: the account type of the user whoses followers are being requested (required)
        :type account_type: str
        :param limit: (required)
        :type limit: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_accounts_following_serialize(
            user_id=user_id,
            profile_id=profile_id,
            account_type=account_type,
            limit=limit,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetAccountsFollowingResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_accounts_following_without_preload_content(
        self,
        user_id: StrictStr,
        profile_id: StrictStr,
        account_type: Annotated[StrictStr, Field(description="the account type of the user whoses followers are being requested")],
        limit: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Communities and users you are following

        This endpoint enables a client to get all the accounts a given user follows

        :param user_id: (required)
        :type user_id: str
        :param profile_id: (required)
        :type profile_id: str
        :param account_type: the account type of the user whoses followers are being requested (required)
        :type account_type: str
        :param limit: (required)
        :type limit: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_accounts_following_serialize(
            user_id=user_id,
            profile_id=profile_id,
            account_type=account_type,
            limit=limit,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetAccountsFollowingResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_accounts_following_serialize(
        self,
        user_id,
        profile_id,
        account_type,
        limit,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if profile_id is not None:
            _path_params['profileId'] = profile_id
        if account_type is not None:
            _path_params['accountType'] = account_type
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/{userId}/profile/{profileId}/account-type/{accountType}/following',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_blog_posts_by_tag(
        self,
        tag: StrictStr,
        post_type: Annotated[StrictStr, Field(description="The type of post being reacted to | type: string")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetBlogPostsByTagResponse:
        """Get blog posts by tag

        This endpoint enables a client to query a set of blog posts tied to a tag

        :param tag: (required)
        :type tag: str
        :param post_type: The type of post being reacted to | type: string (required)
        :type post_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_blog_posts_by_tag_serialize(
            tag=tag,
            post_type=post_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBlogPostsByTagResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_blog_posts_by_tag_with_http_info(
        self,
        tag: StrictStr,
        post_type: Annotated[StrictStr, Field(description="The type of post being reacted to | type: string")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetBlogPostsByTagResponse]:
        """Get blog posts by tag

        This endpoint enables a client to query a set of blog posts tied to a tag

        :param tag: (required)
        :type tag: str
        :param post_type: The type of post being reacted to | type: string (required)
        :type post_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_blog_posts_by_tag_serialize(
            tag=tag,
            post_type=post_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBlogPostsByTagResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_blog_posts_by_tag_without_preload_content(
        self,
        tag: StrictStr,
        post_type: Annotated[StrictStr, Field(description="The type of post being reacted to | type: string")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get blog posts by tag

        This endpoint enables a client to query a set of blog posts tied to a tag

        :param tag: (required)
        :type tag: str
        :param post_type: The type of post being reacted to | type: string (required)
        :type post_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_blog_posts_by_tag_serialize(
            tag=tag,
            post_type=post_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBlogPostsByTagResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_blog_posts_by_tag_serialize(
        self,
        tag,
        post_type,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tag is not None:
            _path_params['tag'] = tag
        # process the query parameters
        if post_type is not None:
            
            _query_params.append(('postType', post_type))
            
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/posts/blog/tag/{tag}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_bookmarked_posts(
        self,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetBookmarkedPostsResponse:
        """Get Bookmarked Posts

        This endpoint enables a client to get all bookmarked posts of a given user

        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_bookmarked_posts_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBookmarkedPostsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_bookmarked_posts_with_http_info(
        self,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetBookmarkedPostsResponse]:
        """Get Bookmarked Posts

        This endpoint enables a client to get all bookmarked posts of a given user

        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_bookmarked_posts_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBookmarkedPostsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_bookmarked_posts_without_preload_content(
        self,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Bookmarked Posts

        This endpoint enables a client to get all bookmarked posts of a given user

        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_bookmarked_posts_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBookmarkedPostsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_bookmarked_posts_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/bookmarks/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_canny_user_sso_token1(
        self,
        user_id: StrictStr,
        email: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetCannyUserSSOTokenResponse:
        """Retrieves user sso token for canny

        Fetches a user sso token for canny

        :param user_id: (required)
        :type user_id: str
        :param email: (required)
        :type email: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_canny_user_sso_token1_serialize(
            user_id=user_id,
            email=email,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCannyUserSSOTokenResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_canny_user_sso_token1_with_http_info(
        self,
        user_id: StrictStr,
        email: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetCannyUserSSOTokenResponse]:
        """Retrieves user sso token for canny

        Fetches a user sso token for canny

        :param user_id: (required)
        :type user_id: str
        :param email: (required)
        :type email: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_canny_user_sso_token1_serialize(
            user_id=user_id,
            email=email,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCannyUserSSOTokenResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_canny_user_sso_token1_without_preload_content(
        self,
        user_id: StrictStr,
        email: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves user sso token for canny

        Fetches a user sso token for canny

        :param user_id: (required)
        :type user_id: str
        :param email: (required)
        :type email: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_canny_user_sso_token1_serialize(
            user_id=user_id,
            email=email,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCannyUserSSOTokenResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_canny_user_sso_token1_serialize(
        self,
        user_id,
        email,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if email is not None:
            _path_params['email'] = email
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/user/{userId}/canny/email/{email}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_comment_replies(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetCommentRepliesResponse:
        """Get Comment Replies

        This endpoint enables a client to get comment replies

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_comment_replies_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommentRepliesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_comment_replies_with_http_info(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetCommentRepliesResponse]:
        """Get Comment Replies

        This endpoint enables a client to get comment replies

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_comment_replies_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommentRepliesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_comment_replies_without_preload_content(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Comment Replies

        This endpoint enables a client to get comment replies

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_comment_replies_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommentRepliesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_comment_replies_serialize(
        self,
        user_id,
        post_id,
        comment_id,
        post_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        if comment_id is not None:
            _path_params['commentId'] = comment_id
        # process the query parameters
        if post_type is not None:
            
            _query_params.append(('postType', post_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/{userId}/post/{postId}/comment/{commentId}/replies',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_communities_user_follows(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID who's communities follow set we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        limit: Annotated[StrictStr, Field(description="the max number of communities to return | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetCommunitiesUserFollowsResponse:
        """Gets all the communities a user follows

        This endpoint enables a client to get all the communities a user follows

        :param user_id: the user ID who's communities follow set we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param limit: the max number of communities to return | type: uint64 (required)
        :type limit: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_communities_user_follows_serialize(
            user_id=user_id,
            limit=limit,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommunitiesUserFollowsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_communities_user_follows_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID who's communities follow set we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        limit: Annotated[StrictStr, Field(description="the max number of communities to return | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetCommunitiesUserFollowsResponse]:
        """Gets all the communities a user follows

        This endpoint enables a client to get all the communities a user follows

        :param user_id: the user ID who's communities follow set we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param limit: the max number of communities to return | type: uint64 (required)
        :type limit: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_communities_user_follows_serialize(
            user_id=user_id,
            limit=limit,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommunitiesUserFollowsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_communities_user_follows_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID who's communities follow set we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        limit: Annotated[StrictStr, Field(description="the max number of communities to return | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets all the communities a user follows

        This endpoint enables a client to get all the communities a user follows

        :param user_id: the user ID who's communities follow set we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param limit: the max number of communities to return | type: uint64 (required)
        :type limit: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_communities_user_follows_serialize(
            user_id=user_id,
            limit=limit,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommunitiesUserFollowsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_communities_user_follows_serialize(
        self,
        user_id,
        limit,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/{userId}/communities-followed',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_community_blog_posts(
        self,
        community_profile_id: StrictStr,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetCommunityBlogPostsResponse:
        """Get community blog posts

        This endpoint enables a client to get community blog posts

        :param community_profile_id: (required)
        :type community_profile_id: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_community_blog_posts_serialize(
            community_profile_id=community_profile_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommunityBlogPostsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_community_blog_posts_with_http_info(
        self,
        community_profile_id: StrictStr,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetCommunityBlogPostsResponse]:
        """Get community blog posts

        This endpoint enables a client to get community blog posts

        :param community_profile_id: (required)
        :type community_profile_id: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_community_blog_posts_serialize(
            community_profile_id=community_profile_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommunityBlogPostsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_community_blog_posts_without_preload_content(
        self,
        community_profile_id: StrictStr,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get community blog posts

        This endpoint enables a client to get community blog posts

        :param community_profile_id: (required)
        :type community_profile_id: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_community_blog_posts_serialize(
            community_profile_id=community_profile_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommunityBlogPostsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_community_blog_posts_serialize(
        self,
        community_profile_id,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if community_profile_id is not None:
            _path_params['communityProfileId'] = community_profile_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/community-profiles/{communityProfileId}/posts/blog',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_community_feed(
        self,
        community_profile_id: Annotated[StrictStr, Field(description="The ID of the community we are trying to obtain the feed for | type: uint64")],
        feed_type: Annotated[StrictStr, Field(description="The type of feed aiming to be obtained | type: string   - FEED_TYPE_PERSONAL: UserFeed is a profile's personal feed  - FEED_TYPE_NEWS: NewsFeed is a profile's timeline  - FEED_TYPE_NOTIFICATION: NotificationFeed encompasses a profile's notification feed")],
        account_type: Annotated[StrictStr, Field(description="The type of account making the request to obtain the feed | type: string")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        next_page_token: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetCommunityFeedResponse:
        """Gets A Community Feed

        This endpoint enables a client query a community feed

        :param community_profile_id: The ID of the community we are trying to obtain the feed for | type: uint64 (required)
        :type community_profile_id: str
        :param feed_type: The type of feed aiming to be obtained | type: string   - FEED_TYPE_PERSONAL: UserFeed is a profile's personal feed  - FEED_TYPE_NEWS: NewsFeed is a profile's timeline  - FEED_TYPE_NOTIFICATION: NotificationFeed encompasses a profile's notification feed (required)
        :type feed_type: str
        :param account_type: The type of account making the request to obtain the feed | type: string (required)
        :type account_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param next_page_token:
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_community_feed_serialize(
            community_profile_id=community_profile_id,
            feed_type=feed_type,
            account_type=account_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommunityFeedResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_community_feed_with_http_info(
        self,
        community_profile_id: Annotated[StrictStr, Field(description="The ID of the community we are trying to obtain the feed for | type: uint64")],
        feed_type: Annotated[StrictStr, Field(description="The type of feed aiming to be obtained | type: string   - FEED_TYPE_PERSONAL: UserFeed is a profile's personal feed  - FEED_TYPE_NEWS: NewsFeed is a profile's timeline  - FEED_TYPE_NOTIFICATION: NotificationFeed encompasses a profile's notification feed")],
        account_type: Annotated[StrictStr, Field(description="The type of account making the request to obtain the feed | type: string")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        next_page_token: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetCommunityFeedResponse]:
        """Gets A Community Feed

        This endpoint enables a client query a community feed

        :param community_profile_id: The ID of the community we are trying to obtain the feed for | type: uint64 (required)
        :type community_profile_id: str
        :param feed_type: The type of feed aiming to be obtained | type: string   - FEED_TYPE_PERSONAL: UserFeed is a profile's personal feed  - FEED_TYPE_NEWS: NewsFeed is a profile's timeline  - FEED_TYPE_NOTIFICATION: NotificationFeed encompasses a profile's notification feed (required)
        :type feed_type: str
        :param account_type: The type of account making the request to obtain the feed | type: string (required)
        :type account_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param next_page_token:
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_community_feed_serialize(
            community_profile_id=community_profile_id,
            feed_type=feed_type,
            account_type=account_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommunityFeedResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_community_feed_without_preload_content(
        self,
        community_profile_id: Annotated[StrictStr, Field(description="The ID of the community we are trying to obtain the feed for | type: uint64")],
        feed_type: Annotated[StrictStr, Field(description="The type of feed aiming to be obtained | type: string   - FEED_TYPE_PERSONAL: UserFeed is a profile's personal feed  - FEED_TYPE_NEWS: NewsFeed is a profile's timeline  - FEED_TYPE_NOTIFICATION: NotificationFeed encompasses a profile's notification feed")],
        account_type: Annotated[StrictStr, Field(description="The type of account making the request to obtain the feed | type: string")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        next_page_token: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets A Community Feed

        This endpoint enables a client query a community feed

        :param community_profile_id: The ID of the community we are trying to obtain the feed for | type: uint64 (required)
        :type community_profile_id: str
        :param feed_type: The type of feed aiming to be obtained | type: string   - FEED_TYPE_PERSONAL: UserFeed is a profile's personal feed  - FEED_TYPE_NEWS: NewsFeed is a profile's timeline  - FEED_TYPE_NOTIFICATION: NotificationFeed encompasses a profile's notification feed (required)
        :type feed_type: str
        :param account_type: The type of account making the request to obtain the feed | type: string (required)
        :type account_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param next_page_token:
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_community_feed_serialize(
            community_profile_id=community_profile_id,
            feed_type=feed_type,
            account_type=account_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommunityFeedResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_community_feed_serialize(
        self,
        community_profile_id,
        feed_type,
        account_type,
        user_id,
        org_id,
        tenant_id,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if community_profile_id is not None:
            _path_params['communityProfileId'] = community_profile_id
        # process the query parameters
        if feed_type is not None:
            
            _query_params.append(('feedType', feed_type))
            
        if account_type is not None:
            
            _query_params.append(('accountType', account_type))
            
        if next_page_token is not None:
            
            _query_params.append(('nextPageToken', next_page_token))
            
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/community-profiles/{communityProfileId}/timeline',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_community_profile(
        self,
        community_id: Annotated[StrictStr, Field(description="The communityID associated with the community being requested  | type: uint64")],
        requestor_profile_id: Annotated[StrictStr, Field(description="The RequestorProfileID is an optional parameter used to check if the profileID (requestor) making a request for the record actually follows the record")],
        requestor_profile_type: Annotated[StrictStr, Field(description="The RequestorProfileType is an optional parameter which tells us what type of profile is the requestor")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetCommunityProfileResponse:
        """Get a community Profile

        This endpoint enables a client to get a community profile

        :param community_id: The communityID associated with the community being requested  | type: uint64 (required)
        :type community_id: str
        :param requestor_profile_id: The RequestorProfileID is an optional parameter used to check if the profileID (requestor) making a request for the record actually follows the record (required)
        :type requestor_profile_id: str
        :param requestor_profile_type: The RequestorProfileType is an optional parameter which tells us what type of profile is the requestor (required)
        :type requestor_profile_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_community_profile_serialize(
            community_id=community_id,
            requestor_profile_id=requestor_profile_id,
            requestor_profile_type=requestor_profile_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommunityProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_community_profile_with_http_info(
        self,
        community_id: Annotated[StrictStr, Field(description="The communityID associated with the community being requested  | type: uint64")],
        requestor_profile_id: Annotated[StrictStr, Field(description="The RequestorProfileID is an optional parameter used to check if the profileID (requestor) making a request for the record actually follows the record")],
        requestor_profile_type: Annotated[StrictStr, Field(description="The RequestorProfileType is an optional parameter which tells us what type of profile is the requestor")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetCommunityProfileResponse]:
        """Get a community Profile

        This endpoint enables a client to get a community profile

        :param community_id: The communityID associated with the community being requested  | type: uint64 (required)
        :type community_id: str
        :param requestor_profile_id: The RequestorProfileID is an optional parameter used to check if the profileID (requestor) making a request for the record actually follows the record (required)
        :type requestor_profile_id: str
        :param requestor_profile_type: The RequestorProfileType is an optional parameter which tells us what type of profile is the requestor (required)
        :type requestor_profile_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_community_profile_serialize(
            community_id=community_id,
            requestor_profile_id=requestor_profile_id,
            requestor_profile_type=requestor_profile_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommunityProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_community_profile_without_preload_content(
        self,
        community_id: Annotated[StrictStr, Field(description="The communityID associated with the community being requested  | type: uint64")],
        requestor_profile_id: Annotated[StrictStr, Field(description="The RequestorProfileID is an optional parameter used to check if the profileID (requestor) making a request for the record actually follows the record")],
        requestor_profile_type: Annotated[StrictStr, Field(description="The RequestorProfileType is an optional parameter which tells us what type of profile is the requestor")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a community Profile

        This endpoint enables a client to get a community profile

        :param community_id: The communityID associated with the community being requested  | type: uint64 (required)
        :type community_id: str
        :param requestor_profile_id: The RequestorProfileID is an optional parameter used to check if the profileID (requestor) making a request for the record actually follows the record (required)
        :type requestor_profile_id: str
        :param requestor_profile_type: The RequestorProfileType is an optional parameter which tells us what type of profile is the requestor (required)
        :type requestor_profile_type: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_community_profile_serialize(
            community_id=community_id,
            requestor_profile_id=requestor_profile_id,
            requestor_profile_type=requestor_profile_type,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommunityProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_community_profile_serialize(
        self,
        community_id,
        requestor_profile_id,
        requestor_profile_type,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if community_id is not None:
            _path_params['communityId'] = community_id
        if requestor_profile_id is not None:
            _path_params['requestorProfileId'] = requestor_profile_id
        if requestor_profile_type is not None:
            _path_params['requestorProfileType'] = requestor_profile_type
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/social/community-profiles/{communityId}/requestor/{requestorProfileId}/profile-type/{requestorProfileType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_community_profiles(
        self,
        page_size: StrictInt,
        page_number: StrictInt,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetCommunityProfilesResponse:
        """Get Community Profiles

        This endpoint enables a client to get community profiles

        :param page_size: (required)
        :type page_size: int
        :param page_number: (required)
        :type page_number: int
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_community_profiles_serialize(
            page_size=page_size,
            page_number=page_number,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommunityProfilesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_community_profiles_with_http_info(
        self,
        page_size: StrictInt,
        page_number: StrictInt,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetCommunityProfilesResponse]:
        """Get Community Profiles

        This endpoint enables a client to get community profiles

        :param page_size: (required)
        :type page_size: int
        :param page_number: (required)
        :type page_number: int
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_community_profiles_serialize(
            page_size=page_size,
            page_number=page_number,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommunityProfilesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_community_profiles_without_preload_content(
        self,
        page_size: StrictInt,
        page_number: StrictInt,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Community Profiles

        This endpoint enables a client to get community profiles

        :param page_size: (required)
        :type page_size: int
        :param page_number: (required)
        :type page_number: int
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_community_profiles_serialize(
            page_size=page_size,
            page_number=page_number,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommunityProfilesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_community_profiles_serialize(
        self,
        page_size,
        page_number,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if page_size is not None:
            _path_params['pageSize'] = page_size
        if page_number is not None:
            _path_params['pageNumber'] = page_number
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/community-profiles/page-size/{pageSize}/page-number/{pageNumber}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_followers(
        self,
        user_id: StrictStr,
        profile_id: StrictStr,
        limit: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetFollowersResponse:
        """Get Users Following you

        This endpoint enables a client to get all the followers following a given user

        :param user_id: (required)
        :type user_id: str
        :param profile_id: (required)
        :type profile_id: str
        :param limit: (required)
        :type limit: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_followers_serialize(
            user_id=user_id,
            profile_id=profile_id,
            limit=limit,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFollowersResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_followers_with_http_info(
        self,
        user_id: StrictStr,
        profile_id: StrictStr,
        limit: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetFollowersResponse]:
        """Get Users Following you

        This endpoint enables a client to get all the followers following a given user

        :param user_id: (required)
        :type user_id: str
        :param profile_id: (required)
        :type profile_id: str
        :param limit: (required)
        :type limit: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_followers_serialize(
            user_id=user_id,
            profile_id=profile_id,
            limit=limit,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFollowersResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_followers_without_preload_content(
        self,
        user_id: StrictStr,
        profile_id: StrictStr,
        limit: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Users Following you

        This endpoint enables a client to get all the followers following a given user

        :param user_id: (required)
        :type user_id: str
        :param profile_id: (required)
        :type profile_id: str
        :param limit: (required)
        :type limit: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_followers_serialize(
            user_id=user_id,
            profile_id=profile_id,
            limit=limit,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFollowersResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_followers_serialize(
        self,
        user_id,
        profile_id,
        limit,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if profile_id is not None:
            _path_params['profileId'] = profile_id
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/{userId}/profile/{profileId}/followers',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_pending_follows(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID who's pending request we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetPendingFollowsResponse:
        """Get Pending Follow Requests

        This endpoint enables a client to get all the pending follow requests

        :param user_id: the user ID who's pending request we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_pending_follows_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPendingFollowsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_pending_follows_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID who's pending request we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetPendingFollowsResponse]:
        """Get Pending Follow Requests

        This endpoint enables a client to get all the pending follow requests

        :param user_id: the user ID who's pending request we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_pending_follows_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPendingFollowsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_pending_follows_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID who's pending request we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Pending Follow Requests

        This endpoint enables a client to get all the pending follow requests

        :param user_id: the user ID who's pending request we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_pending_follows_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPendingFollowsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_pending_follows_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/{userId}/follow/pending-requests',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_poll(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        post_id: Annotated[StrictStr, Field(description="The ID of the post attempted to be delete | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetPollResponse:
        """Get a poll

        This endpoint enables a client to query a poll by id

        :param user_id: the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param post_id: The ID of the post attempted to be delete | type: string (required)
        :type post_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_poll_serialize(
            user_id=user_id,
            post_id=post_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPollResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_poll_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        post_id: Annotated[StrictStr, Field(description="The ID of the post attempted to be delete | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetPollResponse]:
        """Get a poll

        This endpoint enables a client to query a poll by id

        :param user_id: the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param post_id: The ID of the post attempted to be delete | type: string (required)
        :type post_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_poll_serialize(
            user_id=user_id,
            post_id=post_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPollResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_poll_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        post_id: Annotated[StrictStr, Field(description="The ID of the post attempted to be delete | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a poll

        This endpoint enables a client to query a poll by id

        :param user_id: the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param post_id: The ID of the post attempted to be delete | type: string (required)
        :type post_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_poll_serialize(
            user_id=user_id,
            post_id=post_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPollResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_poll_serialize(
        self,
        user_id,
        post_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/{userId}/poll/{postId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_polls(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetPollsResponse:
        """Get all the polls of a given user

        This endpoint enables a client to query all polls tied to a given user id

        :param user_id: the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_polls_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPollsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_polls_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetPollsResponse]:
        """Get all the polls of a given user

        This endpoint enables a client to query all polls tied to a given user id

        :param user_id: the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_polls_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPollsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_polls_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get all the polls of a given user

        This endpoint enables a client to query all polls tied to a given user id

        :param user_id: the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_polls_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPollsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_polls_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/{userId}/polls',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_post(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to obtain a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        post_id: Annotated[StrictStr, Field(description="The ID of the post to obtain | type: string")],
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetPostResponse:
        """Get a post

        This endpoint enables a client to get a post

        :param user_id: the user ID trying to obtain a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param post_id: The ID of the post to obtain | type: string (required)
        :type post_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_post_serialize(
            user_id=user_id,
            post_id=post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPostResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_post_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to obtain a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        post_id: Annotated[StrictStr, Field(description="The ID of the post to obtain | type: string")],
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetPostResponse]:
        """Get a post

        This endpoint enables a client to get a post

        :param user_id: the user ID trying to obtain a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param post_id: The ID of the post to obtain | type: string (required)
        :type post_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_post_serialize(
            user_id=user_id,
            post_id=post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPostResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_post_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to obtain a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        post_id: Annotated[StrictStr, Field(description="The ID of the post to obtain | type: string")],
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a post

        This endpoint enables a client to get a post

        :param user_id: the user ID trying to obtain a post (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param post_id: The ID of the post to obtain | type: string (required)
        :type post_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_post_serialize(
            user_id=user_id,
            post_id=post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPostResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_post_serialize(
        self,
        user_id,
        post_id,
        post_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        if post_type is not None:
            _path_params['postType'] = post_type
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/{userId}/post/{postId}/type/{postType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_post_thread(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetPostThreadResponse:
        """Gets A Post's Thread

        This endpoint enables a client to query a post's thread

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_post_thread_serialize(
            user_id=user_id,
            post_id=post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPostThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_post_thread_with_http_info(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetPostThreadResponse]:
        """Gets A Post's Thread

        This endpoint enables a client to query a post's thread

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_post_thread_serialize(
            user_id=user_id,
            post_id=post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPostThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_post_thread_without_preload_content(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets A Post's Thread

        This endpoint enables a client to query a post's thread

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_post_thread_serialize(
            user_id=user_id,
            post_id=post_id,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPostThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_post_thread_serialize(
        self,
        user_id,
        post_id,
        post_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        # process the query parameters
        if post_type is not None:
            
            _query_params.append(('postType', post_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/{userId}/post/thread/{postId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_posts(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetPostsResponse:
        """Get all the posts of a given user

        This endpoint enables a client to query all posts tied to a given user id

        :param user_id: the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_posts_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPostsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_posts_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetPostsResponse]:
        """Get all the posts of a given user

        This endpoint enables a client to query all posts tied to a given user id

        :param user_id: the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_posts_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPostsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_posts_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get all the posts of a given user

        This endpoint enables a client to query all posts tied to a given user id

        :param user_id: the user ID trying to delete this user profile (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_posts_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPostsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_posts_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/{userId}/posts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_posts_by_category(
        self,
        user_id: StrictStr,
        category: StrictStr,
        post_type: StrictStr,
        limit: StrictStr,
        offset: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetPostsByCategoryResponse:
        """Get all posts associated with a category

        This endpoint enables a client to get all posts tied to a category

        :param user_id: (required)
        :type user_id: str
        :param category: (required)
        :type category: str
        :param post_type: (required)
        :type post_type: str
        :param limit: (required)
        :type limit: str
        :param offset: (required)
        :type offset: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_posts_by_category_serialize(
            user_id=user_id,
            category=category,
            post_type=post_type,
            limit=limit,
            offset=offset,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPostsByCategoryResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_posts_by_category_with_http_info(
        self,
        user_id: StrictStr,
        category: StrictStr,
        post_type: StrictStr,
        limit: StrictStr,
        offset: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetPostsByCategoryResponse]:
        """Get all posts associated with a category

        This endpoint enables a client to get all posts tied to a category

        :param user_id: (required)
        :type user_id: str
        :param category: (required)
        :type category: str
        :param post_type: (required)
        :type post_type: str
        :param limit: (required)
        :type limit: str
        :param offset: (required)
        :type offset: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_posts_by_category_serialize(
            user_id=user_id,
            category=category,
            post_type=post_type,
            limit=limit,
            offset=offset,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPostsByCategoryResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_posts_by_category_without_preload_content(
        self,
        user_id: StrictStr,
        category: StrictStr,
        post_type: StrictStr,
        limit: StrictStr,
        offset: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get all posts associated with a category

        This endpoint enables a client to get all posts tied to a category

        :param user_id: (required)
        :type user_id: str
        :param category: (required)
        :type category: str
        :param post_type: (required)
        :type post_type: str
        :param limit: (required)
        :type limit: str
        :param offset: (required)
        :type offset: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_posts_by_category_serialize(
            user_id=user_id,
            category=category,
            post_type=post_type,
            limit=limit,
            offset=offset,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPostsByCategoryResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_posts_by_category_serialize(
        self,
        user_id,
        category,
        post_type,
        limit,
        offset,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if category is not None:
            _path_params['category'] = category
        if post_type is not None:
            _path_params['postType'] = post_type
        if limit is not None:
            _path_params['limit'] = limit
        if offset is not None:
            _path_params['offset'] = offset
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/user/{userId}/category/{category}/posts/{postType}/limit/{limit}/offset/{offset}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_posts_by_topic(
        self,
        community_profile_id: Annotated[StrictStr, Field(description="the community profile to associate the topic to | type: uint64")],
        topic_name: Annotated[StrictStr, Field(description="the name of a given topic | type: string")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetPostsByTopicResponse:
        """Get all posts associated with a topic

        This endpoint enables a client to get all posts tied to a topic

        :param community_profile_id: the community profile to associate the topic to | type: uint64 (required)
        :type community_profile_id: str
        :param topic_name: the name of a given topic | type: string (required)
        :type topic_name: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_posts_by_topic_serialize(
            community_profile_id=community_profile_id,
            topic_name=topic_name,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPostsByTopicResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_posts_by_topic_with_http_info(
        self,
        community_profile_id: Annotated[StrictStr, Field(description="the community profile to associate the topic to | type: uint64")],
        topic_name: Annotated[StrictStr, Field(description="the name of a given topic | type: string")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetPostsByTopicResponse]:
        """Get all posts associated with a topic

        This endpoint enables a client to get all posts tied to a topic

        :param community_profile_id: the community profile to associate the topic to | type: uint64 (required)
        :type community_profile_id: str
        :param topic_name: the name of a given topic | type: string (required)
        :type topic_name: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_posts_by_topic_serialize(
            community_profile_id=community_profile_id,
            topic_name=topic_name,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPostsByTopicResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_posts_by_topic_without_preload_content(
        self,
        community_profile_id: Annotated[StrictStr, Field(description="the community profile to associate the topic to | type: uint64")],
        topic_name: Annotated[StrictStr, Field(description="the name of a given topic | type: string")],
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get all posts associated with a topic

        This endpoint enables a client to get all posts tied to a topic

        :param community_profile_id: the community profile to associate the topic to | type: uint64 (required)
        :type community_profile_id: str
        :param topic_name: the name of a given topic | type: string (required)
        :type topic_name: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_posts_by_topic_serialize(
            community_profile_id=community_profile_id,
            topic_name=topic_name,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPostsByTopicResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_posts_by_topic_serialize(
        self,
        community_profile_id,
        topic_name,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if community_profile_id is not None:
            _path_params['communityProfileId'] = community_profile_id
        if topic_name is not None:
            _path_params['topicName'] = topic_name
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/community/{communityProfileId}/topic/{topicName}/posts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_publication(
        self,
        user_id: StrictStr,
        publication_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetPublicationResponse:
        """Gets a publication

        This endpoint enables a client to get a publication

        :param user_id: (required)
        :type user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_publication_serialize(
            user_id=user_id,
            publication_id=publication_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_publication_with_http_info(
        self,
        user_id: StrictStr,
        publication_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetPublicationResponse]:
        """Gets a publication

        This endpoint enables a client to get a publication

        :param user_id: (required)
        :type user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_publication_serialize(
            user_id=user_id,
            publication_id=publication_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_publication_without_preload_content(
        self,
        user_id: StrictStr,
        publication_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets a publication

        This endpoint enables a client to get a publication

        :param user_id: (required)
        :type user_id: str
        :param publication_id: (required)
        :type publication_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_publication_serialize(
            user_id=user_id,
            publication_id=publication_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetPublicationResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_publication_serialize(
        self,
        user_id,
        publication_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if publication_id is not None:
            _path_params['publicationId'] = publication_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/{userId}/publication/{publicationId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_topics_of_communities_user_follows(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID whose communities topics follow set we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        limit: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetTopicsOfCommunitiesUserFollowsResponse:
        """Get Topics Of Communities User Follows

        This endpoint enables a client to get topics of communities a user follows

        :param user_id: the user ID whose communities topics follow set we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param limit: (required)
        :type limit: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_topics_of_communities_user_follows_serialize(
            user_id=user_id,
            limit=limit,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTopicsOfCommunitiesUserFollowsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_topics_of_communities_user_follows_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID whose communities topics follow set we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        limit: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetTopicsOfCommunitiesUserFollowsResponse]:
        """Get Topics Of Communities User Follows

        This endpoint enables a client to get topics of communities a user follows

        :param user_id: the user ID whose communities topics follow set we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param limit: (required)
        :type limit: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_topics_of_communities_user_follows_serialize(
            user_id=user_id,
            limit=limit,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTopicsOfCommunitiesUserFollowsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_topics_of_communities_user_follows_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID whose communities topics follow set we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        limit: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Topics Of Communities User Follows

        This endpoint enables a client to get topics of communities a user follows

        :param user_id: the user ID whose communities topics follow set we want to obtain (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param limit: (required)
        :type limit: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_topics_of_communities_user_follows_serialize(
            user_id=user_id,
            limit=limit,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTopicsOfCommunitiesUserFollowsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_topics_of_communities_user_follows_serialize(
        self,
        user_id,
        limit,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/{userId}/topics',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_user_feed(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to obtain a given feed (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        feed_type: Annotated[StrictStr, Field(description="The type of feed aiming to be obtained | type: string   - FEED_TYPE_PERSONAL: UserFeed is a profile's personal feed  - FEED_TYPE_NEWS: NewsFeed is a profile's timeline  - FEED_TYPE_NOTIFICATION: NotificationFeed encompasses a profile's notification feed")],
        account_type: Annotated[StrictStr, Field(description="The type of account making the request to obtain the feed | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        next_page_token: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetUserFeedResponse:
        """Gets A Userfeed

        This endpoint enables a client query a user feed

        :param user_id: the user ID trying to obtain a given feed (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param feed_type: The type of feed aiming to be obtained | type: string   - FEED_TYPE_PERSONAL: UserFeed is a profile's personal feed  - FEED_TYPE_NEWS: NewsFeed is a profile's timeline  - FEED_TYPE_NOTIFICATION: NotificationFeed encompasses a profile's notification feed (required)
        :type feed_type: str
        :param account_type: The type of account making the request to obtain the feed | type: string (required)
        :type account_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param next_page_token:
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_feed_serialize(
            user_id=user_id,
            feed_type=feed_type,
            account_type=account_type,
            org_id=org_id,
            tenant_id=tenant_id,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserFeedResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_user_feed_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to obtain a given feed (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        feed_type: Annotated[StrictStr, Field(description="The type of feed aiming to be obtained | type: string   - FEED_TYPE_PERSONAL: UserFeed is a profile's personal feed  - FEED_TYPE_NEWS: NewsFeed is a profile's timeline  - FEED_TYPE_NOTIFICATION: NotificationFeed encompasses a profile's notification feed")],
        account_type: Annotated[StrictStr, Field(description="The type of account making the request to obtain the feed | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        next_page_token: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetUserFeedResponse]:
        """Gets A Userfeed

        This endpoint enables a client query a user feed

        :param user_id: the user ID trying to obtain a given feed (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param feed_type: The type of feed aiming to be obtained | type: string   - FEED_TYPE_PERSONAL: UserFeed is a profile's personal feed  - FEED_TYPE_NEWS: NewsFeed is a profile's timeline  - FEED_TYPE_NOTIFICATION: NotificationFeed encompasses a profile's notification feed (required)
        :type feed_type: str
        :param account_type: The type of account making the request to obtain the feed | type: string (required)
        :type account_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param next_page_token:
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_feed_serialize(
            user_id=user_id,
            feed_type=feed_type,
            account_type=account_type,
            org_id=org_id,
            tenant_id=tenant_id,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserFeedResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_user_feed_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="the user ID trying to obtain a given feed (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64")],
        feed_type: Annotated[StrictStr, Field(description="The type of feed aiming to be obtained | type: string   - FEED_TYPE_PERSONAL: UserFeed is a profile's personal feed  - FEED_TYPE_NEWS: NewsFeed is a profile's timeline  - FEED_TYPE_NOTIFICATION: NotificationFeed encompasses a profile's notification feed")],
        account_type: Annotated[StrictStr, Field(description="The type of account making the request to obtain the feed | type: string")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        next_page_token: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets A Userfeed

        This endpoint enables a client query a user feed

        :param user_id: the user ID trying to obtain a given feed (NOTE: userID refers to the ID from the vantage point of the user service. This ID is the single source of truth for a given user across our suite of services) | type: uint64 (required)
        :type user_id: str
        :param feed_type: The type of feed aiming to be obtained | type: string   - FEED_TYPE_PERSONAL: UserFeed is a profile's personal feed  - FEED_TYPE_NEWS: NewsFeed is a profile's timeline  - FEED_TYPE_NOTIFICATION: NotificationFeed encompasses a profile's notification feed (required)
        :type feed_type: str
        :param account_type: The type of account making the request to obtain the feed | type: string (required)
        :type account_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param next_page_token:
        :type next_page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_feed_serialize(
            user_id=user_id,
            feed_type=feed_type,
            account_type=account_type,
            org_id=org_id,
            tenant_id=tenant_id,
            next_page_token=next_page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserFeedResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_user_feed_serialize(
        self,
        user_id,
        feed_type,
        account_type,
        org_id,
        tenant_id,
        next_page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if feed_type is not None:
            
            _query_params.append(('feedType', feed_type))
            
        if account_type is not None:
            
            _query_params.append(('accountType', account_type))
            
        if next_page_token is not None:
            
            _query_params.append(('nextPageToken', next_page_token))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/{userId}/timeline',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_user_profile(
        self,
        user_id: Annotated[StrictStr, Field(description="The user ID associated with the profile we want to get | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        requestor_profile_id: Annotated[Optional[StrictStr], Field(description="The RequestorProfileID is an optional parameter used to check if the profileID (requestor) making a request for the record actually follows the record")] = None,
        requestor_profile_type: Annotated[Optional[StrictStr], Field(description="The RequestorProfileType is an optional parameter which tells us what type of profile is the requestor")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetUserProfileResponse:
        """gets a user profile

        This endpoint performs a query against the social service to obtain a user profile

        :param user_id: The user ID associated with the profile we want to get | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param requestor_profile_id: The RequestorProfileID is an optional parameter used to check if the profileID (requestor) making a request for the record actually follows the record
        :type requestor_profile_id: str
        :param requestor_profile_type: The RequestorProfileType is an optional parameter which tells us what type of profile is the requestor
        :type requestor_profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_profile_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            requestor_profile_id=requestor_profile_id,
            requestor_profile_type=requestor_profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_user_profile_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="The user ID associated with the profile we want to get | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        requestor_profile_id: Annotated[Optional[StrictStr], Field(description="The RequestorProfileID is an optional parameter used to check if the profileID (requestor) making a request for the record actually follows the record")] = None,
        requestor_profile_type: Annotated[Optional[StrictStr], Field(description="The RequestorProfileType is an optional parameter which tells us what type of profile is the requestor")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetUserProfileResponse]:
        """gets a user profile

        This endpoint performs a query against the social service to obtain a user profile

        :param user_id: The user ID associated with the profile we want to get | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param requestor_profile_id: The RequestorProfileID is an optional parameter used to check if the profileID (requestor) making a request for the record actually follows the record
        :type requestor_profile_id: str
        :param requestor_profile_type: The RequestorProfileType is an optional parameter which tells us what type of profile is the requestor
        :type requestor_profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_profile_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            requestor_profile_id=requestor_profile_id,
            requestor_profile_type=requestor_profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_user_profile_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="The user ID associated with the profile we want to get | type: uint64")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        requestor_profile_id: Annotated[Optional[StrictStr], Field(description="The RequestorProfileID is an optional parameter used to check if the profileID (requestor) making a request for the record actually follows the record")] = None,
        requestor_profile_type: Annotated[Optional[StrictStr], Field(description="The RequestorProfileType is an optional parameter which tells us what type of profile is the requestor")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """gets a user profile

        This endpoint performs a query against the social service to obtain a user profile

        :param user_id: The user ID associated with the profile we want to get | type: uint64 (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param requestor_profile_id: The RequestorProfileID is an optional parameter used to check if the profileID (requestor) making a request for the record actually follows the record
        :type requestor_profile_id: str
        :param requestor_profile_type: The RequestorProfileType is an optional parameter which tells us what type of profile is the requestor
        :type requestor_profile_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_profile_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            requestor_profile_id=requestor_profile_id,
            requestor_profile_type=requestor_profile_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_user_profile_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        requestor_profile_id,
        requestor_profile_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if requestor_profile_id is not None:
            
            _query_params.append(('requestorProfileId', requestor_profile_id))
            
        if requestor_profile_type is not None:
            
            _query_params.append(('requestorProfileType', requestor_profile_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_user_profiles(
        self,
        page_size: StrictInt,
        page_number: StrictInt,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetUserProfilesResponse:
        """Gets a set of user profiles

        This endpoint enables a client to get a number of user profiles in a paginated manner

        :param page_size: (required)
        :type page_size: int
        :param page_number: (required)
        :type page_number: int
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_profiles_serialize(
            page_size=page_size,
            page_number=page_number,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserProfilesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_user_profiles_with_http_info(
        self,
        page_size: StrictInt,
        page_number: StrictInt,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetUserProfilesResponse]:
        """Gets a set of user profiles

        This endpoint enables a client to get a number of user profiles in a paginated manner

        :param page_size: (required)
        :type page_size: int
        :param page_number: (required)
        :type page_number: int
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_profiles_serialize(
            page_size=page_size,
            page_number=page_number,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserProfilesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_user_profiles_without_preload_content(
        self,
        page_size: StrictInt,
        page_number: StrictInt,
        user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets a set of user profiles

        This endpoint enables a client to get a number of user profiles in a paginated manner

        :param page_size: (required)
        :type page_size: int
        :param page_number: (required)
        :type page_number: int
        :param user_id: (required)
        :type user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_profiles_serialize(
            page_size=page_size,
            page_number=page_number,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetUserProfilesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_user_profiles_serialize(
        self,
        page_size,
        page_number,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if page_size is not None:
            _path_params['pageSize'] = page_size
        if page_number is not None:
            _path_params['pageNumber'] = page_number
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/users/page-size/{pageSize}/page-number/{pageNumber}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def health_check1(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> HealthCheckResponse1:
        """health check

        This endpoint performs a healc check on the service

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._health_check1_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HealthCheckResponse1",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def health_check1_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[HealthCheckResponse1]:
        """health check

        This endpoint performs a healc check on the service

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._health_check1_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HealthCheckResponse1",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def health_check1_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """health check

        This endpoint performs a healc check on the service

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._health_check1_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HealthCheckResponse1",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _health_check1_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/social-microservice/api/v1/health',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def react_to_comment(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        account_type: StrictStr,
        reaction: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ReactToCommentResponse:
        """Reacts to a comment

        This endpoint enables a client to react to a comment

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param account_type: (required)
        :type account_type: str
        :param reaction: (required)
        :type reaction: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._react_to_comment_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            account_type=account_type,
            reaction=reaction,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReactToCommentResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def react_to_comment_with_http_info(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        account_type: StrictStr,
        reaction: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ReactToCommentResponse]:
        """Reacts to a comment

        This endpoint enables a client to react to a comment

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param account_type: (required)
        :type account_type: str
        :param reaction: (required)
        :type reaction: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._react_to_comment_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            account_type=account_type,
            reaction=reaction,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReactToCommentResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def react_to_comment_without_preload_content(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        account_type: StrictStr,
        reaction: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Reacts to a comment

        This endpoint enables a client to react to a comment

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param account_type: (required)
        :type account_type: str
        :param reaction: (required)
        :type reaction: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._react_to_comment_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            account_type=account_type,
            reaction=reaction,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReactToCommentResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _react_to_comment_serialize(
        self,
        user_id,
        post_id,
        comment_id,
        account_type,
        reaction,
        post_type,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        if post_id is not None:
            _path_params['postId'] = post_id
        if comment_id is not None:
            _path_params['commentId'] = comment_id
        if account_type is not None:
            _path_params['accountType'] = account_type
        if reaction is not None:
            _path_params['reaction'] = reaction
        # process the query parameters
        if post_type is not None:
            
            _query_params.append(('postType', post_type))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/social-microservice/api/v1/users/{userId}/post/{postId}/comment/{commentId}/account-type/{accountType}/reaction/{reaction}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def react_to_comment_reply(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        reply_id: StrictStr,
        account_type: StrictStr,
        reaction: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ReactToCommentReplyResponse:
        """Reacts to a comment reply

        This endpoint enables a client to react to a comment reply

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param reply_id: (required)
        :type reply_id: str
        :param account_type: (required)
        :type account_type: str
        :param reaction: (required)
        :type reaction: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._react_to_comment_reply_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            reply_id=reply_id,
            account_type=account_type,
            reaction=reaction,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReactToCommentReplyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def react_to_comment_reply_with_http_info(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        reply_id: StrictStr,
        account_type: StrictStr,
        reaction: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ReactToCommentReplyResponse]:
        """Reacts to a comment reply

        This endpoint enables a client to react to a comment reply

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param reply_id: (required)
        :type reply_id: str
        :param account_type: (required)
        :type account_type: str
        :param reaction: (required)
        :type reaction: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._react_to_comment_reply_serialize(
            user_id=user_id,
            post_id=post_id,
            comment_id=comment_id,
            reply_id=reply_id,
            account_type=account_type,
            reaction=reaction,
            post_type=post_type,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReactToCommentReplyResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def react_to_comment_reply_without_preload_content(
        self,
        user_id: StrictStr,
        post_id: StrictStr,
        comment_id: StrictStr,
        reply_id: StrictStr,
        account_type: StrictStr,
        reaction: StrictStr,
        post_type: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Reacts to a comment reply

        This endpoint enables a client to react to a comment reply

        :param user_id: (required)
        :type user_id: str
        :param post_id: (required)
        :type post_id: str
        :param comment_id: (required)
        :type comment_id: str
        :param reply_id: (required)
        :type reply_id: str
        :param account_type: (required)
        :type account_type: str
        :param reaction: (required)
        :type reaction: str
        :param post_type: (required)
        :type post_type: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        