"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketRoute = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const authorizer_1 = require("./authorizer");
/**
 * Route class that creates the Route for API Gateway WebSocket API
 * @resource AWS::ApiGatewayV2::Route
 */
class WebSocketRoute extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketRouteProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.routeKey != '$connect' && props.authorizer) {
            throw new Error('You can only set a WebSocket authorizer to a $connect route.');
        }
        this.webSocketApi = props.webSocketApi;
        this.routeKey = props.routeKey;
        const config = props.integration._bindToRoute({
            route: this,
            scope: this,
        });
        const authorizer = (_b = props.authorizer) !== null && _b !== void 0 ? _b : new authorizer_1.WebSocketNoneAuthorizer(); // must be explicitly NONE (not undefined) for stack updates to work correctly
        const authBindResult = authorizer.bind({
            route: this,
            scope: this.webSocketApi instanceof constructs_1.Construct ? this.webSocketApi : this,
        });
        const route = new aws_apigatewayv2_1.CfnRoute(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            apiKeyRequired: props.apiKeyRequired,
            routeKey: props.routeKey,
            target: `integrations/${config.integrationId}`,
            authorizerId: authBindResult.authorizerId,
            authorizationType: authBindResult.authorizationType,
        });
        this.routeId = route.ref;
    }
}
exports.WebSocketRoute = WebSocketRoute;
_a = JSII_RTTI_SYMBOL_1;
WebSocketRoute[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketRoute", version: "2.23.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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