"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Host = exports.HostProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const bastionhost_generated_1 = require("./bastionhost.generated");
Object.defineProperty(exports, "HostProperty", { enumerable: true, get: function () { return bastionhost_generated_1.RosHost; } });
/**
 * A ROS resource type:  `ALIYUN::BastionHost::Host`
 */
class Host extends ros.Resource {
    /**
     * Create a new `ALIYUN::BastionHost::Host`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosHost = new bastionhost_generated_1.RosHost(this, id, {
            comment: props.comment,
            activeAddressType: props.activeAddressType,
            hostPrivateAddress: props.hostPrivateAddress,
            instanceRegionId: props.instanceRegionId,
            hostPublicAddress: props.hostPublicAddress,
            instanceId: props.instanceId,
            osType: props.osType,
            sourceInstanceId: props.sourceInstanceId,
            hostName: props.hostName,
            source: props.source,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosHost;
        this.attrHostId = rosHost.attrHostId;
    }
}
exports.Host = Host;
//# sourceMappingURL=data:application/json;base64,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