# todo-manager

MCP server for: I want an MCP that manages todo lists. It should allow creating, reading, updating, and deleting tod...

## TODO: Implementation Required

This is a boilerplate MCP server generated by KEN-MCP. Claude needs to customize it based on these requirements:

**Original Requirements:**
> I want an MCP that manages todo lists. It should allow creating, reading, updating, and deleting todo items. Each todo should have a title, description, priority level, and completion status. The MCP should store todos in a JSON file and provide tools to list all todos, add new todos, mark todos as complete, and delete todos.

### Implementation Checklist

- [ ] Update tool names and implementations in `server.py`
- [ ] Implement resource handlers if needed
- [ ] Customize prompt templates
- [ ] Update dependencies in `pyproject.toml`
- [ ] Update this README with actual functionality
- [ ] Test all tools with MCP Inspector

## Prerequisites

Before you begin, ensure you have the following installed:

1. **Python 3.10 or higher**
   ```bash
   python --version  # Should show Python 3.10+
   ```

2. **pip (Python package installer)**
   ```bash
   pip --version
   ```

3. **Node.js** (required for npx commands)
   ```bash
   node --version  # Should show v16 or higher
   npm --version
   ```

If any of these are missing:
- Python: Download from [python.org](https://python.org)
- Node.js: Download from [nodejs.org](https://nodejs.org)

## Installation

1. **Clone or download this MCP server folder**

2. **Set up environment variables (if needed)**
   ```bash
   cd todo-manager
   cp .env.example .env
   # Edit .env and add your API keys and configuration
   ```

3. **Install Python dependencies**
   ```bash
   pip install -e .
   ```

   Or using a virtual environment (recommended):
   ```bash
   python -m venv venv
   source venv/bin/activate  # On Windows: venv\Scripts\activate
   pip install -e .
   ```

## Configuration

### Option 1: Claude Code

Add this server to Claude Code using the CLI:

```bash
# Add as a local project server (recommended for development)
claude mcp add todo-manager "python /Users/kenkai/ClaudeCode/MCP/test_servers/todo-manager/server.py"

# Or add as a user server (available across all projects)
claude mcp add todo-manager "python /Users/kenkai/ClaudeCode/MCP/test_servers/todo-manager/server.py" --user

# List configured servers to verify
claude mcp list
```

**Important**: Restart Claude Code after adding the server for changes to take effect.

### Option 2: Claude Desktop

1. **Find your configuration file**:
   - macOS: `~/Library/Application Support/Claude/claude_desktop_config.json`
   - Windows: `%APPDATA%\Claude\claude_desktop_config.json`

2. **Edit the configuration file** and add your server:
   ```json
   {
     "mcpServers": {
       "todo-manager": {
         "command": "python",
         "args": ["/Users/kenkai/ClaudeCode/MCP/test_servers/todo-manager/server.py"]
       }
     }
   }
   ```

   If you already have other servers, add this one to the existing `mcpServers` object:
   ```json
   {
     "mcpServers": {
       "existing-server": { ... },
       "todo-manager": {
         "command": "python",
         "args": ["/Users/kenkai/ClaudeCode/MCP/test_servers/todo-manager/server.py"]
       }
     }
   }
   ```

3. **Restart Claude Desktop completely** (quit and reopen)

4. **Verify the server is loaded**: Look for the 🔌 icon in the bottom of your chat interface

## Testing Your Server

### 1. Test with the included harness
```bash
python test_server.py
```

### 2. Test with MCP Inspector
```bash
npx @modelcontextprotocol/inspector python server.py
```
This opens an interactive testing interface in your browser.

## Usage

Once configured, you can use your MCP server in Claude:
- Tools will appear in the available tools list
- Resources can be accessed using their URIs
- Prompts will be available as slash commands

## Troubleshooting

### Server not appearing in Claude
1. **Verify the server runs without errors**:
   ```bash
   python server.py
   ```
   It should output: "Server running on stdio"

2. **Check configuration**:
   - Claude Code: Run `claude mcp list` to see configured servers
   - Claude Desktop: Verify the JSON configuration is valid

3. **Restart Claude completely**:
   - Claude Code: Close and reopen the application
   - Claude Desktop: Quit (not just close) and restart

4. **Check logs**:
   - Claude Code: Check terminal output for errors
   - Claude Desktop: Check the logs in the app's developer console

### Common Issues
- **"ModuleNotFoundError: No module named 'fastmcp'"**: Run `pip install -e .` in the project directory
- **"No such file or directory"**: Use absolute paths in configuration
- **Server not updating**: Always restart Claude after configuration changes

## Features (TO BE IMPLEMENTED)

### Tools

#### `tool_one`
Primary tool - TODO: Implement based on requirements: I want an MCP that manages todo lists. It should allow creating, reading, updating, and deleting todo items. Each todo should have a title, description, priority level, and completion status. The MCP should store todos in a JSON file and provide tools to list all todos, add new todos, mark todos as complete, and delete todos.

Parameters:
- `input_data` (str): Main input parameter
- `options` (Optional[Dict[str, Any]]): Additional options

#### `tool_two`
Secondary tool - TODO: Implement based on requirements: I want an MCP that manages todo lists. It should allow creating, reading, updating, and deleting todo items. Each todo should have a title, description, priority level, and completion status. The MCP should store todos in a JSON file and provide tools to list all todos, add new todos, mark todos as complete, and delete todos.

Parameters:
- `param1` (str): First parameter
- `param2` (Optional[int]): Optional second parameter

#### `tool_three`
Additional tool - TODO: Implement or remove based on requirements: I want an MCP that manages todo lists. It should allow creating, reading, updating, and deleting todo items. Each todo should have a title, description, priority level, and completion status. The MCP should store todos in a JSON file and provide tools to list all todos, add new todos, mark todos as complete, and delete todos.

Parameters:
- `data` (Any): Input data

### Resources

- `data://items`: TODO: List of items - implement based on requirements

- `resource://config`: TODO: Configuration data - implement based on requirements

- `data://status`: TODO: Status information - implement or remove based on requirements

### Prompts

- `help`: TODO: Generate contextual help based on requirements

- `assistant`: TODO: Assistant prompt - customize based on requirements


## License

MIT

---
Generated by KEN-MCP on 2025-06-25
