# Docker networks

Don't use the constructor directly. Instead use 
```python
from dockertown import docker

my_network = docker.network.create("some-network")

my_network = docker.container.inspect("some-network")
```
For type hints, use this

```python
from dockertown import Network, docker

def ping_hostname_in_network(my_network: Network):
    docker.run("busybox", ["ping", "-c", "10", "my_hostname"], networks=[my_network])
```

## Attributes

It attributes are the same that you get with the command line:
`docker network inspect ...`

If you want to know the exact structure, you can go to the 
[`docker network inspect` reference page](https://docs.docker.com/engine/api/v1.40/#operation/NetworkInspect)
and click on "200 no error".
An example is worth many lines of descriptions.


```
In [1]: from dockertown import docker

In [2]: network = docker.network.create("my-network")

In [3]: container = docker.run(
            "ubuntu", ["sleep", "infinity"], name="my_ubuntu", detach=True, networks=[network]
        )

In [4]: def super_print(obj):
   ...:     print(f"type={type(obj)}, value={obj}")
   ...:

@INSERT_GENERATED_CODE@
```

## Methods

{{autogenerated}}
