"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommonCheckWidget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const uuid_1 = require("uuid");
const commonCheckService_1 = require("./commonCheckService");
exports.commonCheckVerify = require("./commonCheckService");
class CommonCheckWidget {
    constructor(requestID) {
        let requestIDValue = uuid_1.v4();
        if (requestID != null) {
            requestIDValue = requestID;
        }
        this.commonCheckVerify = new commonCheckService_1.CommonCheckVerify(requestIDValue);
    }
    verifyWithCallback(encryptionFile, callback) {
        (async () => {
            this.commonCheckVerify.fillEncryptionFile(encryptionFile);
            const result = await this.commonCheckVerify.generateResponse();
            callback(result);
        })();
    }
    async verifyAsync(encryptionFile) {
        this.commonCheckVerify.fillEncryptionFile(encryptionFile);
        const result = await this.commonCheckVerify.generateResponse();
        return result;
    }
    verifyByPathWithCallback(encryptionFilePath, callback) {
        (async () => {
            let encryptionFileReadStream = fs.createReadStream(encryptionFilePath);
            this.commonCheckVerify.fillEncryptionFile(encryptionFileReadStream);
            const result = await this.commonCheckVerify.generateResponse();
            callback(result);
        })();
    }
    async verifyByPathAsync(encryptionFilePath) {
        let encryptionFileReadStream = fs.createReadStream(encryptionFilePath);
        this.commonCheckVerify.fillEncryptionFile(encryptionFileReadStream);
        const result = await this.commonCheckVerify.generateResponse();
        return result;
    }
    getErrorMessage(errorObj) {
        return this.commonCheckVerify.getErrorMessage(errorObj);
    }
    async generateHashFromData(data) {
        return await this.commonCheckVerify.generateHashFromData(data);
    }
    async generateTokenFromData(data) {
        return await this.commonCheckVerify.generateTokenFromData(data);
    }
    async generateJWTFromData(data) {
        return await this.commonCheckVerify.generateJWTFromData(data);
    }
    compareToken(tokenExpected, tokenCompared) {
        return this.commonCheckVerify.compareToken(tokenExpected, tokenCompared);
    }
    generatePayloadJsonStr(flightNumber, flightDate, firstName, lastName, dateOfBirth, passport, nationality) {
        return this.commonCheckVerify.generatePayloadJsonStr(flightNumber, flightDate, firstName, lastName, dateOfBirth, passport, nationality);
    }
}
exports.CommonCheckWidget = CommonCheckWidget;
_a = JSII_RTTI_SYMBOL_1;
CommonCheckWidget[_a] = { fqn: "@affinidi/common-check-widget-backend-lib.CommonCheckWidget", version: "1.5.3" };
//# sourceMappingURL=data:application/json;base64,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