"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommonCheckVerify = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const dotenv_1 = require("dotenv");
const FormData = require("form-data");
const base_1 = require("./base");
exports.endpointServiceBase = require("./base");
dotenv_1.config();
class CommonCheckVerify extends base_1.EndpointServiceBase {
    constructor(requestID) {
        const { COMMON_CHECK_ENDPOINT = require('COMMON_CHECK_ENDPOINT'), COMMON_CHECK_API = require('COMMON_CHECK_API'), API_KEY = require('API_KEY'), ERROR_CODE = require('ERROR_CODE'), SECRET_PASSPHRASE = require('SECRET_PASSPHRASE'), PRIVATE_KEY_FILE_NAME = require('PRIVATE_KEY_FILE_NAME') } = process.env;
        super(COMMON_CHECK_ENDPOINT + COMMON_CHECK_API, API_KEY, ERROR_CODE, PRIVATE_KEY_FILE_NAME, SECRET_PASSPHRASE, requestID);
        this.requestID = requestID;
        console.log("Requst ID", { requestID });
    }
    async generateToken() {
        const data = await fs.promises.readFile(this.encryptionFile.path, "binary");
        return await this.generateTokenFromData(data);
    }
    async generateOptions() {
        let formData = new FormData();
        formData.append('file', this.encryptionFile);
        this.options = {
            method: 'POST',
            body: formData,
            headers: {
                'Api-Key': this.retrieveApiKey(),
                'Authorization': await this.generateToken(),
                'Request-ID': this.requestID
            },
            timeout: 30000,
        };
        return this.options;
    }
    fillEncryptionFile(encryptionFile) {
        this.encryptionFile = encryptionFile;
    }
    async generateResponse() {
        if (this.encryptionFile === undefined || this.encryptionFile === null) {
            return this.getErrorMessage({
                type: 'Invalid File',
                value: 'Undefined',
                description: 'File is required'
            });
        }
        try {
            this.fillOptions(await this.generateOptions());
            return this.callAPIEndpoint();
        }
        catch (error) {
            return this.getErrorMessage({
                type: 'Generate Response',
                value: 'Trying to Get Response',
                description: error
            });
        }
    }
}
exports.CommonCheckVerify = CommonCheckVerify;
_a = JSII_RTTI_SYMBOL_1;
CommonCheckVerify[_a] = { fqn: "@affinidi/common-check-widget-backend-lib.commonCheckVerify.CommonCheckVerify", version: "1.5.3" };
//# sourceMappingURL=data:application/json;base64,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