"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointServiceBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const node_fetch_1 = require("node-fetch");
const crypto = require("crypto");
const jwt = require("jsonwebtoken");
class EndpointServiceBase {
    constructor(apiEndpoint, apiKey, errorCode, privateKeyFile, secretPassphrase, requestID) {
        this.apiEndpoint = apiEndpoint;
        this.apiKey = apiKey;
        this.errorCode = errorCode;
        this.privateKeyFile = privateKeyFile;
        this.secretPassphrase = secretPassphrase;
        this.requestID = requestID;
    }
    retrieveApiKey() {
        return this.apiKey;
    }
    fillOptions(options) {
        this.options = options;
    }
    async callAPIEndpoint() {
        console.log(new Date(), "Calling Endpoint", this.apiEndpoint);
        let response;
        try {
            response = await node_fetch_1.default(this.apiEndpoint, this.options);
            console.log(new Date(), "Completed Endpoint");
            if (response === null || response === void 0 ? void 0 : response.code) {
                return this.getErrorMessage({
                    type: 'Error Code',
                    value: response.code,
                    description: 'Error From Endpoint'
                });
            }
            return response.json();
        }
        catch (error) {
            console.log(new Date(), "Fail Endpoint with error", { error });
            throw new Error(response.status);
        }
    }
    getErrorMessage(errorObj) {
        let error = [];
        if (errorObj) {
            error.push(errorObj);
        }
        this.errors = ({
            validToEnter: false,
            code: this.errorCode,
            errors: error,
            entryWindow: {},
            metadata: {
                requestID: this.requestID,
                service: 'EndpointService'
            }
        });
        return this.errors;
    }
    async generateHashFromData(dataToSign) {
        const binary = Buffer.from(dataToSign, 'binary');
        const hashSum = crypto.createHash('sha256');
        hashSum.update(binary);
        const hash = hashSum.digest('hex');
        return hash;
    }
    async generateTokenFromData(dataToSign) {
        const binary = Buffer.from(dataToSign, 'binary');
        const hashSum = crypto.createHash('sha256');
        hashSum.update(binary);
        const privateKey = fs.readFileSync(this.privateKeyFile);
        const objectToSign = hashSum.digest('hex');
        const token = jwt.sign(objectToSign, { key: privateKey, passphrase: this.secretPassphrase }, { algorithm: 'RS512' });
        return token;
    }
    async generateJWTFromData(dataToSign) {
        const privateKey = fs.readFileSync(this.privateKeyFile);
        const token = jwt.sign(dataToSign, { key: privateKey, passphrase: this.secretPassphrase }, { algorithm: 'RS512' });
        return token;
    }
    compareToken(tokenExpected, tokenCompared) {
        let isVaildToken = false;
        if (tokenCompared && tokenCompared) {
            if (tokenExpected === tokenCompared) {
                isVaildToken = true;
            }
            else {
                isVaildToken = false;
            }
        }
        return isVaildToken;
    }
    generatePayloadJsonStr(flightNumber, flightDate, firstName, lastName, dateOfBirth, passport, nationality) {
        const json = {
            intent: {
                flight_number: flightNumber,
                scheduled_departure_time: flightDate
            },
            user_identity: {
                first_name: firstName,
                last_name: lastName,
                dob: dateOfBirth,
                passport: passport,
                nationality: nationality
            }
        };
        return JSON.stringify(json);
    }
}
exports.EndpointServiceBase = EndpointServiceBase;
_a = JSII_RTTI_SYMBOL_1;
EndpointServiceBase[_a] = { fqn: "@affinidi/common-check-widget-backend-lib.commonCheckVerify.endpointServiceBase.EndpointServiceBase", version: "1.5.3" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFzZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImJhc2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSx5QkFBd0I7QUFDeEIsMkNBQThCO0FBQzlCLGlDQUFnQztBQUNoQyxvQ0FBbUM7QUFFbkMsTUFBc0IsbUJBQW1CO0lBVXJDLFlBQWEsV0FBbUIsRUFBRSxNQUFjLEVBQUUsU0FBZ0IsRUFBRSxjQUFzQixFQUFFLGdCQUF3QixFQUFFLFNBQWlCO1FBQ25JLElBQUksQ0FBQyxXQUFXLEdBQUcsV0FBVyxDQUFBO1FBQzlCLElBQUksQ0FBQyxNQUFNLEdBQUcsTUFBTSxDQUFBO1FBQ3BCLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFBO1FBQzFCLElBQUksQ0FBQyxjQUFjLEdBQUcsY0FBYyxDQUFBO1FBQ3BDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxnQkFBZ0IsQ0FBQTtRQUN4QyxJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQTtJQUM5QixDQUFDO0lBRU0sY0FBYztRQUVqQixPQUFPLElBQUksQ0FBQyxNQUFNLENBQUE7SUFDdEIsQ0FBQztJQUVNLFdBQVcsQ0FBQyxPQUFZO1FBRTNCLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFBO0lBQzFCLENBQUM7SUFFTSxLQUFLLENBQUMsZUFBZTtRQUV4QixPQUFPLENBQUMsR0FBRyxDQUFDLElBQUksSUFBSSxFQUFFLEVBQUUsa0JBQWtCLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFBO1FBQzdELElBQUksUUFBWSxDQUFBO1FBQ2hCLElBQUc7WUFDQyxRQUFRLEdBQUcsTUFBTSxvQkFBSyxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFBO1lBQ3RELE9BQU8sQ0FBQyxHQUFHLENBQUMsSUFBSSxJQUFJLEVBQUUsRUFBRSxvQkFBb0IsQ0FBQyxDQUFBO1lBQzdDLElBQUksUUFBUSxhQUFSLFFBQVEsdUJBQVIsUUFBUSxDQUFFLElBQUksRUFDbEI7Z0JBQ0ksT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO29CQUN4QixJQUFJLEVBQUUsWUFBWTtvQkFDbEIsS0FBSyxFQUFHLFFBQVEsQ0FBQyxJQUFJO29CQUNyQixXQUFXLEVBQUcscUJBQXFCO2lCQUN0QyxDQUFDLENBQUE7YUFDTDtZQUNELE9BQU8sUUFBUSxDQUFDLElBQUksRUFBRSxDQUFBO1NBQ3pCO1FBQUMsT0FBTyxLQUFLLEVBQUU7WUFDWixPQUFPLENBQUMsR0FBRyxDQUFDLElBQUksSUFBSSxFQUFFLEVBQUUsMEJBQTBCLEVBQUUsRUFBQyxLQUFLLEVBQUMsQ0FBQyxDQUFBO1lBQzVELE1BQU0sSUFBSSxLQUFLLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQyxDQUFBO1NBQ25DO0lBQ0wsQ0FBQztJQUVNLGVBQWUsQ0FBQyxRQUFjO1FBRWpDLElBQUksS0FBSyxHQUFHLEVBQUUsQ0FBQTtRQUNkLElBQUksUUFBUSxFQUNaO1lBQ0ksS0FBSyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQTtTQUN2QjtRQUNELElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FDVjtZQUNFLFlBQVksRUFBRSxLQUFLO1lBQ25CLElBQUksRUFBRSxJQUFJLENBQUMsU0FBUztZQUNwQixNQUFNLEVBQUUsS0FBSztZQUNiLFdBQVcsRUFBRSxFQUFFO1lBQ2YsUUFBUSxFQUFFO2dCQUNOLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztnQkFDekIsT0FBTyxFQUFFLGlCQUFpQjthQUU3QjtTQUNGLENBQ0YsQ0FBQTtRQUNILE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQTtJQUN0QixDQUFDO0lBRU0sS0FBSyxDQUFDLG9CQUFvQixDQUFDLFVBQWU7UUFFN0MsTUFBTSxNQUFNLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUUsUUFBUSxDQUFDLENBQUE7UUFDaEQsTUFBTSxPQUFPLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQTtRQUMzQyxPQUFPLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFBO1FBQ3RCLE1BQU0sSUFBSSxHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUE7UUFDbEMsT0FBTyxJQUFJLENBQUE7SUFDZixDQUFDO0lBRU0sS0FBSyxDQUFDLHFCQUFxQixDQUFDLFVBQWU7UUFFOUMsTUFBTSxNQUFNLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUUsUUFBUSxDQUFDLENBQUE7UUFDaEQsTUFBTSxPQUFPLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQTtRQUMzQyxPQUFPLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFBO1FBQ3RCLE1BQU0sVUFBVSxHQUFHLEVBQUUsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFBO1FBQ3ZELE1BQU0sWUFBWSxHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUE7UUFDMUMsTUFBTSxLQUFLLEdBQUcsR0FBRyxDQUFDLElBQUksQ0FBQyxZQUFZLEVBQUUsRUFBRSxHQUFHLEVBQUUsVUFBVSxFQUFFLFVBQVUsRUFBRSxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsRUFBRSxFQUFFLFNBQVMsRUFBRSxPQUFPLEVBQUUsQ0FBQyxDQUFBO1FBQ3BILE9BQU8sS0FBSyxDQUFBO0lBQ2hCLENBQUM7SUFFTSxLQUFLLENBQUMsbUJBQW1CLENBQUMsVUFBZTtRQUU1QyxNQUFNLFVBQVUsR0FBRyxFQUFFLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQTtRQUN2RCxNQUFNLEtBQUssR0FBRyxHQUFHLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxFQUFFLEdBQUcsRUFBRSxVQUFVLEVBQUUsVUFBVSxFQUFFLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxFQUFFLEVBQUUsU0FBUyxFQUFFLE9BQU8sRUFBRSxDQUFDLENBQUE7UUFDbEgsT0FBTyxLQUFLLENBQUE7SUFDaEIsQ0FBQztJQUVNLFlBQVksQ0FBQyxhQUFrQixFQUFFLGFBQWlCO1FBRXZELElBQUksWUFBWSxHQUFHLEtBQUssQ0FBQTtRQUN4QixJQUFJLGFBQWEsSUFBSSxhQUFhLEVBQ2xDO1lBRUUsSUFBSSxhQUFhLEtBQUssYUFBYSxFQUNuQztnQkFDRSxZQUFZLEdBQUcsSUFBSSxDQUFBO2FBQ3BCO2lCQUVEO2dCQUNFLFlBQVksR0FBRyxLQUFLLENBQUE7YUFDckI7U0FDRjtRQUNELE9BQU8sWUFBWSxDQUFBO0lBQ3JCLENBQUM7SUFFTSxzQkFBc0IsQ0FBQyxZQUFvQixFQUFFLFVBQWtCLEVBQUUsU0FBaUIsRUFBRSxRQUFnQixFQUFFLFdBQW1CLEVBQUUsUUFBZ0IsRUFBRSxXQUFtQjtRQUNuSyxNQUFNLElBQUksR0FBSTtZQUNWLE1BQU0sRUFBRTtnQkFDTixhQUFhLEVBQUUsWUFBWTtnQkFDM0Isd0JBQXdCLEVBQUUsVUFBVTthQUNyQztZQUNELGFBQWEsRUFBQztnQkFDWixVQUFVLEVBQUUsU0FBUztnQkFDckIsU0FBUyxFQUFFLFFBQVE7Z0JBQ25CLEdBQUcsRUFBRSxXQUFXO2dCQUNoQixRQUFRLEVBQUUsUUFBUTtnQkFDbEIsV0FBVyxFQUFFLFdBQVc7YUFDekI7U0FDRixDQUFBO1FBQ0QsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxDQUFBO0lBQ2pDLENBQUM7O0FBdElMLGtEQXVJQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGZzIGZyb20gJ2ZzJ1xuaW1wb3J0IGZldGNoIGZyb20gJ25vZGUtZmV0Y2gnXG5pbXBvcnQgKiBhcyBjcnlwdG8gZnJvbSAnY3J5cHRvJ1xuaW1wb3J0ICogYXMgand0IGZyb20gJ2pzb253ZWJ0b2tlbidcblxuZXhwb3J0IGFic3RyYWN0IGNsYXNzIEVuZHBvaW50U2VydmljZUJhc2Uge1xuICAgIGFwaUVuZHBvaW50OiBzdHJpbmdcbiAgICBhcGlLZXk6IHN0cmluZ1xuICAgIGVycm9yQ29kZTogc3RyaW5nXG4gICAgcHJpdmF0ZUtleUZpbGU6IHN0cmluZ1xuICAgIHNlY3JldFBhc3NwaHJhc2U6IHN0cmluZ1xuICAgIHJlcXVlc3RJRDogc3RyaW5nXG4gICAgb3B0aW9uczogYW55XG4gICAgZXJyb3JzOiBhbnlcblxuICAgIGNvbnN0cnVjdG9yIChhcGlFbmRwb2ludDogc3RyaW5nLCBhcGlLZXk6IHN0cmluZywgZXJyb3JDb2RlOnN0cmluZywgcHJpdmF0ZUtleUZpbGU6IHN0cmluZywgc2VjcmV0UGFzc3BocmFzZTogc3RyaW5nLCByZXF1ZXN0SUQ6IHN0cmluZykge1xuICAgICAgICB0aGlzLmFwaUVuZHBvaW50ID0gYXBpRW5kcG9pbnRcbiAgICAgICAgdGhpcy5hcGlLZXkgPSBhcGlLZXlcbiAgICAgICAgdGhpcy5lcnJvckNvZGUgPSBlcnJvckNvZGVcbiAgICAgICAgdGhpcy5wcml2YXRlS2V5RmlsZSA9IHByaXZhdGVLZXlGaWxlXG4gICAgICAgIHRoaXMuc2VjcmV0UGFzc3BocmFzZSA9IHNlY3JldFBhc3NwaHJhc2VcbiAgICAgICAgdGhpcy5yZXF1ZXN0SUQgPSByZXF1ZXN0SURcbiAgICB9XG5cbiAgICBwdWJsaWMgcmV0cmlldmVBcGlLZXkoKVxuICAgIHtcbiAgICAgICAgcmV0dXJuIHRoaXMuYXBpS2V5XG4gICAgfVxuXG4gICAgcHVibGljIGZpbGxPcHRpb25zKG9wdGlvbnM6IGFueSlcbiAgICB7XG4gICAgICAgIHRoaXMub3B0aW9ucyA9IG9wdGlvbnNcbiAgICB9XG5cbiAgICBwdWJsaWMgYXN5bmMgY2FsbEFQSUVuZHBvaW50ICgpIHtcblxuICAgICAgICBjb25zb2xlLmxvZyhuZXcgRGF0ZSgpLCBcIkNhbGxpbmcgRW5kcG9pbnRcIiwgdGhpcy5hcGlFbmRwb2ludClcbiAgICAgICAgbGV0IHJlc3BvbnNlOmFueVxuICAgICAgICB0cnl7XG4gICAgICAgICAgICByZXNwb25zZSA9IGF3YWl0IGZldGNoKHRoaXMuYXBpRW5kcG9pbnQsIHRoaXMub3B0aW9ucylcbiAgICAgICAgICAgIGNvbnNvbGUubG9nKG5ldyBEYXRlKCksIFwiQ29tcGxldGVkIEVuZHBvaW50XCIpXG4gICAgICAgICAgICBpZiAocmVzcG9uc2U/LmNvZGUpXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHRoaXMuZ2V0RXJyb3JNZXNzYWdlKHtcbiAgICAgICAgICAgICAgICAgICAgdHlwZTogJ0Vycm9yIENvZGUnLCBcbiAgICAgICAgICAgICAgICAgICAgdmFsdWUgOiByZXNwb25zZS5jb2RlLCBcbiAgICAgICAgICAgICAgICAgICAgZGVzY3JpcHRpb24gOiAnRXJyb3IgRnJvbSBFbmRwb2ludCdcbiAgICAgICAgICAgICAgICB9KVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIHJlc3BvbnNlLmpzb24oKVxuICAgICAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICAgICAgY29uc29sZS5sb2cobmV3IERhdGUoKSwgXCJGYWlsIEVuZHBvaW50IHdpdGggZXJyb3JcIiwge2Vycm9yfSlcbiAgICAgICAgICAgIHRocm93IG5ldyBFcnJvcihyZXNwb25zZS5zdGF0dXMpXG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBwdWJsaWMgZ2V0RXJyb3JNZXNzYWdlKGVycm9yT2JqPzogYW55KVxuICAgIHtcbiAgICAgICAgbGV0IGVycm9yID0gW11cbiAgICAgICAgaWYgKGVycm9yT2JqKVxuICAgICAgICB7XG4gICAgICAgICAgICBlcnJvci5wdXNoKGVycm9yT2JqKVxuICAgICAgICB9XG4gICAgICAgIHRoaXMuZXJyb3JzID0gKFxuICAgICAgICAgICAge1xuICAgICAgICAgICAgICB2YWxpZFRvRW50ZXI6IGZhbHNlLFxuICAgICAgICAgICAgICBjb2RlOiB0aGlzLmVycm9yQ29kZSxcbiAgICAgICAgICAgICAgZXJyb3JzOiBlcnJvcixcbiAgICAgICAgICAgICAgZW50cnlXaW5kb3c6IHt9LFxuICAgICAgICAgICAgICBtZXRhZGF0YToge1xuICAgICAgICAgICAgICAgICAgcmVxdWVzdElEOiB0aGlzLnJlcXVlc3RJRCxcbiAgICAgICAgICAgICAgICAgIHNlcnZpY2U6ICdFbmRwb2ludFNlcnZpY2UnXG5cbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgIClcbiAgICAgICAgcmV0dXJuIHRoaXMuZXJyb3JzXG4gICAgfVxuXG4gICAgcHVibGljIGFzeW5jIGdlbmVyYXRlSGFzaEZyb21EYXRhKGRhdGFUb1NpZ246IGFueSlcbiAgICB7XG4gICAgICAgIGNvbnN0IGJpbmFyeSA9IEJ1ZmZlci5mcm9tKGRhdGFUb1NpZ24sICdiaW5hcnknKVxuICAgICAgICBjb25zdCBoYXNoU3VtID0gY3J5cHRvLmNyZWF0ZUhhc2goJ3NoYTI1NicpXG4gICAgICAgIGhhc2hTdW0udXBkYXRlKGJpbmFyeSlcbiAgICAgICAgY29uc3QgaGFzaCA9IGhhc2hTdW0uZGlnZXN0KCdoZXgnKVxuICAgICAgICByZXR1cm4gaGFzaFxuICAgIH1cblxuICAgIHB1YmxpYyBhc3luYyBnZW5lcmF0ZVRva2VuRnJvbURhdGEoZGF0YVRvU2lnbjogYW55KVxuICAgIHtcbiAgICAgICAgY29uc3QgYmluYXJ5ID0gQnVmZmVyLmZyb20oZGF0YVRvU2lnbiwgJ2JpbmFyeScpXG4gICAgICAgIGNvbnN0IGhhc2hTdW0gPSBjcnlwdG8uY3JlYXRlSGFzaCgnc2hhMjU2JylcbiAgICAgICAgaGFzaFN1bS51cGRhdGUoYmluYXJ5KVxuICAgICAgICBjb25zdCBwcml2YXRlS2V5ID0gZnMucmVhZEZpbGVTeW5jKHRoaXMucHJpdmF0ZUtleUZpbGUpXG4gICAgICAgIGNvbnN0IG9iamVjdFRvU2lnbiA9IGhhc2hTdW0uZGlnZXN0KCdoZXgnKVxuICAgICAgICBjb25zdCB0b2tlbiA9IGp3dC5zaWduKG9iamVjdFRvU2lnbiwgeyBrZXk6IHByaXZhdGVLZXksIHBhc3NwaHJhc2U6IHRoaXMuc2VjcmV0UGFzc3BocmFzZSB9LCB7IGFsZ29yaXRobTogJ1JTNTEyJyB9KVxuICAgICAgICByZXR1cm4gdG9rZW5cbiAgICB9XG5cbiAgICBwdWJsaWMgYXN5bmMgZ2VuZXJhdGVKV1RGcm9tRGF0YShkYXRhVG9TaWduOiBhbnkpXG4gICAge1xuICAgICAgICBjb25zdCBwcml2YXRlS2V5ID0gZnMucmVhZEZpbGVTeW5jKHRoaXMucHJpdmF0ZUtleUZpbGUpXG4gICAgICAgIGNvbnN0IHRva2VuID0gand0LnNpZ24oZGF0YVRvU2lnbiwgeyBrZXk6IHByaXZhdGVLZXksIHBhc3NwaHJhc2U6IHRoaXMuc2VjcmV0UGFzc3BocmFzZSB9LCB7IGFsZ29yaXRobTogJ1JTNTEyJyB9KVxuICAgICAgICByZXR1cm4gdG9rZW5cbiAgICB9XG5cbiAgICBwdWJsaWMgY29tcGFyZVRva2VuKHRva2VuRXhwZWN0ZWQ6IGFueSwgdG9rZW5Db21wYXJlZDphbnkpIFxuICAgIHtcbiAgICAgIGxldCBpc1ZhaWxkVG9rZW4gPSBmYWxzZVxuICAgICAgaWYgKHRva2VuQ29tcGFyZWQgJiYgdG9rZW5Db21wYXJlZClcbiAgICAgIHtcblxuICAgICAgICBpZiAodG9rZW5FeHBlY3RlZCA9PT0gdG9rZW5Db21wYXJlZClcbiAgICAgICAge1xuICAgICAgICAgIGlzVmFpbGRUb2tlbiA9IHRydWVcbiAgICAgICAgfVxuICAgICAgICBlbHNlXG4gICAgICAgIHtcbiAgICAgICAgICBpc1ZhaWxkVG9rZW4gPSBmYWxzZVxuICAgICAgICB9XG4gICAgICB9XG4gICAgICByZXR1cm4gaXNWYWlsZFRva2VuXG4gICAgfVxuXG4gICAgcHVibGljIGdlbmVyYXRlUGF5bG9hZEpzb25TdHIoZmxpZ2h0TnVtYmVyOiBzdHJpbmcsIGZsaWdodERhdGU6IHN0cmluZywgZmlyc3ROYW1lOiBzdHJpbmcsIGxhc3ROYW1lOiBzdHJpbmcsIGRhdGVPZkJpcnRoOiBzdHJpbmcsIHBhc3Nwb3J0OiBzdHJpbmcsIG5hdGlvbmFsaXR5OiBzdHJpbmcpIHtcbiAgICAgICAgY29uc3QganNvbiA9ICB7XG4gICAgICAgICAgICBpbnRlbnQ6IHtcbiAgICAgICAgICAgICAgZmxpZ2h0X251bWJlcjogZmxpZ2h0TnVtYmVyLFxuICAgICAgICAgICAgICBzY2hlZHVsZWRfZGVwYXJ0dXJlX3RpbWU6IGZsaWdodERhdGVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICB1c2VyX2lkZW50aXR5OntcbiAgICAgICAgICAgICAgZmlyc3RfbmFtZTogZmlyc3ROYW1lLFxuICAgICAgICAgICAgICBsYXN0X25hbWU6IGxhc3ROYW1lLFxuICAgICAgICAgICAgICBkb2I6IGRhdGVPZkJpcnRoLFxuICAgICAgICAgICAgICBwYXNzcG9ydDogcGFzc3BvcnQsXG4gICAgICAgICAgICAgIG5hdGlvbmFsaXR5OiBuYXRpb25hbGl0eVxuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgICByZXR1cm4gSlNPTi5zdHJpbmdpZnkoanNvbilcbiAgICB9XG59Il19