export declare abstract class EndpointServiceBase {
    apiEndpoint: string;
    apiKey: string;
    errorCode: string;
    privateKeyFile: string;
    secretPassphrase: string;
    requestID: string;
    options: any;
    errors: any;
    constructor(apiEndpoint: string, apiKey: string, errorCode: string, privateKeyFile: string, secretPassphrase: string, requestID: string);
    retrieveApiKey(): string;
    fillOptions(options: any): void;
    callAPIEndpoint(): Promise<any>;
    getErrorMessage(errorObj?: any): any;
    generateHashFromData(dataToSign: any): Promise<string>;
    generateTokenFromData(dataToSign: any): Promise<string>;
    generateJWTFromData(dataToSign: any): Promise<string>;
    compareToken(tokenExpected: any, tokenCompared: any): boolean;
    generatePayloadJsonStr(flightNumber: string, flightDate: string, firstName: string, lastName: string, dateOfBirth: string, passport: string, nationality: string): string;
}
