### Dev

Install npm packages
```sh
npm i
```

In order to compile, do use docker or setup jsii environment in your machine
```sh
docker run -it --rm -v `pwd`:/source  jsii/superchain bash
```

Compile steps in docker
```sh
cd source
npm run build && npm run package
```

### Publish

```sh
npm version <major | minor | patch>
git push --follow-tags origin feature
``````

- In order to publish as any version, please triger the action manually at CI
- For maven need to close and release at https://s01.oss.sonatype.org/index.html#stagingRepositories


### Development

The development version is not deployed on CDN, we simply use the bundled local version so just push your code normally.

**Production can only published from the staging release

1. NPM
    - All npm package will be reflected under https://www.npmjs.com/package/@affinidi/common-check-widget-backend-lib/
2. PIPY
    - Staging py TEST package will be reflected under https://test.pypi.org/project/affinidi.common-check-widget-backend-lib/
    - Production py package will be reflected under https://pypi.org/project/affinidi.common-check-widget-backend-lib/
4. .net
    - All .net package will be reflected under https://www.nuget.org/packages/Affinidi.Common.Check.Widget.Backend.Lib/
5. Maven
    - Staging maven package will be reflected under https://github.com/affinityproject/common-check-widget-backend-lib/packages/953025
    - Production maven package will be reflected under https://search.maven.org/artifact/com.affinidi.stg/common-check-widget-backend-lib


