#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("source-map-support/register");
const cdk = require("@aws-cdk/core");
const core_1 = require("@aws-cdk/core");
const cicd_spa_website_1 = require("../lib/cicd_spa_website");
const app = new cdk.App();
const stack = new core_1.Stack(app, 'public-site-cicd', {
    env: { account: 'asdf', region: 'us-east-1' },
});
new cicd_spa_website_1.CicdSpaWebsite(stack, 'fld-public-site', {
    url: 'www.matthewbonig.com',
    githubSource: {
        owner: 'mbonig',
        repo: 'public_site',
        oauthToken: core_1.SecretValue.secretsManager('github-oauth-token')
    },
    hostedZone: {
        hostedZoneId: 'asdf',
        zoneName: 'matthewbonig.com'
    },
    certificate: true
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3BhX2RlcGxveS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNwYV9kZXBsb3kudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0EsdUNBQXFDO0FBQ3JDLHFDQUFxQztBQUNyQyx3Q0FBaUQ7QUFDakQsOERBQXVEO0FBRXZELE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQzFCLE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRTtJQUM3QyxHQUFHLEVBQUUsRUFBQyxPQUFPLEVBQUUsTUFBTSxFQUFFLE1BQU0sRUFBRSxXQUFXLEVBQUM7Q0FDOUMsQ0FBQyxDQUFDO0FBRUgsSUFBSSxpQ0FBYyxDQUFDLEtBQUssRUFBRSxpQkFBaUIsRUFBRTtJQUN6QyxHQUFHLEVBQUUsc0JBQXNCO0lBQzNCLFlBQVksRUFBRTtRQUNWLEtBQUssRUFBRSxRQUFRO1FBQ2YsSUFBSSxFQUFFLGFBQWE7UUFDbkIsVUFBVSxFQUFFLGtCQUFXLENBQUMsY0FBYyxDQUFDLG9CQUFvQixDQUFDO0tBQy9EO0lBQ0QsVUFBVSxFQUFFO1FBQ1IsWUFBWSxFQUFFLE1BQU07UUFDcEIsUUFBUSxFQUFFLGtCQUFrQjtLQUMvQjtJQUNELFdBQVcsRUFBRSxJQUFJO0NBQ3BCLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIiMhL3Vzci9iaW4vZW52IG5vZGVcbmltcG9ydCAnc291cmNlLW1hcC1zdXBwb3J0L3JlZ2lzdGVyJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7U2VjcmV0VmFsdWUsIFN0YWNrfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7Q2ljZFNwYVdlYnNpdGV9IGZyb20gJy4uL2xpYi9jaWNkX3NwYV93ZWJzaXRlJztcblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcbmNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKGFwcCwgJ3B1YmxpYy1zaXRlLWNpY2QnLCB7XG4gICAgZW52OiB7YWNjb3VudDogJ2FzZGYnLCByZWdpb246ICd1cy1lYXN0LTEnfSxcbn0pO1xuXG5uZXcgQ2ljZFNwYVdlYnNpdGUoc3RhY2ssICdmbGQtcHVibGljLXNpdGUnLCB7XG4gICAgdXJsOiAnd3d3Lm1hdHRoZXdib25pZy5jb20nLFxuICAgIGdpdGh1YlNvdXJjZToge1xuICAgICAgICBvd25lcjogJ21ib25pZycsXG4gICAgICAgIHJlcG86ICdwdWJsaWNfc2l0ZScsXG4gICAgICAgIG9hdXRoVG9rZW46IFNlY3JldFZhbHVlLnNlY3JldHNNYW5hZ2VyKCdnaXRodWItb2F1dGgtdG9rZW4nKVxuICAgIH0sXG4gICAgaG9zdGVkWm9uZToge1xuICAgICAgICBob3N0ZWRab25lSWQ6ICdhc2RmJyxcbiAgICAgICAgem9uZU5hbWU6ICdtYXR0aGV3Ym9uaWcuY29tJ1xuICAgIH0sXG4gICAgY2VydGlmaWNhdGU6IHRydWVcbn0pO1xuIl19