# Runlayer CLI

The Runlayer CLI enables secure execution of trusted MCP servers with enterprise-grade security, auditing, and permission management. Run Model Context Protocol servers through an authenticated proxy that enforces access controls, maintains audit logs, and manages permissions - allowing AI agents to safely connect to internal systems without exposing credentials or running unvetted code locally.

The CLI also provides deployment capabilities to build and deploy Docker-based services to your Runlayer infrastructure.

## Quick Start

The easiest way to get started is to **copy the complete command from the server overview page in your Runlayer app** - it includes all the required parameters pre-filled for your server.

Alternatively, you can construct the command manually:

```bash
uvx runlayer run <server_uuid> --secret <your_api_key> --host <runlayer_url>
```

## Commands

### `run` - Run an MCP Server

Run an MCP server through the Runlayer proxy.

#### Command Arguments

- `server_uuid`: UUID of your MCP server (found in your Runlayer deployment)

#### Command Options

- `--secret`, `-s`: Your Runlayer API key (found under your user settings)
- `--host`: Your Runlayer instance URL (e.g., https://runlayer.example.com)

#### Example

```bash
uvx runlayer run abc123-def456 --secret my_api_key --host https://runlayer.example.com
```

### `deploy` - Deploy a Service

Deploy a Docker-based service to your Runlayer infrastructure based on a `runlayer.yaml` configuration file.

#### Command Options

- `--config`, `-c`: Path to runlayer.yaml config file (default: `runlayer.yaml`)
- `--secret`, `-s`: Your Runlayer API key (required, must have admin permissions)
- `--host`, `-H`: Your Runlayer instance URL (default: `http://localhost:3000`)

#### Example

```bash
uvx runlayer deploy --config runlayer.yaml --secret my_admin_key --host https://runlayer.example.com
```

#### Configuration File (`runlayer.yaml`)

The deploy command reads from a `runlayer.yaml` file that defines your service configuration:

```yaml
name: my-awesome-service
runtime: docker

build:
  dockerfile: Dockerfile
  context: .
  platform: x86  # or "arm"

service:
  port: 8000
  path: /api

infrastructure:
  cpu: 512
  memory: 1024

env:
  DATABASE_URL: postgres://...
  API_KEY: secret123
```

### `deploy init` - Initialize a New Deployment

Create a new deployment and generate a `runlayer.yaml` configuration file.

#### Example

```bash
uvx runlayer deploy init --config runlayer.yaml --secret my_admin_key --host https://runlayer.example.com
```
