# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['omymodels',
 'omymodels.dataclass',
 'omymodels.gino',
 'omymodels.pydantic',
 'omymodels.sqlalchemy',
 'omymodels.sqlalchemy_core']

package_data = \
{'': ['*']}

install_requires = \
['simple-ddl-parser>=0.12,<0.13']

entry_points = \
{'console_scripts': ['omm = omymodels.cli:main']}

setup_kwargs = {
    'name': 'omymodels',
    'version': '0.8.0',
    'description': 'O! My Models (omymodels) is a library to generate Python Models for SQLAlchemy, GinoORM, Pydantic & Python Dataclasses from SQL DDL .',
    'long_description': '\nO! My Models\n------------\n\n\n.. image:: https://img.shields.io/pypi/v/omymodels\n   :target: https://img.shields.io/pypi/v/omymodels\n   :alt: badge1\n \n.. image:: https://img.shields.io/pypi/l/omymodels\n   :target: https://img.shields.io/pypi/l/omymodels\n   :alt: badge2\n \n.. image:: https://img.shields.io/pypi/pyversions/omymodels\n   :target: https://img.shields.io/pypi/pyversions/omymodels\n   :alt: badge3\n \n\nBig example you can find in example/ folder on the github: https://github.com/xnuinside/omymodels/tree/main/example\n\nO! My Models (omymodels) is a library to generate from SQL DDL Python Models for SQLAlchemy (models), SQLAlchemy Core (tables), GinoORM (I hope to add several more ORMs in future), Pydantic classes and Python Dataclasses (dataclasses module).\n\nBy default method **create_models** generate GinoORM models, to get Pydantic models output use the argument ``models_type=\'pydantic\'`` (\'sqlalchemy\' for SQLAlchemy models; \'dataclass\' for Dataclasses; \'sqlalchemy_core\' for Sqlalchemy Core Tables).\n\nA lot of examples in tests/ - https://github.com/xnuinside/omymodels/tree/main/tests.\n\nFor example,\n\n.. code-block:: python\n\n   from omymodels import create_models\n\n\n   ddl = """\n   CREATE table user_history (\n        runid                 decimal(21) null\n       ,job_id                decimal(21)  null\n       ,id                    varchar(100) not null\n       ,user              varchar(100) not null\n       ,status                varchar(10) not null\n       ,event_time            timestamp not null default now()\n       ,comment           varchar(1000) not null default \'none\'\n       ) ;\n\n\n   """\n   result = create_models(ddl, models_type=\'pydantic\')[\'code\']\n\n    # and output will be:    \n   import datetime\n   from typing import Optional\n   from pydantic import BaseModel\n\n\n   class UserHistory(BaseModel):\n\n       runid: Optional[int]\n       job_id: Optional[int]\n       id: str\n       user: str\n       status: str\n       event_time: datetime.datetime\n       comment: str\n\nTo generate Dataclasses from DDL use argument ``models_type=\'dataclass\'``\n\nfor example:\n\n.. code-block:: python\n\n       #  (same DDL as in Pydantic sample)\n       result = create_models(ddl, schema_global=False, models_type=\'dataclass\')[\'code\']\n\n       # and result will be: \n       import datetime\n       from dataclasses import dataclass\n\n\n       @dataclass\n       class UserHistory:\n\n           id: str\n           user: str\n           status: str\n           runid: int = None\n           job_id: int = None\n           event_time: datetime.datetime = datetime.datetime.now()\n           comment: str = \'none\'\n\nGinoORM example. If you provide an input like:\n\n.. code-block:: sql\n\n\n   CREATE TABLE "users" (\n     "id" SERIAL PRIMARY KEY,\n     "name" varchar,\n     "created_at" timestamp,\n     "updated_at" timestamp,\n     "country_code" int,\n     "default_language" int\n   );\n\n   CREATE TABLE "languages" (\n     "id" int PRIMARY KEY,\n     "code" varchar(2) NOT NULL,\n     "name" varchar NOT NULL\n   );\n\nand you will get output:\n\n.. code-block:: python\n\n\n       from gino import Gino\n\n\n       db = Gino()\n\n\n       class Users(db.Model):\n\n           __tablename__ = \'users\'\n\n           id = db.Column(db.Integer(), autoincrement=True, primary_key=True)\n           name = db.Column(db.String())\n           created_at = db.Column(db.TIMESTAMP())\n           updated_at = db.Column(db.TIMESTAMP())\n           country_code = db.Column(db.Integer())\n           default_language = db.Column(db.Integer())\n\n\n       class Languages(db.Model):\n\n           __tablename__ = \'languages\'\n\n           id = db.Column(db.Integer(), primary_key=True)\n           code = db.Column(db.String(2))\n           name = db.Column(db.String())\n\nHow to install\n^^^^^^^^^^^^^^\n\n.. code-block:: bash\n\n\n       pip install omymodels\n\nHow to use\n^^^^^^^^^^\n\nFrom cli\n~~~~~~~~\n\n.. code-block:: bash\n\n\n       omm path/to/your.ddl\n\n       # for example\n       omm tests/test_two_tables.sql\n\nYou can define target path where to save models with **-t**\\ , **--target** flag:\n\n.. code-block:: bash\n\n\n       # for example\n       omm tests/test_two_tables.sql -t test_path/test_models.py\n\nIf you want generate the Pydantic or Dataclasses models - just use flag **-m** or **--models_type=\'pydantic\'** / **--models_type=\'dataclass\'**\n\n.. code-block:: bash\n\n\n       omm /path/to/your.ddl -m dataclass\n\n       # or \n       omm /path/to/your.ddl --models_type pydantic\n\nSmall library is used for parse DDL- https://github.com/xnuinside/simple-ddl-parser.\n\nWhat to do if types not supported in O! My Models and you cannot wait until PR will be approved\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nFirst of all, to parse types correct from DDL to models - they must be in types mypping, for Gino it exitst in this file:\n\nomymodels/gino/types.py  **types_mapping**\n\nIf you need to use fast type that not exist in mapping - just do a path before call code with types_mapping.update()\n\nfor example:\n\n.. code-block:: python\n\n\n       from omymodels.gino import types\n       from omymodels import create_models\n\n       types.types_mapping.update({\'your_type_from_ddl\': \'db.TypeInGino\'})\n\n       ddl = "YOUR DDL with your custom your_type_from_ddl"\n\n       models = create_models(ddl)\n\n       #### And similar for Pydantic types\n\n       from omymodels.pydantic import types  types_mapping\n       from omymodels import create_models\n\n       types.types_mapping.update({\'your_type_from_ddl\': \'db.TypeInGino\'})\n\n       ddl = "YOUR DDL with your custom your_type_from_ddl"\n\n       models = create_models(ddl, models_type=\'pydantic\')\n\nSchema defenition\n^^^^^^^^^^^^^^^^^\n\nThere is 2 ways how to define schema in Models:\n\n1) Globally in Gino() class and it will be like this:\n\n.. code-block:: python\n\n\n       from gino import Gino\n       db = Gino(schema="schema_name")\n\nAnd this is a default way for put schema during generation - it takes first schema in tables and use it. \n\n2) But if you work with tables in different schemas, you need to define schema in each model in table_args. O!MyModels can do this also. Just use flag ``--no-global-schema`` if you use cli or put argument \'schema_global=False\' to create_models() function if you use library from code. Like this:\n\n.. code-block:: python\n\n\n       ddl = """\n       CREATE TABLE "prefix--schema-name"."table" (\n       _id uuid PRIMARY KEY,\n       one_more_id int\n       );\n           create unique index table_pk on "prefix--schema-name"."table" (one_more_id) ;\n           create index table_ix2 on "prefix--schema-name"."table" (_id) ;\n       """\n       result = create_models(ddl, schema_global=False)\n\nAnd result will be this:\n\n.. code-block:: python\n\n\n       from sqlalchemy.dialects.postgresql import UUID\n       from sqlalchemy.schema import UniqueConstraint\n       from sqlalchemy import Index\n       from gino import Gino\n\n       db = Gino()\n\n\n       class Table(db.Model):\n\n           __tablename__ = \'table\'\n\n           _id = db.Column(UUID, primary_key=True)\n           one_more_id = db.Column(db.Integer())\n\n           __table_args__ = (\n\n           UniqueConstraint(one_more_id, name=\'table_pk\'),\n           Index(\'table_ix2\', _id),\n           dict(schema="prefix--schema-name")\n                   )\n\nTODO in next releases\n---------------------\n\n\n#. Add Sequence generation in Models (Gino, SQLAlchemy)\n#. Generate Tortoise ORM models (https://tortoise-orm.readthedocs.io/en/latest/)\n\nHow to contribute\n-----------------\n\nPlease describe issue that you want to solve and open the PR, I will review it as soon as possible.\n\nAny questions? Ping me in Telegram: https://t.me/xnuinside\n\nChangelog\n---------\n\n**v0.8.0**\n\n\n#. Fix --defaults-off flag in cli\n#. Added support for SQLAlchemy Core Tables generation\n#. Added examples folder in github ``omymodels/example``\n#. Fix issue with ForeignKey in SQLAlchemy\n\n**v0.7.0**\n\n\n#. Added generation for SQLAlchemy models (defaults from DDLs are setting up as \'server_default\')\n#. Added defaults for Pydantic models\n#. Added flag to generate Pydantic & Dataclass models WITHOUT defaults ``defaults_off=True`` (by default it is False). And cli flag --defaults-off\n#. Fixed issue with Enum types with lower case names in DDLs\n#. Fixed several issues with Dataclass generation (default with datetime & Enums)\n#. \'"\' do not remove from defaults now\n\n**v0.6.0**\n\n\n#. O!MyModels now also can generate python Dataclass from DDL. Use argument models_type=\'dataclass\' or if you use the cli flag --models_type dataclass or -m dataclass\n#. Added ForeignKey generation to GinoORM Models, added support for ondelete and onupdate\n\n**v0.5.0**\n\n\n#. Added Enums/IntEnums types for Gino & Pydantic\n#. Added UUID type\n#. Added key ``schema_global`` in create_models method (by default schema_global = True). \n   If you set schema_global=False schema if it exists in ddl will be defined for each table (model) in table args.\n   This way you can have differen schemas per model (table). By default schema_global=True - this mean for all \n   table only one schema and it is defined in ``db = Gino(schema="prefix--schema-name")``.\n#. If column is a primary key (primary_key=True) nullable argument not showed, because primary keys always are not null.\n#. To cli was added flag \'--no-global-schema\' to set schema in table_args.\n\n**v0.4.1**\n\n\n#. Added correct work with table names contains multiple \'-\'\n\n**v0.4.0**\n\n\n#. Added generation for Pydantic models from ddl\n#. Main method create_gino_models renamed to create_models\n\n**v0.3.0**\n\n\n#. Generated Index for \'index\' statement in **table_args** (not unique constrait as previously)\n#. Fix issue with column size as tuple (4,2)\n\n**v0.2.0**\n\n\n#. Valid generating columns in models: autoincrement, default, type, arrays, unique, primary key and etc.\n#. Added creating **table_args** for indexes\n',
    'author': 'Iuliia Volkova',
    'author_email': 'xnuinside@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/xnuinside/omymodels',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
