# Copyright 2020 Adap GmbH. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
"""Common baseline components."""


from .client import VisionClassificationClient as VisionClassificationClient
from .common import custom_fit as custom_fit
from .common import get_eval_fn as get_eval_fn
from .common import get_lr_schedule as get_lr_schedule
from .common import keras_evaluate as keras_evaluate
from .common import keras_fit as keras_fit
from .config import configure_client_instances as configure_client_instances
from .config import sample_delay_factors as sample_delay_factors
from .config import sample_real_delay_factors as sample_real_delay_factors
from .data import build_dataset as build_dataset
from .data import load_partition as load_partition
