# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pytest_jtr']

package_data = \
{'': ['*']}

install_requires = \
['fire>=0.4.0,<0.5.0',
 'loguru>=0.6.0,<0.7.0',
 'pytest-metadata>=2.0.1,<3.0.0',
 'pytest-xdist>=2.5.0,<3.0.0',
 'pytest>=7.1.2,<8.0.0',
 'rich>=12.6.0,<13.0.0']

entry_points = \
{'console_scripts': ['prep-dev-release = scripts.prep_release:dev',
                     'prep-major-release = scripts.release_process:prep_major',
                     'prep-minor-release = scripts.release_process:prep_minor',
                     'prep-patch-release = scripts.release_process:prep_patch',
                     'release = scripts.release_process:upload_release'],
 'pytest11': ['jtr = pytest_jtr.plugin']}

setup_kwargs = {
    'name': 'pytest-jtr',
    'version': '1.1.0',
    'description': 'pytest plugin supporting json test report output',
    'long_description': '# Pytest jtr JSON Test Report\n\n[![CI](https://github.com/Gleams-Machine/pytest-jtr/actions/workflows/main.yml/badge.svg)](https://github.com/Gleams-Machine/pytest-jtr/actions/workflows/main.yml)\n\nForked from [numirias/pytest-json-report](https://github.com/numirias/pytest-json-report)\n\nThis pytest plugin creates test reports as JSON files. This can make it easier to process test results in other applications.\n\nIt can report a summary, test details, captured output, logs, exception tracebacks and more. Additionally, you can use the available fixtures and hooks to [add metadata](#metadata) and [customize](#modifying-the-report) the report as you like.\n\n## Table of contents\n\n* [Installation](#installation)\n* [Options](#options)\n* [Usage](#usage)\n   * [Metadata](#metadata)\n   * [Modifying the report](#modifying-the-report)\n   * [Direct invocation](#direct-invocation)\n* [Format](#format)\n   * [Summary](#summary)\n   * [Environment](#environment)\n   * [Collectors](#collectors)\n   * [Tests](#tests)\n   * [Test stage](#test-stage)\n   * [Log](#log)\n   * [Warnings](#warnings)\n* [Related tools](#related-tools)\n\n## Installation\n\n```\n\npip install pytest-jtr\n\n# or\n\npoetry add pytest-jtr\n\n```\n\n## Options\n\n| Option | Description |\n| --- | --- |\n| `--json-report` | Create JSON report |\n| `--json-report-file=PATH` | Target path to save JSON report (use "none" to not save the report) |\n| `--json-report-summary` | Just create a summary without per-test details |\n| `--json-report-omit=FIELD_LIST` | List of fields to omit in the report (choose from: `collectors`, `log`, `traceback`, `streams`, `warnings`, `keywords`) |\n| `--json-report-indent=LEVEL` | Pretty-print JSON with specified indentation level |\n| `--json-report-verbosity=LEVEL` | Set verbosity (default is value of `--verbosity`) |\n\n## Usage\n\nJust run pytest with `--json-report`. The report is saved in `.report.json` by default.\n\n```bash\n$ pytest --json-report -v tests/\n$ cat .report.json\n{"created": 1518371686.7981803, ... "tests":[{"nodeid": "test_foo.py", "outcome": "passed", ...}, ...]}\n```\n\nIf you just need to know how many tests passed or failed and don\'t care about details, you can produce a summary only:\n\n```bash\n$ pytest --json-report --json-report-summary\n```\n\nMany fields can be omitted to keep the report size small. E.g., this will leave out keywords and stdout/stderr output:\n\n```bash\n$ pytest --json-report --json-report-omit keywords streams\n```\n\nIf you don\'t like to have the report saved, you can specify `none` as the target file name:\n\n```bash\n$ pytest --json-report --json-report-file none\n```\n\n## Advanced usage\n\n### Metadata\n\nThe easiest way to add your own metadata to a test item is by using the `json_metadata` [test fixture](https://docs.pytest.org/en/stable/fixture.html):\n\n```python\ndef test_something(json_metadata):\n    json_metadata[\'foo\'] = {"some": "thing"}\n    json_metadata[\'bar\'] = 123\n```\n\nOr use the `pytest_json_runtest_metadata` [hook](https://docs.pytest.org/en/stable/reference.html#hooks) (in your `conftest.py`) to add metadata based on the current test run. The dict returned will automatically be merged with any existing metadata. E.g., this adds the start and stop time of each test\'s `call` stage:\n\n```python\ndef pytest_json_runtest_metadata(item, call):\n    if call.when != \'call\':\n        return {}\n    return {\'start\': call.start, \'stop\': call.stop}\n```\n\nAlso, you could add metadata using [pytest-metadata\'s `--metadata` switch](https://github.com/pytest-dev/pytest-metadata#additional-metadata) which will add metadata to the report\'s `environment` section, but not to a specific test item. You need to make sure all your metadata is JSON-serializable.\n\n### A note on hooks\n\nIf you\'re using a `pytest_json_*` hook although the plugin is not installed or not active (not using `--json-report`), pytest doesn\'t recognize it and may fail with an internal error like this:\n```\nINTERNALERROR> pluggy.manager.PluginValidationError: unknown hook \'pytest_json_runtest_metadata\' in plugin <module \'conftest\' from \'conftest.py\'>\n```\nYou can avoid this by declaring the hook implementation optional:\n\n```python\nimport pytest\n@pytest.hookimpl(optionalhook=True)\ndef pytest_json_runtest_metadata(item, call):\n    ...\n```\n\n### Modifying the report\n\nYou can modify the entire report before it\'s saved by using the `pytest_json_modifyreport` hook.\n\nJust implement the hook in your `conftest.py`, e.g.:\n\n```python\ndef pytest_json_modifyreport(json_report):\n    # Add a key to the report\n    json_report[\'foo\'] = \'bar\'\n    # Delete the summary from the report\n    del json_report[\'summary\']\n```\n\nAfter `pytest_sessionfinish`, the report object is also directly available to script via `config._json_report.report`. So you can access it using some built-in hook:\n\n```python\ndef pytest_sessionfinish(session):\n    report = session.config._json_report.report\n    print(\'exited with\', report[\'exitcode\'])\n```\n\nIf you *really* want to change how the result of a test stage run is turned into JSON, you can use the `pytest_json_runtest_stage` hook. It takes a [`TestReport`](https://docs.pytest.org/en/latest/reference.html#_pytest.runner.TestReport) and returns a JSON-serializable dict:\n\n```python\ndef pytest_json_runtest_stage(report):\n    return {\'outcome\': report.outcome}\n```\n\n### Direct invocation\n\nYou can use the plugin when invoking `pytest.main()` directly from code:\n\n```python\nimport pytest\nfrom pytest_jtr.plugin import JSONReport\n\nplugin = JSONReport()\npytest.main([\'--json-report-file=none\', \'test_foo.py\'], plugins=[plugin])\n```\n\nYou can then access the `report` object:\n\n```python\nprint(plugin.report)\n```\n\nAnd save the report manually:\n\n```python\nplugin.save_report(\'/tmp/my_report.json\')\n```\n\n\n## Format\n\nThe JSON report contains metadata of the session, a summary, collectors, tests and warnings. You can find a sample report in [`sample_report.json`](sample_report.json).\n\n| Key | Description |\n| --- | --- |\n| `created` | Report creation date. (Unix time) |\n| `duration` | Session duration in seconds. |\n| `exitcode` | Process exit code as listed [in the pytest docs](https://docs.pytest.org/en/latest/usage.html#possible-exit-codes). The exit code is a quick way to tell if any tests failed, an internal error occurred, etc. |\n| `root` | Absolute root path from which the session was started. |\n| `environment` | [Environment](#environment) entry. |\n| `summary` | [Summary](#summary) entry. |\n| `collectors` | [Collectors](#collectors) entry. (absent if `--json-report-summary` or if no collectors)  |\n| `tests` | [Tests](#tests) entry. (absent if `--json-report-summary`)  |\n| `warnings` | [Warnings](#warnings) entry. (absent if `--json-report-summary` or if no warnings)  |\n\n#### Example\n\n```python\n{\n    "created": 1518371686.7981803,\n    "duration": 0.1235666275024414,\n    "exitcode": 1,\n    "root": "/path/to/tests",\n    "environment": ENVIRONMENT,\n    "summary": SUMMARY,\n    "collectors": COLLECTORS,\n    "tests": TESTS,\n    "warnings": WARNINGS,\n}\n```\n\n### Summary\n\nNumber of outcomes per category and the total number of test items.\n\n| Key | Description |\n| --- | --- |\n|  `collected` | Total number of tests collected. |\n|  `total` | Total number of tests run. |\n|  `deselected` | Total number of tests deselected. (absent if number is 0) |\n| `<outcome>` | Number of tests with that outcome. (absent if number is 0) |\n\n#### Example\n\n```python\n{\n    "collected": 10,\n    "passed": 2,\n    "failed": 3,\n    "xfailed": 1,\n    "xpassed": 1,\n    "error": 2,\n    "skipped": 1,\n    "total": 10\n}\n```\n\n### Environment\n\nThe environment section is provided by [pytest-metadata](https://github.com/pytest-dev/pytest-metadata). All metadata given by that plugin will be added here, so you need to make sure it is JSON-serializable.\n\n#### Example\n\n```python\n{\n    "Python": "3.6.4",\n    "Platform": "Linux-4.56.78-9-ARCH-x86_64-with-arch",\n    "Packages": {\n        "pytest": "3.4.0",\n        "py": "1.5.2",\n        "pluggy": "0.6.0"\n    },\n    "Plugins": {\n        "json-report": "0.4.1",\n        "xdist": "1.22.0",\n        "metadata": "1.5.1",\n        "forked": "0.2",\n        "cov": "2.5.1"\n    },\n    "foo": "bar", # Custom metadata entry passed via pytest-metadata\n}\n```\n\n### Collectors\n\nA list of collector nodes. These are useful to check what tests are available without running them, or to debug an error during test discovery.\n\n| Key | Description |\n| --- | --- |\n| `nodeid` | ID of the collector node. ([See docs](https://docs.pytest.org/en/latest/example/markers.html#node-id)) The root node has an empty node ID. |\n| `outcome` | Outcome of the collection. (Not the test outcome!) |\n| `result` | Nodes collected by the collector. |\n| `longrepr` | Representation of the collection error. (absent if no error occurred) |\n\nThe `result` is a list of the collected nodes:\n\n| Key | Description |\n| --- | --- |\n| `nodeid` | ID of the node. |\n| `type` | Type of the collected node. |\n| `lineno` | Line number. (absent if not applicable) |\n| `deselected` | `true` if the test is deselected. (absent if not deselected) |\n\n#### Example\n\n```python\n[\n    {\n        "nodeid": "",\n        "outcome": "passed",\n        "result": [\n            {\n                "nodeid": "test_foo.py",\n                "type": "Module"\n            }\n        ]\n    },\n    {\n        "nodeid": "test_foo.py",\n        "outcome": "passed",\n        "result": [\n            {\n                "nodeid": "test_foo.py::test_pass",\n                "type": "Function",\n                "lineno": 24,\n                "deselected": true\n            },\n            ...\n        ]\n    },\n    {\n        "nodeid": "test_bar.py",\n        "outcome": "failed",\n        "result": [],\n        "longrepr": "/usr/lib/python3.6 ... invalid syntax"\n    },\n    ...\n]\n```\n\n### Tests\n\nA list of test nodes. Each completed test stage produces a stage object (`setup`, `call`, `teardown`) with its own `outcome`.\n\n| Key | Description |\n| --- | --- |\n| `nodeid` | ID of the test node. |\n| `lineno` | Line number where the test starts. |\n| `keywords` | List of keywords and markers associated with the test. |\n| `outcome` | Outcome of the test run. |\n| `{setup, call, teardown}` | [Test stage](#test-stage) entry. To find the error in a failed test you need to check all stages. (absent if stage didn\'t run) |\n| `metadata` | [Metadata](#metadata) item. (absent if no metadata) |\n\n#### Example\n\n```python\n[\n    {\n        "nodeid": "test_foo.py::test_fail",\n        "lineno": 50,\n        "keywords": [\n            "test_fail",\n            "test_foo.py",\n            "test_foo0"\n        ],\n        "outcome": "failed",\n        "setup": TEST_STAGE,\n        "call": TEST_STAGE,\n        "teardown": TEST_STAGE,\n        "metadata": {\n            "foo": "bar",\n        }\n    },\n    ...\n]\n```\n\n\n### Test stage\n\nA test stage item.\n\n| Key | Description |\n| --- | --- |\n| `duration` | Duration of the test stage in seconds. |\n| `outcome` | Outcome of the test stage. (can be different from the overall test outcome) |\n| `crash` | Crash entry. (absent if no error occurred) |\n| `traceback` | List of traceback entries. (absent if no error occurred; affected by `--tb` option) |\n| `stdout` | Standard output. (absent if none available) |\n| `stderr` | Standard error. (absent if none available) |\n| `log` | [Log](#log) entry. (absent if none available) |\n| `longrepr` | Representation of the error. (absent if no error occurred; format affected by `--tb` option) |\n\n#### Example\n\n```python\n{\n    "duration": 0.00018835067749023438,\n    "outcome": "failed",\n    "crash": {\n        "path": "/path/to/tests/test_foo.py",\n        "lineno": 54,\n        "message": "TypeError: unsupported operand type(s) for -: \'int\' and \'NoneType\'"\n    },\n    "traceback": [\n        {\n            "path": "test_foo.py",\n            "lineno": 65,\n            "message": ""\n        },\n        {\n            "path": "test_foo.py",\n            "lineno": 63,\n            "message": "in foo"\n        },\n        {\n            "path": "test_foo.py",\n            "lineno": 63,\n            "message": "in <listcomp>"\n        },\n        {\n            "path": "test_foo.py",\n            "lineno": 54,\n            "message": "TypeError"\n        }\n    ],\n    "stdout": "foo\\nbar\\n",\n    "stderr": "baz\\n",\n    "log": LOG,\n    "longrepr": "def test_fail_nested():\\n ..."\n}\n```\n\n### Log\n\nA list of log records. The fields of a log record are the [`logging.LogRecord` attributes](https://docs.python.org/3/library/logging.html#logrecord-attributes), with the exception that the fields `exc_info` and `args` are always empty and `msg` contains the formatted log message.\n\nYou can apply [`logging.makeLogRecord()`](https://docs.python.org/3/library/logging.html#logging.makeLogRecord)  on a log record to convert it back to a `logging.LogRecord` object.\n\n#### Example\n\n```python\n[\n    {\n        "name": "root",\n        "msg": "This is a warning.",\n        "args": null,\n        "levelname": "WARNING",\n        "levelno": 30,\n        "pathname": "/path/to/tests/test_foo.py",\n        "filename": "test_foo.py",\n        "module": "test_foo",\n        "exc_info": null,\n        "exc_text": null,\n        "stack_info": null,\n        "lineno": 8,\n        "funcName": "foo",\n        "created": 1519772464.291738,\n        "msecs": 291.73803329467773,\n        "relativeCreated": 332.90839195251465,\n        "thread": 140671803118912,\n        "threadName": "MainThread",\n        "processName": "MainProcess",\n        "process": 31481\n    },\n    ...\n]\n```\n\n\n### Warnings\n\nA list of warnings that occurred during the session. (See the [pytest docs on warnings](https://docs.pytest.org/en/latest/warnings.html).)\n\n| Key | Description |\n| --- | --- |\n| `filename` | File name. |\n| `lineno` | Line number. |\n| `message` | Warning message. |\n| `when` | When the warning was captured. (`"config"`, `"collect"` or `"runtest"` as listed [here](https://docs.pytest.org/en/latest/reference.html#_pytest.hookspec.pytest_warning_captured)) |\n\n#### Example\n\n```python\n[\n    {\n        "code": "C1",\n        "path": "/path/to/tests/test_foo.py",\n        "nodeid": "test_foo.py::TestFoo",\n        "message": "cannot collect test class \'TestFoo\' because it has a __init__ constructor"\n    }\n]\n```\n',
    'author': 'Gleams API user',
    'author_email': 'Stephen.Swannell+ghapi@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<3.11.0',
}


setup(**setup_kwargs)
