"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbToFargate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
class AlbToFargate extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckAlbProps(props);
        defaults.CheckFargateProps(props);
        // Obtain VPC for construct (existing or created)
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: { enableDnsHostnames: true, enableDnsSupport: true }
        });
        // Set up the ALB
        this.loadBalancer = defaults.ObtainAlb(scope, `${id}-lb`, this.vpc, props.publicApi, props.existingLoadBalancerObj, props.loadBalancerProps, props.logAlbAccessLogs, props.albLoggingBucketProps);
        const newListener = this.loadBalancer.listeners.length === 0;
        // If there's no listener, then we add one here
        if (newListener) {
            this.listener = defaults.AddListener(this, id, this.loadBalancer, props.listenerProps);
        }
        else {
            this.listener = core_1.GetActiveListener(this.loadBalancer.listeners);
        }
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            const createFargateServiceResponse = defaults.CreateFargateService(scope, id, this.vpc, props.clusterProps, props.ecrRepositoryArn, props.ecrImageVersion, props.fargateTaskDefinitionProps, props.containerDefinitionProps, props.fargateServiceProps);
            this.service = createFargateServiceResponse.service;
            this.container = createFargateServiceResponse.containerDefinition;
        }
        // Add the Fargate Service to the
        // to the ALB Listener we set up earlier
        const applicationTargetGroupProps = defaults.consolidateProps(defaults.DefaultApplicationTargetGroupProps(this.vpc), props.targetGroupProps);
        const newTargetGroup = defaults.AddFargateTarget(scope, `${id}-target`, this.listener, this.service, props.ruleProps, applicationTargetGroupProps);
        if (newListener && this.listener) {
            const levelOneListener = this.listener.node.defaultChild;
            const cfnTargetGroup = newTargetGroup.node.defaultChild;
            levelOneListener.addDependency(cfnTargetGroup);
        }
    }
}
exports.AlbToFargate = AlbToFargate;
_a = JSII_RTTI_SYMBOL_1;
AlbToFargate[_a] = { fqn: "@aws-solutions-constructs/aws-alb-fargate.AlbToFargate", version: "2.33.0" };
//# sourceMappingURL=data:application/json;base64,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