# coding: utf-8


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from gitee.api_client import ApiClient


class PullRequestsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_v5_repos_owner_repo_pulls_comments_id(self, owner, repo, id, **kwargs):  # noqa: E501
        """删除评论  # noqa: E501

        删除评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_repos_owner_repo_pulls_comments_id(owner, repo, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int id: 评论的ID (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_v5_repos_owner_repo_pulls_comments_id_with_http_info(owner, repo, id,
                                                                                    **kwargs)  # noqa: E501
        else:
            (data) = self.delete_v5_repos_owner_repo_pulls_comments_id_with_http_info(owner, repo, id,
                                                                                      **kwargs)  # noqa: E501
            return data

    def delete_v5_repos_owner_repo_pulls_comments_id_with_http_info(self, owner, repo, id, **kwargs):  # noqa: E501
        """删除评论  # noqa: E501

        删除评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_repos_owner_repo_pulls_comments_id_with_http_info(owner, repo, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int id: 评论的ID (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'id', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_v5_repos_owner_repo_pulls_comments_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `delete_v5_repos_owner_repo_pulls_comments_id`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `delete_v5_repos_owner_repo_pulls_comments_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError(
                "Missing the required parameter `id` when calling `delete_v5_repos_owner_repo_pulls_comments_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/comments/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_v5_repos_owner_repo_pulls_number_assignees(self, owner, repo, number, assignees, **kwargs):  # noqa: E501
        """取消用户审查 Pull Request  # noqa: E501

        取消用户审查 Pull Request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_repos_owner_repo_pulls_number_assignees(owner, repo, number, assignees, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str assignees: 用户的个人空间地址, 以 , 分隔 (required)
        :param str access_token: 用户授权码
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_v5_repos_owner_repo_pulls_number_assignees_with_http_info(owner, repo, number, assignees,
                                                                                         **kwargs)  # noqa: E501
        else:
            (data) = self.delete_v5_repos_owner_repo_pulls_number_assignees_with_http_info(owner, repo, number,
                                                                                           assignees,
                                                                                           **kwargs)  # noqa: E501
            return data

    def delete_v5_repos_owner_repo_pulls_number_assignees_with_http_info(self, owner, repo, number, assignees,
                                                                         **kwargs):  # noqa: E501
        """取消用户审查 Pull Request  # noqa: E501

        取消用户审查 Pull Request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_repos_owner_repo_pulls_number_assignees_with_http_info(owner, repo, number, assignees, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str assignees: 用户的个人空间地址, 以 , 分隔 (required)
        :param str access_token: 用户授权码
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'assignees', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_v5_repos_owner_repo_pulls_number_assignees" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `delete_v5_repos_owner_repo_pulls_number_assignees`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `delete_v5_repos_owner_repo_pulls_number_assignees`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `delete_v5_repos_owner_repo_pulls_number_assignees`")  # noqa: E501
        # verify the required parameter 'assignees' is set
        if ('assignees' not in params or
                params['assignees'] is None):
            raise ValueError(
                "Missing the required parameter `assignees` when calling `delete_v5_repos_owner_repo_pulls_number_assignees`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'assignees' in params:
            query_params.append(('assignees', params['assignees']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/assignees', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PullRequest',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_v5_repos_owner_repo_pulls_number_labels_name(self, owner, repo, number, name, **kwargs):  # noqa: E501
        """删除 Pull Request 标签  # noqa: E501

        删除 Pull Request 标签  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_repos_owner_repo_pulls_number_labels_name(owner, repo, number, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str name: 标签名称 (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_v5_repos_owner_repo_pulls_number_labels_name_with_http_info(owner, repo, number, name,
                                                                                           **kwargs)  # noqa: E501
        else:
            (data) = self.delete_v5_repos_owner_repo_pulls_number_labels_name_with_http_info(owner, repo, number, name,
                                                                                             **kwargs)  # noqa: E501
            return data

    def delete_v5_repos_owner_repo_pulls_number_labels_name_with_http_info(self, owner, repo, number, name,
                                                                           **kwargs):  # noqa: E501
        """删除 Pull Request 标签  # noqa: E501

        删除 Pull Request 标签  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_repos_owner_repo_pulls_number_labels_name_with_http_info(owner, repo, number, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str name: 标签名称 (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'name', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_v5_repos_owner_repo_pulls_number_labels_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `delete_v5_repos_owner_repo_pulls_number_labels_name`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `delete_v5_repos_owner_repo_pulls_number_labels_name`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `delete_v5_repos_owner_repo_pulls_number_labels_name`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError(
                "Missing the required parameter `name` when calling `delete_v5_repos_owner_repo_pulls_number_labels_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/labels/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_v5_repos_owner_repo_pulls_number_testers(self, owner, repo, number, testers, **kwargs):  # noqa: E501
        """取消用户测试 Pull Request  # noqa: E501

        取消用户测试 Pull Request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_repos_owner_repo_pulls_number_testers(owner, repo, number, testers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str testers: 用户的个人空间地址, 以 , 分隔 (required)
        :param str access_token: 用户授权码
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_v5_repos_owner_repo_pulls_number_testers_with_http_info(owner, repo, number, testers,
                                                                                       **kwargs)  # noqa: E501
        else:
            (data) = self.delete_v5_repos_owner_repo_pulls_number_testers_with_http_info(owner, repo, number, testers,
                                                                                         **kwargs)  # noqa: E501
            return data

    def delete_v5_repos_owner_repo_pulls_number_testers_with_http_info(self, owner, repo, number, testers,
                                                                       **kwargs):  # noqa: E501
        """取消用户测试 Pull Request  # noqa: E501

        取消用户测试 Pull Request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_repos_owner_repo_pulls_number_testers_with_http_info(owner, repo, number, testers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str testers: 用户的个人空间地址, 以 , 分隔 (required)
        :param str access_token: 用户授权码
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'testers', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_v5_repos_owner_repo_pulls_number_testers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `delete_v5_repos_owner_repo_pulls_number_testers`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `delete_v5_repos_owner_repo_pulls_number_testers`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `delete_v5_repos_owner_repo_pulls_number_testers`")  # noqa: E501
        # verify the required parameter 'testers' is set
        if ('testers' not in params or
                params['testers'] is None):
            raise ValueError(
                "Missing the required parameter `testers` when calling `delete_v5_repos_owner_repo_pulls_number_testers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'testers' in params:
            query_params.append(('testers', params['testers']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/testers', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PullRequest',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_repo_pulls(self, owner, repo, **kwargs):  # noqa: E501
        """获取Pull Request列表  # noqa: E501

        获取Pull Request列表  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param str access_token: 用户授权码
        :param str state: 可选。Pull Request 状态
        :param str head: 可选。Pull Request 提交的源分支。格式：branch 或者：username:branch
        :param str base: 可选。Pull Request 提交目标分支的名称。
        :param str sort: 可选。排序字段，默认按创建时间
        :param str direction: 可选。升序/降序
        :param int milestone_number: 可选。里程碑序号(id)
        :param str labels: 用逗号分开的标签。如: bug,performance
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[PullRequest]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_repo_pulls_with_http_info(owner, repo, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_repo_pulls_with_http_info(owner, repo, **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_repo_pulls_with_http_info(self, owner, repo, **kwargs):  # noqa: E501
        """获取Pull Request列表  # noqa: E501

        获取Pull Request列表  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_with_http_info(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param str access_token: 用户授权码
        :param str state: 可选。Pull Request 状态
        :param str head: 可选。Pull Request 提交的源分支。格式：branch 或者：username:branch
        :param str base: 可选。Pull Request 提交目标分支的名称。
        :param str sort: 可选。排序字段，默认按创建时间
        :param str direction: 可选。升序/降序
        :param int milestone_number: 可选。里程碑序号(id)
        :param str labels: 用逗号分开的标签。如: bug,performance
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[PullRequest]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'access_token', 'state', 'head', 'base', 'sort', 'direction', 'milestone_number',
                      'labels', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_repo_pulls" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_repo_pulls`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_v5_repos_owner_repo_pulls`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'head' in params:
            query_params.append(('head', params['head']))  # noqa: E501
        if 'base' in params:
            query_params.append(('base', params['base']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'direction' in params:
            query_params.append(('direction', params['direction']))  # noqa: E501
        if 'milestone_number' in params:
            query_params.append(('milestone_number', params['milestone_number']))  # noqa: E501
        if 'labels' in params:
            query_params.append(('labels', params['labels']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PullRequest]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_repo_pulls_comments(self, owner, repo, **kwargs):  # noqa: E501
        """获取该仓库下的所有Pull Request评论  # noqa: E501

        获取该仓库下的所有Pull Request评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_comments(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param str access_token: 用户授权码
        :param str sort: 可选。按创建时间/更新时间排序
        :param str direction: 可选。升序/降序
        :param str since: 起始的更新时间，要求时间格式为 ISO 8601
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[PullRequestComments]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_repo_pulls_comments_with_http_info(owner, repo, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_repo_pulls_comments_with_http_info(owner, repo, **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_repo_pulls_comments_with_http_info(self, owner, repo, **kwargs):  # noqa: E501
        """获取该仓库下的所有Pull Request评论  # noqa: E501

        获取该仓库下的所有Pull Request评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_comments_with_http_info(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param str access_token: 用户授权码
        :param str sort: 可选。按创建时间/更新时间排序
        :param str direction: 可选。升序/降序
        :param str since: 起始的更新时间，要求时间格式为 ISO 8601
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[PullRequestComments]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'access_token', 'sort', 'direction', 'since', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_repo_pulls_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_repo_pulls_comments`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_v5_repos_owner_repo_pulls_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'direction' in params:
            query_params.append(('direction', params['direction']))  # noqa: E501
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/comments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PullRequestComments]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_repo_pulls_comments_id(self, owner, repo, id, **kwargs):  # noqa: E501
        """获取Pull Request的某个评论  # noqa: E501

        获取Pull Request的某个评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_comments_id(owner, repo, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int id: (required)
        :param str access_token: 用户授权码
        :return: PullRequestComments
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_repo_pulls_comments_id_with_http_info(owner, repo, id,
                                                                                 **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_repo_pulls_comments_id_with_http_info(owner, repo, id,
                                                                                   **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_repo_pulls_comments_id_with_http_info(self, owner, repo, id, **kwargs):  # noqa: E501
        """获取Pull Request的某个评论  # noqa: E501

        获取Pull Request的某个评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_comments_id_with_http_info(owner, repo, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int id: (required)
        :param str access_token: 用户授权码
        :return: PullRequestComments
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'id', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_repo_pulls_comments_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_repo_pulls_comments_id`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_v5_repos_owner_repo_pulls_comments_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError(
                "Missing the required parameter `id` when calling `get_v5_repos_owner_repo_pulls_comments_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/comments/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PullRequestComments',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_repo_pulls_number(self, owner, repo, number, **kwargs):  # noqa: E501
        """获取单个Pull Request  # noqa: E501

        获取单个Pull Request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_number(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token: 用户授权码
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_repo_pulls_number_with_http_info(owner, repo, number, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_repo_pulls_number_with_http_info(owner, repo, number,
                                                                              **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_repo_pulls_number_with_http_info(self, owner, repo, number, **kwargs):  # noqa: E501
        """获取单个Pull Request  # noqa: E501

        获取单个Pull Request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_number_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token: 用户授权码
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_repo_pulls_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_repo_pulls_number`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_v5_repos_owner_repo_pulls_number`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `get_v5_repos_owner_repo_pulls_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PullRequest',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_repo_pulls_number_comments(self, owner, repo, number, **kwargs):  # noqa: E501
        """获取某个Pull Request的所有评论  # noqa: E501

        获取某个Pull Request的所有评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_number_comments(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[PullRequestComments]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_repo_pulls_number_comments_with_http_info(owner, repo, number,
                                                                                     **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_repo_pulls_number_comments_with_http_info(owner, repo, number,
                                                                                       **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_repo_pulls_number_comments_with_http_info(self, owner, repo, number, **kwargs):  # noqa: E501
        """获取某个Pull Request的所有评论  # noqa: E501

        获取某个Pull Request的所有评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_number_comments_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[PullRequestComments]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'access_token', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_repo_pulls_number_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_repo_pulls_number_comments`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_v5_repos_owner_repo_pulls_number_comments`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `get_v5_repos_owner_repo_pulls_number_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/comments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PullRequestComments]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_repo_pulls_number_commits(self, owner, repo, number, **kwargs):  # noqa: E501
        """获取某Pull Request的所有Commit信息。最多显示250条Commit  # noqa: E501

        获取某Pull Request的所有Commit信息。最多显示250条Commit  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_number_commits(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token: 用户授权码
        :return: list[PullRequestCommits]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_repo_pulls_number_commits_with_http_info(owner, repo, number,
                                                                                    **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_repo_pulls_number_commits_with_http_info(owner, repo, number,
                                                                                      **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_repo_pulls_number_commits_with_http_info(self, owner, repo, number, **kwargs):  # noqa: E501
        """获取某Pull Request的所有Commit信息。最多显示250条Commit  # noqa: E501

        获取某Pull Request的所有Commit信息。最多显示250条Commit  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_number_commits_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token: 用户授权码
        :return: list[PullRequestCommits]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_repo_pulls_number_commits" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_repo_pulls_number_commits`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_v5_repos_owner_repo_pulls_number_commits`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `get_v5_repos_owner_repo_pulls_number_commits`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/commits', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PullRequestCommits]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_repo_pulls_number_files(self, owner, repo, number, **kwargs):  # noqa: E501
        """Pull Request Commit文件列表。最多显示300条diff  # noqa: E501

        Pull Request Commit文件列表。最多显示300条diff  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_number_files(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token: 用户授权码
        :return: list[PullRequestFiles]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_repo_pulls_number_files_with_http_info(owner, repo, number,
                                                                                  **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_repo_pulls_number_files_with_http_info(owner, repo, number,
                                                                                    **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_repo_pulls_number_files_with_http_info(self, owner, repo, number, **kwargs):  # noqa: E501
        """Pull Request Commit文件列表。最多显示300条diff  # noqa: E501

        Pull Request Commit文件列表。最多显示300条diff  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_number_files_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token: 用户授权码
        :return: list[PullRequestFiles]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_repo_pulls_number_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_repo_pulls_number_files`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_v5_repos_owner_repo_pulls_number_files`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `get_v5_repos_owner_repo_pulls_number_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PullRequestFiles]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_repo_pulls_number_issues(self, owner, repo, number, **kwargs):  # noqa: E501
        """获取 Pull Request 关联的 issues  # noqa: E501

        获取 Pull Request 关联的 issues  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_number_issues(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[Issue]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_repo_pulls_number_issues_with_http_info(owner, repo, number,
                                                                                   **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_repo_pulls_number_issues_with_http_info(owner, repo, number,
                                                                                     **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_repo_pulls_number_issues_with_http_info(self, owner, repo, number, **kwargs):  # noqa: E501
        """获取 Pull Request 关联的 issues  # noqa: E501

        获取 Pull Request 关联的 issues  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_number_issues_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[Issue]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'access_token', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_repo_pulls_number_issues" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_repo_pulls_number_issues`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_v5_repos_owner_repo_pulls_number_issues`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `get_v5_repos_owner_repo_pulls_number_issues`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/issues', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Issue]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_repo_pulls_number_labels(self, owner, repo, number, **kwargs):  # noqa: E501
        """获取某个 Pull Request 的所有标签  # noqa: E501

        获取某个 Pull Request 的所有标签  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_number_labels(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[Label]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_repo_pulls_number_labels_with_http_info(owner, repo, number,
                                                                                   **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_repo_pulls_number_labels_with_http_info(owner, repo, number,
                                                                                     **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_repo_pulls_number_labels_with_http_info(self, owner, repo, number, **kwargs):  # noqa: E501
        """获取某个 Pull Request 的所有标签  # noqa: E501

        获取某个 Pull Request 的所有标签  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_number_labels_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[Label]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'access_token', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_repo_pulls_number_labels" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_repo_pulls_number_labels`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_v5_repos_owner_repo_pulls_number_labels`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `get_v5_repos_owner_repo_pulls_number_labels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Label]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_repo_pulls_number_merge(self, owner, repo, number, **kwargs):  # noqa: E501
        """判断Pull Request是否已经合并  # noqa: E501

        判断Pull Request是否已经合并  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_number_merge(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_repo_pulls_number_merge_with_http_info(owner, repo, number,
                                                                                  **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_repo_pulls_number_merge_with_http_info(owner, repo, number,
                                                                                    **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_repo_pulls_number_merge_with_http_info(self, owner, repo, number, **kwargs):  # noqa: E501
        """判断Pull Request是否已经合并  # noqa: E501

        判断Pull Request是否已经合并  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_number_merge_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_repo_pulls_number_merge" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_repo_pulls_number_merge`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_v5_repos_owner_repo_pulls_number_merge`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `get_v5_repos_owner_repo_pulls_number_merge`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/merge', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_repo_pulls_number_operate_logs(self, owner, repo, number, **kwargs):  # noqa: E501
        """获取某个Pull Request的操作日志  # noqa: E501

        获取某个Pull Request的操作日志  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_number_operate_logs(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token: 用户授权码
        :param str sort: 按递增(asc)或递减(desc)排序，默认：递减
        :return: OperateLog
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_repo_pulls_number_operate_logs_with_http_info(owner, repo, number,
                                                                                         **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_repo_pulls_number_operate_logs_with_http_info(owner, repo, number,
                                                                                           **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_repo_pulls_number_operate_logs_with_http_info(self, owner, repo, number,
                                                                         **kwargs):  # noqa: E501
        """获取某个Pull Request的操作日志  # noqa: E501

        获取某个Pull Request的操作日志  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_pulls_number_operate_logs_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token: 用户授权码
        :param str sort: 按递增(asc)或递减(desc)排序，默认：递减
        :return: OperateLog
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'access_token', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_repo_pulls_number_operate_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_repo_pulls_number_operate_logs`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_v5_repos_owner_repo_pulls_number_operate_logs`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `get_v5_repos_owner_repo_pulls_number_operate_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/operate_logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OperateLog',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_v5_repos_owner_repo_pulls_comments_id(self, access_token, body, owner, repo, id, **kwargs):  # noqa: E501
        """编辑评论  # noqa: E501

        编辑评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_repos_owner_repo_pulls_comments_id(access_token, body, owner, repo, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: (required)
        :param str body: (required)
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int id: 评论的ID (required)
        :return: PullRequestComments
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_v5_repos_owner_repo_pulls_comments_id_with_http_info(access_token, body, owner, repo, id,
                                                                                   **kwargs)  # noqa: E501
        else:
            (data) = self.patch_v5_repos_owner_repo_pulls_comments_id_with_http_info(access_token, body, owner, repo,
                                                                                     id, **kwargs)  # noqa: E501
            return data

    def patch_v5_repos_owner_repo_pulls_comments_id_with_http_info(self, access_token, body, owner, repo, id,
                                                                   **kwargs):  # noqa: E501
        """编辑评论  # noqa: E501

        编辑评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_repos_owner_repo_pulls_comments_id_with_http_info(access_token, body, owner, repo, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: (required)
        :param str body: (required)
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int id: 评论的ID (required)
        :return: PullRequestComments
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_token', 'body', 'owner', 'repo', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_v5_repos_owner_repo_pulls_comments_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'access_token' is set
        if ('access_token' not in params or
                params['access_token'] is None):
            raise ValueError(
                "Missing the required parameter `access_token` when calling `patch_v5_repos_owner_repo_pulls_comments_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `patch_v5_repos_owner_repo_pulls_comments_id`")  # noqa: E501
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `patch_v5_repos_owner_repo_pulls_comments_id`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `patch_v5_repos_owner_repo_pulls_comments_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError(
                "Missing the required parameter `id` when calling `patch_v5_repos_owner_repo_pulls_comments_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'access_token' in params:
            form_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'body' in params:
            form_params.append(('body', params['body']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/comments/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PullRequestComments',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_v5_repos_owner_repo_pulls_number(self, owner, repo, number, **kwargs):  # noqa: E501
        """更新Pull Request信息  # noqa: E501

        更新Pull Request信息  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_repos_owner_repo_pulls_number(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token:
        :param str title:
        :param str body:
        :param str state:
        :param int milestone_number:
        :param str labels:
        :param int assignees_number:
        :param int testers_number:
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_v5_repos_owner_repo_pulls_number_with_http_info(owner, repo, number,
                                                                              **kwargs)  # noqa: E501
        else:
            (data) = self.patch_v5_repos_owner_repo_pulls_number_with_http_info(owner, repo, number,
                                                                                **kwargs)  # noqa: E501
            return data

    def patch_v5_repos_owner_repo_pulls_number_with_http_info(self, owner, repo, number, **kwargs):  # noqa: E501
        """更新Pull Request信息  # noqa: E501

        更新Pull Request信息  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_repos_owner_repo_pulls_number_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token:
        :param str title:
        :param str body:
        :param str state:
        :param int milestone_number:
        :param str labels:
        :param int assignees_number:
        :param int testers_number:
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'access_token', 'title', 'body', 'state', 'milestone_number', 'labels',
                      'assignees_number', 'testers_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_v5_repos_owner_repo_pulls_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `patch_v5_repos_owner_repo_pulls_number`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `patch_v5_repos_owner_repo_pulls_number`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `patch_v5_repos_owner_repo_pulls_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'access_token' in params:
            form_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'title' in params:
            form_params.append(('title', params['title']))  # noqa: E501
        if 'body' in params:
            form_params.append(('body', params['body']))  # noqa: E501
        if 'state' in params:
            form_params.append(('state', params['state']))  # noqa: E501
        if 'milestone_number' in params:
            form_params.append(('milestone_number', params['milestone_number']))  # noqa: E501
        if 'labels' in params:
            form_params.append(('labels', params['labels']))  # noqa: E501
        if 'assignees_number' in params:
            form_params.append(('assignees_number', params['assignees_number']))  # noqa: E501
        if 'testers_number' in params:
            form_params.append(('testers_number', params['testers_number']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PullRequest',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_v5_repos_owner_repo_pulls_number_assignees(self, owner, repo, number, **kwargs):  # noqa: E501
        """重置 Pull Request 审查 的状态  # noqa: E501

        重置 Pull Request 审查 的状态  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_repos_owner_repo_pulls_number_assignees(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token:
        :param bool reset_all:
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_v5_repos_owner_repo_pulls_number_assignees_with_http_info(owner, repo, number,
                                                                                        **kwargs)  # noqa: E501
        else:
            (data) = self.patch_v5_repos_owner_repo_pulls_number_assignees_with_http_info(owner, repo, number,
                                                                                          **kwargs)  # noqa: E501
            return data

    def patch_v5_repos_owner_repo_pulls_number_assignees_with_http_info(self, owner, repo, number,
                                                                        **kwargs):  # noqa: E501
        """重置 Pull Request 审查 的状态  # noqa: E501

        重置 Pull Request 审查 的状态  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_repos_owner_repo_pulls_number_assignees_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token:
        :param bool reset_all:
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'access_token', 'reset_all']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_v5_repos_owner_repo_pulls_number_assignees" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `patch_v5_repos_owner_repo_pulls_number_assignees`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `patch_v5_repos_owner_repo_pulls_number_assignees`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `patch_v5_repos_owner_repo_pulls_number_assignees`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'access_token' in params:
            form_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'reset_all' in params:
            form_params.append(('reset_all', params['reset_all']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/assignees', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PullRequest',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_v5_repos_owner_repo_pulls_number_testers(self, owner, repo, number, **kwargs):  # noqa: E501
        """重置 Pull Request 测试 的状态  # noqa: E501

        重置 Pull Request 测试 的状态  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_repos_owner_repo_pulls_number_testers(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token:
        :param bool reset_all:
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_v5_repos_owner_repo_pulls_number_testers_with_http_info(owner, repo, number,
                                                                                      **kwargs)  # noqa: E501
        else:
            (data) = self.patch_v5_repos_owner_repo_pulls_number_testers_with_http_info(owner, repo, number,
                                                                                        **kwargs)  # noqa: E501
            return data

    def patch_v5_repos_owner_repo_pulls_number_testers_with_http_info(self, owner, repo, number,
                                                                      **kwargs):  # noqa: E501
        """重置 Pull Request 测试 的状态  # noqa: E501

        重置 Pull Request 测试 的状态  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_repos_owner_repo_pulls_number_testers_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param str access_token:
        :param bool reset_all:
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'access_token', 'reset_all']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_v5_repos_owner_repo_pulls_number_testers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `patch_v5_repos_owner_repo_pulls_number_testers`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `patch_v5_repos_owner_repo_pulls_number_testers`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `patch_v5_repos_owner_repo_pulls_number_testers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'access_token' in params:
            form_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'reset_all' in params:
            form_params.append(('reset_all', params['reset_all']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/testers', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PullRequest',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v5_repos_owner_repo_pulls(self, body, owner, repo, **kwargs):  # noqa: E501
        """创建Pull Request  # noqa: E501

        创建Pull Request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_repo_pulls(body, owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body25 body: (required)
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v5_repos_owner_repo_pulls_with_http_info(body, owner, repo, **kwargs)  # noqa: E501
        else:
            (data) = self.post_v5_repos_owner_repo_pulls_with_http_info(body, owner, repo, **kwargs)  # noqa: E501
            return data

    def post_v5_repos_owner_repo_pulls_with_http_info(self, body, owner, repo, **kwargs):  # noqa: E501
        """创建Pull Request  # noqa: E501

        创建Pull Request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_repo_pulls_with_http_info(body, owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body25 body: (required)
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'owner', 'repo']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v5_repos_owner_repo_pulls" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `post_v5_repos_owner_repo_pulls`")  # noqa: E501
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `post_v5_repos_owner_repo_pulls`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `post_v5_repos_owner_repo_pulls`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PullRequest',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v5_repos_owner_repo_pulls_number_assignees(self, body, owner, repo, number, **kwargs):  # noqa: E501
        """指派用户审查 Pull Request  # noqa: E501

        指派用户审查 Pull Request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_repo_pulls_number_assignees(body, owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body30 body: (required)
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v5_repos_owner_repo_pulls_number_assignees_with_http_info(body, owner, repo, number,
                                                                                       **kwargs)  # noqa: E501
        else:
            (data) = self.post_v5_repos_owner_repo_pulls_number_assignees_with_http_info(body, owner, repo, number,
                                                                                         **kwargs)  # noqa: E501
            return data

    def post_v5_repos_owner_repo_pulls_number_assignees_with_http_info(self, body, owner, repo, number,
                                                                       **kwargs):  # noqa: E501
        """指派用户审查 Pull Request  # noqa: E501

        指派用户审查 Pull Request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_repo_pulls_number_assignees_with_http_info(body, owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body30 body: (required)
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'owner', 'repo', 'number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v5_repos_owner_repo_pulls_number_assignees" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `post_v5_repos_owner_repo_pulls_number_assignees`")  # noqa: E501
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `post_v5_repos_owner_repo_pulls_number_assignees`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `post_v5_repos_owner_repo_pulls_number_assignees`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `post_v5_repos_owner_repo_pulls_number_assignees`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/assignees', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PullRequest',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v5_repos_owner_repo_pulls_number_comments(self, body, owner, repo, number, **kwargs):  # noqa: E501
        """提交Pull Request评论  # noqa: E501

        提交Pull Request评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_repo_pulls_number_comments(body, owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body34 body: (required)
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :return: PullRequestComments
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v5_repos_owner_repo_pulls_number_comments_with_http_info(body, owner, repo, number,
                                                                                      **kwargs)  # noqa: E501
        else:
            (data) = self.post_v5_repos_owner_repo_pulls_number_comments_with_http_info(body, owner, repo, number,
                                                                                        **kwargs)  # noqa: E501
            return data

    def post_v5_repos_owner_repo_pulls_number_comments_with_http_info(self, body, owner, repo, number,
                                                                      **kwargs):  # noqa: E501
        """提交Pull Request评论  # noqa: E501

        提交Pull Request评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_repo_pulls_number_comments_with_http_info(body, owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body34 body: (required)
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :return: PullRequestComments
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'owner', 'repo', 'number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v5_repos_owner_repo_pulls_number_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `post_v5_repos_owner_repo_pulls_number_comments`")  # noqa: E501
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `post_v5_repos_owner_repo_pulls_number_comments`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `post_v5_repos_owner_repo_pulls_number_comments`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `post_v5_repos_owner_repo_pulls_number_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/comments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PullRequestComments',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v5_repos_owner_repo_pulls_number_labels(self, owner, repo, number, **kwargs):  # noqa: E501
        """创建 Pull Request 标签  # noqa: E501

        创建 Pull Request 标签  需要在请求的 body 里填上数组，元素为标签的名字。如: [\"performance\", \"bug\"]  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_repo_pulls_number_labels(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param Body36 body:
        :return: Label
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v5_repos_owner_repo_pulls_number_labels_with_http_info(owner, repo, number,
                                                                                    **kwargs)  # noqa: E501
        else:
            (data) = self.post_v5_repos_owner_repo_pulls_number_labels_with_http_info(owner, repo, number,
                                                                                      **kwargs)  # noqa: E501
            return data

    def post_v5_repos_owner_repo_pulls_number_labels_with_http_info(self, owner, repo, number, **kwargs):  # noqa: E501
        """创建 Pull Request 标签  # noqa: E501

        创建 Pull Request 标签  需要在请求的 body 里填上数组，元素为标签的名字。如: [\"performance\", \"bug\"]  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_repo_pulls_number_labels_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param Body36 body:
        :return: Label
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v5_repos_owner_repo_pulls_number_labels" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `post_v5_repos_owner_repo_pulls_number_labels`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `post_v5_repos_owner_repo_pulls_number_labels`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `post_v5_repos_owner_repo_pulls_number_labels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Label',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v5_repos_owner_repo_pulls_number_review(self, owner, repo, number, **kwargs):  # noqa: E501
        """处理 Pull Request 审查  # noqa: E501

        处理 Pull Request 审查  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_repo_pulls_number_review(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param Body28 body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v5_repos_owner_repo_pulls_number_review_with_http_info(owner, repo, number,
                                                                                    **kwargs)  # noqa: E501
        else:
            (data) = self.post_v5_repos_owner_repo_pulls_number_review_with_http_info(owner, repo, number,
                                                                                      **kwargs)  # noqa: E501
            return data

    def post_v5_repos_owner_repo_pulls_number_review_with_http_info(self, owner, repo, number, **kwargs):  # noqa: E501
        """处理 Pull Request 审查  # noqa: E501

        处理 Pull Request 审查  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_repo_pulls_number_review_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param Body28 body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v5_repos_owner_repo_pulls_number_review" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `post_v5_repos_owner_repo_pulls_number_review`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `post_v5_repos_owner_repo_pulls_number_review`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `post_v5_repos_owner_repo_pulls_number_review`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/review', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v5_repos_owner_repo_pulls_number_test(self, owner, repo, number, **kwargs):  # noqa: E501
        """处理 Pull Request 测试  # noqa: E501

        处理 Pull Request 测试  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_repo_pulls_number_test(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param Body29 body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v5_repos_owner_repo_pulls_number_test_with_http_info(owner, repo, number,
                                                                                  **kwargs)  # noqa: E501
        else:
            (data) = self.post_v5_repos_owner_repo_pulls_number_test_with_http_info(owner, repo, number,
                                                                                    **kwargs)  # noqa: E501
            return data

    def post_v5_repos_owner_repo_pulls_number_test_with_http_info(self, owner, repo, number, **kwargs):  # noqa: E501
        """处理 Pull Request 测试  # noqa: E501

        处理 Pull Request 测试  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_repo_pulls_number_test_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param Body29 body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v5_repos_owner_repo_pulls_number_test" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `post_v5_repos_owner_repo_pulls_number_test`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `post_v5_repos_owner_repo_pulls_number_test`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `post_v5_repos_owner_repo_pulls_number_test`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/test', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v5_repos_owner_repo_pulls_number_testers(self, body, owner, repo, number, **kwargs):  # noqa: E501
        """指派用户测试 Pull Request  # noqa: E501

        指派用户测试 Pull Request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_repo_pulls_number_testers(body, owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body32 body: (required)
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v5_repos_owner_repo_pulls_number_testers_with_http_info(body, owner, repo, number,
                                                                                     **kwargs)  # noqa: E501
        else:
            (data) = self.post_v5_repos_owner_repo_pulls_number_testers_with_http_info(body, owner, repo, number,
                                                                                       **kwargs)  # noqa: E501
            return data

    def post_v5_repos_owner_repo_pulls_number_testers_with_http_info(self, body, owner, repo, number,
                                                                     **kwargs):  # noqa: E501
        """指派用户测试 Pull Request  # noqa: E501

        指派用户测试 Pull Request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_repo_pulls_number_testers_with_http_info(body, owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body32 body: (required)
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :return: PullRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'owner', 'repo', 'number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v5_repos_owner_repo_pulls_number_testers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `post_v5_repos_owner_repo_pulls_number_testers`")  # noqa: E501
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `post_v5_repos_owner_repo_pulls_number_testers`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `post_v5_repos_owner_repo_pulls_number_testers`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `post_v5_repos_owner_repo_pulls_number_testers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/testers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PullRequest',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_v5_repos_owner_repo_pulls_number_labels(self, owner, repo, number, **kwargs):  # noqa: E501
        """替换 Pull Request 所有标签  # noqa: E501

        替换 Pull Request 所有标签  需要在请求的body里填上数组，元素为标签的名字。如: [\"performance\", \"bug\"]  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_v5_repos_owner_repo_pulls_number_labels(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param Body35 body:
        :return: Label
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_v5_repos_owner_repo_pulls_number_labels_with_http_info(owner, repo, number,
                                                                                   **kwargs)  # noqa: E501
        else:
            (data) = self.put_v5_repos_owner_repo_pulls_number_labels_with_http_info(owner, repo, number,
                                                                                     **kwargs)  # noqa: E501
            return data

    def put_v5_repos_owner_repo_pulls_number_labels_with_http_info(self, owner, repo, number, **kwargs):  # noqa: E501
        """替换 Pull Request 所有标签  # noqa: E501

        替换 Pull Request 所有标签  需要在请求的body里填上数组，元素为标签的名字。如: [\"performance\", \"bug\"]  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_v5_repos_owner_repo_pulls_number_labels_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param Body35 body:
        :return: Label
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_v5_repos_owner_repo_pulls_number_labels" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `put_v5_repos_owner_repo_pulls_number_labels`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `put_v5_repos_owner_repo_pulls_number_labels`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `put_v5_repos_owner_repo_pulls_number_labels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/labels', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Label',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_v5_repos_owner_repo_pulls_number_merge(self, owner, repo, number, **kwargs):  # noqa: E501
        """合并Pull Request  # noqa: E501

        合并Pull Request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_v5_repos_owner_repo_pulls_number_merge(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param Body27 body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_v5_repos_owner_repo_pulls_number_merge_with_http_info(owner, repo, number,
                                                                                  **kwargs)  # noqa: E501
        else:
            (data) = self.put_v5_repos_owner_repo_pulls_number_merge_with_http_info(owner, repo, number,
                                                                                    **kwargs)  # noqa: E501
            return data

    def put_v5_repos_owner_repo_pulls_number_merge_with_http_info(self, owner, repo, number, **kwargs):  # noqa: E501
        """合并Pull Request  # noqa: E501

        合并Pull Request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_v5_repos_owner_repo_pulls_number_merge_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int number: 第几个PR，即本仓库PR的序数 (required)
        :param Body27 body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_v5_repos_owner_repo_pulls_number_merge" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `put_v5_repos_owner_repo_pulls_number_merge`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `put_v5_repos_owner_repo_pulls_number_merge`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `put_v5_repos_owner_repo_pulls_number_merge`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/pulls/{number}/merge', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
