# coding: utf-8


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from gitee.api_client import ApiClient


class OrganizationsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_v5_orgs_org_memberships_username(self, org, username, **kwargs):  # noqa: E501
        """移除授权用户所管理组织中的成员  # noqa: E501

        移除授权用户所管理组织中的成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_orgs_org_memberships_username(org, username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str username: 用户名(username/login) (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_v5_orgs_org_memberships_username_with_http_info(org, username, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_v5_orgs_org_memberships_username_with_http_info(org, username, **kwargs)  # noqa: E501
            return data

    def delete_v5_orgs_org_memberships_username_with_http_info(self, org, username, **kwargs):  # noqa: E501
        """移除授权用户所管理组织中的成员  # noqa: E501

        移除授权用户所管理组织中的成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_orgs_org_memberships_username_with_http_info(org, username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str username: 用户名(username/login) (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'username', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_v5_orgs_org_memberships_username" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if ('org' not in params or
                params['org'] is None):
            raise ValueError(
                "Missing the required parameter `org` when calling `delete_v5_orgs_org_memberships_username`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError(
                "Missing the required parameter `username` when calling `delete_v5_orgs_org_memberships_username`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'username' in params:
            path_params['username'] = params['username']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/orgs/{org}/memberships/{username}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_v5_user_memberships_orgs_org(self, org, **kwargs):  # noqa: E501
        """退出一个组织  # noqa: E501

        退出一个组织  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_user_memberships_orgs_org(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_v5_user_memberships_orgs_org_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_v5_user_memberships_orgs_org_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def delete_v5_user_memberships_orgs_org_with_http_info(self, org, **kwargs):  # noqa: E501
        """退出一个组织  # noqa: E501

        退出一个组织  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_user_memberships_orgs_org_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_v5_user_memberships_orgs_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if ('org' not in params or
                params['org'] is None):
            raise ValueError(
                "Missing the required parameter `org` when calling `delete_v5_user_memberships_orgs_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/user/memberships/orgs/{org}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_orgs_org(self, org, **kwargs):  # noqa: E501
        """获取一个组织  # noqa: E501

        获取一个组织  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_orgs_org(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str access_token: 用户授权码
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_orgs_org_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_orgs_org_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def get_v5_orgs_org_with_http_info(self, org, **kwargs):  # noqa: E501
        """获取一个组织  # noqa: E501

        获取一个组织  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_orgs_org_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str access_token: 用户授权码
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_orgs_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if ('org' not in params or
                params['org'] is None):
            raise ValueError("Missing the required parameter `org` when calling `get_v5_orgs_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/orgs/{org}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Group',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_orgs_org_followers(self, org, **kwargs):  # noqa: E501
        """列出指定组织的所有关注者  # noqa: E501

        列出指定组织的所有关注者  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_orgs_org_followers(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[GroupFollowers]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_orgs_org_followers_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_orgs_org_followers_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def get_v5_orgs_org_followers_with_http_info(self, org, **kwargs):  # noqa: E501
        """列出指定组织的所有关注者  # noqa: E501

        列出指定组织的所有关注者  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_orgs_org_followers_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[GroupFollowers]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'access_token', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_orgs_org_followers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if ('org' not in params or
                params['org'] is None):
            raise ValueError(
                "Missing the required parameter `org` when calling `get_v5_orgs_org_followers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/orgs/{org}/followers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GroupFollowers]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_orgs_org_members(self, org, **kwargs):  # noqa: E501
        """列出一个组织的所有成员  # noqa: E501

        列出一个组织的所有成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_orgs_org_members(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param str role: 根据角色筛选成员
        :return: list[UserBasic]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_orgs_org_members_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_orgs_org_members_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def get_v5_orgs_org_members_with_http_info(self, org, **kwargs):  # noqa: E501
        """列出一个组织的所有成员  # noqa: E501

        列出一个组织的所有成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_orgs_org_members_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param str role: 根据角色筛选成员
        :return: list[UserBasic]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'access_token', 'page', 'per_page', 'role']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_orgs_org_members" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if ('org' not in params or
                params['org'] is None):
            raise ValueError(
                "Missing the required parameter `org` when calling `get_v5_orgs_org_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'role' in params:
            query_params.append(('role', params['role']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/orgs/{org}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[UserBasic]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_orgs_org_memberships_username(self, org, username, **kwargs):  # noqa: E501
        """获取授权用户所属组织的一个成员  # noqa: E501

        获取授权用户所属组织的一个成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_orgs_org_memberships_username(org, username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str username: 用户名(username/login) (required)
        :param str access_token: 用户授权码
        :return: GroupMember
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_orgs_org_memberships_username_with_http_info(org, username, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_orgs_org_memberships_username_with_http_info(org, username, **kwargs)  # noqa: E501
            return data

    def get_v5_orgs_org_memberships_username_with_http_info(self, org, username, **kwargs):  # noqa: E501
        """获取授权用户所属组织的一个成员  # noqa: E501

        获取授权用户所属组织的一个成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_orgs_org_memberships_username_with_http_info(org, username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str username: 用户名(username/login) (required)
        :param str access_token: 用户授权码
        :return: GroupMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'username', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_orgs_org_memberships_username" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if ('org' not in params or
                params['org'] is None):
            raise ValueError(
                "Missing the required parameter `org` when calling `get_v5_orgs_org_memberships_username`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError(
                "Missing the required parameter `username` when calling `get_v5_orgs_org_memberships_username`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'username' in params:
            path_params['username'] = params['username']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/orgs/{org}/memberships/{username}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_user_memberships_orgs(self, **kwargs):  # noqa: E501
        """列出授权用户在所属组织的成员资料  # noqa: E501

        列出授权用户在所属组织的成员资料  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_user_memberships_orgs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: 用户授权码
        :param bool active: 根据成员是否已激活进行筛选资料，缺省返回所有资料
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[GroupMember]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_user_memberships_orgs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_user_memberships_orgs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_v5_user_memberships_orgs_with_http_info(self, **kwargs):  # noqa: E501
        """列出授权用户在所属组织的成员资料  # noqa: E501

        列出授权用户在所属组织的成员资料  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_user_memberships_orgs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: 用户授权码
        :param bool active: 根据成员是否已激活进行筛选资料，缺省返回所有资料
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[GroupMember]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_token', 'active', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_user_memberships_orgs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'active' in params:
            query_params.append(('active', params['active']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/user/memberships/orgs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GroupMember]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_user_memberships_orgs_org(self, org, **kwargs):  # noqa: E501
        """获取授权用户在一个组织的成员资料  # noqa: E501

        获取授权用户在一个组织的成员资料  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_user_memberships_orgs_org(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str access_token: 用户授权码
        :return: GroupMember
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_user_memberships_orgs_org_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_user_memberships_orgs_org_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def get_v5_user_memberships_orgs_org_with_http_info(self, org, **kwargs):  # noqa: E501
        """获取授权用户在一个组织的成员资料  # noqa: E501

        获取授权用户在一个组织的成员资料  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_user_memberships_orgs_org_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str access_token: 用户授权码
        :return: GroupMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_user_memberships_orgs_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if ('org' not in params or
                params['org'] is None):
            raise ValueError(
                "Missing the required parameter `org` when calling `get_v5_user_memberships_orgs_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/user/memberships/orgs/{org}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_user_orgs(self, **kwargs):  # noqa: E501
        """列出授权用户所属的组织  # noqa: E501

        列出授权用户所属的组织  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_user_orgs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param bool admin: 只列出授权用户管理的组织
        :return: list[Group]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_user_orgs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_user_orgs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_v5_user_orgs_with_http_info(self, **kwargs):  # noqa: E501
        """列出授权用户所属的组织  # noqa: E501

        列出授权用户所属的组织  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_user_orgs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param bool admin: 只列出授权用户管理的组织
        :return: list[Group]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_token', 'page', 'per_page', 'admin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_user_orgs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'admin' in params:
            query_params.append(('admin', params['admin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/user/orgs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Group]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_users_username_orgs(self, username, **kwargs):  # noqa: E501
        """列出用户所属的组织  # noqa: E501

        列出用户所属的组织  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_users_username_orgs(username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: 用户名(username/login) (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[Group]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_users_username_orgs_with_http_info(username, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_users_username_orgs_with_http_info(username, **kwargs)  # noqa: E501
            return data

    def get_v5_users_username_orgs_with_http_info(self, username, **kwargs):  # noqa: E501
        """列出用户所属的组织  # noqa: E501

        列出用户所属的组织  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_users_username_orgs_with_http_info(username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: 用户名(username/login) (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[Group]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'access_token', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_users_username_orgs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError(
                "Missing the required parameter `username` when calling `get_v5_users_username_orgs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'username' in params:
            path_params['username'] = params['username']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/users/{username}/orgs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Group]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_v5_orgs_org(self, org, **kwargs):  # noqa: E501
        """更新授权用户所管理的组织资料  # noqa: E501

        更新授权用户所管理的组织资料  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_orgs_org(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str access_token:
        :param str email:
        :param str location:
        :param str name:
        :param str description:
        :param str html_url:
        :return: GroupDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_v5_orgs_org_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_v5_orgs_org_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def patch_v5_orgs_org_with_http_info(self, org, **kwargs):  # noqa: E501
        """更新授权用户所管理的组织资料  # noqa: E501

        更新授权用户所管理的组织资料  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_orgs_org_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str access_token:
        :param str email:
        :param str location:
        :param str name:
        :param str description:
        :param str html_url:
        :return: GroupDetail
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'access_token', 'email', 'location', 'name', 'description', 'html_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_v5_orgs_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if ('org' not in params or
                params['org'] is None):
            raise ValueError("Missing the required parameter `org` when calling `patch_v5_orgs_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'access_token' in params:
            form_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'email' in params:
            form_params.append(('email', params['email']))  # noqa: E501
        if 'location' in params:
            form_params.append(('location', params['location']))  # noqa: E501
        if 'name' in params:
            form_params.append(('name', params['name']))  # noqa: E501
        if 'description' in params:
            form_params.append(('description', params['description']))  # noqa: E501
        if 'html_url' in params:
            form_params.append(('html_url', params['html_url']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/orgs/{org}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_v5_user_memberships_orgs_org(self, org, **kwargs):  # noqa: E501
        """更新授权用户在一个组织的成员资料  # noqa: E501

        更新授权用户在一个组织的成员资料  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_user_memberships_orgs_org(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str access_token:
        :param str remark:
        :return: GroupMember
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_v5_user_memberships_orgs_org_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_v5_user_memberships_orgs_org_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def patch_v5_user_memberships_orgs_org_with_http_info(self, org, **kwargs):  # noqa: E501
        """更新授权用户在一个组织的成员资料  # noqa: E501

        更新授权用户在一个组织的成员资料  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_user_memberships_orgs_org_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str access_token:
        :param str remark:
        :return: GroupMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'access_token', 'remark']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_v5_user_memberships_orgs_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if ('org' not in params or
                params['org'] is None):
            raise ValueError(
                "Missing the required parameter `org` when calling `patch_v5_user_memberships_orgs_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'access_token' in params:
            form_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'remark' in params:
            form_params.append(('remark', params['remark']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/user/memberships/orgs/{org}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v5_users_organization(self, body, **kwargs):  # noqa: E501
        """创建组织  # noqa: E501

        创建组织  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_users_organization(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body57 body: (required)
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v5_users_organization_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_v5_users_organization_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_v5_users_organization_with_http_info(self, body, **kwargs):  # noqa: E501
        """创建组织  # noqa: E501

        创建组织  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_users_organization_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body57 body: (required)
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v5_users_organization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `post_v5_users_organization`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/users/organization', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Group',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_v5_orgs_org_memberships_username(self, org, username, **kwargs):  # noqa: E501
        """增加或更新授权用户所管理组织的成员  # noqa: E501

        增加或更新授权用户所管理组织的成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_v5_orgs_org_memberships_username(org, username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str username: 用户名(username/login) (required)
        :param Body60 body:
        :return: GroupMember
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_v5_orgs_org_memberships_username_with_http_info(org, username, **kwargs)  # noqa: E501
        else:
            (data) = self.put_v5_orgs_org_memberships_username_with_http_info(org, username, **kwargs)  # noqa: E501
            return data

    def put_v5_orgs_org_memberships_username_with_http_info(self, org, username, **kwargs):  # noqa: E501
        """增加或更新授权用户所管理组织的成员  # noqa: E501

        增加或更新授权用户所管理组织的成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_v5_orgs_org_memberships_username_with_http_info(org, username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str username: 用户名(username/login) (required)
        :param Body60 body:
        :return: GroupMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'username', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_v5_orgs_org_memberships_username" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if ('org' not in params or
                params['org'] is None):
            raise ValueError(
                "Missing the required parameter `org` when calling `put_v5_orgs_org_memberships_username`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError(
                "Missing the required parameter `username` when calling `put_v5_orgs_org_memberships_username`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'username' in params:
            path_params['username'] = params['username']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/orgs/{org}/memberships/{username}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
