# coding: utf-8


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from gitee.api_client import ApiClient


class IssuesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_v5_repos_owner_repo_issues_comments_id(self, owner, repo, id, **kwargs):  # noqa: E501
        """删除Issue某条评论  # noqa: E501

        删除Issue某条评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_repos_owner_repo_issues_comments_id(owner, repo, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int id: 评论的ID (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_v5_repos_owner_repo_issues_comments_id_with_http_info(owner, repo, id,
                                                                                     **kwargs)  # noqa: E501
        else:
            (data) = self.delete_v5_repos_owner_repo_issues_comments_id_with_http_info(owner, repo, id,
                                                                                       **kwargs)  # noqa: E501
            return data

    def delete_v5_repos_owner_repo_issues_comments_id_with_http_info(self, owner, repo, id, **kwargs):  # noqa: E501
        """删除Issue某条评论  # noqa: E501

        删除Issue某条评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_repos_owner_repo_issues_comments_id_with_http_info(owner, repo, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int id: 评论的ID (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'id', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_v5_repos_owner_repo_issues_comments_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `delete_v5_repos_owner_repo_issues_comments_id`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `delete_v5_repos_owner_repo_issues_comments_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError(
                "Missing the required parameter `id` when calling `delete_v5_repos_owner_repo_issues_comments_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/issues/comments/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_enterprises_enterprise_issues(self, enterprise, **kwargs):  # noqa: E501
        """获取某个企业的所有Issues  # noqa: E501

        获取某个企业的所有Issues  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_issues(enterprise, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str access_token: 用户授权码
        :param str state: Issue的状态: open（开启的）, progressing(进行中), closed（关闭的）, rejected（拒绝的）。 默认: open
        :param str labels: 用逗号分开的标签。如: bug,performance
        :param str sort: 排序依据: 创建时间(created)，更新时间(updated_at)。默认: created_at
        :param str direction: 排序方式: 升序(asc)，降序(desc)。默认: desc
        :param str since: 起始的更新时间，要求时间格式为 ISO 8601
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param str schedule: 计划开始日期，格式：20181006T173008+80-20181007T173008+80（区间），或者 -20181007T173008+80（小于20181007T173008+80），或者 20181006T173008+80-（大于20181006T173008+80），要求时间格式为20181006T173008+80
        :param str deadline: 计划截止日期，格式同上
        :param str created_at: 任务创建时间，格式同上
        :param str finished_at: 任务完成时间，即任务最后一次转为已完成状态的时间点。格式同上
        :param str milestone: 根据里程碑标题。none为没里程碑的，*为所有带里程碑的
        :param str assignee: 用户的username。 none为没指派者, *为所有带有指派者的
        :param str creator: 创建Issues的用户username
        :param str program: 所属项目名称。none为没所属有项目的，*为所有带所属项目的
        :return: list[Issue]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_enterprises_enterprise_issues_with_http_info(enterprise, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_enterprises_enterprise_issues_with_http_info(enterprise, **kwargs)  # noqa: E501
            return data

    def get_v5_enterprises_enterprise_issues_with_http_info(self, enterprise, **kwargs):  # noqa: E501
        """获取某个企业的所有Issues  # noqa: E501

        获取某个企业的所有Issues  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_issues_with_http_info(enterprise, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str access_token: 用户授权码
        :param str state: Issue的状态: open（开启的）, progressing(进行中), closed（关闭的）, rejected（拒绝的）。 默认: open
        :param str labels: 用逗号分开的标签。如: bug,performance
        :param str sort: 排序依据: 创建时间(created)，更新时间(updated_at)。默认: created_at
        :param str direction: 排序方式: 升序(asc)，降序(desc)。默认: desc
        :param str since: 起始的更新时间，要求时间格式为 ISO 8601
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param str schedule: 计划开始日期，格式：20181006T173008+80-20181007T173008+80（区间），或者 -20181007T173008+80（小于20181007T173008+80），或者 20181006T173008+80-（大于20181006T173008+80），要求时间格式为20181006T173008+80
        :param str deadline: 计划截止日期，格式同上
        :param str created_at: 任务创建时间，格式同上
        :param str finished_at: 任务完成时间，即任务最后一次转为已完成状态的时间点。格式同上
        :param str milestone: 根据里程碑标题。none为没里程碑的，*为所有带里程碑的
        :param str assignee: 用户的username。 none为没指派者, *为所有带有指派者的
        :param str creator: 创建Issues的用户username
        :param str program: 所属项目名称。none为没所属有项目的，*为所有带所属项目的
        :return: list[Issue]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enterprise', 'access_token', 'state', 'labels', 'sort', 'direction', 'since', 'page', 'per_page',
                      'schedule', 'deadline', 'created_at', 'finished_at', 'milestone', 'assignee', 'creator',
                      'program']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_enterprises_enterprise_issues" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `get_v5_enterprises_enterprise_issues`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'labels' in params:
            query_params.append(('labels', params['labels']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'direction' in params:
            query_params.append(('direction', params['direction']))  # noqa: E501
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'schedule' in params:
            query_params.append(('schedule', params['schedule']))  # noqa: E501
        if 'deadline' in params:
            query_params.append(('deadline', params['deadline']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('created_at', params['created_at']))  # noqa: E501
        if 'finished_at' in params:
            query_params.append(('finished_at', params['finished_at']))  # noqa: E501
        if 'milestone' in params:
            query_params.append(('milestone', params['milestone']))  # noqa: E501
        if 'assignee' in params:
            query_params.append(('assignee', params['assignee']))  # noqa: E501
        if 'creator' in params:
            query_params.append(('creator', params['creator']))  # noqa: E501
        if 'program' in params:
            query_params.append(('program', params['program']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/issues', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Issue]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_enterprises_enterprise_issues_number(self, enterprise, number, **kwargs):  # noqa: E501
        """获取企业的某个Issue  # noqa: E501

        获取企业的某个Issue  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_issues_number(enterprise, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str number: Issue 编号(区分大小写，无需添加 # 号) (required)
        :param str access_token: 用户授权码
        :return: Issue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_enterprises_enterprise_issues_number_with_http_info(enterprise, number,
                                                                                   **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_enterprises_enterprise_issues_number_with_http_info(enterprise, number,
                                                                                     **kwargs)  # noqa: E501
            return data

    def get_v5_enterprises_enterprise_issues_number_with_http_info(self, enterprise, number, **kwargs):  # noqa: E501
        """获取企业的某个Issue  # noqa: E501

        获取企业的某个Issue  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_issues_number_with_http_info(enterprise, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str number: Issue 编号(区分大小写，无需添加 # 号) (required)
        :param str access_token: 用户授权码
        :return: Issue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enterprise', 'number', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_enterprises_enterprise_issues_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `get_v5_enterprises_enterprise_issues_number`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `get_v5_enterprises_enterprise_issues_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/issues/{number}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Issue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_enterprises_enterprise_issues_number_comments(self, enterprise, number, **kwargs):  # noqa: E501
        """获取企业某个Issue所有评论  # noqa: E501

        获取企业某个Issue所有评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_issues_number_comments(enterprise, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str number: Issue 编号(区分大小写，无需添加 # 号) (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[Note]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_enterprises_enterprise_issues_number_comments_with_http_info(enterprise, number,
                                                                                            **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_enterprises_enterprise_issues_number_comments_with_http_info(enterprise, number,
                                                                                              **kwargs)  # noqa: E501
            return data

    def get_v5_enterprises_enterprise_issues_number_comments_with_http_info(self, enterprise, number,
                                                                            **kwargs):  # noqa: E501
        """获取企业某个Issue所有评论  # noqa: E501

        获取企业某个Issue所有评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_issues_number_comments_with_http_info(enterprise, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str number: Issue 编号(区分大小写，无需添加 # 号) (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[Note]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enterprise', 'number', 'access_token', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_enterprises_enterprise_issues_number_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `get_v5_enterprises_enterprise_issues_number_comments`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `get_v5_enterprises_enterprise_issues_number_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/issues/{number}/comments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Note]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_enterprises_enterprise_issues_number_labels(self, enterprise, number, **kwargs):  # noqa: E501
        """获取企业某个Issue所有标签  # noqa: E501

        获取企业某个Issue所有标签  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_issues_number_labels(enterprise, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str number: Issue 编号(区分大小写，无需添加 # 号) (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[Label]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_enterprises_enterprise_issues_number_labels_with_http_info(enterprise, number,
                                                                                          **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_enterprises_enterprise_issues_number_labels_with_http_info(enterprise, number,
                                                                                            **kwargs)  # noqa: E501
            return data

    def get_v5_enterprises_enterprise_issues_number_labels_with_http_info(self, enterprise, number,
                                                                          **kwargs):  # noqa: E501
        """获取企业某个Issue所有标签  # noqa: E501

        获取企业某个Issue所有标签  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_issues_number_labels_with_http_info(enterprise, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str number: Issue 编号(区分大小写，无需添加 # 号) (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[Label]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enterprise', 'number', 'access_token', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_enterprises_enterprise_issues_number_labels" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `get_v5_enterprises_enterprise_issues_number_labels`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `get_v5_enterprises_enterprise_issues_number_labels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/issues/{number}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Label]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_issues(self, **kwargs):  # noqa: E501
        """获取当前授权用户的所有Issues  # noqa: E501

        获取当前授权用户的所有Issues  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_issues(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: 用户授权码
        :param str filter: 筛选参数: 授权用户负责的(assigned)，授权用户创建的(created)，包含前两者的(all)。默认: assigned
        :param str state: Issue的状态: open（开启的）, progressing(进行中), closed（关闭的）, rejected（拒绝的）。 默认: open
        :param str labels: 用逗号分开的标签。如: bug,performance
        :param str sort: 排序依据: 创建时间(created)，更新时间(updated_at)。默认: created_at
        :param str direction: 排序方式: 升序(asc)，降序(desc)。默认: desc
        :param str since: 起始的更新时间，要求时间格式为 ISO 8601
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param str schedule: 计划开始日期，格式：20181006T173008+80-20181007T173008+80（区间），或者 -20181007T173008+80（小于20181007T173008+80），或者 20181006T173008+80-（大于20181006T173008+80），要求时间格式为20181006T173008+80
        :param str deadline: 计划截止日期，格式同上
        :param str created_at: 任务创建时间，格式同上
        :param str finished_at: 任务完成时间，即任务最后一次转为已完成状态的时间点。格式同上
        :return: list[Issue]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_issues_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_issues_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_v5_issues_with_http_info(self, **kwargs):  # noqa: E501
        """获取当前授权用户的所有Issues  # noqa: E501

        获取当前授权用户的所有Issues  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_issues_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: 用户授权码
        :param str filter: 筛选参数: 授权用户负责的(assigned)，授权用户创建的(created)，包含前两者的(all)。默认: assigned
        :param str state: Issue的状态: open（开启的）, progressing(进行中), closed（关闭的）, rejected（拒绝的）。 默认: open
        :param str labels: 用逗号分开的标签。如: bug,performance
        :param str sort: 排序依据: 创建时间(created)，更新时间(updated_at)。默认: created_at
        :param str direction: 排序方式: 升序(asc)，降序(desc)。默认: desc
        :param str since: 起始的更新时间，要求时间格式为 ISO 8601
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param str schedule: 计划开始日期，格式：20181006T173008+80-20181007T173008+80（区间），或者 -20181007T173008+80（小于20181007T173008+80），或者 20181006T173008+80-（大于20181006T173008+80），要求时间格式为20181006T173008+80
        :param str deadline: 计划截止日期，格式同上
        :param str created_at: 任务创建时间，格式同上
        :param str finished_at: 任务完成时间，即任务最后一次转为已完成状态的时间点。格式同上
        :return: list[Issue]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_token', 'filter', 'state', 'labels', 'sort', 'direction', 'since', 'page', 'per_page',
                      'schedule', 'deadline', 'created_at', 'finished_at']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_issues" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'labels' in params:
            query_params.append(('labels', params['labels']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'direction' in params:
            query_params.append(('direction', params['direction']))  # noqa: E501
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'schedule' in params:
            query_params.append(('schedule', params['schedule']))  # noqa: E501
        if 'deadline' in params:
            query_params.append(('deadline', params['deadline']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('created_at', params['created_at']))  # noqa: E501
        if 'finished_at' in params:
            query_params.append(('finished_at', params['finished_at']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/issues', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Issue]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_orgs_org_issues(self, org, **kwargs):  # noqa: E501
        """获取当前用户某个组织的Issues  # noqa: E501

        获取当前用户某个组织的Issues  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_orgs_org_issues(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str access_token: 用户授权码
        :param str filter: 筛选参数: 授权用户负责的(assigned)，授权用户创建的(created)，包含前两者的(all)。默认: assigned
        :param str state: Issue的状态: open（开启的）, progressing(进行中), closed（关闭的）, rejected（拒绝的）。 默认: open
        :param str labels: 用逗号分开的标签。如: bug,performance
        :param str sort: 排序依据: 创建时间(created)，更新时间(updated_at)。默认: created_at
        :param str direction: 排序方式: 升序(asc)，降序(desc)。默认: desc
        :param str since: 起始的更新时间，要求时间格式为 ISO 8601
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param str schedule: 计划开始日期，格式：20181006T173008+80-20181007T173008+80（区间），或者 -20181007T173008+80（小于20181007T173008+80），或者 20181006T173008+80-（大于20181006T173008+80），要求时间格式为20181006T173008+80
        :param str deadline: 计划截止日期，格式同上
        :param str created_at: 任务创建时间，格式同上
        :param str finished_at: 任务完成时间，即任务最后一次转为已完成状态的时间点。格式同上
        :return: list[Issue]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_orgs_org_issues_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_orgs_org_issues_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def get_v5_orgs_org_issues_with_http_info(self, org, **kwargs):  # noqa: E501
        """获取当前用户某个组织的Issues  # noqa: E501

        获取当前用户某个组织的Issues  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_orgs_org_issues_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: 组织的路径(path/login) (required)
        :param str access_token: 用户授权码
        :param str filter: 筛选参数: 授权用户负责的(assigned)，授权用户创建的(created)，包含前两者的(all)。默认: assigned
        :param str state: Issue的状态: open（开启的）, progressing(进行中), closed（关闭的）, rejected（拒绝的）。 默认: open
        :param str labels: 用逗号分开的标签。如: bug,performance
        :param str sort: 排序依据: 创建时间(created)，更新时间(updated_at)。默认: created_at
        :param str direction: 排序方式: 升序(asc)，降序(desc)。默认: desc
        :param str since: 起始的更新时间，要求时间格式为 ISO 8601
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param str schedule: 计划开始日期，格式：20181006T173008+80-20181007T173008+80（区间），或者 -20181007T173008+80（小于20181007T173008+80），或者 20181006T173008+80-（大于20181006T173008+80），要求时间格式为20181006T173008+80
        :param str deadline: 计划截止日期，格式同上
        :param str created_at: 任务创建时间，格式同上
        :param str finished_at: 任务完成时间，即任务最后一次转为已完成状态的时间点。格式同上
        :return: list[Issue]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'access_token', 'filter', 'state', 'labels', 'sort', 'direction', 'since', 'page',
                      'per_page', 'schedule', 'deadline', 'created_at', 'finished_at']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_orgs_org_issues" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if ('org' not in params or
                params['org'] is None):
            raise ValueError("Missing the required parameter `org` when calling `get_v5_orgs_org_issues`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'labels' in params:
            query_params.append(('labels', params['labels']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'direction' in params:
            query_params.append(('direction', params['direction']))  # noqa: E501
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'schedule' in params:
            query_params.append(('schedule', params['schedule']))  # noqa: E501
        if 'deadline' in params:
            query_params.append(('deadline', params['deadline']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('created_at', params['created_at']))  # noqa: E501
        if 'finished_at' in params:
            query_params.append(('finished_at', params['finished_at']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/orgs/{org}/issues', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Issue]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_issues_number_operate_logs(self, owner, number, **kwargs):  # noqa: E501
        """获取某个Issue下的操作日志  # noqa: E501

        获取某个Issue下的操作日志  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_issues_number_operate_logs(owner, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str number: Issue 编号(区分大小写，无需添加 # 号) (required)
        :param str access_token: 用户授权码
        :param str repo: 仓库路径(path)
        :param str sort: 按递增(asc)或递减(desc)排序，默认：递减
        :return: list[OperateLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_issues_number_operate_logs_with_http_info(owner, number,
                                                                                     **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_issues_number_operate_logs_with_http_info(owner, number,
                                                                                       **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_issues_number_operate_logs_with_http_info(self, owner, number, **kwargs):  # noqa: E501
        """获取某个Issue下的操作日志  # noqa: E501

        获取某个Issue下的操作日志  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_issues_number_operate_logs_with_http_info(owner, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str number: Issue 编号(区分大小写，无需添加 # 号) (required)
        :param str access_token: 用户授权码
        :param str repo: 仓库路径(path)
        :param str sort: 按递增(asc)或递减(desc)排序，默认：递减
        :return: list[OperateLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'number', 'access_token', 'repo', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_issues_number_operate_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_issues_number_operate_logs`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `get_v5_repos_owner_issues_number_operate_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'repo' in params:
            query_params.append(('repo', params['repo']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/issues/{number}/operate_logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OperateLog]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_repo_issues(self, owner, repo, **kwargs):  # noqa: E501
        """仓库的所有Issues  # noqa: E501

        仓库的所有Issues  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_issues(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param str access_token: 用户授权码
        :param str state: Issue的状态: open（开启的）, progressing(进行中), closed（关闭的）, rejected（拒绝的）。 默认: open
        :param str labels: 用逗号分开的标签。如: bug,performance
        :param str sort: 排序依据: 创建时间(created)，更新时间(updated_at)。默认: created_at
        :param str direction: 排序方式: 升序(asc)，降序(desc)。默认: desc
        :param str since: 起始的更新时间，要求时间格式为 ISO 8601
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param str schedule: 计划开始日期，格式：20181006T173008+80-20181007T173008+80（区间），或者 -20181007T173008+80（小于20181007T173008+80），或者 20181006T173008+80-（大于20181006T173008+80），要求时间格式为20181006T173008+80
        :param str deadline: 计划截止日期，格式同上
        :param str created_at: 任务创建时间，格式同上
        :param str finished_at: 任务完成时间，即任务最后一次转为已完成状态的时间点。格式同上
        :param str milestone: 根据里程碑标题。none为没里程碑的，*为所有带里程碑的
        :param str assignee: 用户的username。 none为没指派者, *为所有带有指派者的
        :param str creator: 创建Issues的用户username
        :param str program: 所属项目名称。none为没有所属项目，*为所有带所属项目的
        :return: list[Issue]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_repo_issues_with_http_info(owner, repo, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_repo_issues_with_http_info(owner, repo, **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_repo_issues_with_http_info(self, owner, repo, **kwargs):  # noqa: E501
        """仓库的所有Issues  # noqa: E501

        仓库的所有Issues  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_issues_with_http_info(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param str access_token: 用户授权码
        :param str state: Issue的状态: open（开启的）, progressing(进行中), closed（关闭的）, rejected（拒绝的）。 默认: open
        :param str labels: 用逗号分开的标签。如: bug,performance
        :param str sort: 排序依据: 创建时间(created)，更新时间(updated_at)。默认: created_at
        :param str direction: 排序方式: 升序(asc)，降序(desc)。默认: desc
        :param str since: 起始的更新时间，要求时间格式为 ISO 8601
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param str schedule: 计划开始日期，格式：20181006T173008+80-20181007T173008+80（区间），或者 -20181007T173008+80（小于20181007T173008+80），或者 20181006T173008+80-（大于20181006T173008+80），要求时间格式为20181006T173008+80
        :param str deadline: 计划截止日期，格式同上
        :param str created_at: 任务创建时间，格式同上
        :param str finished_at: 任务完成时间，即任务最后一次转为已完成状态的时间点。格式同上
        :param str milestone: 根据里程碑标题。none为没里程碑的，*为所有带里程碑的
        :param str assignee: 用户的username。 none为没指派者, *为所有带有指派者的
        :param str creator: 创建Issues的用户username
        :param str program: 所属项目名称。none为没有所属项目，*为所有带所属项目的
        :return: list[Issue]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'access_token', 'state', 'labels', 'sort', 'direction', 'since', 'page',
                      'per_page', 'schedule', 'deadline', 'created_at', 'finished_at', 'milestone', 'assignee',
                      'creator', 'program']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_repo_issues" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_repo_issues`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_v5_repos_owner_repo_issues`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'labels' in params:
            query_params.append(('labels', params['labels']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'direction' in params:
            query_params.append(('direction', params['direction']))  # noqa: E501
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'schedule' in params:
            query_params.append(('schedule', params['schedule']))  # noqa: E501
        if 'deadline' in params:
            query_params.append(('deadline', params['deadline']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('created_at', params['created_at']))  # noqa: E501
        if 'finished_at' in params:
            query_params.append(('finished_at', params['finished_at']))  # noqa: E501
        if 'milestone' in params:
            query_params.append(('milestone', params['milestone']))  # noqa: E501
        if 'assignee' in params:
            query_params.append(('assignee', params['assignee']))  # noqa: E501
        if 'creator' in params:
            query_params.append(('creator', params['creator']))  # noqa: E501
        if 'program' in params:
            query_params.append(('program', params['program']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/issues', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Issue]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_repo_issues_comments(self, owner, repo, **kwargs):  # noqa: E501
        """获取仓库所有Issue的评论  # noqa: E501

        获取仓库所有Issue的评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_issues_comments(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param str access_token: 用户授权码
        :param str sort: Either created or updated. Default: created
        :param str direction: Either asc or desc. Ignored without the sort parameter.
        :param str since: Only comments updated at or after this time are returned.                                               This is a timestamp in ISO 8601 format: YYYY-MM-DDTHH:MM:SSZ
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_repo_issues_comments_with_http_info(owner, repo, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_repo_issues_comments_with_http_info(owner, repo, **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_repo_issues_comments_with_http_info(self, owner, repo, **kwargs):  # noqa: E501
        """获取仓库所有Issue的评论  # noqa: E501

        获取仓库所有Issue的评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_issues_comments_with_http_info(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param str access_token: 用户授权码
        :param str sort: Either created or updated. Default: created
        :param str direction: Either asc or desc. Ignored without the sort parameter.
        :param str since: Only comments updated at or after this time are returned.                                               This is a timestamp in ISO 8601 format: YYYY-MM-DDTHH:MM:SSZ
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'access_token', 'sort', 'direction', 'since', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_repo_issues_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_repo_issues_comments`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_v5_repos_owner_repo_issues_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'direction' in params:
            query_params.append(('direction', params['direction']))  # noqa: E501
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/issues/comments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Note',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_repo_issues_comments_id(self, owner, repo, id, **kwargs):  # noqa: E501
        """获取仓库Issue某条评论  # noqa: E501

        获取仓库Issue某条评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_issues_comments_id(owner, repo, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int id: 评论的ID (required)
        :param str access_token: 用户授权码
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_repo_issues_comments_id_with_http_info(owner, repo, id,
                                                                                  **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_repo_issues_comments_id_with_http_info(owner, repo, id,
                                                                                    **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_repo_issues_comments_id_with_http_info(self, owner, repo, id, **kwargs):  # noqa: E501
        """获取仓库Issue某条评论  # noqa: E501

        获取仓库Issue某条评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_issues_comments_id_with_http_info(owner, repo, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int id: 评论的ID (required)
        :param str access_token: 用户授权码
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'id', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_repo_issues_comments_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_repo_issues_comments_id`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_v5_repos_owner_repo_issues_comments_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError(
                "Missing the required parameter `id` when calling `get_v5_repos_owner_repo_issues_comments_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/issues/comments/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Note',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_repo_issues_number(self, owner, repo, number, **kwargs):  # noqa: E501
        """仓库的某个Issue  # noqa: E501

        仓库的某个Issue  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_issues_number(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param str number: Issue 编号(区分大小写，无需添加 # 号) (required)
        :param str access_token: 用户授权码
        :return: Issue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_repo_issues_number_with_http_info(owner, repo, number,
                                                                             **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_repo_issues_number_with_http_info(owner, repo, number,
                                                                               **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_repo_issues_number_with_http_info(self, owner, repo, number, **kwargs):  # noqa: E501
        """仓库的某个Issue  # noqa: E501

        仓库的某个Issue  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_issues_number_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param str number: Issue 编号(区分大小写，无需添加 # 号) (required)
        :param str access_token: 用户授权码
        :return: Issue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_repo_issues_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_repo_issues_number`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_v5_repos_owner_repo_issues_number`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `get_v5_repos_owner_repo_issues_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/issues/{number}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Issue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_repos_owner_repo_issues_number_comments(self, owner, repo, number, **kwargs):  # noqa: E501
        """获取仓库某个Issue所有的评论  # noqa: E501

        获取仓库某个Issue所有的评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_issues_number_comments(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param str number: Issue 编号(区分大小写，无需添加 # 号) (required)
        :param str access_token: 用户授权码
        :param str since: Only comments updated at or after this time are returned.                                               This is a timestamp in ISO 8601 format: YYYY-MM-DDTHH:MM:SSZ
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param str order: 排序顺序: asc(default),desc
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_repos_owner_repo_issues_number_comments_with_http_info(owner, repo, number,
                                                                                      **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_repos_owner_repo_issues_number_comments_with_http_info(owner, repo, number,
                                                                                        **kwargs)  # noqa: E501
            return data

    def get_v5_repos_owner_repo_issues_number_comments_with_http_info(self, owner, repo, number,
                                                                      **kwargs):  # noqa: E501
        """获取仓库某个Issue所有的评论  # noqa: E501

        获取仓库某个Issue所有的评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_repos_owner_repo_issues_number_comments_with_http_info(owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param str number: Issue 编号(区分大小写，无需添加 # 号) (required)
        :param str access_token: 用户授权码
        :param str since: Only comments updated at or after this time are returned.                                               This is a timestamp in ISO 8601 format: YYYY-MM-DDTHH:MM:SSZ
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param str order: 排序顺序: asc(default),desc
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'number', 'access_token', 'since', 'page', 'per_page', 'order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_repos_owner_repo_issues_number_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `get_v5_repos_owner_repo_issues_number_comments`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `get_v5_repos_owner_repo_issues_number_comments`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `get_v5_repos_owner_repo_issues_number_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/issues/{number}/comments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Note',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_user_issues(self, **kwargs):  # noqa: E501
        """获取授权用户的所有Issues  # noqa: E501

        获取授权用户的所有Issues  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_user_issues(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: 用户授权码
        :param str filter: 筛选参数: 授权用户负责的(assigned)，授权用户创建的(created)，包含前两者的(all)。默认: assigned
        :param str state: Issue的状态: open（开启的）, progressing(进行中), closed（关闭的）, rejected（拒绝的）。 默认: open
        :param str labels: 用逗号分开的标签。如: bug,performance
        :param str sort: 排序依据: 创建时间(created)，更新时间(updated_at)。默认: created_at
        :param str direction: 排序方式: 升序(asc)，降序(desc)。默认: desc
        :param str since: 起始的更新时间，要求时间格式为 ISO 8601
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param str schedule: 计划开始日期，格式：20181006T173008+80-20181007T173008+80（区间），或者 -20181007T173008+80（小于20181007T173008+80），或者 20181006T173008+80-（大于20181006T173008+80），要求时间格式为20181006T173008+80
        :param str deadline: 计划截止日期，格式同上
        :param str created_at: 任务创建时间，格式同上
        :param str finished_at: 任务完成时间，即任务最后一次转为已完成状态的时间点。格式同上
        :return: list[Issue]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_user_issues_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_user_issues_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_v5_user_issues_with_http_info(self, **kwargs):  # noqa: E501
        """获取授权用户的所有Issues  # noqa: E501

        获取授权用户的所有Issues  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_user_issues_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: 用户授权码
        :param str filter: 筛选参数: 授权用户负责的(assigned)，授权用户创建的(created)，包含前两者的(all)。默认: assigned
        :param str state: Issue的状态: open（开启的）, progressing(进行中), closed（关闭的）, rejected（拒绝的）。 默认: open
        :param str labels: 用逗号分开的标签。如: bug,performance
        :param str sort: 排序依据: 创建时间(created)，更新时间(updated_at)。默认: created_at
        :param str direction: 排序方式: 升序(asc)，降序(desc)。默认: desc
        :param str since: 起始的更新时间，要求时间格式为 ISO 8601
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param str schedule: 计划开始日期，格式：20181006T173008+80-20181007T173008+80（区间），或者 -20181007T173008+80（小于20181007T173008+80），或者 20181006T173008+80-（大于20181006T173008+80），要求时间格式为20181006T173008+80
        :param str deadline: 计划截止日期，格式同上
        :param str created_at: 任务创建时间，格式同上
        :param str finished_at: 任务完成时间，即任务最后一次转为已完成状态的时间点。格式同上
        :return: list[Issue]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_token', 'filter', 'state', 'labels', 'sort', 'direction', 'since', 'page', 'per_page',
                      'schedule', 'deadline', 'created_at', 'finished_at']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_user_issues" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'labels' in params:
            query_params.append(('labels', params['labels']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'direction' in params:
            query_params.append(('direction', params['direction']))  # noqa: E501
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'schedule' in params:
            query_params.append(('schedule', params['schedule']))  # noqa: E501
        if 'deadline' in params:
            query_params.append(('deadline', params['deadline']))  # noqa: E501
        if 'created_at' in params:
            query_params.append(('created_at', params['created_at']))  # noqa: E501
        if 'finished_at' in params:
            query_params.append(('finished_at', params['finished_at']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/user/issues', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Issue]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_v5_repos_owner_issues_number(self, owner, number, **kwargs):  # noqa: E501
        """更新Issue  # noqa: E501

        更新Issue  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_repos_owner_issues_number(owner, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str number: Issue 编号(区分大小写，无需添加 # 号) (required)
        :param str access_token:
        :param str repo:
        :param str title:
        :param str state:
        :param str body:
        :param str assignee:
        :param str collaborators:
        :param int milestone:
        :param str labels:
        :param str program:
        :param bool security_hole:
        :return: Issue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_v5_repos_owner_issues_number_with_http_info(owner, number, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_v5_repos_owner_issues_number_with_http_info(owner, number, **kwargs)  # noqa: E501
            return data

    def patch_v5_repos_owner_issues_number_with_http_info(self, owner, number, **kwargs):  # noqa: E501
        """更新Issue  # noqa: E501

        更新Issue  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_repos_owner_issues_number_with_http_info(owner, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str number: Issue 编号(区分大小写，无需添加 # 号) (required)
        :param str access_token:
        :param str repo:
        :param str title:
        :param str state:
        :param str body:
        :param str assignee:
        :param str collaborators:
        :param int milestone:
        :param str labels:
        :param str program:
        :param bool security_hole:
        :return: Issue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'number', 'access_token', 'repo', 'title', 'state', 'body', 'assignee', 'collaborators',
                      'milestone', 'labels', 'program', 'security_hole']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_v5_repos_owner_issues_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `patch_v5_repos_owner_issues_number`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `patch_v5_repos_owner_issues_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'access_token' in params:
            form_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'repo' in params:
            form_params.append(('repo', params['repo']))  # noqa: E501
        if 'title' in params:
            form_params.append(('title', params['title']))  # noqa: E501
        if 'state' in params:
            form_params.append(('state', params['state']))  # noqa: E501
        if 'body' in params:
            form_params.append(('body', params['body']))  # noqa: E501
        if 'assignee' in params:
            form_params.append(('assignee', params['assignee']))  # noqa: E501
        if 'collaborators' in params:
            form_params.append(('collaborators', params['collaborators']))  # noqa: E501
        if 'milestone' in params:
            form_params.append(('milestone', params['milestone']))  # noqa: E501
        if 'labels' in params:
            form_params.append(('labels', params['labels']))  # noqa: E501
        if 'program' in params:
            form_params.append(('program', params['program']))  # noqa: E501
        if 'security_hole' in params:
            form_params.append(('security_hole', params['security_hole']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/issues/{number}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Issue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_v5_repos_owner_repo_issues_comments_id(self, access_token, body, owner, repo, id, **kwargs):  # noqa: E501
        """更新Issue某条评论  # noqa: E501

        更新Issue某条评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_repos_owner_repo_issues_comments_id(access_token, body, owner, repo, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: (required)
        :param str body: (required)
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int id: 评论的ID (required)
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_v5_repos_owner_repo_issues_comments_id_with_http_info(access_token, body, owner, repo, id,
                                                                                    **kwargs)  # noqa: E501
        else:
            (data) = self.patch_v5_repos_owner_repo_issues_comments_id_with_http_info(access_token, body, owner, repo,
                                                                                      id, **kwargs)  # noqa: E501
            return data

    def patch_v5_repos_owner_repo_issues_comments_id_with_http_info(self, access_token, body, owner, repo, id,
                                                                    **kwargs):  # noqa: E501
        """更新Issue某条评论  # noqa: E501

        更新Issue某条评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_repos_owner_repo_issues_comments_id_with_http_info(access_token, body, owner, repo, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: (required)
        :param str body: (required)
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param int id: 评论的ID (required)
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_token', 'body', 'owner', 'repo', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_v5_repos_owner_repo_issues_comments_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'access_token' is set
        if ('access_token' not in params or
                params['access_token'] is None):
            raise ValueError(
                "Missing the required parameter `access_token` when calling `patch_v5_repos_owner_repo_issues_comments_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `patch_v5_repos_owner_repo_issues_comments_id`")  # noqa: E501
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `patch_v5_repos_owner_repo_issues_comments_id`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `patch_v5_repos_owner_repo_issues_comments_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError(
                "Missing the required parameter `id` when calling `patch_v5_repos_owner_repo_issues_comments_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'access_token' in params:
            form_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'body' in params:
            form_params.append(('body', params['body']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/issues/comments/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Note',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v5_repos_owner_issues(self, body, owner, **kwargs):  # noqa: E501
        """创建Issue  # noqa: E501

        创建Issue  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_issues(body, owner, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body6 body: (required)
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :return: Issue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v5_repos_owner_issues_with_http_info(body, owner, **kwargs)  # noqa: E501
        else:
            (data) = self.post_v5_repos_owner_issues_with_http_info(body, owner, **kwargs)  # noqa: E501
            return data

    def post_v5_repos_owner_issues_with_http_info(self, body, owner, **kwargs):  # noqa: E501
        """创建Issue  # noqa: E501

        创建Issue  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_issues_with_http_info(body, owner, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body6 body: (required)
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :return: Issue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'owner']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v5_repos_owner_issues" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `post_v5_repos_owner_issues`")  # noqa: E501
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `post_v5_repos_owner_issues`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/issues', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Issue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v5_repos_owner_repo_issues_number_comments(self, body, owner, repo, number, **kwargs):  # noqa: E501
        """创建某个Issue评论  # noqa: E501

        创建某个Issue评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_repo_issues_number_comments(body, owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body16 body: (required)
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param str number: Issue 编号(区分大小写，无需添加 # 号) (required)
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v5_repos_owner_repo_issues_number_comments_with_http_info(body, owner, repo, number,
                                                                                       **kwargs)  # noqa: E501
        else:
            (data) = self.post_v5_repos_owner_repo_issues_number_comments_with_http_info(body, owner, repo, number,
                                                                                         **kwargs)  # noqa: E501
            return data

    def post_v5_repos_owner_repo_issues_number_comments_with_http_info(self, body, owner, repo, number,
                                                                       **kwargs):  # noqa: E501
        """创建某个Issue评论  # noqa: E501

        创建某个Issue评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_repos_owner_repo_issues_number_comments_with_http_info(body, owner, repo, number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body16 body: (required)
        :param str owner: 仓库所属空间地址(企业、组织或个人的地址path) (required)
        :param str repo: 仓库路径(path) (required)
        :param str number: Issue 编号(区分大小写，无需添加 # 号) (required)
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'owner', 'repo', 'number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v5_repos_owner_repo_issues_number_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `post_v5_repos_owner_repo_issues_number_comments`")  # noqa: E501
        # verify the required parameter 'owner' is set
        if ('owner' not in params or
                params['owner'] is None):
            raise ValueError(
                "Missing the required parameter `owner` when calling `post_v5_repos_owner_repo_issues_number_comments`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if ('repo' not in params or
                params['repo'] is None):
            raise ValueError(
                "Missing the required parameter `repo` when calling `post_v5_repos_owner_repo_issues_number_comments`")  # noqa: E501
        # verify the required parameter 'number' is set
        if ('number' not in params or
                params['number'] is None):
            raise ValueError(
                "Missing the required parameter `number` when calling `post_v5_repos_owner_repo_issues_number_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'number' in params:
            path_params['number'] = params['number']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/repos/{owner}/{repo}/issues/{number}/comments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Note',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
