# coding: utf-8


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from gitee.api_client import ApiClient


class GistsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_v5_gists_gist_id_comments_id(self, gist_id, id, **kwargs):  # noqa: E501
        """删除代码片段的评论  # noqa: E501

        删除代码片段的评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_gists_gist_id_comments_id(gist_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str gist_id: 代码片段的ID (required)
        :param int id: 评论的ID (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_v5_gists_gist_id_comments_id_with_http_info(gist_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_v5_gists_gist_id_comments_id_with_http_info(gist_id, id, **kwargs)  # noqa: E501
            return data

    def delete_v5_gists_gist_id_comments_id_with_http_info(self, gist_id, id, **kwargs):  # noqa: E501
        """删除代码片段的评论  # noqa: E501

        删除代码片段的评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_gists_gist_id_comments_id_with_http_info(gist_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str gist_id: 代码片段的ID (required)
        :param int id: 评论的ID (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gist_id', 'id', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_v5_gists_gist_id_comments_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gist_id' is set
        if ('gist_id' not in params or
                params['gist_id'] is None):
            raise ValueError(
                "Missing the required parameter `gist_id` when calling `delete_v5_gists_gist_id_comments_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError(
                "Missing the required parameter `id` when calling `delete_v5_gists_gist_id_comments_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'gist_id' in params:
            path_params['gist_id'] = params['gist_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists/{gist_id}/comments/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_v5_gists_id(self, id, **kwargs):  # noqa: E501
        """删除指定代码片段  # noqa: E501

        删除指定代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_gists_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_v5_gists_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_v5_gists_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_v5_gists_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """删除指定代码片段  # noqa: E501

        删除指定代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_gists_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_v5_gists_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_v5_gists_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_v5_gists_id_star(self, id, **kwargs):  # noqa: E501
        """取消Star代码片段  # noqa: E501

        取消Star代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_gists_id_star(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_v5_gists_id_star_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_v5_gists_id_star_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_v5_gists_id_star_with_http_info(self, id, **kwargs):  # noqa: E501
        """取消Star代码片段  # noqa: E501

        取消Star代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_gists_id_star_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_v5_gists_id_star" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_v5_gists_id_star`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists/{id}/star', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_gists(self, **kwargs):  # noqa: E501
        """获取代码片段  # noqa: E501

        获取代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_gists(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: 用户授权码
        :param str since: 起始的更新时间，要求时间格式为 ISO 8601
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[Code]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_gists_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_gists_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_v5_gists_with_http_info(self, **kwargs):  # noqa: E501
        """获取代码片段  # noqa: E501

        获取代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_gists_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: 用户授权码
        :param str since: 起始的更新时间，要求时间格式为 ISO 8601
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[Code]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_token', 'since', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_gists" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Code]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_gists_gist_id_comments(self, gist_id, **kwargs):  # noqa: E501
        """获取代码片段的评论  # noqa: E501

        获取代码片段的评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_gists_gist_id_comments(gist_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str gist_id: 代码片段的ID (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[CodeComment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_gists_gist_id_comments_with_http_info(gist_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_gists_gist_id_comments_with_http_info(gist_id, **kwargs)  # noqa: E501
            return data

    def get_v5_gists_gist_id_comments_with_http_info(self, gist_id, **kwargs):  # noqa: E501
        """获取代码片段的评论  # noqa: E501

        获取代码片段的评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_gists_gist_id_comments_with_http_info(gist_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str gist_id: 代码片段的ID (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[CodeComment]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gist_id', 'access_token', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_gists_gist_id_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gist_id' is set
        if ('gist_id' not in params or
                params['gist_id'] is None):
            raise ValueError(
                "Missing the required parameter `gist_id` when calling `get_v5_gists_gist_id_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'gist_id' in params:
            path_params['gist_id'] = params['gist_id']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists/{gist_id}/comments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CodeComment]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_gists_gist_id_comments_id(self, gist_id, id, **kwargs):  # noqa: E501
        """获取单条代码片段的评论  # noqa: E501

        获取单条代码片段的评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_gists_gist_id_comments_id(gist_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str gist_id: 代码片段的ID (required)
        :param int id: 评论的ID (required)
        :param str access_token: 用户授权码
        :return: CodeComment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_gists_gist_id_comments_id_with_http_info(gist_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_gists_gist_id_comments_id_with_http_info(gist_id, id, **kwargs)  # noqa: E501
            return data

    def get_v5_gists_gist_id_comments_id_with_http_info(self, gist_id, id, **kwargs):  # noqa: E501
        """获取单条代码片段的评论  # noqa: E501

        获取单条代码片段的评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_gists_gist_id_comments_id_with_http_info(gist_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str gist_id: 代码片段的ID (required)
        :param int id: 评论的ID (required)
        :param str access_token: 用户授权码
        :return: CodeComment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gist_id', 'id', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_gists_gist_id_comments_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gist_id' is set
        if ('gist_id' not in params or
                params['gist_id'] is None):
            raise ValueError(
                "Missing the required parameter `gist_id` when calling `get_v5_gists_gist_id_comments_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError(
                "Missing the required parameter `id` when calling `get_v5_gists_gist_id_comments_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'gist_id' in params:
            path_params['gist_id'] = params['gist_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists/{gist_id}/comments/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CodeComment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_gists_id(self, id, **kwargs):  # noqa: E501
        """获取单条代码片段  # noqa: E501

        获取单条代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_gists_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param str access_token: 用户授权码
        :return: CodeForksHistory
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_gists_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_gists_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_v5_gists_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """获取单条代码片段  # noqa: E501

        获取单条代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_gists_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param str access_token: 用户授权码
        :return: CodeForksHistory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_gists_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_v5_gists_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CodeForksHistory',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_gists_id_commits(self, id, **kwargs):  # noqa: E501
        """获取代码片段的commit  # noqa: E501

        获取代码片段的commit  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_gists_id_commits(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param str access_token: 用户授权码
        :return: CodeForksHistory
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_gists_id_commits_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_gists_id_commits_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_v5_gists_id_commits_with_http_info(self, id, **kwargs):  # noqa: E501
        """获取代码片段的commit  # noqa: E501

        获取代码片段的commit  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_gists_id_commits_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param str access_token: 用户授权码
        :return: CodeForksHistory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_gists_id_commits" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_v5_gists_id_commits`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists/{id}/commits', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CodeForksHistory',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_gists_id_forks(self, id, **kwargs):  # noqa: E501
        """获取 Fork 了指定代码片段的列表  # noqa: E501

        获取 Fork 了指定代码片段的列表  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_gists_id_forks(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: CodeForks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_gists_id_forks_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_gists_id_forks_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_v5_gists_id_forks_with_http_info(self, id, **kwargs):  # noqa: E501
        """获取 Fork 了指定代码片段的列表  # noqa: E501

        获取 Fork 了指定代码片段的列表  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_gists_id_forks_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: CodeForks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'access_token', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_gists_id_forks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_v5_gists_id_forks`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists/{id}/forks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CodeForks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_gists_id_star(self, id, **kwargs):  # noqa: E501
        """判断代码片段是否已Star  # noqa: E501

        判断代码片段是否已Star  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_gists_id_star(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_gists_id_star_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_gists_id_star_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_v5_gists_id_star_with_http_info(self, id, **kwargs):  # noqa: E501
        """判断代码片段是否已Star  # noqa: E501

        判断代码片段是否已Star  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_gists_id_star_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_gists_id_star" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_v5_gists_id_star`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists/{id}/star', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_gists_starred(self, **kwargs):  # noqa: E501
        """获取用户Star的代码片段  # noqa: E501

        获取用户Star的代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_gists_starred(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: 用户授权码
        :param str since: 起始的更新时间，要求时间格式为 ISO 8601
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[Code]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_gists_starred_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_gists_starred_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_v5_gists_starred_with_http_info(self, **kwargs):  # noqa: E501
        """获取用户Star的代码片段  # noqa: E501

        获取用户Star的代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_gists_starred_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: 用户授权码
        :param str since: 起始的更新时间，要求时间格式为 ISO 8601
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[Code]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_token', 'since', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_gists_starred" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists/starred', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Code]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_v5_gists_gist_id_comments_id(self, access_token, body, gist_id, id, **kwargs):  # noqa: E501
        """修改代码片段的评论  # noqa: E501

        修改代码片段的评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_gists_gist_id_comments_id(access_token, body, gist_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: (required)
        :param str body: (required)
        :param str gist_id: 代码片段的ID (required)
        :param int id: 评论的ID (required)
        :return: CodeComment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_v5_gists_gist_id_comments_id_with_http_info(access_token, body, gist_id, id,
                                                                          **kwargs)  # noqa: E501
        else:
            (data) = self.patch_v5_gists_gist_id_comments_id_with_http_info(access_token, body, gist_id, id,
                                                                            **kwargs)  # noqa: E501
            return data

    def patch_v5_gists_gist_id_comments_id_with_http_info(self, access_token, body, gist_id, id,
                                                          **kwargs):  # noqa: E501
        """修改代码片段的评论  # noqa: E501

        修改代码片段的评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_gists_gist_id_comments_id_with_http_info(access_token, body, gist_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: (required)
        :param str body: (required)
        :param str gist_id: 代码片段的ID (required)
        :param int id: 评论的ID (required)
        :return: CodeComment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_token', 'body', 'gist_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_v5_gists_gist_id_comments_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'access_token' is set
        if ('access_token' not in params or
                params['access_token'] is None):
            raise ValueError(
                "Missing the required parameter `access_token` when calling `patch_v5_gists_gist_id_comments_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `patch_v5_gists_gist_id_comments_id`")  # noqa: E501
        # verify the required parameter 'gist_id' is set
        if ('gist_id' not in params or
                params['gist_id'] is None):
            raise ValueError(
                "Missing the required parameter `gist_id` when calling `patch_v5_gists_gist_id_comments_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError(
                "Missing the required parameter `id` when calling `patch_v5_gists_gist_id_comments_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'gist_id' in params:
            path_params['gist_id'] = params['gist_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'access_token' in params:
            form_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'body' in params:
            form_params.append(('body', params['body']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists/{gist_id}/comments/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CodeComment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_v5_gists_id(self, id, **kwargs):  # noqa: E501
        """修改代码片段  # noqa: E501

        修改代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_gists_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param str access_token:
        :param object files:
        :param str description:
        :param bool public:
        :return: CodeForksHistory
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_v5_gists_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_v5_gists_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def patch_v5_gists_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """修改代码片段  # noqa: E501

        修改代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_gists_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param str access_token:
        :param object files:
        :param str description:
        :param bool public:
        :return: CodeForksHistory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'access_token', 'files', 'description', 'public']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_v5_gists_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_v5_gists_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'access_token' in params:
            form_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'files' in params:
            form_params.append(('files', params['files']))  # noqa: E501
        if 'description' in params:
            form_params.append(('description', params['description']))  # noqa: E501
        if 'public' in params:
            form_params.append(('public', params['public']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CodeForksHistory',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v5_gists(self, body, **kwargs):  # noqa: E501
        """创建代码片段  # noqa: E501

        创建代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_gists(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body51 body: (required)
        :return: list[CodeForksHistory]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v5_gists_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_v5_gists_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_v5_gists_with_http_info(self, body, **kwargs):  # noqa: E501
        """创建代码片段  # noqa: E501

        创建代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_gists_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body51 body: (required)
        :return: list[CodeForksHistory]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v5_gists" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_v5_gists`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CodeForksHistory]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v5_gists_gist_id_comments(self, body, gist_id, **kwargs):  # noqa: E501
        """增加代码片段的评论  # noqa: E501

        增加代码片段的评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_gists_gist_id_comments(body, gist_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body52 body: (required)
        :param str gist_id: 代码片段的ID (required)
        :return: CodeComment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v5_gists_gist_id_comments_with_http_info(body, gist_id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_v5_gists_gist_id_comments_with_http_info(body, gist_id, **kwargs)  # noqa: E501
            return data

    def post_v5_gists_gist_id_comments_with_http_info(self, body, gist_id, **kwargs):  # noqa: E501
        """增加代码片段的评论  # noqa: E501

        增加代码片段的评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_gists_gist_id_comments_with_http_info(body, gist_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body52 body: (required)
        :param str gist_id: 代码片段的ID (required)
        :return: CodeComment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'gist_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v5_gists_gist_id_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `post_v5_gists_gist_id_comments`")  # noqa: E501
        # verify the required parameter 'gist_id' is set
        if ('gist_id' not in params or
                params['gist_id'] is None):
            raise ValueError(
                "Missing the required parameter `gist_id` when calling `post_v5_gists_gist_id_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'gist_id' in params:
            path_params['gist_id'] = params['gist_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists/{gist_id}/comments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CodeComment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v5_gists_id_forks(self, id, **kwargs):  # noqa: E501
        """Fork代码片段  # noqa: E501

        Fork代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_gists_id_forks(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param Body56 body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v5_gists_id_forks_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_v5_gists_id_forks_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def post_v5_gists_id_forks_with_http_info(self, id, **kwargs):  # noqa: E501
        """Fork代码片段  # noqa: E501

        Fork代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_gists_id_forks_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param Body56 body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v5_gists_id_forks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `post_v5_gists_id_forks`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists/{id}/forks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_v5_gists_id_star(self, id, **kwargs):  # noqa: E501
        """Star代码片段  # noqa: E501

        Star代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_v5_gists_id_star(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param Body55 body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_v5_gists_id_star_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.put_v5_gists_id_star_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def put_v5_gists_id_star_with_http_info(self, id, **kwargs):  # noqa: E501
        """Star代码片段  # noqa: E501

        Star代码片段  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_v5_gists_id_star_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: 代码片段的ID (required)
        :param Body55 body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_v5_gists_id_star" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `put_v5_gists_id_star`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/gists/{id}/star', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
