# coding: utf-8


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from gitee.api_client import ApiClient


class EnterprisesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_v5_enterprises_enterprise_members_username(self, enterprise, username, **kwargs):  # noqa: E501
        """移除企业成员  # noqa: E501

        移除企业成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_enterprises_enterprise_members_username(enterprise, username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str username: 用户名(username/login) (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_v5_enterprises_enterprise_members_username_with_http_info(enterprise, username,
                                                                                         **kwargs)  # noqa: E501
        else:
            (data) = self.delete_v5_enterprises_enterprise_members_username_with_http_info(enterprise, username,
                                                                                           **kwargs)  # noqa: E501
            return data

    def delete_v5_enterprises_enterprise_members_username_with_http_info(self, enterprise, username,
                                                                         **kwargs):  # noqa: E501
        """移除企业成员  # noqa: E501

        移除企业成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_enterprises_enterprise_members_username_with_http_info(enterprise, username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str username: 用户名(username/login) (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enterprise', 'username', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_v5_enterprises_enterprise_members_username" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `delete_v5_enterprises_enterprise_members_username`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError(
                "Missing the required parameter `username` when calling `delete_v5_enterprises_enterprise_members_username`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501
        if 'username' in params:
            path_params['username'] = params['username']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/members/{username}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_v5_enterprises_enterprise_week_reports_report_id_comments_id(self, enterprise, report_id, id,
                                                                            **kwargs):  # noqa: E501
        """删除周报某个评论  # noqa: E501

        删除周报某个评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_enterprises_enterprise_week_reports_report_id_comments_id(enterprise, report_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param int report_id: 周报ID (required)
        :param int id: 评论ID (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_v5_enterprises_enterprise_week_reports_report_id_comments_id_with_http_info(enterprise,
                                                                                                           report_id,
                                                                                                           id,
                                                                                                           **kwargs)  # noqa: E501
        else:
            (data) = self.delete_v5_enterprises_enterprise_week_reports_report_id_comments_id_with_http_info(enterprise,
                                                                                                             report_id,
                                                                                                             id,
                                                                                                             **kwargs)  # noqa: E501
            return data

    def delete_v5_enterprises_enterprise_week_reports_report_id_comments_id_with_http_info(self, enterprise, report_id,
                                                                                           id, **kwargs):  # noqa: E501
        """删除周报某个评论  # noqa: E501

        删除周报某个评论  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_v5_enterprises_enterprise_week_reports_report_id_comments_id_with_http_info(enterprise, report_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param int report_id: 周报ID (required)
        :param int id: 评论ID (required)
        :param str access_token: 用户授权码
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enterprise', 'report_id', 'id', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_v5_enterprises_enterprise_week_reports_report_id_comments_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `delete_v5_enterprises_enterprise_week_reports_report_id_comments_id`")  # noqa: E501
        # verify the required parameter 'report_id' is set
        if ('report_id' not in params or
                params['report_id'] is None):
            raise ValueError(
                "Missing the required parameter `report_id` when calling `delete_v5_enterprises_enterprise_week_reports_report_id_comments_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError(
                "Missing the required parameter `id` when calling `delete_v5_enterprises_enterprise_week_reports_report_id_comments_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501
        if 'report_id' in params:
            path_params['report_id'] = params['report_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/week_reports/{report_id}/comments/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_enterprise_enterprise_pull_requests(self, enterprise, **kwargs):  # noqa: E501
        """企业Pull Reuqest 列表  # noqa: E501

        企业Pull Reuqest 列表  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprise_enterprise_pull_requests(enterprise, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str access_token: 用户授权码
        :param str issue_number: 可选。Issue 编号(区分大小写，无需添加 # 号)
        :param str repo: 可选。仓库路径(path)
        :param int program_id: 可选。项目ID
        :param str state: 可选。Pull Request 状态
        :param str head: 可选。Pull Request 提交的源分支。格式：branch 或者：username:branch
        :param str base: 可选。Pull Request 提交目标分支的名称。
        :param str sort: 可选。排序字段，默认按创建时间
        :param str direction: 可选。升序/降序
        :param int milestone_number: 可选。里程碑序号(id)
        :param str labels: 用逗号分开的标签。如: bug,performance
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[PullRequest]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_enterprise_enterprise_pull_requests_with_http_info(enterprise, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_enterprise_enterprise_pull_requests_with_http_info(enterprise, **kwargs)  # noqa: E501
            return data

    def get_v5_enterprise_enterprise_pull_requests_with_http_info(self, enterprise, **kwargs):  # noqa: E501
        """企业Pull Reuqest 列表  # noqa: E501

        企业Pull Reuqest 列表  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprise_enterprise_pull_requests_with_http_info(enterprise, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str access_token: 用户授权码
        :param str issue_number: 可选。Issue 编号(区分大小写，无需添加 # 号)
        :param str repo: 可选。仓库路径(path)
        :param int program_id: 可选。项目ID
        :param str state: 可选。Pull Request 状态
        :param str head: 可选。Pull Request 提交的源分支。格式：branch 或者：username:branch
        :param str base: 可选。Pull Request 提交目标分支的名称。
        :param str sort: 可选。排序字段，默认按创建时间
        :param str direction: 可选。升序/降序
        :param int milestone_number: 可选。里程碑序号(id)
        :param str labels: 用逗号分开的标签。如: bug,performance
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[PullRequest]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enterprise', 'access_token', 'issue_number', 'repo', 'program_id', 'state', 'head', 'base',
                      'sort', 'direction', 'milestone_number', 'labels', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_enterprise_enterprise_pull_requests" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `get_v5_enterprise_enterprise_pull_requests`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'issue_number' in params:
            query_params.append(('issue_number', params['issue_number']))  # noqa: E501
        if 'repo' in params:
            query_params.append(('repo', params['repo']))  # noqa: E501
        if 'program_id' in params:
            query_params.append(('program_id', params['program_id']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'head' in params:
            query_params.append(('head', params['head']))  # noqa: E501
        if 'base' in params:
            query_params.append(('base', params['base']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'direction' in params:
            query_params.append(('direction', params['direction']))  # noqa: E501
        if 'milestone_number' in params:
            query_params.append(('milestone_number', params['milestone_number']))  # noqa: E501
        if 'labels' in params:
            query_params.append(('labels', params['labels']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprise/{enterprise}/pull_requests', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PullRequest]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_enterprises_enterprise(self, enterprise, **kwargs):  # noqa: E501
        """获取一个企业  # noqa: E501

        获取一个企业  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise(enterprise, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str access_token: 用户授权码
        :return: EnterpriseBasic
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_enterprises_enterprise_with_http_info(enterprise, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_enterprises_enterprise_with_http_info(enterprise, **kwargs)  # noqa: E501
            return data

    def get_v5_enterprises_enterprise_with_http_info(self, enterprise, **kwargs):  # noqa: E501
        """获取一个企业  # noqa: E501

        获取一个企业  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_with_http_info(enterprise, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str access_token: 用户授权码
        :return: EnterpriseBasic
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enterprise', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_enterprises_enterprise" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `get_v5_enterprises_enterprise`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnterpriseBasic',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_enterprises_enterprise_members(self, enterprise, **kwargs):  # noqa: E501
        """列出企业的所有成员  # noqa: E501

        列出企业的所有成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_members(enterprise, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str access_token: 用户授权码
        :param str role: 根据角色筛选成员
        :return: list[EnterpriseMember]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_enterprises_enterprise_members_with_http_info(enterprise, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_enterprises_enterprise_members_with_http_info(enterprise, **kwargs)  # noqa: E501
            return data

    def get_v5_enterprises_enterprise_members_with_http_info(self, enterprise, **kwargs):  # noqa: E501
        """列出企业的所有成员  # noqa: E501

        列出企业的所有成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_members_with_http_info(enterprise, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str access_token: 用户授权码
        :param str role: 根据角色筛选成员
        :return: list[EnterpriseMember]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enterprise', 'access_token', 'role']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_enterprises_enterprise_members" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `get_v5_enterprises_enterprise_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'role' in params:
            query_params.append(('role', params['role']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EnterpriseMember]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_enterprises_enterprise_members_username(self, enterprise, username, **kwargs):  # noqa: E501
        """获取企业的一个成员  # noqa: E501

        获取企业的一个成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_members_username(enterprise, username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str username: 用户名(username/login) (required)
        :param str access_token: 用户授权码
        :return: EnterpriseMember
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_enterprises_enterprise_members_username_with_http_info(enterprise, username,
                                                                                      **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_enterprises_enterprise_members_username_with_http_info(enterprise, username,
                                                                                        **kwargs)  # noqa: E501
            return data

    def get_v5_enterprises_enterprise_members_username_with_http_info(self, enterprise, username,
                                                                      **kwargs):  # noqa: E501
        """获取企业的一个成员  # noqa: E501

        获取企业的一个成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_members_username_with_http_info(enterprise, username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str username: 用户名(username/login) (required)
        :param str access_token: 用户授权码
        :return: EnterpriseMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enterprise', 'username', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_enterprises_enterprise_members_username" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `get_v5_enterprises_enterprise_members_username`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError(
                "Missing the required parameter `username` when calling `get_v5_enterprises_enterprise_members_username`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501
        if 'username' in params:
            path_params['username'] = params['username']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/members/{username}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnterpriseMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_enterprises_enterprise_users_username_week_reports(self, enterprise, username, **kwargs):  # noqa: E501
        """个人周报列表  # noqa: E501

        个人周报列表  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_users_username_week_reports(enterprise, username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str username: 用户名(username/login) (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[WeekReport]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_enterprises_enterprise_users_username_week_reports_with_http_info(enterprise, username,
                                                                                                 **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_enterprises_enterprise_users_username_week_reports_with_http_info(enterprise, username,
                                                                                                   **kwargs)  # noqa: E501
            return data

    def get_v5_enterprises_enterprise_users_username_week_reports_with_http_info(self, enterprise, username,
                                                                                 **kwargs):  # noqa: E501
        """个人周报列表  # noqa: E501

        个人周报列表  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_users_username_week_reports_with_http_info(enterprise, username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str username: 用户名(username/login) (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[WeekReport]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enterprise', 'username', 'access_token', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_enterprises_enterprise_users_username_week_reports" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `get_v5_enterprises_enterprise_users_username_week_reports`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError(
                "Missing the required parameter `username` when calling `get_v5_enterprises_enterprise_users_username_week_reports`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501
        if 'username' in params:
            path_params['username'] = params['username']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/users/{username}/week_reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[WeekReport]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_enterprises_enterprise_week_reports(self, enterprise, **kwargs):  # noqa: E501
        """企业成员周报列表  # noqa: E501

        企业成员周报列表  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_week_reports(enterprise, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param str username: 用户名(username/login)
        :param int year: 周报所属年
        :param int week_index: 周报所属周
        :param str _date: 周报日期(格式：2019-03-25)
        :return: list[WeekReport]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_enterprises_enterprise_week_reports_with_http_info(enterprise, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_enterprises_enterprise_week_reports_with_http_info(enterprise, **kwargs)  # noqa: E501
            return data

    def get_v5_enterprises_enterprise_week_reports_with_http_info(self, enterprise, **kwargs):  # noqa: E501
        """企业成员周报列表  # noqa: E501

        企业成员周报列表  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_week_reports_with_http_info(enterprise, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param str username: 用户名(username/login)
        :param int year: 周报所属年
        :param int week_index: 周报所属周
        :param str _date: 周报日期(格式：2019-03-25)
        :return: list[WeekReport]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enterprise', 'access_token', 'page', 'per_page', 'username', 'year', 'week_index',
                      '_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_enterprises_enterprise_week_reports" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `get_v5_enterprises_enterprise_week_reports`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'year' in params:
            query_params.append(('year', params['year']))  # noqa: E501
        if 'week_index' in params:
            query_params.append(('week_index', params['week_index']))  # noqa: E501
        if '_date' in params:
            query_params.append(('date', params['_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/week_reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[WeekReport]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_enterprises_enterprise_week_reports_id(self, enterprise, id, **kwargs):  # noqa: E501
        """周报详情  # noqa: E501

        周报详情  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_week_reports_id(enterprise, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param int id: 周报ID (required)
        :param str access_token: 用户授权码
        :return: WeekReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_enterprises_enterprise_week_reports_id_with_http_info(enterprise, id,
                                                                                     **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_enterprises_enterprise_week_reports_id_with_http_info(enterprise, id,
                                                                                       **kwargs)  # noqa: E501
            return data

    def get_v5_enterprises_enterprise_week_reports_id_with_http_info(self, enterprise, id, **kwargs):  # noqa: E501
        """周报详情  # noqa: E501

        周报详情  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_week_reports_id_with_http_info(enterprise, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param int id: 周报ID (required)
        :param str access_token: 用户授权码
        :return: WeekReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enterprise', 'id', 'access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_enterprises_enterprise_week_reports_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `get_v5_enterprises_enterprise_week_reports_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError(
                "Missing the required parameter `id` when calling `get_v5_enterprises_enterprise_week_reports_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/week_reports/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WeekReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_enterprises_enterprise_week_reports_id_comments(self, enterprise, id, **kwargs):  # noqa: E501
        """某个周报评论列表  # noqa: E501

        某个周报评论列表  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_week_reports_id_comments(enterprise, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param int id: 周报ID (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[Note]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_enterprises_enterprise_week_reports_id_comments_with_http_info(enterprise, id,
                                                                                              **kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_enterprises_enterprise_week_reports_id_comments_with_http_info(enterprise, id,
                                                                                                **kwargs)  # noqa: E501
            return data

    def get_v5_enterprises_enterprise_week_reports_id_comments_with_http_info(self, enterprise, id,
                                                                              **kwargs):  # noqa: E501
        """某个周报评论列表  # noqa: E501

        某个周报评论列表  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_enterprises_enterprise_week_reports_id_comments_with_http_info(enterprise, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param int id: 周报ID (required)
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :return: list[Note]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enterprise', 'id', 'access_token', 'page', 'per_page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_enterprises_enterprise_week_reports_id_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `get_v5_enterprises_enterprise_week_reports_id_comments`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError(
                "Missing the required parameter `id` when calling `get_v5_enterprises_enterprise_week_reports_id_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/week_reports/{id}/comments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Note]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v5_user_enterprises(self, **kwargs):  # noqa: E501
        """列出授权用户所属的企业  # noqa: E501

        列出授权用户所属的企业  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_user_enterprises(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param bool admin: 只列出授权用户管理的企业
        :return: list[EnterpriseBasic]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v5_user_enterprises_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_v5_user_enterprises_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_v5_user_enterprises_with_http_info(self, **kwargs):  # noqa: E501
        """列出授权用户所属的企业  # noqa: E501

        列出授权用户所属的企业  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v5_user_enterprises_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: 用户授权码
        :param int page: 当前的页码
        :param int per_page: 每页的数量，最大为 100
        :param bool admin: 只列出授权用户管理的企业
        :return: list[EnterpriseBasic]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_token', 'page', 'per_page', 'admin']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v5_user_enterprises" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'admin' in params:
            query_params.append(('admin', params['admin']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/user/enterprises', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EnterpriseBasic]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_v5_enterprises_enterprise_week_report_id(self, access_token, content, enterprise, id,
                                                       **kwargs):  # noqa: E501
        """编辑周报  # noqa: E501

        编辑周报  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_enterprises_enterprise_week_report_id(access_token, content, enterprise, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: (required)
        :param str content: (required)
        :param str enterprise: 企业的路径(path/login) (required)
        :param int id: 周报ID (required)
        :return: WeekReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_v5_enterprises_enterprise_week_report_id_with_http_info(access_token, content, enterprise,
                                                                                      id, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_v5_enterprises_enterprise_week_report_id_with_http_info(access_token, content,
                                                                                        enterprise, id,
                                                                                        **kwargs)  # noqa: E501
            return data

    def patch_v5_enterprises_enterprise_week_report_id_with_http_info(self, access_token, content, enterprise, id,
                                                                      **kwargs):  # noqa: E501
        """编辑周报  # noqa: E501

        编辑周报  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_v5_enterprises_enterprise_week_report_id_with_http_info(access_token, content, enterprise, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token: (required)
        :param str content: (required)
        :param str enterprise: 企业的路径(path/login) (required)
        :param int id: 周报ID (required)
        :return: WeekReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_token', 'content', 'enterprise', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_v5_enterprises_enterprise_week_report_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'access_token' is set
        if ('access_token' not in params or
                params['access_token'] is None):
            raise ValueError(
                "Missing the required parameter `access_token` when calling `patch_v5_enterprises_enterprise_week_report_id`")  # noqa: E501
        # verify the required parameter 'content' is set
        if ('content' not in params or
                params['content'] is None):
            raise ValueError(
                "Missing the required parameter `content` when calling `patch_v5_enterprises_enterprise_week_report_id`")  # noqa: E501
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `patch_v5_enterprises_enterprise_week_report_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError(
                "Missing the required parameter `id` when calling `patch_v5_enterprises_enterprise_week_report_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'access_token' in params:
            form_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'content' in params:
            form_params.append(('content', params['content']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/week_report/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WeekReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v5_enterprises_enterprise_members(self, enterprise, **kwargs):  # noqa: E501
        """添加或邀请企业成员  # noqa: E501

        添加或邀请企业成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_enterprises_enterprise_members(enterprise, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param Body61 body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v5_enterprises_enterprise_members_with_http_info(enterprise, **kwargs)  # noqa: E501
        else:
            (data) = self.post_v5_enterprises_enterprise_members_with_http_info(enterprise, **kwargs)  # noqa: E501
            return data

    def post_v5_enterprises_enterprise_members_with_http_info(self, enterprise, **kwargs):  # noqa: E501
        """添加或邀请企业成员  # noqa: E501

        添加或邀请企业成员  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_enterprises_enterprise_members_with_http_info(enterprise, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param Body61 body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enterprise', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v5_enterprises_enterprise_members" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `post_v5_enterprises_enterprise_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v5_enterprises_enterprise_week_report(self, body, enterprise, **kwargs):  # noqa: E501
        """新建周报  # noqa: E501

        新建周报  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_enterprises_enterprise_week_report(body, enterprise, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body64 body: (required)
        :param str enterprise: 企业的路径(path/login) (required)
        :return: WeekReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v5_enterprises_enterprise_week_report_with_http_info(body, enterprise,
                                                                                  **kwargs)  # noqa: E501
        else:
            (data) = self.post_v5_enterprises_enterprise_week_report_with_http_info(body, enterprise,
                                                                                    **kwargs)  # noqa: E501
            return data

    def post_v5_enterprises_enterprise_week_report_with_http_info(self, body, enterprise, **kwargs):  # noqa: E501
        """新建周报  # noqa: E501

        新建周报  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_enterprises_enterprise_week_report_with_http_info(body, enterprise, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body64 body: (required)
        :param str enterprise: 企业的路径(path/login) (required)
        :return: WeekReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'enterprise']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v5_enterprises_enterprise_week_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `post_v5_enterprises_enterprise_week_report`")  # noqa: E501
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `post_v5_enterprises_enterprise_week_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/week_report', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WeekReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v5_enterprises_enterprise_week_reports_id_comment(self, body, enterprise, id, **kwargs):  # noqa: E501
        """评论周报  # noqa: E501

        评论周报  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_enterprises_enterprise_week_reports_id_comment(body, enterprise, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body62 body: (required)
        :param str enterprise: 企业的路径(path/login) (required)
        :param int id: 周报ID (required)
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v5_enterprises_enterprise_week_reports_id_comment_with_http_info(body, enterprise, id,
                                                                                              **kwargs)  # noqa: E501
        else:
            (data) = self.post_v5_enterprises_enterprise_week_reports_id_comment_with_http_info(body, enterprise, id,
                                                                                                **kwargs)  # noqa: E501
            return data

    def post_v5_enterprises_enterprise_week_reports_id_comment_with_http_info(self, body, enterprise, id,
                                                                              **kwargs):  # noqa: E501
        """评论周报  # noqa: E501

        评论周报  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v5_enterprises_enterprise_week_reports_id_comment_with_http_info(body, enterprise, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body62 body: (required)
        :param str enterprise: 企业的路径(path/login) (required)
        :param int id: 周报ID (required)
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'enterprise', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v5_enterprises_enterprise_week_reports_id_comment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `post_v5_enterprises_enterprise_week_reports_id_comment`")  # noqa: E501
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `post_v5_enterprises_enterprise_week_reports_id_comment`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError(
                "Missing the required parameter `id` when calling `post_v5_enterprises_enterprise_week_reports_id_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/week_reports/{id}/comment', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Note',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_v5_enterprises_enterprise_members_username(self, enterprise, username, **kwargs):  # noqa: E501
        """修改企业成员权限或备注  # noqa: E501

        修改企业成员权限或备注  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_v5_enterprises_enterprise_members_username(enterprise, username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str username: 用户名(username/login) (required)
        :param Body66 body:
        :return: EnterpriseMember
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_v5_enterprises_enterprise_members_username_with_http_info(enterprise, username,
                                                                                      **kwargs)  # noqa: E501
        else:
            (data) = self.put_v5_enterprises_enterprise_members_username_with_http_info(enterprise, username,
                                                                                        **kwargs)  # noqa: E501
            return data

    def put_v5_enterprises_enterprise_members_username_with_http_info(self, enterprise, username,
                                                                      **kwargs):  # noqa: E501
        """修改企业成员权限或备注  # noqa: E501

        修改企业成员权限或备注  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_v5_enterprises_enterprise_members_username_with_http_info(enterprise, username, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enterprise: 企业的路径(path/login) (required)
        :param str username: 用户名(username/login) (required)
        :param Body66 body:
        :return: EnterpriseMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enterprise', 'username', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_v5_enterprises_enterprise_members_username" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'enterprise' is set
        if ('enterprise' not in params or
                params['enterprise'] is None):
            raise ValueError(
                "Missing the required parameter `enterprise` when calling `put_v5_enterprises_enterprise_members_username`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError(
                "Missing the required parameter `username` when calling `put_v5_enterprises_enterprise_members_username`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enterprise' in params:
            path_params['enterprise'] = params['enterprise']  # noqa: E501
        if 'username' in params:
            path_params['username'] = params['username']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v5/enterprises/{enterprise}/members/{username}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnterpriseMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
