from typing import Any, Dict, List


def default_color_tables() -> List[Dict[str, Any]]:
    return [
        {
            "name": "Physics",
            "discrete": False,
            "description": "Full options color table",
            "colorNaN": [255, 255, 255],
            "colorBelow": [255, 0.0, 0.0],
            "colorAbove": [0.0, 0.0, 255],
            "colors": [
                [0.0, 255, 0.0, 0.0],
                [0.25, 182, 182, 0.0],
                [0.5, 0.0, 255, 0.0],
                [0.75, 0.0, 182, 182],
                [1.0, 0.0, 0.0, 255],
            ],
        },
        {
            "name": "Physics reverse",
            "discrete": False,
            "colors": [
                [0.0, 0.0, 0.0, 255],
                [0.25, 0.0, 182, 182],
                [0.5, 0.0, 255, 0.0],
                [0.75, 182, 182, 0.0],
                [1.0, 255, 0.0, 0.0],
            ],
        },
        {
            "name": "Rainbow",
            "discrete": False,
            "colors": [
                [0.0, 255, 0.0, 0.0],
                [0.2, 182, 182, 0.0],
                [0.4, 0.0, 255, 0.0],
                [0.6, 0.0, 182, 182],
                [0.8, 0.0, 0.0, 255],
                [1.0, 182, 0.0, 182],
            ],
        },
        {
            "name": "Rainbow reverse",
            "discrete": False,
            "colors": [
                [0.0, 182, 0.0, 182],
                [0.2, 0.0, 0.0, 255],
                [0.4, 0.0, 182, 182],
                [0.6, 0.0, 255, 0.0],
                [0.8, 182, 182, 0.0],
                [1.0, 255, 0.0, 0.0],
            ],
        },
        {
            "name": "Colors_set_1",
            "discrete": True,
            "colors": [
                [0, 255, 13, 186],
                [1, 255, 64, 53],
                [2, 247, 255, 164],
                [3, 112, 255, 97],
                [4, 9, 254, 133],
                [5, 254, 4, 135],
                [6, 255, 5, 94],
                [7, 32, 50, 255],
                [8, 109, 255, 32],
                [9, 254, 146, 92],
                [10, 185, 116, 255],
                [11, 255, 144, 1],
                [12, 157, 32, 255],
                [13, 255, 26, 202],
                [14, 73, 255, 35],
            ],
        },
        {
            "name": "Colors_set_2",
            "discrete": True,
            "colors": [
                [0, 159, 76, 255],
                [1, 56, 14, 255],
                [2, 255, 229, 123],
                [3, 30, 15, 254],
                [4, 129, 255, 16],
                [5, 81, 187, 255],
                [6, 7, 168, 254],
                [7, 255, 23, 50],
                [8, 207, 255, 102],
                [9, 128, 27, 255],
                [10, 61, 59, 255],
                [11, 21, 255, 134],
                [12, 224, 235, 255],
                [13, 255, 75, 96],
                [14, 170, 78, 255],
                [15, 243, 255, 125],
            ],
        },
        {
            "name": "Colors_set_3",
            "discrete": True,
            "colors": [
                [0, 120, 181, 255],
                [1, 255, 29, 102],
                [2, 247, 255, 173],
                [3, 239, 157, 255],
                [4, 186, 255, 236],
                [5, 46, 255, 121],
                [6, 212, 255, 144],
                [7, 165, 255, 143],
                [8, 122, 255, 89],
                [9, 255, 212, 213],
            ],
        },
        {
            "name": "Colors_set_4",
            "discrete": True,
            "colors": [
                [0, 144, 255, 188],
                [1, 255, 42, 141],
                [2, 255, 239, 194],
                [3, 66, 255, 117],
                [4, 255, 157, 59],
            ],
        },
        {
            "name": "Colors_set_5",
            "discrete": True,
            "colors": [[0, 244, 237, 255], [1, 255, 171, 178]],
        },
        {
            "name": "Colors_set_6",
            "discrete": True,
            "colors": [[0, 244, 237, 255], [1, 255, 171, 178]],
        },
        {
            "name": "Colors_set_7",
            "discrete": True,
            "colors": [
                [0, 159, 76, 255],
                [1, 56, 14, 255],
                [2, 255, 229, 123],
                [3, 30, 15, 254],
                [4, 129, 255, 16],
                [5, 81, 187, 255],
                [6, 7, 168, 254],
                [7, 255, 23, 50],
                [8, 207, 255, 102],
                [9, 128, 27, 255],
            ],
        },
        {
            "name": "Colors_set_8",
            "discrete": True,
            "colors": [
                [0, 159, 76, 255],
                [1, 232, 244, 255],
                [2, 255, 29, 102],
                [3, 247, 255, 173],
                [4, 34, 144, 255],
                [5, 3, 255, 70],
            ],
        },
    ]
