/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.sql.join;

import com.databricks.labs.mosaic.functions.MosaicContext;
import com.databricks.labs.mosaic.functions.MosaicContext$;
import com.databricks.labs.mosaic.sql.MosaicFrame;
import com.databricks.labs.mosaic.sql.package$constants$ColMetaTags$;
import com.databricks.labs.mosaic.sql.package$constants$ColRoles$;
import java.util.UUID;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcI$sp;

public final class PointInPolygonJoin$ {
    public static PointInPolygonJoin$ MODULE$;
    private int selectedResolution;

    static {
        new PointInPolygonJoin$();
    }

    public int selectedResolution() {
        return this.selectedResolution;
    }

    public void selectedResolution_$eq(int x$1) {
        this.selectedResolution = x$1;
    }

    public MosaicFrame join(MosaicFrame points, MosaicFrame polygons, Option<Object> resolution) {
        this.selectedResolution_$eq(BoxesRunTime.unboxToInt(resolution.getOrElse((JFunction0$mcI$sp & Serializable)() -> polygons.getIndexResolution())));
        MosaicFrame indexedPoints = this.checkIndex(points);
        MosaicFrame indexedPolygons = this.checkIndex(polygons);
        Column pointsIndexCol = (Column)indexedPoints.indexColumnMap(this.selectedResolution()).apply(package$constants$ColRoles$.MODULE$.INDEX());
        Column polygonsIndexCol = (Column)indexedPolygons.indexColumnMap(this.selectedResolution()).apply(package$constants$ColRoles$.MODULE$.INDEX());
        Dataset<Row> joinedDf = indexedPolygons.schema().apply(polygonsIndexCol.toString()).metadata().getBoolean(package$constants$ColMetaTags$.MODULE$.EXPLODED_POLYFILL()) ? this.joinExplodedRows(indexedPoints, indexedPolygons, pointsIndexCol, polygonsIndexCol) : this.joinArrayRows(indexedPoints, indexedPolygons, pointsIndexCol, polygonsIndexCol);
        return new MosaicFrame(joinedDf);
    }

    public Option<Object> join$default$3() {
        return None$.MODULE$;
    }

    private Dataset<Row> joinArrayRows(MosaicFrame indexedPoints, MosaicFrame indexedPolygons, Column pointsIndexCol, Column polygonsIndexCol) {
        MosaicContext mosaicContext = MosaicContext$.MODULE$.context();
        Column polygonIndexChips = polygonsIndexCol.getField("chips");
        String tempColName = UUID.randomUUID().toString();
        return indexedPoints.join(indexedPolygons, functions$.MODULE$.array_contains(polygonIndexChips.getField("index_id"), (Object)pointsIndexCol)).withColumn(tempColName, functions$.MODULE$.array_position(polygonIndexChips.getField("index_id"), (Object)pointsIndexCol).cast((DataType)IntegerType$.MODULE$)).where(functions$.MODULE$.col(tempColName).$greater((Object)BoxesRunTime.boxToInteger(0))).where(functions$.MODULE$.element_at(polygonIndexChips.getField("is_core"), (Object)functions$.MODULE$.col(tempColName)).$bar$bar((Object)mosaicContext.functions().st_contains(functions$.MODULE$.element_at(polygonIndexChips.getField("wkb"), (Object)functions$.MODULE$.col(tempColName)), indexedPoints.getGeometryColumn()))).drop(tempColName);
    }

    private Dataset<Row> joinExplodedRows(MosaicFrame indexedPoints, MosaicFrame indexedPolygons, Column pointsIndexCol, Column polygonsIndexCol) {
        MosaicContext mosaicContext = MosaicContext$.MODULE$.context();
        return indexedPoints.join(indexedPolygons, pointsIndexCol.$eq$eq$eq((Object)polygonsIndexCol.getField("index_id")).$amp$amp((Object)polygonsIndexCol.getField("is_core").$bar$bar((Object)mosaicContext.functions().st_contains(polygonsIndexCol.getField("wkb"), indexedPoints.getGeometryColumn()))));
    }

    public MosaicFrame checkIndex(MosaicFrame mosaicFrame) {
        List<MosaicFrame.MosaicFrameIndex> list = mosaicFrame.listIndexesForGeometry(mosaicFrame.listIndexesForGeometry$default$1());
        MosaicFrame mosaicFrame2 = list.isEmpty() ? this.applyNewIndex(mosaicFrame) : (!list.exists((Function1<MosaicFrame.MosaicFrameIndex, Object> & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean(PointInPolygonJoin$.$anonfun$checkIndex$1(x))) ? this.applyNewIndex(mosaicFrame) : mosaicFrame);
        return mosaicFrame2;
    }

    public MosaicFrame applyNewIndex(MosaicFrame mosaicFrame) {
        MosaicFrame qual$1 = mosaicFrame.setIndexResolution(this.selectedResolution());
        boolean x$1 = false;
        boolean x$2 = qual$1.applyIndex$default$2();
        return qual$1.applyIndex(x$1, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$checkIndex$1(MosaicFrame.MosaicFrameIndex x) {
        return x.indexResolution() == MODULE$.selectedResolution();
    }

    private PointInPolygonJoin$() {
        MODULE$ = this;
    }
}

