/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.index;

import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.index.H3$;
import com.databricks.labs.mosaic.core.index.IndexSystem;
import com.databricks.labs.mosaic.core.index.IndexSystemID;
import com.databricks.labs.mosaic.core.types.model.Coordinates;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.MosaicChip;
import com.uber.h3core.H3Core;
import com.uber.h3core.util.GeoCoord;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering$Double$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

public final class H3IndexSystem$
implements IndexSystem {
    public static H3IndexSystem$ MODULE$;
    private final transient H3Core h3;

    static {
        new H3IndexSystem$();
    }

    @Override
    public String name() {
        return IndexSystem.name$(this);
    }

    @Override
    public Seq<MosaicChip> getBorderChips(MosaicGeometry geometry, Seq<Object> borderIndices, boolean keepCoreGeom, GeometryAPI geometryAPI) {
        return IndexSystem.getBorderChips$(this, geometry, borderIndices, keepCoreGeom, geometryAPI);
    }

    @Override
    public Seq<MosaicChip> getCoreChips(Seq<Object> coreIndices, boolean keepCoreGeom, GeometryAPI geometryAPI) {
        return IndexSystem.getCoreChips$(this, coreIndices, keepCoreGeom, geometryAPI);
    }

    public H3Core h3() {
        return this.h3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getResolution(Object res) {
        void var2_2;
        int resolution = BoxesRunTime.unboxToInt(res);
        if (resolution < 0 | resolution > 15) {
            throw new IllegalStateException(new StringBuilder(48).append("H3 resolution has to be between 0 and 15; found ").append(resolution).toString());
        }
        return (int)var2_2;
    }

    @Override
    public double getBufferRadius(MosaicGeometry geometry, int resolution, GeometryAPI geometryAPI) {
        MosaicPoint centroid = geometry.getCentroid();
        long centroidIndex = this.h3().geoToH3(centroid.getY(), centroid.getX(), resolution);
        MosaicGeometry indexGeom = this.indexToGeometry(centroidIndex, geometryAPI);
        Seq boundary = (Seq)indexGeom.getShellPoints().head();
        return BoxesRunTime.unboxToDouble(((TraversableOnce)Seq$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{((MosaicGeometry)boundary.apply(false)).distance((MosaicGeometry)boundary.apply(3)), ((MosaicGeometry)boundary.apply(true)).distance((MosaicGeometry)boundary.apply(4)), ((MosaicGeometry)boundary.apply(2)).distance((MosaicGeometry)boundary.apply(5))}))).max(Ordering$Double$.MODULE$)) / (double)2;
    }

    @Override
    public MosaicGeometry indexToGeometry(long index, GeometryAPI geometryAPI) {
        Buffer<GeoCoord> boundary = JavaConverters$.MODULE$.asScalaBufferConverter(this.h3().h3ToGeoBoundary(index)).asScala();
        Object extended = boundary.$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)((GeoCoord)boundary.head())), Nil$.MODULE$));
        return geometryAPI.geometry(extended.map((Function1<GeoCoord, MosaicPoint> & Serializable & scala.Serializable)p -> geometryAPI.fromGeoCoord(new Coordinates(p.lat, p.lng)), Buffer$.MODULE$.canBuildFrom()), GeometryTypeEnum$.MODULE$.POLYGON());
    }

    @Override
    public Seq<Object> polyfill(MosaicGeometry geometry, int resolution, Option<GeometryAPI> geometryAPI) {
        Seq seq;
        if (geometry.isEmpty()) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            Seq<Seq<MosaicPoint>> shellPoints = geometry.getShellPoints();
            Seq<Seq<Seq<MosaicPoint>>> holePoints = geometry.getHolePoints();
            seq = (Seq)((GenericTraversableTemplate)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), geometry.getNumGeometries()).map((Function1<Object, Buffer> & Serializable & scala.Serializable)i -> H3IndexSystem$.$anonfun$polyfill$1(shellPoints, holePoints, resolution, BoxesRunTime.unboxToInt(i)), IndexedSeq$.MODULE$.canBuildFrom())).flatten(Predef$.MODULE$.$conforms());
        }
        return seq;
    }

    @Override
    public Option<GeometryAPI> polyfill$default$3() {
        return None$.MODULE$;
    }

    @Override
    public IndexSystemID getIndexSystemID() {
        return H3$.MODULE$;
    }

    @Override
    public long pointToIndex(double lon, double lat, int resolution) {
        return this.h3().geoToH3(lat, lon, resolution);
    }

    @Override
    public Seq<Object> kRing(long index, int n) {
        return ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.h3().kRing(index, n)).asScala()).map((Function1<Long, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong(Predef$.MODULE$.Long2long(x$5)), Buffer$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<Object> kDisk(long index, int n) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.h3().kRing(index, n)).asScala()).toSet().diff(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.h3().kRing(index, n - 1)).asScala()).toSet()).toSeq().map((Function1<Long, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong(Predef$.MODULE$.Long2long(x$6)), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Set<Object> resolutions() {
        return RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 15).toSet();
    }

    @Override
    public MosaicGeometry indexToGeometry(String index, GeometryAPI geometryAPI) {
        Buffer<GeoCoord> boundary = JavaConverters$.MODULE$.asScalaBufferConverter(this.h3().h3ToGeoBoundary(index)).asScala();
        Object extended = boundary.$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)((GeoCoord)boundary.head())), Nil$.MODULE$));
        return geometryAPI.geometry(extended.map((Function1<GeoCoord, MosaicPoint> & Serializable & scala.Serializable)p -> geometryAPI.fromGeoCoord(new Coordinates(p.lat, p.lng)), Buffer$.MODULE$.canBuildFrom()), GeometryTypeEnum$.MODULE$.POLYGON());
    }

    @Override
    public DataType defaultDataTypeID() {
        return LongType$.MODULE$;
    }

    @Override
    public String format(long id) {
        GeoCoord geo = this.h3().h3ToGeo(id);
        return this.h3().geoToH3Address(geo.lat, geo.lng, this.h3().h3GetResolution(id));
    }

    @Override
    public String getResolutionStr(int resolution) {
        return ((Object)BoxesRunTime.boxToInteger(resolution)).toString();
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Buffer $anonfun$polyfill$1(Seq shellPoints$1, Seq holePoints$1, int resolution$1, int i) {
        List<GeoCoord> boundary = JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableLike)((TraversableLike)shellPoints$1.apply(i)).map((Function1<MosaicPoint, Coordinates> & Serializable & scala.Serializable)x$1 -> x$1.geoCoord(), Seq$.MODULE$.canBuildFrom())).map((Function1<Coordinates, GeoCoord> & Serializable & scala.Serializable)p -> new GeoCoord(p.lat(), p.lng()), Seq$.MODULE$.canBuildFrom())).asJava();
        List<List<GeoCoord>> holes = JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableLike)holePoints$1.apply(i)).map((Function1<Seq, List> & Serializable & scala.Serializable)x$2 -> JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableLike)x$2.map((Function1<MosaicPoint, Coordinates> & Serializable & scala.Serializable)x$3 -> x$3.geoCoord(), Seq$.MODULE$.canBuildFrom())).map((Function1<Coordinates, GeoCoord> & Serializable & scala.Serializable)p -> new GeoCoord(p.lat(), p.lng()), Seq$.MODULE$.canBuildFrom())).asJava(), Seq$.MODULE$.canBuildFrom())).asJava();
        List<Long> indices = MODULE$.h3().polyfill(boundary, holes, resolution$1);
        return ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(indices).asScala()).map((Function1<Long, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong(Predef$.MODULE$.Long2long(x$4)), Buffer$.MODULE$.canBuildFrom());
    }

    private H3IndexSystem$() {
        MODULE$ = this;
        IndexSystem.$init$(this);
        this.h3 = H3Core.newInstance();
    }
}

