/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core;

import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.linestring.MosaicLineString;
import com.databricks.labs.mosaic.core.geometry.multilinestring.MosaicMultiLineString;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.index.IndexSystem;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.MosaicChip;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1$mcZJ$sp;

public final class Mosaic$ {
    public static Mosaic$ MODULE$;

    static {
        new Mosaic$();
    }

    public Seq<MosaicChip> mosaicFill(MosaicGeometry geometry, int resolution, boolean keepCoreGeom, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        double radius = indexSystem.getBufferRadius(geometry, resolution, geometryAPI);
        MosaicGeometry carvedGeometry = geometry.buffer(-radius);
        MosaicGeometry borderGeometry = carvedGeometry.isEmpty() ? geometry.buffer(radius * 1.01).simplify(0.01 * radius) : geometry.boundary().buffer(radius * 1.01).simplify(0.01 * radius);
        Seq<Object> coreIndices = indexSystem.polyfill(carvedGeometry, resolution, new Some<GeometryAPI>(geometryAPI));
        Seq<Object> borderIndices = indexSystem.polyfill(borderGeometry, resolution, new Some<GeometryAPI>(geometryAPI));
        Seq<MosaicChip> coreChips = indexSystem.getCoreChips(coreIndices, keepCoreGeom, geometryAPI);
        Seq<MosaicChip> borderChips = indexSystem.getBorderChips(geometry, borderIndices, keepCoreGeom, geometryAPI);
        return coreChips.$plus$plus(borderChips, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<MosaicChip> lineFill(MosaicGeometry geometry, int resolution, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        Seq<MosaicChip> seq;
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(geometry.getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.LINESTRING();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
            seq = this.lineDecompose((MosaicLineString)geometry, resolution, indexSystem, geometryAPI);
        } else {
            Enumeration.Value value4 = GeometryTypeEnum$.MODULE$.MULTILINESTRING();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null)) {
                MosaicMultiLineString multiLine = (MosaicMultiLineString)geometry;
                seq = multiLine.flatten().flatMap((Function1<MosaicGeometry, Seq> & Serializable & scala.Serializable)line -> MODULE$.lineDecompose((MosaicLineString)line, resolution, indexSystem, geometryAPI), Seq$.MODULE$.canBuildFrom());
            } else {
                throw new Error(new StringBuilder(49).append(value).append(" not supported for line fill/decompose operation.").toString());
            }
        }
        return seq;
    }

    private Seq<MosaicChip> lineDecompose(MosaicLineString line, int resolution, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        MosaicPoint start = (MosaicPoint)((MosaicLineString)line.getShells().head()).asSeq().head();
        long startIndex = indexSystem.pointToIndex(start.getX(), start.getY(), resolution);
        Seq result = this.traverseLine$1(line, (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapLongArray(new long[]{startIndex})), (Set)Predef$.MODULE$.Set().empty(), (Seq)Seq$.MODULE$.empty(), indexSystem, geometryAPI);
        return result;
    }

    public static final /* synthetic */ Tuple2 $anonfun$lineDecompose$1(IndexSystem indexSystem$2, GeometryAPI geometryAPI$2, MosaicLineString line$1, Set newTraversed$1, Tuple2 accumulator, long current) {
        Tuple2 tuple2;
        MosaicGeometry indexGeom = indexSystem$2.indexToGeometry(current, geometryAPI$2);
        MosaicGeometry lineSegment = line$1.intersection(indexGeom);
        if (!lineSegment.isEmpty()) {
            MosaicChip chip = new MosaicChip(false, package$.MODULE$.Left().apply(BoxesRunTime.boxToLong(current)), lineSegment);
            Seq<Object> kRing = indexSystem$2.kRing(current, 1);
            Seq toQueue = (Seq)kRing.filterNot((JFunction1$mcZJ$sp & scala.Serializable)elem -> newTraversed$1.contains(BoxesRunTime.boxToLong(elem)));
            tuple2 = new Tuple2(toQueue, ((TraversableLike)accumulator._2()).$plus$plus(Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new MosaicChip[]{chip})), Seq$.MODULE$.canBuildFrom()));
        } else {
            tuple2 = accumulator;
        }
        return tuple2;
    }

    private final Seq traverseLine$1(MosaicLineString line, Seq queue, Set traversed, Seq chips, IndexSystem indexSystem$2, GeometryAPI geometryAPI$2) {
        Seq newChips;
        while (true) {
            Set newTraversed = (Set)traversed.$plus$plus(queue);
            Tuple2 tuple2 = queue.foldLeft(new Tuple2(Seq$.MODULE$.empty(), chips), (Function2<Tuple2, Object, Tuple2> & Serializable & scala.Serializable)(accumulator, current) -> Mosaic$.$anonfun$lineDecompose$1(indexSystem$2, geometryAPI$2, line, newTraversed, accumulator, BoxesRunTime.unboxToLong(current)));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq newQueue = (Seq)tuple2._1();
            Seq newChips2 = tuple2._2();
            Tuple2<Seq, Seq> tuple22 = new Tuple2<Seq, Seq>(newQueue, newChips2);
            Tuple2<Seq, Seq> tuple23 = tuple22;
            Seq newQueue2 = tuple23._1();
            newChips = tuple23._2();
            if (newQueue2.isEmpty()) break;
            chips = newChips;
            traversed = newTraversed;
            queue = newQueue2;
        }
        return newChips;
    }

    private Mosaic$() {
        MODULE$ = this;
    }
}

