/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.sql;

import scala.Enumeration;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;

public final class MosaicSQLExceptions$ {
    public static MosaicSQLExceptions$ MODULE$;

    static {
        new MosaicSQLExceptions$();
    }

    public Exception NoGeometryColumnSet() {
        return new Exception("Cannot index a MosaicFrame which does not have an active geometry column set. Use the setGeometryColumn method to update this value.");
    }

    public Exception NotEnoughGeometriesException() {
        return new Exception("Not enough geometries supplied to MosaicAnalyser to compute resolution metrics. Try increasing the sampleFraction using the setSampleFraction method.");
    }

    public Exception IncorrectGeometryTypeSupplied(String simpleString, Enumeration.Value supplied, Enumeration.Value expected) {
        return new Exception(new StringBuilder(82).append("Could not execute ").append(simpleString).append(". Wrong geometry type supplied to function.").append("Expected ").append(expected).append(", received ").append(supplied).append(".").toString());
    }

    public Exception NoIndexResolutionSet() {
        return new Exception("No index resolutions set on this MosaicFrame. Use getOptimalResolution to determine what this value should beand setIndexResolution to update this value");
    }

    public Exception BadIndexResolution(Set<Object> resolutions) {
        return new Exception(new StringBuilder(73).append("Resolution supplied to setIndexResolution must be in the set of values: ").append(resolutions).append(".").toString());
    }

    public Exception MosaicFrameNotIndexed() {
        return new Exception("Cannot perform this action before the MosaicFrame has been indexed. Use applyIndex() to index the MosaicFrame");
    }

    public Exception SpatialJoinTypeNotSupported(Enumeration.Value geometryType, Enumeration.Value otherGeometryType) {
        return new Exception(new StringBuilder(56).append("Joins between ").append(geometryType).append(" and ").append(otherGeometryType).append(" are not supported with MosaicFrames.").toString());
    }

    public Exception GeometryEncodingNotSupported(List<String> supportedGeometryEncodings, String suppliedGeometryEncoding) {
        return new Exception(new StringBuilder(76).append("This expression only supports geometries encoded as ").append(supportedGeometryEncodings.mkString(",")).append(".").append(suppliedGeometryEncoding).append(" was supplied as input.").toString());
    }

    private MosaicSQLExceptions$() {
        MODULE$ = this;
    }
}

