/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.expressions.index;

import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI$;
import com.databricks.labs.mosaic.core.index.IndexSystem;
import com.databricks.labs.mosaic.core.index.IndexSystemID$;
import com.databricks.labs.mosaic.core.types.package$;
import com.databricks.labs.mosaic.expressions.index.IndexGeometry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(indexID, indexSystem) - Returns the geometry representing the grid cell.", examples="\n    Examples:\n      > SELECT _FUNC_(a, 'H3');\n      0001100100100.....001010 // WKB\n  ", since="1.0")
@ScalaSignature(bytes="\u0006\u0001\t]b\u0001B\u0013'\u0001NB\u0001\u0002\u001b\u0001\u0003\u0016\u0004%\t!\u001b\u0005\t[\u0002\u0011\t\u0012)A\u0005U\"Aa\u000e\u0001BK\u0002\u0013\u0005\u0011\u000e\u0003\u0005p\u0001\tE\t\u0015!\u0003k\u0011!\u0001\bA!f\u0001\n\u0003\t\b\u0002\u0003>\u0001\u0005#\u0005\u000b\u0011\u0002:\t\u0011m\u0004!Q3A\u0005\u0002ED\u0001\u0002 \u0001\u0003\u0012\u0003\u0006IA\u001d\u0005\u0006{\u0002!\tA \u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0011\u001d\tY\u0002\u0001C!\u0003;Aq!a\u000b\u0001\t\u0003\ni\u0003\u0003\u0004\u00020\u0001!\t%\u001d\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u001d\t\u0019\u0005\u0001C!\u0003\u000bBa!a\u0016\u0001\t\u0003J\u0007BBA-\u0001\u0011\u0005\u0013\u000eC\u0004\u0002\\\u0001!\t&!\u0018\t\u0013\u0005\u001d\u0004!!A\u0005\u0002\u0005%\u0004\"CA:\u0001E\u0005I\u0011AA;\u0011%\tY\tAI\u0001\n\u0003\t)\bC\u0005\u0002\u000e\u0002\t\n\u0011\"\u0001\u0002\u0010\"I\u00111\u0013\u0001\u0012\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003+\u0003\u0011\u0011!C!\u0003/C\u0011\"a*\u0001\u0003\u0003%\t!!+\t\u0013\u0005E\u0006!!A\u0005\u0002\u0005M\u0006\"CA]\u0001\u0005\u0005I\u0011IA^\u0011%\tI\rAA\u0001\n\u0003\tY\rC\u0005\u0002V\u0002\t\t\u0011\"\u0011\u0002X\u001e9\u0011Q\u001f\u0014\t\u0002\u0005]hAB\u0013'\u0011\u0003\tI\u0010\u0003\u0004~?\u0011\u0005\u00111 \u0005\b\u0003{|B\u0011AA\u0000\u0011%\u0011\tbHA\u0001\n\u0003\u0013\u0019\u0002C\u0005\u0003\u001e}\t\t\u0011\"!\u0003 !I!QF\u0010\u0002\u0002\u0013%!q\u0006\u0002\u000e\u0013:$W\r_$f_6,GO]=\u000b\u0005\u001dB\u0013!B5oI\u0016D(BA\u0015+\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005-b\u0013AB7pg\u0006L7M\u0003\u0002.]\u0005!A.\u00192t\u0015\ty\u0003'\u0001\u0006eCR\f'M]5dWNT\u0011!M\u0001\u0004G>l7\u0001A\n\u0007\u0001Q\u001a\u0015lX3\u0011\u0005U\nU\"\u0001\u001c\u000b\u0005%:$B\u0001\u001d:\u0003!\u0019\u0017\r^1msN$(B\u0001\u001e<\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003yu\nQa\u001d9be.T!AP \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0015aA8sO&\u0011!I\u000e\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"\u0001\u0012,\u000f\u0005\u0015#fB\u0001$T\u001d\t9%K\u0004\u0002I#:\u0011\u0011\n\u0015\b\u0003\u0015>s!a\u0013(\u000e\u00031S!!\u0014\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0015B\u0001 @\u0013\taT(\u0003\u0002;w%\u0011\u0001(O\u0005\u0003S]J!!\u0016\u001c\u0002\u000fA\f7m[1hK&\u0011q\u000b\u0017\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\t)f\u0007\u0005\u0002[;6\t1L\u0003\u0002]m\u000591m\u001c3fO\u0016t\u0017B\u00010\\\u0005=\u0019u\u000eZ3hK:4\u0015\r\u001c7cC\u000e\\\u0007C\u00011d\u001b\u0005\t'\"\u00012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\f'a\u0002)s_\u0012,8\r\u001e\t\u0003A\u001aL!aZ1\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000f%tG-\u001a=J\tV\t!\u000e\u0005\u00026W&\u0011AN\u000e\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001C5oI\u0016D\u0018\n\u0012\u0011\u0002\r\u0019|'/\\1u\u0003\u001d1wN]7bi\u0002\nq\"\u001b8eKb\u001c\u0016p\u001d;f[:\u000bW.Z\u000b\u0002eB\u00111o\u001e\b\u0003iV\u0004\"aS1\n\u0005Y\f\u0017A\u0002)sK\u0012,g-\u0003\u0002ys\n11\u000b\u001e:j]\u001eT!A^1\u0002!%tG-\u001a=TsN$X-\u001c(b[\u0016\u0004\u0013aD4f_6,GO]=B!&s\u0015-\\3\u0002!\u001d,w.\\3uef\f\u0005+\u0013(b[\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0005\u0000\u0003\u0007\t)!a\u0002\u0002\nA\u0019\u0011\u0011\u0001\u0001\u000e\u0003\u0019BQ\u0001[\u0005A\u0002)DQA\\\u0005A\u0002)DQ\u0001]\u0005A\u0002IDQa_\u0005A\u0002I\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+I\u0014!\u0002;za\u0016\u001c\u0018\u0002BA\r\u0003'\u0011\u0001\u0002R1uCRK\b/Z\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003?\u0001B!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003K9\u0014\u0001C1oC2L8/[:\n\t\u0005%\u00121\u0005\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006AAo\\*ue&tw\rF\u0001s\u0003)\u0001(/\u001a;us:\u000bW.Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0007\u0003k\tY$a\u0010\u0011\u0007\u0001\f9$C\u0002\u0002:\u0005\u00141!\u00118z\u0011\u001d\tiD\u0004a\u0001\u0003k\ta!\u001b8qkR\f\u0004bBA!\u001d\u0001\u0007\u0011QG\u0001\u0007S:\u0004X\u000f\u001e\u001a\u0002\u00115\f7.Z\"paf$2A[A$\u0011\u001d\tIe\u0004a\u0001\u0003\u0017\nqA\\3x\u0003J<7\u000fE\u0003a\u0003\u001b\n\t&C\u0002\u0002P\u0005\u0014Q!\u0011:sCf\u00042\u0001YA*\u0013\r\t)&\u0019\u0002\u0007\u0003:L(+\u001a4\u0002\t1,g\r^\u0001\u0006e&<\u0007\u000e^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$RA[A0\u0003GBa!!\u0019\u0013\u0001\u0004Q\u0017a\u00028fo2+g\r\u001e\u0005\u0007\u0003K\u0012\u0002\u0019\u00016\u0002\u00119,wOU5hQR\fAaY8qsRIq0a\u001b\u0002n\u0005=\u0014\u0011\u000f\u0005\bQN\u0001\n\u00111\u0001k\u0011\u001dq7\u0003%AA\u0002)Dq\u0001]\n\u0011\u0002\u0003\u0007!\u000fC\u0004|'A\u0005\t\u0019\u0001:\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u000f\u0016\u0004U\u0006e4FAA>!\u0011\ti(a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015\u0015-\u0001\u0006b]:|G/\u0019;j_:LA!!#\u0002\u0000\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAAIU\r\u0011\u0018\u0011P\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0014\t\u0005\u00037\u000b)+\u0004\u0002\u0002\u001e*!\u0011qTAQ\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0016\u0001\u00026bm\u0006L1\u0001_AO\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY\u000bE\u0002a\u0003[K1!a,b\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)$!.\t\u0013\u0005]&$!AA\u0002\u0005-\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002>B1\u0011qXAc\u0003ki!!!1\u000b\u0007\u0005\r\u0017-\u0001\u0006d_2dWm\u0019;j_:LA!a2\u0002B\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti-a5\u0011\u0007\u0001\fy-C\u0002\u0002R\u0006\u0014qAQ8pY\u0016\fg\u000eC\u0005\u00028r\t\t\u00111\u0001\u00026\u00051Q-];bYN$B!!4\u0002Z\"I\u0011qW\u000f\u0002\u0002\u0003\u0007\u0011Q\u0007\u0015\u0010\u0001\u0005u\u00171]As\u0003S\fY/a<\u0002rB\u0019Q'a8\n\u0007\u0005\u0005hGA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u001d\u0018aT0G+:\u001bu\fK5oI\u0016D\u0018\n\u0012\u0017!S:$W\r_*zgR,W.\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011hK>lW\r\u001e:zAI,\u0007O]3tK:$\u0018N\\4!i\",\u0007e\u001a:jI\u0002\u001aW\r\u001c7/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAw\u0003]S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019\u0017!O!\u001bt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u00111aA\n\u0014\u0007\r\u00192aA\n\u0004\u0007\r\u0018/]9r\u0003\u0007M\u00191cA\u0002sf\f\u0011X\u0017\nS\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003g\f1!\r\u00181\u00035Ie\u000eZ3y\u000f\u0016|W.\u001a;ssB\u0019\u0011\u0011A\u0010\u0014\t}\t\t&\u001a\u000b\u0003\u0003o\faC]3hSN$(/_#yaJ,7o]5p]&sgm\u001c\u000b\u0005\u0005\u0003\u00119\u0001E\u00026\u0005\u0007I1A!\u00027\u00059)\u0005\u0010\u001d:fgNLwN\\%oM>DqA!\u0003\"\u0001\u0004\u0011Y!\u0001\u0002eEB!\u0001M!\u0004s\u0013\r\u0011y!\u0019\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013}\u0014)Ba\u0006\u0003\u001a\tm\u0001\"\u00025#\u0001\u0004Q\u0007\"\u00028#\u0001\u0004Q\u0007\"\u00029#\u0001\u0004\u0011\b\"B>#\u0001\u0004\u0011\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0005C\u0011I\u0003E\u0003a\u0005\u001b\u0011\u0019\u0003E\u0004a\u0005KQ'N\u001d:\n\u0007\t\u001d\u0012M\u0001\u0004UkBdW\r\u000e\u0005\t\u0005W\u0019\u0013\u0011!a\u0001\u007f\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005c\u0001B!a'\u00034%!!QGAO\u0005\u0019y%M[3di\u0002")
public class IndexGeometry
extends BinaryExpression
implements package.NullIntolerant,
CodegenFallback,
Serializable {
    private final Expression indexID;
    private final Expression format;
    private final String indexSystemName;
    private final String geometryAPIName;

    public static Option<Tuple4<Expression, Expression, String, String>> unapply(IndexGeometry indexGeometry) {
        return IndexGeometry$.MODULE$.unapply(indexGeometry);
    }

    public static ExpressionInfo registryExpressionInfo(Option<String> option) {
        return IndexGeometry$.MODULE$.registryExpressionInfo(option);
    }

    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$((CodegenFallback)this, (CodegenContext)ctx, (ExprCode)ev);
    }

    public Expression indexID() {
        return this.indexID;
    }

    public Expression format() {
        return this.format;
    }

    public String indexSystemName() {
        return this.indexSystemName;
    }

    public String geometryAPIName() {
        return this.geometryAPIName;
    }

    public DataType dataType() {
        StringType$ stringType$;
        Literal formatExpr = (Literal)this.format();
        String formatName = ((UTF8String)formatExpr.value()).toString();
        String string = formatName;
        if ("WKT".equals(string)) {
            stringType$ = StringType$.MODULE$;
        } else if ("WKB".equals(string)) {
            stringType$ = BinaryType$.MODULE$;
        } else if ("GEOJSON".equals(string)) {
            stringType$ = StringType$.MODULE$;
        } else if ("COORDS".equals(string)) {
            stringType$ = package$.MODULE$.InternalGeometryType();
        } else {
            throw new Error(new StringBuilder(79).append("Format name can only be 'WKT', 'WKB', 'GEOJSON' or 'COORDS', but ").append(formatName).append(" was provided.").toString());
        }
        return stringType$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TypeCheckResult checkInputDataTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.indexID().dataType(), (Object)this.format().dataType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (LongType$.MODULE$.equals(dataType) && StringType$.MODULE$.equals(dataType2)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (IntegerType$.MODULE$.equals(dataType) && StringType$.MODULE$.equals(dataType3)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 == null) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(148).append("CellGeometry expression only supports numerical and string cell IDs and StringType for format.").append("But ").append(this.indexID().dataType()).append(" was provided for ID and ").append(this.format().dataType()).append(" was provided for format.").toString());
        DataType dataType = (DataType)tuple2._1();
        DataType dataType4 = (DataType)tuple2._2();
        if (!StringType$.MODULE$.equals(dataType)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(148).append("CellGeometry expression only supports numerical and string cell IDs and StringType for format.").append("But ").append(this.indexID().dataType()).append(" was provided for ID and ").append(this.format().dataType()).append(" was provided for format.").toString());
        if (!StringType$.MODULE$.equals(dataType4)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(148).append("CellGeometry expression only supports numerical and string cell IDs and StringType for format.").append("But ").append(this.indexID().dataType()).append(" was provided for ID and ").append(this.format().dataType()).append(" was provided for format.").toString());
        return TypeCheckResult.TypeCheckSuccess$.MODULE$;
    }

    public String toString() {
        return new StringBuilder(20).append("grid_boundaryaswkb(").append(this.indexID()).append(")").toString();
    }

    public String prettyName() {
        return "grid_boundaryaswkb";
    }

    public Object nullSafeEval(Object input1, Object input2) {
        MosaicGeometry mosaicGeometry;
        IndexSystem indexSystem = IndexSystemID$.MODULE$.getIndexSystem(IndexSystemID$.MODULE$.apply(this.indexSystemName()));
        GeometryAPI geometryAPI = GeometryAPI$.MODULE$.apply(this.geometryAPIName());
        String formatName = ((UTF8String)input2).toString();
        DataType dataType = this.indexID().dataType();
        if (LongType$.MODULE$.equals(dataType)) {
            mosaicGeometry = indexSystem.indexToGeometry(BoxesRunTime.unboxToLong((Object)input1), geometryAPI);
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            mosaicGeometry = indexSystem.indexToGeometry(BoxesRunTime.unboxToInt((Object)input1), geometryAPI);
        } else if (StringType$.MODULE$.equals(dataType)) {
            mosaicGeometry = indexSystem.indexToGeometry(((UTF8String)input1).toString(), geometryAPI);
        } else {
            throw new Error(new StringBuilder(15).append(this.indexID().dataType()).append(" not supported.").toString());
        }
        MosaicGeometry indexGeometry = mosaicGeometry;
        return geometryAPI.serialize(indexGeometry, formatName);
    }

    public Expression makeCopy(Object[] newArgs) {
        Expression arg1 = (Expression)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(newArgs)).head();
        Expression arg2 = (Expression)newArgs[1];
        IndexGeometry res = new IndexGeometry(arg1, arg2, this.indexSystemName(), this.geometryAPIName());
        res.copyTagsFrom((TreeNode)this);
        return res;
    }

    public Expression left() {
        return this.indexID();
    }

    public Expression right() {
        return this.format();
    }

    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    public IndexGeometry copy(Expression indexID, Expression format, String indexSystemName, String geometryAPIName) {
        return new IndexGeometry(indexID, format, indexSystemName, geometryAPIName);
    }

    public Expression copy$default$1() {
        return this.indexID();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public String copy$default$3() {
        return this.indexSystemName();
    }

    public String copy$default$4() {
        return this.geometryAPIName();
    }

    public String productPrefix() {
        return "IndexGeometry";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.indexID();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.indexSystemName();
                break;
            }
            case 3: {
                object = this.geometryAPIName();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IndexGeometry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IndexGeometry)) return false;
        boolean bl = true;
        if (!bl) return false;
        IndexGeometry indexGeometry = (IndexGeometry)((Object)x$1);
        Expression expression = this.indexID();
        Expression expression2 = indexGeometry.indexID();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = indexGeometry.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        String string = this.indexSystemName();
        String string2 = indexGeometry.indexSystemName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.geometryAPIName();
        String string4 = indexGeometry.geometryAPIName();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (!indexGeometry.canEqual((Object)this)) return false;
        return true;
    }

    public IndexGeometry(Expression indexID, Expression format, String indexSystemName, String geometryAPIName) {
        this.indexID = indexID;
        this.format = format;
        this.indexSystemName = indexSystemName;
        this.geometryAPIName = geometryAPIName;
        CodegenFallback.$init$((CodegenFallback)this);
    }
}

