/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.expressions.format;

import com.databricks.labs.mosaic.codegen.format.ConvertToCodeGen$;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI$;
import com.databricks.labs.mosaic.core.types.package$;
import com.databricks.labs.mosaic.expressions.format.ConvertTo$;
import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr1, dataType) - Converts expr1 to the specified data type.", examples="\n    Examples:\n      > SELECT _FUNC_(a, 'hex');\n       {\"00001005FA...00A\"}\n      > SELECT _FUNC_(a, 'wkt');\n      \"POLYGON ((...))\"\n  ", since="1.0")
@ScalaSignature(bytes="\u0006\u0001\tMb\u0001B\u0012%\u0001FB\u0001\u0002\u0019\u0001\u0003\u0016\u0004%\t!\u0019\u0005\tK\u0002\u0011\t\u0012)A\u0005E\"Aa\r\u0001BK\u0002\u0013\u0005q\r\u0003\u0005q\u0001\tE\t\u0015!\u0003i\u0011!\t\bA!f\u0001\n\u00039\u0007\u0002\u0003:\u0001\u0005#\u0005\u000b\u0011\u00025\t\u000bM\u0004A\u0011\u0001;\t\u000bi\u0004A\u0011I>\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011Q\u0003\u0001\u0005B\u0005]\u0001BBA\r\u0001\u0011\u0005s\rC\u0004\u0002\u001c\u0001!\t%!\b\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,!9\u0011Q\b\u0001\u0005R\u0005}\u0002\"\u0002\u001d\u0001\t\u0003:\u0007BBA.\u0001\u0011\u0005\u0013\rC\u0004\u0002^\u0001!\t&a\u0018\t\u0013\u0005\u0015\u0004!!A\u0005\u0002\u0005\u001d\u0004\"CA8\u0001E\u0005I\u0011AA9\u0011%\t9\tAI\u0001\n\u0003\tI\tC\u0005\u0002\u000e\u0002\t\n\u0011\"\u0001\u0002\n\"I\u0011q\u0012\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0013\u0005\n\u0003C\u0003\u0011\u0011!C\u0001\u0003GC\u0011\"a+\u0001\u0003\u0003%\t!!,\t\u0013\u0005M\u0006!!A\u0005B\u0005U\u0006\"CAb\u0001\u0005\u0005I\u0011AAc\u0011%\ty\rAA\u0001\n\u0003\n\tnB\u0004\u0002p\u0012B\t!!=\u0007\r\r\"\u0003\u0012AAz\u0011\u0019\u0019X\u0004\"\u0001\u0002v\"9\u0011q_\u000f\u0005\u0002\u0005e\b\"\u0003B\b;\u0005\u0005I\u0011\u0011B\t\u0011%\u0011I\"HA\u0001\n\u0003\u0013Y\u0002C\u0005\u0003*u\t\t\u0011\"\u0003\u0003,\tI1i\u001c8wKJ$Hk\u001c\u0006\u0003K\u0019\naAZ8s[\u0006$(BA\u0014)\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005%R\u0013AB7pg\u0006L7M\u0003\u0002,Y\u0005!A.\u00192t\u0015\tic&\u0001\u0006eCR\f'M]5dWNT\u0011aL\u0001\u0004G>l7\u0001A\n\u0006\u0001I\nu+\u0018\t\u0003g}j\u0011\u0001\u000e\u0006\u0003OUR!AN\u001c\u0002\u0011\r\fG/\u00197zgRT!\u0001O\u001d\u0002\u0007M\fHN\u0003\u0002;w\u0005)1\u000f]1sW*\u0011A(P\u0001\u0007CB\f7\r[3\u000b\u0003y\n1a\u001c:h\u0013\t\u0001EGA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\u0011EK\u0004\u0002D%:\u0011A)\u0015\b\u0003\u000bBs!AR(\u000f\u0005\u001dseB\u0001%N\u001d\tIE*D\u0001K\u0015\tY\u0005'\u0001\u0004=e>|GOP\u0005\u0002}%\u0011A(P\u0005\u0003umJ!\u0001O\u001d\n\u0005Y:\u0014BA\u00146\u0013\t\u0019F'A\u0004qC\u000e\\\u0017mZ3\n\u0005U3&A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003'R\u0002\"\u0001W.\u000e\u0003eS\u0011AW\u0001\u0006g\u000e\fG.Y\u0005\u00039f\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002Y=&\u0011q,\u0017\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u000bS:<Um\\7fiJLX#\u00012\u0011\u0005M\u001a\u0017B\u000135\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\fS:<Um\\7fiJL\b%A\u0006pkR$\u0015\r^1UsB,W#\u00015\u0011\u0005%lgB\u00016l!\tI\u0015,\u0003\u0002m3\u00061\u0001K]3eK\u001aL!A\\8\u0003\rM#(/\u001b8h\u0015\ta\u0017,\u0001\u0007pkR$\u0015\r^1UsB,\u0007%A\bhK>lW\r\u001e:z\u0003BKe*Y7f\u0003A9Wm\\7fiJL\u0018\tU%OC6,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005k^D\u0018\u0010\u0005\u0002w\u00015\tA\u0005C\u0003a\u000f\u0001\u0007!\rC\u0003g\u000f\u0001\u0007\u0001\u000eC\u0003r\u000f\u0001\u0007\u0001.A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001}!\ri\u0018\u0011A\u0007\u0002}*\u0011q0N\u0001\tC:\fG._:jg&\u0019\u00111\u0001@\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f9\u0014!\u0002;za\u0016\u001c\u0018\u0002BA\n\u0003\u001b\u0011\u0001\u0002R1uCRK\b/Z\u0001\ti>\u001cFO]5oOR\t\u0001.\u0001\u0006qe\u0016$H/\u001f(b[\u0016\fAB\\;mYN\u000bg-Z#wC2$B!a\b\u0002&A\u0019\u0001,!\t\n\u0007\u0005\r\u0012LA\u0002B]fDq!a\n\r\u0001\u0004\ty\"A\u0003j]B,H/\u0001\u0005nC.,7i\u001c9z)\r\u0011\u0017Q\u0006\u0005\b\u0003_i\u0001\u0019AA\u0019\u0003\u001dqWm^!sON\u0004R\u0001WA\u001a\u0003oI1!!\u000eZ\u0005\u0015\t%O]1z!\rA\u0016\u0011H\u0005\u0004\u0003wI&AB!osJ+g-A\u0005e_\u001e+gnQ8eKR1\u0011\u0011IA'\u0003/\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000f\"\u0014aB2pI\u0016<WM\\\u0005\u0005\u0003\u0017\n)E\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tyE\u0004a\u0001\u0003#\n1a\u0019;y!\u0011\t\u0019%a\u0015\n\t\u0005U\u0013Q\t\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\tIF\u0004a\u0001\u0003\u0003\n!!\u001a<\u0002\u000b\rD\u0017\u000e\u001c3\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\r\u0011\u0017\u0011\r\u0005\u0007\u0003G\n\u0002\u0019\u00012\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR9Q/!\u001b\u0002l\u00055\u0004b\u00021\u0013!\u0003\u0005\rA\u0019\u0005\bMJ\u0001\n\u00111\u0001i\u0011\u001d\t(\u0003%AA\u0002!\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002t)\u001a!-!\u001e,\u0005\u0005]\u0004\u0003BA=\u0003\u0007k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!!Z\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000b\u000bYHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\f*\u001a\u0001.!\u001e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a%\u0011\t\u0005U\u0015qT\u0007\u0003\u0003/SA!!'\u0002\u001c\u0006!A.\u00198h\u0015\t\ti*\u0001\u0003kCZ\f\u0017b\u00018\u0002\u0018\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0015\t\u00041\u0006\u001d\u0016bAAU3\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qDAX\u0011%\t\t\fGA\u0001\u0002\u0004\t)+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003o\u0003b!!/\u0002@\u0006}QBAA^\u0015\r\ti,W\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAa\u0003w\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qYAg!\rA\u0016\u0011Z\u0005\u0004\u0003\u0017L&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003cS\u0012\u0011!a\u0001\u0003?\ta!Z9vC2\u001cH\u0003BAd\u0003'D\u0011\"!-\u001c\u0003\u0003\u0005\r!a\b)\u001f\u0001\t9.!8\u0002`\u0006\r\u0018Q]Au\u0003W\u00042aMAm\u0013\r\tY\u000e\u000e\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t/\u0001#`\rVs5i\u0018\u0015fqB\u0014\u0018\u0007\f\u0011eCR\fG+\u001f9fS\u0001j\u0003eQ8om\u0016\u0014Ho\u001d\u0011fqB\u0014\u0018\u0007\t;pAQDW\rI:qK\u000eLg-[3eA\u0011\fG/\u0019\u0011usB,g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t9/AA\b\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\nG\u0006I\u0014iKb<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011|EA\u0002\u0004\u0007M\u00191aU2\u0015I\f\u0018/aA\n%% \u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)C2\u0002se^6uO%Z$\u0002\t\u0011!A\u0001\u0002#\u0005U(M3\u001e{e\n\t\u0015)]9r\u0013&\u000b\u0012\u000bA\u0001\nQa]5oG\u0016\f#!!<\u0002\u0007Er\u0003'A\u0005D_:4XM\u001d;U_B\u0011a/H\n\u0005;\u0005]R\f\u0006\u0002\u0002r\u00061\"/Z4jgR\u0014\u00180\u0012=qe\u0016\u001c8/[8o\u0013:4w\u000e\u0006\u0004\u0002|\n\u0005!1\u0002\t\u0004g\u0005u\u0018bAA\u0000i\tqQ\t\u001f9sKN\u001c\u0018n\u001c8J]\u001a|\u0007b\u0002B\u0002?\u0001\u0007!QA\u0001\u0003I\n\u0004B\u0001\u0017B\u0004Q&\u0019!\u0011B-\u0003\r=\u0003H/[8o\u0011\u0019\u0011ia\ba\u0001Q\u0006!a.Y7f\u0003\u0015\t\u0007\u000f\u001d7z)\u001d)(1\u0003B\u000b\u0005/AQ\u0001\u0019\u0011A\u0002\tDQA\u001a\u0011A\u0002!DQ!\u001d\u0011A\u0002!\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u001e\t\u0015\u0002#\u0002-\u0003\b\t}\u0001C\u0002-\u0003\"\tD\u0007.C\u0002\u0003$e\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B\u0014C\u0005\u0005\t\u0019A;\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0017!\u0011\t)Ja\f\n\t\tE\u0012q\u0013\u0002\u0007\u001f\nTWm\u0019;")
public class ConvertTo
extends UnaryExpression
implements package.NullIntolerant,
scala.Serializable {
    private final Expression inGeometry;
    private final String outDataType;
    private final String geometryAPIName;

    public static Option<Tuple3<Expression, String, String>> unapply(ConvertTo convertTo) {
        return ConvertTo$.MODULE$.unapply(convertTo);
    }

    public static ExpressionInfo registryExpressionInfo(Option<String> option, String string) {
        return ConvertTo$.MODULE$.registryExpressionInfo(option, string);
    }

    public Expression inGeometry() {
        return this.inGeometry;
    }

    public String outDataType() {
        return this.outDataType;
    }

    public String geometryAPIName() {
        return this.geometryAPIName;
    }

    public TypeCheckResult checkInputDataTypes() {
        Seq inputTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{BinaryType$.MODULE$, StringType$.MODULE$, package$.MODULE$.HexType(), package$.MODULE$.JSONType(), package$.MODULE$.InternalGeometryType()}));
        Seq outputDataTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WKT", "WKB", "COORDS", "HEX", "GEOJSON", "JSONOBJECT"}));
        return inputTypes.contains((Object)this.inGeometry().dataType()) && outputDataTypes.contains((Object)this.outDataType().toUpperCase(Locale.ROOT)) ? TypeCheckResult.TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(24).append("Cannot convert from ").append(this.inGeometry().dataType().sql()).append(" to ").append(this.dataType()).toString());
    }

    public DataType dataType() {
        StringType$ stringType$;
        String string = this.outDataType().toUpperCase(Locale.ROOT);
        if ("WKT".equals(string)) {
            stringType$ = StringType$.MODULE$;
        } else if ("WKB".equals(string)) {
            stringType$ = BinaryType$.MODULE$;
        } else if ("HEX".equals(string)) {
            stringType$ = package$.MODULE$.HexType();
        } else if ("COORDS".equals(string)) {
            stringType$ = package$.MODULE$.InternalGeometryType();
        } else if ("GEOJSON".equals(string)) {
            stringType$ = StringType$.MODULE$;
        } else if ("JSONOBJECT".equals(string)) {
            stringType$ = package$.MODULE$.JSONType();
        } else {
            throw new Error(new StringBuilder(25).append("Data type not supported: ").append(this.outDataType()).toString());
        }
        return stringType$;
    }

    public String toString() {
        return new StringBuilder(14).append("convert_to(").append(this.inGeometry()).append(", ").append(this.outDataType()).append(")").toString();
    }

    public String prettyName() {
        return "convert_to";
    }

    public Object nullSafeEval(Object input) {
        Object object;
        String string = this.inGeometry().dataType().simpleString();
        String string2 = this.outDataType();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            object = input;
        } else {
            GeometryAPI geometryAPI = GeometryAPI$.MODULE$.apply(this.geometryAPIName());
            MosaicGeometry geometry = geometryAPI.geometry(input, this.inGeometry().dataType());
            object = geometryAPI.serialize(geometry, this.outDataType());
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public Expression makeCopy(Object[] newArgs) {
        void var2_2;
        ConvertTo res = new ConvertTo((Expression)newArgs[0], this.outDataType(), this.geometryAPIName());
        res.copyTagsFrom((TreeNode)this);
        return var2_2;
    }

    public ExprCode doGenCode(CodegenContext ctx2, ExprCode ev2) {
        GeometryAPI geometryAPI = GeometryAPI$.MODULE$.apply(this.geometryAPIName());
        return ConvertToCodeGen$.MODULE$.doCodeGen(ctx2, ev2, (Function3<CodegenContext, ExprCode, Function1<String, String>, ExprCode>)(Function3 & Serializable & scala.Serializable)(ctx, ev, f) -> this.nullSafeCodeGen((CodegenContext)ctx, (ExprCode)ev, (Function1)f), this.child().dataType(), this.outDataType().toUpperCase(Locale.ROOT), geometryAPI);
    }

    public String sql() {
        String childrenSQL = ((TraversableOnce)this.children().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.sql(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        return new StringBuilder(6).append(this.prettyName()).append("(").append(childrenSQL).append(", '").append(this.outDataType()).append("')").toString();
    }

    public Expression child() {
        return this.inGeometry();
    }

    public Expression withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public ConvertTo copy(Expression inGeometry, String outDataType, String geometryAPIName) {
        return new ConvertTo(inGeometry, outDataType, geometryAPIName);
    }

    public Expression copy$default$1() {
        return this.inGeometry();
    }

    public String copy$default$2() {
        return this.outDataType();
    }

    public String copy$default$3() {
        return this.geometryAPIName();
    }

    public String productPrefix() {
        return "ConvertTo";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.inGeometry();
                break;
            }
            case 1: {
                object = this.outDataType();
                break;
            }
            case 2: {
                object = this.geometryAPIName();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ConvertTo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ConvertTo)) return false;
        boolean bl = true;
        if (!bl) return false;
        ConvertTo convertTo = (ConvertTo)((Object)x$1);
        Expression expression = this.inGeometry();
        Expression expression2 = convertTo.inGeometry();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        String string = this.outDataType();
        String string2 = convertTo.outDataType();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.geometryAPIName();
        String string4 = convertTo.geometryAPIName();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (!convertTo.canEqual((Object)this)) return false;
        return true;
    }

    public ConvertTo(Expression inGeometry, String outDataType, String geometryAPIName) {
        this.inGeometry = inGeometry;
        this.outDataType = outDataType;
        this.geometryAPIName = geometryAPIName;
    }
}

