/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.index;

import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.linestring.MosaicLineString;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.index.BNG$;
import com.databricks.labs.mosaic.core.index.IndexSystem;
import com.databricks.labs.mosaic.core.index.IndexSystemID;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.MosaicChip;
import java.io.Serializable;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class BNGIndexSystem$
implements IndexSystem {
    public static BNGIndexSystem$ MODULE$;
    private final Seq<String> quadrants;
    private final Map<String, Object> resolutionMap;
    private final Map<String, Object> sizeMap;
    private final Seq<Seq<String>> letterMap;

    static {
        new BNGIndexSystem$();
    }

    @Override
    public String name() {
        return IndexSystem.name$(this);
    }

    @Override
    public Option<GeometryAPI> polyfill$default$3() {
        return IndexSystem.polyfill$default$3$(this);
    }

    @Override
    public Seq<MosaicChip> getBorderChips(MosaicGeometry geometry, Seq<Object> borderIndices, boolean keepCoreGeom, GeometryAPI geometryAPI) {
        return IndexSystem.getBorderChips$(this, geometry, borderIndices, keepCoreGeom, geometryAPI);
    }

    @Override
    public Seq<MosaicChip> getCoreChips(Seq<Object> coreIndices, boolean keepCoreGeom, GeometryAPI geometryAPI) {
        return IndexSystem.getCoreChips$(this, coreIndices, keepCoreGeom, geometryAPI);
    }

    public Seq<String> quadrants() {
        return this.quadrants;
    }

    public Map<String, Object> resolutionMap() {
        return this.resolutionMap;
    }

    public Map<String, Object> sizeMap() {
        return this.sizeMap;
    }

    public Seq<Seq<String>> letterMap() {
        return this.letterMap;
    }

    @Override
    public String format(long id) {
        String string;
        Seq<Object> digits = this.indexDigits(id);
        if (digits.length() < 6) {
            String prefix;
            string = prefix = ((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString((String)((SeqLike)this.letterMap().apply(new StringOps(Predef$.MODULE$.augmentString(((TraversableOnce)digits.slice(3, 5)).mkString())).toInt())).apply(new StringOps(Predef$.MODULE$.augmentString(((TraversableOnce)digits.slice(1, 3)).mkString())).toInt())), 0))).toString();
        } else {
            int quadrant = BoxesRunTime.unboxToInt((Object)digits.last());
            String prefix = (String)((SeqLike)this.letterMap().apply(new StringOps(Predef$.MODULE$.augmentString(((TraversableOnce)digits.slice(3, 5)).mkString())).toInt())).apply(new StringOps(Predef$.MODULE$.augmentString(((TraversableOnce)digits.slice(1, 3)).mkString())).toInt());
            Seq coords = (Seq)((IterableLike)digits.drop(5)).dropRight(1);
            int k = coords.length() / 2;
            String xStr = coords.isEmpty() ? "" : ((TraversableOnce)((SeqLike)coords.slice(0, k)).padTo(k, (Object)BoxesRunTime.boxToInteger((int)0), Seq$.MODULE$.canBuildFrom())).mkString();
            String yStr = coords.isEmpty() ? "" : ((TraversableOnce)((SeqLike)coords.slice(k, 2 * k)).padTo(k, (Object)BoxesRunTime.boxToInteger((int)0), Seq$.MODULE$.canBuildFrom())).mkString();
            String qStr = (String)this.quadrants().apply(quadrant);
            string = new StringBuilder(0).append(prefix).append(xStr).append(yStr).append(qStr).toString();
        }
        return string;
    }

    @Override
    public double getBufferRadius(MosaicGeometry geometry, int resolution, GeometryAPI geometryAPI) {
        int size = this.getEdgeSize(resolution);
        return (double)size * package$.MODULE$.sqrt(2.0) / (double)2;
    }

    public int getEdgeSize(int resolution) {
        String resolutionStr = this.getResolutionStr(resolution);
        return this.getEdgeSize(resolutionStr);
    }

    public int getEdgeSize(String resolution) {
        return BoxesRunTime.unboxToInt((Object)this.sizeMap().apply((Object)resolution));
    }

    @Override
    public Seq<Object> polyfill(MosaicGeometry geometry, int resolution, Option<GeometryAPI> geometryAPI) {
        Seq seq;
        Predef$.MODULE$.require(geometryAPI.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "GeometryAPI cannot be None for BNG Index System.");
        if (geometry.isEmpty()) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            Seq<MosaicLineString> shells = geometry.getShells();
            Seq<Seq<MosaicLineString>> holes = geometry.getHoles();
            Seq startPoints = (Seq)((TraversableLike)((TraversableLike)shells.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.asSeq(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)holes.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> (Seq)x$5.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.asSeq(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MosaicPoint[]{geometry.getCentroid()})), Seq$.MODULE$.canBuildFrom());
            Seq startIndices = (Seq)startPoints.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToLong((long)BNGIndexSystem$.MODULE$.pointToIndex(p.getX(), p.getY(), resolution)), Seq$.MODULE$.canBuildFrom());
            seq = this.visit$1(startIndices.toSet(), Predef$.MODULE$.Set().empty(), Predef$.MODULE$.Set().empty(), geometry, geometryAPI).toSeq();
        }
        return seq;
    }

    @Override
    public IndexSystemID getIndexSystemID() {
        return BNG$.MODULE$;
    }

    @Override
    public Seq<Object> kRing(long index, int n) {
        return n == 1 ? (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{index}))).$plus$plus(this.kDisk(index, 1), Seq$.MODULE$.canBuildFrom()) : (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{index}))).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), n).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> BNGIndexSystem$.MODULE$.kDisk(index, BoxesRunTime.unboxToInt((Object)x$7)), IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<Object> kDisk(long index2, int k) {
        Seq<Object> digits = this.indexDigits(index2);
        int resolution = this.getResolution(digits);
        int edgeSize = this.getEdgeSize(resolution);
        int x = this.getX(digits, edgeSize);
        int y = this.getY(digits, edgeSize);
        IndexedSeq bottom = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2 * k).map((Function1 & Serializable & scala.Serializable)c -> BNGIndexSystem$.$anonfun$kDisk$1(x, k, edgeSize, y, BoxesRunTime.unboxToInt((Object)c)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq right = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2 * k).map((Function1 & Serializable & scala.Serializable)c -> BNGIndexSystem$.$anonfun$kDisk$2(x, k, edgeSize, y, BoxesRunTime.unboxToInt((Object)c)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq top = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2 * k).map((Function1 & Serializable & scala.Serializable)c -> BNGIndexSystem$.$anonfun$kDisk$3(x, k, edgeSize, y, BoxesRunTime.unboxToInt((Object)c)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq left = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2 * k).map((Function1 & Serializable & scala.Serializable)c -> BNGIndexSystem$.$anonfun$kDisk$4(x, k, edgeSize, y, BoxesRunTime.unboxToInt((Object)c)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq neighbours = (IndexedSeq)((TraversableLike)((TraversableLike)((TraversableLike)bottom.$plus$plus((GenTraversableOnce)right, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)top, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)left, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)BNGIndexSystem$.$anonfun$kDisk$5(resolution, x0$1)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq result = (IndexedSeq)neighbours.filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)index -> MODULE$.isValid(index));
        return result;
    }

    public boolean isValid(long index) {
        Seq<Object> digits = this.indexDigits(index);
        int resolution = this.getResolution(digits);
        int edgeSize = this.getEdgeSize(resolution);
        int x = this.getX(digits, edgeSize);
        int y = this.getY(digits, edgeSize);
        return x >= 0 && x <= 700000 && y >= 0 && y <= 1300000;
    }

    @Override
    public long pointToIndex(double eastings, double northings, int resolution) {
        int eastingsInt = (int)eastings;
        int northingsInt = (int)northings;
        int eLetter = (int)package$.MODULE$.floor((double)(eastingsInt / 100000));
        int nLetter = (int)package$.MODULE$.floor((double)(northingsInt / 100000));
        double divisor = resolution < 0 ? package$.MODULE$.pow(10.0, (double)(6 - package$.MODULE$.abs(resolution) + 1)) : package$.MODULE$.pow(10.0, (double)(6 - resolution));
        int quadrant = this.getQuadrant(resolution, eastingsInt, northingsInt, divisor);
        int nPositions = resolution >= -1 ? package$.MODULE$.abs(resolution) : package$.MODULE$.abs(resolution) - 1;
        int eBin = (int)package$.MODULE$.floor((double)(eastingsInt % 100000) / divisor);
        int nBin = (int)package$.MODULE$.floor((double)(northingsInt % 100000) / divisor);
        return this.encode(eLetter, nLetter, eBin, nBin, quadrant, nPositions, resolution);
    }

    public int getQuadrant(int resolution, double eastings, double northings, double divisor) {
        int n;
        if (resolution < -1) {
            double n2;
            double e;
            double n3;
            double e2;
            double nDecimal;
            double eQ = eastings / divisor;
            double nQ = northings / divisor;
            double eDecimal = eQ - package$.MODULE$.floor(eQ);
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(eDecimal, nDecimal = nQ - package$.MODULE$.floor(nQ));
            int n4 = sp2 != null && (e2 = sp2._1$mcD$sp()) < 0.5 & (n3 = sp2._2$mcD$sp()) < 0.5 ? 1 : (sp2 != null && (e = sp2._1$mcD$sp()) < 0.5 ? 2 : (sp2 != null && (n2 = sp2._2$mcD$sp()) < 0.5 ? 4 : 3));
            n = n4;
        } else {
            n = 0;
        }
        int quadrant = n;
        return quadrant;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getResolution(Object res) {
        Try try_;
        Try try_2;
        Tuple3 tuple3 = new Tuple3((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)res)), (Object)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (String)res), (Object)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((UTF8String)res).toString()));
        if (tuple3 != null && (try_2 = (Try)tuple3._1()) instanceof Success) {
            Success success = (Success)try_2;
            int value = BoxesRunTime.unboxToInt((Object)success.value());
            if (this.resolutions().contains((Object)BoxesRunTime.boxToInteger((int)value))) {
                return value;
            }
        }
        if (tuple3 != null && (try_ = (Try)tuple3._3()) instanceof Success) {
            Success success = (Success)try_;
            String value = (String)success.value();
            if (this.resolutionMap().contains((Object)value)) {
                return BoxesRunTime.unboxToInt((Object)this.resolutionMap().apply((Object)value));
            }
        }
        if (tuple3 == null) throw new IllegalStateException(new StringBuilder(36).append("BNG resolution not supported; found ").append(res).toString());
        Try try_3 = (Try)tuple3._2();
        if (!(try_3 instanceof Success)) throw new IllegalStateException(new StringBuilder(36).append("BNG resolution not supported; found ").append(res).toString());
        Success success = (Success)try_3;
        String value = (String)success.value();
        if (!this.resolutionMap().contains((Object)value)) throw new IllegalStateException(new StringBuilder(36).append("BNG resolution not supported; found ").append(res).toString());
        return BoxesRunTime.unboxToInt((Object)this.resolutionMap().apply((Object)value));
    }

    @Override
    public Set<Object> resolutions() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, -1, 2, -2, 3, -3, 4, -4, 5, -5, 6, -6}));
    }

    @Override
    public MosaicGeometry indexToGeometry(String index, GeometryAPI geometryAPI) {
        long indexId = this.parse(index);
        return this.indexToGeometry(indexId, geometryAPI);
    }

    public long parse(String index) {
        long l;
        String prefix = index.length() >= 2 ? (String)new StringOps(Predef$.MODULE$.augmentString(index)).take(2) : new StringBuilder(1).append(index).append("V").toString();
        Seq letterRow = (Seq)this.letterMap().find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.contains((Object)prefix))).get();
        int eLetter = letterRow.indexOf((Object)prefix);
        int nLetter = this.letterMap().indexOf((Object)letterRow);
        if (index.length() == 1) {
            l = this.encode(eLetter, 0, 0, 0, 0, 1, -1);
        } else {
            String binDigits;
            String suffix = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(index), index.length() - 2, index.length());
            int quadrant = this.quadrants().contains((Object)suffix) ? this.quadrants().indexOf((Object)suffix) : 0;
            String string = binDigits = quadrant > 0 ? (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(index)).drop(2))).dropRight(2) : (String)new StringOps(Predef$.MODULE$.augmentString(index)).drop(2);
            if (binDigits.isEmpty()) {
                l = this.encode(eLetter, nLetter, 0, 0, quadrant, 1, -2);
            } else {
                int eBin = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(binDigits)).dropRight(binDigits.length() / 2))).toInt();
                int nBin = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(binDigits)).drop(binDigits.length() / 2))).toInt();
                int nPositions = binDigits.length() / 2 + 1;
                int resolution = quadrant == 0 ? nPositions + 1 : -nPositions;
                l = this.encode(eLetter, nLetter, eBin, nBin, quadrant, nPositions, resolution);
            }
        }
        return l;
    }

    private long encode(int eLetter, int nLetter, int eBin, int nBin, int quadrant, int nPositions, int resolution) {
        double idPlaceholder = package$.MODULE$.pow(10.0, (double)(5 + 2 * nPositions - 2));
        double eLetterShift = package$.MODULE$.pow(10.0, (double)(3 + 2 * nPositions - 2));
        double nLetterShift = package$.MODULE$.pow(10.0, (double)(1 + 2 * nPositions - 2));
        double eShift = package$.MODULE$.pow(10.0, (double)nPositions);
        int nShift = 10;
        double id = resolution == -1 ? (idPlaceholder + (double)eLetter * eLetterShift) / (double)100 + (double)quadrant : idPlaceholder + (double)eLetter * eLetterShift + (double)nLetter * nLetterShift + (double)eBin * eShift + (double)(nBin * nShift) + (double)quadrant;
        return (long)id;
    }

    @Override
    public MosaicGeometry indexToGeometry(long index, GeometryAPI geometryAPI) {
        Seq<Object> digits = this.indexDigits(index);
        int resolution = this.getResolution(digits);
        int edgeSize = this.getEdgeSize(resolution);
        int x = this.getX(digits, edgeSize);
        int y = this.getY(digits, edgeSize);
        MosaicPoint p1 = geometryAPI.fromCoords((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{x, y}))));
        MosaicPoint p2 = geometryAPI.fromCoords((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{x + edgeSize, y}))));
        MosaicPoint p3 = geometryAPI.fromCoords((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{x + edgeSize, y + edgeSize}))));
        MosaicPoint p4 = geometryAPI.fromCoords((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{x, y + edgeSize}))));
        return geometryAPI.geometry((Seq<MosaicPoint>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MosaicPoint[]{p1, p2, p3, p4, p1}))), GeometryTypeEnum$.MODULE$.POLYGON());
    }

    public Seq<Object> indexDigits(long index) {
        return (Seq)new StringOps(Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToLong((long)index)).toString())).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)RichChar$.MODULE$.asDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$9)))), Predef$.MODULE$.fallbackStringCanBuildFrom());
    }

    public int getResolution(Seq<Object> digits) {
        int n;
        if (digits.length() < 6) {
            n = -1;
        } else {
            int quadrant = BoxesRunTime.unboxToInt((Object)digits.last());
            int n2 = digits.length();
            int k = (n2 - 6) / 2;
            n = quadrant > 0 ? -(k + 2) : k + 1;
        }
        return n;
    }

    public int getX(Seq<Object> digits, int edgeSize) {
        int n = digits.length();
        int k = (n - 6) / 2;
        Seq xDigits = (Seq)((TraversableLike)digits.slice(1, 3)).$plus$plus((GenTraversableOnce)digits.slice(5, 5 + k), Seq$.MODULE$.canBuildFrom());
        int quadrant = BoxesRunTime.unboxToInt((Object)digits.last());
        int edgeSizeAdj = quadrant > 0 ? 2 * edgeSize : edgeSize;
        int xOffset = quadrant == 3 || quadrant == 4 ? edgeSize : 0;
        return new StringOps(Predef$.MODULE$.augmentString(xDigits.mkString())).toInt() * edgeSizeAdj + xOffset;
    }

    public int getY(Seq<Object> digits, int edgeSize) {
        int n = digits.length();
        int k = (n - 6) / 2;
        Seq yDigits = (Seq)((TraversableLike)digits.slice(3, 5)).$plus$plus((GenTraversableOnce)digits.slice(5 + k, 5 + 2 * k), Seq$.MODULE$.canBuildFrom());
        int quadrant = BoxesRunTime.unboxToInt((Object)digits.last());
        int edgeSizeAdj = quadrant > 0 ? 2 * edgeSize : edgeSize;
        int yOffset = quadrant == 2 || quadrant == 3 ? edgeSize : 0;
        return new StringOps(Predef$.MODULE$.augmentString(yDigits.mkString())).toInt() * edgeSizeAdj + yOffset;
    }

    @Override
    public DataType defaultDataTypeID() {
        return StringType$.MODULE$;
    }

    @Override
    public String getResolutionStr(int resolution) {
        return (String)this.resolutionMap().find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)BNGIndexSystem$.$anonfun$getResolutionStr$1(resolution, x$10))).map((Function1 & Serializable & scala.Serializable)x$11 -> (String)x$11._1()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Tuple2 $anonfun$polyfill$2(MosaicGeometry geometry$1, Option geometryAPI$1, long index) {
        return new Tuple2.mcJZ.sp(index, geometry$1.contains(MODULE$.indexToGeometry(index, (GeometryAPI)geometryAPI$1.get()).getCentroid()));
    }

    private final Set visit$1(Set queue, Set visited, Set result, MosaicGeometry geometry$1, Option geometryAPI$1) {
        Set newResult;
        while (true) {
            Set visits = (Set)queue.map((Function1 & Serializable & scala.Serializable)index -> BNGIndexSystem$.$anonfun$polyfill$2(geometry$1, geometryAPI$1, BoxesRunTime.unboxToLong((Object)index)), Set$.MODULE$.canBuildFrom());
            Set matches = (Set)visits.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1._2$mcZ$sp()));
            Set newVisited = (Set)visited.$plus$plus((GenTraversableOnce)visits.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2._1$mcJ$sp()), Set$.MODULE$.canBuildFrom()));
            Set newQueue = (Set)matches.flatMap((Function1 & Serializable & scala.Serializable)c -> (Seq)MODULE$.kDisk(c._1$mcJ$sp(), 1).filterNot((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)elem -> newVisited.contains((Object)BoxesRunTime.boxToLong((long)elem))), Set$.MODULE$.canBuildFrom());
            newResult = (Set)result.$plus$plus((GenTraversableOnce)matches.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3._1$mcJ$sp()), Set$.MODULE$.canBuildFrom()));
            if (newQueue.isEmpty()) break;
            result = newResult;
            visited = newVisited;
            queue = newQueue;
        }
        return newResult;
    }

    public static final /* synthetic */ Tuple2 $anonfun$kDisk$1(int x$12, int k$1, int edgeSize$1, int y$1, int c) {
        return new Tuple2.mcII.sp(x$12 + (c - k$1) * edgeSize$1, y$1 - k$1 * edgeSize$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$kDisk$2(int x$12, int k$1, int edgeSize$1, int y$1, int c) {
        return new Tuple2.mcII.sp(x$12 + k$1 * edgeSize$1, y$1 + (c - k$1) * edgeSize$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$kDisk$3(int x$12, int k$1, int edgeSize$1, int y$1, int c) {
        return new Tuple2.mcII.sp(x$12 + (k$1 - c) * edgeSize$1, y$1 + k$1 * edgeSize$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$kDisk$4(int x$12, int k$1, int edgeSize$1, int y$1, int c) {
        return new Tuple2.mcII.sp(x$12 - k$1 * edgeSize$1, y$1 + (k$1 - c) * edgeSize$1);
    }

    public static final /* synthetic */ long $anonfun$kDisk$5(int resolution$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int x = tuple2._1$mcI$sp();
        int y = tuple2._2$mcI$sp();
        long l = MODULE$.pointToIndex(x, y, resolution$2);
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$getResolutionStr$1(int resolution$3, Tuple2 x$10) {
        return x$10._2$mcI$sp() == resolution$3;
    }

    private BNGIndexSystem$() {
        MODULE$ = this;
        IndexSystem.$init$(this);
        this.quadrants = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "SW", "NW", "NE", "SE"}));
        this.resolutionMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"500km"), (Object)BoxesRunTime.boxToInteger((int)-1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"100km"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"50km"), (Object)BoxesRunTime.boxToInteger((int)-2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"10km"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"5km"), (Object)BoxesRunTime.boxToInteger((int)-3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1km"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"500m"), (Object)BoxesRunTime.boxToInteger((int)-4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"100m"), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"50m"), (Object)BoxesRunTime.boxToInteger((int)-5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"10m"), (Object)BoxesRunTime.boxToInteger((int)5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"5m"), (Object)BoxesRunTime.boxToInteger((int)-6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1m"), (Object)BoxesRunTime.boxToInteger((int)6))}));
        this.sizeMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"500km"), (Object)BoxesRunTime.boxToInteger((int)500000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"100km"), (Object)BoxesRunTime.boxToInteger((int)100000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"50km"), (Object)BoxesRunTime.boxToInteger((int)50000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"10km"), (Object)BoxesRunTime.boxToInteger((int)10000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"5km"), (Object)BoxesRunTime.boxToInteger((int)5000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1km"), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"500m"), (Object)BoxesRunTime.boxToInteger((int)500)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"100m"), (Object)BoxesRunTime.boxToInteger((int)100)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"50m"), (Object)BoxesRunTime.boxToInteger((int)50)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"10m"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"5m"), (Object)BoxesRunTime.boxToInteger((int)5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1m"), (Object)BoxesRunTime.boxToInteger((int)1))}));
        this.letterMap = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SV", "SW", "SX", "SY", "SZ", "TV", "TW"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SQ", "SR", "SS", "ST", "SU", "TQ", "TR"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SL", "SM", "SN", "SO", "SP", "TL", "TM"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SF", "SG", "SH", "SJ", "SK", "TF", "TG"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SA", "SB", "SC", "SD", "SE", "TA", "TB"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NV", "NW", "NX", "NY", "NZ", "OV", "OW"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NQ", "NR", "NS", "NT", "NU", "OQ", "OR"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NL", "NM", "NN", "NO", "NP", "OL", "OM"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NF", "NG", "NH", "NJ", "NK", "OF", "OG"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NA", "NB", "NC", "ND", "NE", "OA", "OB"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HV", "HW", "HX", "HY", "SZ", "JV", "JW"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HQ", "HR", "HS", "HT", "HU", "JQ", "JR"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HL", "HM", "HN", "HO", "HP", "JL", "JM"}))}));
    }
}

