/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.geometry.point;

import com.databricks.labs.mosaic.core.geometry.GeometryReader;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometryESRI$;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPointESRI;
import com.databricks.labs.mosaic.core.types.model.Coordinates;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.InternalCoord;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry$;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCPoint;
import org.apache.spark.sql.catalyst.InternalRow;
import scala.Enumeration;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class MosaicPointESRI$
implements GeometryReader,
Serializable {
    public static MosaicPointESRI$ MODULE$;
    private final int defaultSpatialReferenceId;

    static {
        new MosaicPointESRI$();
    }

    @Override
    public int defaultSpatialReferenceId() {
        return this.defaultSpatialReferenceId;
    }

    @Override
    public void com$databricks$labs$mosaic$core$geometry$GeometryReader$_setter_$defaultSpatialReferenceId_$eq(int x$1) {
        this.defaultSpatialReferenceId = x$1;
    }

    public MosaicPointESRI apply(Coordinates geoCoord) {
        return this.apply((OGCGeometry)new OGCPoint(new Point(geoCoord.lng(), geoCoord.lat()), SpatialReference.create((int)this.defaultSpatialReferenceId())));
    }

    public MosaicPointESRI apply(Seq<Object> coords) {
        return coords.length() == 3 ? this.apply((OGCGeometry)new OGCPoint(new Point(BoxesRunTime.unboxToDouble((Object)coords.apply(0)), BoxesRunTime.unboxToDouble((Object)coords.apply(1)), BoxesRunTime.unboxToDouble((Object)coords.apply(2))), SpatialReference.create((int)this.defaultSpatialReferenceId()))) : this.apply((OGCGeometry)new OGCPoint(new Point(BoxesRunTime.unboxToDouble((Object)coords.apply(0)), BoxesRunTime.unboxToDouble((Object)coords.apply(1))), SpatialReference.create((int)this.defaultSpatialReferenceId())));
    }

    public MosaicPointESRI apply(OGCGeometry point) {
        return new MosaicPointESRI((OGCPoint)point);
    }

    @Override
    public MosaicGeometry fromInternal(InternalRow row) {
        InternalGeometry internalGeom = InternalGeometry$.MODULE$.apply(row);
        Predef$.MODULE$.require(internalGeom.typeId() == GeometryTypeEnum$.MODULE$.POINT().id());
        InternalCoord coordinate = (InternalCoord)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])internalGeom.boundaries())).head())).head();
        SpatialReference spatialReference = internalGeom.srid() != 0 ? SpatialReference.create((int)internalGeom.srid()) : MosaicGeometryESRI$.MODULE$.defaultSpatialReference();
        OGCPoint point = coordinate.coords().length() == 2 ? new OGCPoint(new Point(BoxesRunTime.unboxToDouble((Object)coordinate.coords().apply(0)), BoxesRunTime.unboxToDouble((Object)coordinate.coords().apply(1))), spatialReference) : new OGCPoint(new Point(BoxesRunTime.unboxToDouble((Object)coordinate.coords().apply(0)), BoxesRunTime.unboxToDouble((Object)coordinate.coords().apply(1)), BoxesRunTime.unboxToDouble((Object)coordinate.coords().apply(2))), spatialReference);
        return new MosaicPointESRI(point);
    }

    @Override
    public <T extends MosaicGeometry> MosaicPointESRI fromSeq(Seq<T> geomSeq, Enumeration.Value geomType) {
        OGCPoint oGCPoint;
        SpatialReference spatialReference = SpatialReference.create((int)((MosaicGeometry)geomSeq.head()).getSpatialReference());
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(((MosaicGeometry)geomSeq.head()).getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.POINT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            MosaicPoint extractedPoint = (MosaicPoint)geomSeq.head();
            int n = extractedPoint.asSeq().length();
            switch (n) {
                case 3: {
                    oGCPoint = new OGCPoint(new Point(extractedPoint.getX(), extractedPoint.getY(), extractedPoint.getZ()), spatialReference);
                    break;
                }
                case 2: {
                    oGCPoint = new OGCPoint(new Point(extractedPoint.getX(), extractedPoint.getY()), spatialReference);
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        } else {
            if (value != null) {
                Enumeration.Value value4 = value;
                throw new UnsupportedOperationException(new StringBuilder(57).append("MosaicGeometry.fromSeq() cannot create ").append(geomType.toString()).append(" from ").append(value4.toString()).append(" geometries.").toString());
            }
            throw new MatchError((Object)value);
        }
        OGCPoint oGCPoint2 = oGCPoint;
        OGCPoint newGeom = oGCPoint2;
        return this.apply((OGCGeometry)newGeom);
    }

    public <T extends MosaicGeometry> Enumeration.Value fromSeq$default$2() {
        return GeometryTypeEnum$.MODULE$.POINT();
    }

    @Override
    public MosaicGeometry fromWKB(byte[] wkb) {
        return MosaicGeometryESRI$.MODULE$.fromWKB(wkb);
    }

    @Override
    public MosaicGeometry fromWKT(String wkt) {
        return MosaicGeometryESRI$.MODULE$.fromWKT(wkt);
    }

    @Override
    public MosaicGeometry fromJSON(String geoJson) {
        return MosaicGeometryESRI$.MODULE$.fromJSON(geoJson);
    }

    @Override
    public MosaicGeometry fromHEX(String hex) {
        return MosaicGeometryESRI$.MODULE$.fromHEX(hex);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MosaicPointESRI$() {
        MODULE$ = this;
        GeometryReader.$init$(this);
    }
}

