/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.geometry.multipolygon;

import com.databricks.labs.mosaic.core.geometry.GeometryReader;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometryJTS$;
import com.databricks.labs.mosaic.core.geometry.multipolygon.MosaicMultiPolygonJTS;
import com.databricks.labs.mosaic.core.geometry.polygon.MosaicPolygonJTS;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.InternalCoord;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry$;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class MosaicMultiPolygonJTS$
implements GeometryReader,
scala.Serializable {
    public static MosaicMultiPolygonJTS$ MODULE$;
    private final int defaultSpatialReferenceId;

    static {
        new MosaicMultiPolygonJTS$();
    }

    @Override
    public int defaultSpatialReferenceId() {
        return this.defaultSpatialReferenceId;
    }

    @Override
    public void com$databricks$labs$mosaic$core$geometry$GeometryReader$_setter_$defaultSpatialReferenceId_$eq(int x$1) {
        this.defaultSpatialReferenceId = x$1;
    }

    @Override
    public MosaicGeometry fromInternal(InternalRow row) {
        GeometryFactory gf = new GeometryFactory();
        InternalGeometry internalGeom = InternalGeometry$.MODULE$.apply(row);
        gf.createLinearRing(gf.createLineString().getCoordinates());
        Polygon[] polygons = (Polygon[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])internalGeom.boundaries())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])internalGeom.holes()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InternalCoord[] boundaryRing = (InternalCoord[])tuple2._1();
            InternalCoord[][] holesRings = (InternalCoord[][])tuple2._2();
            LinearRing shell = gf.createLinearRing((Coordinate[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])boundaryRing)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toCoordinate(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class))));
            LinearRing[] holes = (LinearRing[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])holesRings)).map((Function1 & Serializable & scala.Serializable)ring -> (Coordinate[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ring)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toCoordinate(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Coordinate.class))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Coordinate.class)))))).map((Function1 & Serializable & scala.Serializable)x$1 -> gf.createLinearRing(x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LinearRing.class)));
            Polygon polygon = gf.createPolygon(shell, holes);
            return polygon;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Polygon.class)));
        MultiPolygon multiPolygon = gf.createMultiPolygon(polygons);
        multiPolygon.setSRID(internalGeom.srid());
        return this.apply((Geometry)multiPolygon);
    }

    @Override
    public <T extends MosaicGeometry> MosaicMultiPolygonJTS fromSeq(Seq<T> geomSeq, Enumeration.Value geomType) {
        GeometryFactory gf = new GeometryFactory();
        int spatialReference = ((MosaicGeometry)geomSeq.head()).getSpatialReference();
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(((MosaicGeometry)geomSeq.head()).getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.POLYGON();
        Enumeration.Value value3 = value;
        if (value2 != null ? !value2.equals(value3) : value3 != null) {
            if (value != null) {
                Enumeration.Value value4 = value;
                throw new UnsupportedOperationException(new StringBuilder(57).append("MosaicGeometry.fromSeq() cannot create ").append(geomType.toString()).append(" from ").append(value4.toString()).append(" geometries.").toString());
            }
            throw new MatchError((Object)value);
        }
        Seq extractedPolys = (Seq)geomSeq.map((Function1 & Serializable & scala.Serializable)x$6 -> (MosaicPolygonJTS)x$6, Seq$.MODULE$.canBuildFrom());
        MultiPolygon multiPolygon = gf.createMultiPolygon((Polygon[])((TraversableOnce)extractedPolys.map((Function1 & Serializable & scala.Serializable)x$7 -> (Polygon)x$7.getGeom(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Polygon.class)));
        MultiPolygon newGeom = multiPolygon;
        newGeom.setSRID(spatialReference);
        return this.apply((Geometry)newGeom);
    }

    public <T extends MosaicGeometry> Enumeration.Value fromSeq$default$2() {
        return GeometryTypeEnum$.MODULE$.MULTIPOLYGON();
    }

    public MosaicMultiPolygonJTS apply(Geometry multiPolygon) {
        return new MosaicMultiPolygonJTS((MultiPolygon)multiPolygon);
    }

    @Override
    public MosaicGeometry fromWKB(byte[] wkb) {
        return MosaicGeometryJTS$.MODULE$.fromWKB(wkb);
    }

    @Override
    public MosaicGeometry fromWKT(String wkt) {
        return MosaicGeometryJTS$.MODULE$.fromWKT(wkt);
    }

    @Override
    public MosaicGeometry fromJSON(String geoJson) {
        return MosaicGeometryJTS$.MODULE$.fromJSON(geoJson);
    }

    @Override
    public MosaicGeometry fromHEX(String hex) {
        return MosaicGeometryJTS$.MODULE$.fromHEX(hex);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MosaicMultiPolygonJTS$() {
        MODULE$ = this;
        GeometryReader.$init$(this);
    }
}

