/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.geometry.api;

import com.databricks.labs.mosaic.codegen.format.GeometryIOCodeGen;
import com.databricks.labs.mosaic.core.geometry.GeometryFormat$;
import com.databricks.labs.mosaic.core.geometry.GeometryReader;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI$;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.types.HexType;
import com.databricks.labs.mosaic.core.types.InternalGeometryType;
import com.databricks.labs.mosaic.core.types.JSONType;
import com.databricks.labs.mosaic.core.types.model.Coordinates;
import com.databricks.labs.mosaic.core.types.package$;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t=b!B A\u0003\u0003y\u0005\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u000by\u0003A\u0011A0\t\u000b\r\u0004a\u0011\u00013\t\u000b\r\u0003A\u0011\u00019\t\u000b\r\u0003A\u0011A>\t\r\r\u0003A\u0011AA\u001d\u0011\u0019\u0019\u0005\u0001\"\u0001\u0002j!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBA8\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003\u007f\u0002A\u0011AAA\u0011\u001d\tY\t\u0001C\u0001\u0003\u001bCq!a'\u0001\t\u0003\ti\nC\u0004\u00020\u0002!\t!!-\t\r\u0005]\u0006\u0001\"\u0001e\u0011\u0019\tI\f\u0001C\u0001I\"1\u00111\u0018\u0001\u0005\u0002\u0011Da!!0\u0001\t\u0003!\u0007BBA`\u0001\u0011\u0005A\r\u0003\u0004\u0002B\u0002!\t\u0001\u001a\u0005\b\u0003\u0007\u0004A\u0011AAc\u000f\u001d\tY\r\u0011E\u0001\u0003\u001b4aa\u0010!\t\u0002\u0005=\u0007B\u00020\u0017\t\u0003\t\t\u000eC\u0004\u0002TZ!\t!!6\b\u000f\u0005eg\u0003#\u0001\u0002\\\u001a9\u0011q\u001c\f\t\u0002\u0005\u0005\bB\u00020\u001b\t\u0003\t\u0019\u000fC\u0003d5\u0011\u0005C\rC\u0004\u0002\u0000i!\t%!:\t\u000f\u0005-%\u0004\"\u0011\u0002j\"9\u00111\u0014\u000e\u0005B\u0005u\u0005bBAX5\u0011\u0005\u0013Q\u001e\u0005\u0007\u0003oSB\u0011\t3\t\r\u0005e&\u0004\"\u0011e\u0011\u0019\tYL\u0007C!I\"1\u0011Q\u0018\u000e\u0005B\u0011Da!a0\u001b\t\u0003\"\u0007BBAa5\u0011\u0005C\rC\u0004\u0002Dj!\t%!=\t\u0013\u0005U($!A\u0005\n\u0005]xa\u0002B\u0005-!\u0005!1\u0002\u0004\b\u0005\u001b1\u0002\u0012\u0001B\b\u0011\u0019q&\u0006\"\u0001\u0003\u0012!)1M\u000bC!I\"9\u0011q\u0010\u0016\u0005B\tM\u0001bBAFU\u0011\u0005#\u0011\u0004\u0005\b\u00037SC\u0011IAO\u0011\u001d\tyK\u000bC!\u0005;Aa!a.+\t\u0003\"\u0007BBA]U\u0011\u0005C\r\u0003\u0004\u0002<*\"\t\u0005\u001a\u0005\u0007\u0003{SC\u0011\t3\t\r\u0005}&\u0006\"\u0011e\u0011\u0019\t\tM\u000bC!I\"9\u00111\u0019\u0016\u0005B\t\u0005\u0002\"CA{U\u0005\u0005I\u0011BA|\u000f\u001d\u0011)C\u0006E\u0001\u0005O1qA!\u000b\u0017\u0011\u0003\u0011Y\u0003\u0003\u0004_u\u0011\u0005!Q\u0006\u0005\u0006Gj\"\t\u0005\u001a\u0005\n\u0003kT\u0014\u0011!C\u0005\u0003oD\u0011\"!>\u0017\u0003\u0003%I!a>\u0003\u0017\u001d+w.\\3uef\f\u0005+\u0013\u0006\u0003\u0003\n\u000b1!\u00199j\u0015\t\u0019E)\u0001\u0005hK>lW\r\u001e:z\u0015\t)e)\u0001\u0003d_J,'BA$I\u0003\u0019iwn]1jG*\u0011\u0011JS\u0001\u0005Y\u0006\u00147O\u0003\u0002L\u0019\u0006QA-\u0019;bEJL7m[:\u000b\u00035\u000b1aY8n\u0007\u0001\u00192\u0001\u0001)W!\t\tF+D\u0001S\u0015\u0005\u0019\u0016!B:dC2\f\u0017BA+S\u0005\u0019\te.\u001f*fMB\u0011\u0011kV\u0005\u00031J\u0013AbU3sS\u0006d\u0017N_1cY\u0016\faA]3bI\u0016\u0014\bCA.]\u001b\u0005\u0011\u0015BA/C\u000599Um\\7fiJL(+Z1eKJ\fa\u0001P5oSRtDC\u00011c!\t\t\u0007!D\u0001A\u0011\u0015I&\u00011\u0001[\u0003\u0011q\u0017-\\3\u0016\u0003\u0015\u0004\"AZ7\u000f\u0005\u001d\\\u0007C\u00015S\u001b\u0005I'B\u00016O\u0003\u0019a$o\\8u}%\u0011ANU\u0001\u0007!J,G-\u001a4\n\u00059|'AB*ue&twM\u0003\u0002m%R\u0019\u0011\u000f^=\u0011\u0005m\u0013\u0018BA:C\u00059iun]1jG\u001e+w.\\3uefDQ!\u001e\u0003A\u0002Y\fQ!\u001b8qkR\u0004\"!U<\n\u0005a\u0014&aA!os\")!\u0010\u0002a\u0001K\u0006AA/\u001f9f\u001d\u0006lW\r\u0006\u0003ry\u0006m\u0001\"B?\u0006\u0001\u0004q\u0018A\u00029pS:$8\u000fE\u0003\u0000\u0003\u0013\tyA\u0004\u0003\u0002\u0002\u0005\u0015ab\u00015\u0002\u0004%\t1+C\u0002\u0002\bI\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\f\u00055!aA*fc*\u0019\u0011q\u0001*\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006C\u0003\u0015\u0001x.\u001b8u\u0013\u0011\tI\"a\u0005\u0003\u00175{7/Y5d!>Lg\u000e\u001e\u0005\b\u0003;)\u0001\u0019AA\u0010\u0003!9Wm\\7UsB,\u0007\u0003BA\u0011\u0003cqA!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#A\u0003n_\u0012,GNC\u0002\u0002,\u0011\u000bQ\u0001^=qKNLA!a\f\u0002&\u0005\u0001r)Z8nKR\u0014\u0018\u0010V=qK\u0016sW/\\\u0005\u0005\u0003g\t)DA\u0003WC2,X-C\u0002\u00028I\u00131\"\u00128v[\u0016\u0014\u0018\r^5p]R)\u0011/a\u000f\u0002\\!9\u0011Q\b\u0004A\u0002\u0005}\u0012!C5oaV$H)\u0019;b!\u0011\t\t%a\u0016\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\n\u0001bY1uC2L8\u000f\u001e\u0006\u0005\u0003\u0013\nY%A\u0002tc2TA!!\u0014\u0002P\u0005)1\u000f]1sW*!\u0011\u0011KA*\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QK\u0001\u0004_J<\u0017\u0002BA-\u0003\u0007\u00121\"\u00138uKJt\u0017\r\u001c*po\"9\u0011Q\f\u0004A\u0002\u0005}\u0013\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\t\u0005\u0005\u0014QM\u0007\u0003\u0003GRA!a\u000b\u0002H%!\u0011qMA2\u0005!!\u0015\r^1UsB,G#B9\u0002l\u00055\u0004BBA\u001f\u000f\u0001\u0007a\u000fC\u0004\u0002^\u001d\u0001\r!a\u0018\u0002\u0013M,'/[1mSj,G#\u0002<\u0002t\u0005U\u0004\"B\"\t\u0001\u0004\t\bbBA/\u0011\u0001\u0007\u0011q\f\u000b\u0006m\u0006e\u00141\u0010\u0005\u0006\u0007&\u0001\r!\u001d\u0005\u0007\u0003{J\u0001\u0019A3\u0002\u001d\u0011\fG/\u0019$pe6\fGOT1nK\u0006aaM]8n\u000f\u0016|7i\\8sIR!\u0011qBAB\u0011\u001d\t)B\u0003a\u0001\u0003\u000b\u0003B!a\t\u0002\b&!\u0011\u0011RA\u0013\u0005-\u0019un\u001c:eS:\fG/Z:\u0002\u0015\u0019\u0014x.\\\"p_J$7\u000f\u0006\u0003\u0002\u0010\u0005=\u0005bBAI\u0017\u0001\u0007\u00111S\u0001\u0007G>|'\u000fZ:\u0011\u000b}\fI!!&\u0011\u0007E\u000b9*C\u0002\u0002\u001aJ\u0013a\u0001R8vE2,\u0017!C5p\u0007>$WmR3o+\t\ty\n\u0005\u0003\u0002\"\u0006-VBAAR\u0015\u0011\t)+a*\u0002\r\u0019|'/\\1u\u0015\r\tIKR\u0001\bG>$WmZ3o\u0013\u0011\ti+a)\u0003#\u001d+w.\\3uefLujQ8eK\u001e+g.\u0001\bd_\u0012,w)\u001a8Uef<&/\u00199\u0015\u0007\u0015\f\u0019\f\u0003\u0004\u000266\u0001\r!Z\u0001\u0005G>$W-A\u0007hK>lW\r\u001e:z\u00072\f7o]\u0001\u0014[>\u001c\u0018-[2HK>lW\r\u001e:z\u00072\f7o]\u0001\u0011O\u0016|W.\u001a;ss\u0006\u0013X-Y\"pI\u0016\f\u0001cZ3p[\u0016$(/\u001f+za\u0016\u001cu\u000eZ3\u0002'\u001d,w.\\3uefL5OV1mS\u0012\u001cu\u000eZ3\u0002%\u001d,w.\\3uefdUM\\4uQ\u000e{G-Z\u0001\u0011O\u0016|W.\u001a;ssN\u0013\u0016\nR\"pI\u0016$2!ZAd\u0011\u0019\tI\r\u0006a\u0001K\u0006Iq-Z8n\u0013:\u0014VMZ\u0001\f\u000f\u0016|W.\u001a;ss\u0006\u0003\u0016\n\u0005\u0002b-M\u0019a\u0003\u0015,\u0015\u0005\u00055\u0017!B1qa2LHc\u00011\u0002X\")1\r\u0007a\u0001K\u0006!Qi\u0015*J!\r\tiNG\u0007\u0002-\t!Qi\u0015*J'\tQ\u0002\r\u0006\u0002\u0002\\R!\u0011qBAt\u0011\u001d\t)\"\ba\u0001\u0003\u000b#B!a\u0004\u0002l\"9\u0011\u0011\u0013\u0010A\u0002\u0005MEcA3\u0002p\"1\u0011Q\u0017\u0011A\u0002\u0015$2!ZAz\u0011\u0019\tIm\na\u0001K\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\u0010\u0005\u0003\u0002|\n\u0015QBAA\u007f\u0015\u0011\tyP!\u0001\u0002\t1\fgn\u001a\u0006\u0003\u0005\u0007\tAA[1wC&!!qAA\u007f\u0005\u0019y%M[3di\u0006\u0019!\nV*\u0011\u0007\u0005u'FA\u0002K)N\u001b\"A\u000b1\u0015\u0005\t-A\u0003BA\b\u0005+AqAa\u0006.\u0001\u0004\t))\u0001\u0005hK>\u001cun\u001c:e)\u0011\tyAa\u0007\t\u000f\u0005Ee\u00061\u0001\u0002\u0014R\u0019QMa\b\t\r\u0005U\u0006\u00071\u0001f)\r)'1\u0005\u0005\u0007\u0003\u0013<\u0004\u0019A3\u0002\u0015%cG.Z4bY\u0006\u0003\u0016\nE\u0002\u0002^j\u0012!\"\u00137mK\u001e\fG.\u0011)J'\tQ\u0004\r\u0006\u0002\u0003(\u0001")
public abstract class GeometryAPI
implements Serializable {
    private final GeometryReader reader;

    public static GeometryAPI apply(String string) {
        return GeometryAPI$.MODULE$.apply(string);
    }

    public abstract String name();

    public MosaicGeometry geometry(Object input, String typeName) {
        MosaicGeometry mosaicGeometry;
        String string = typeName;
        if ("WKT".equals(string)) {
            mosaicGeometry = this.reader.fromWKT((String)input);
        } else if ("HEX".equals(string)) {
            mosaicGeometry = this.reader.fromHEX((String)input);
        } else if ("WKB".equals(string)) {
            mosaicGeometry = this.reader.fromWKB((byte[])input);
        } else if ("GEOJSON".equals(string)) {
            mosaicGeometry = this.reader.fromJSON((String)input);
        } else {
            if ("COORDS".equals(string)) {
                throw new Error(new StringBuilder(15).append(typeName).append(" not supported.").toString());
            }
            throw new Error(new StringBuilder(15).append(typeName).append(" not supported.").toString());
        }
        return mosaicGeometry;
    }

    public MosaicGeometry geometry(Seq<MosaicPoint> points, Enumeration.Value geomType) {
        return this.reader.fromSeq(points, geomType);
    }

    public MosaicGeometry geometry(InternalRow inputData, DataType dataType) {
        MosaicGeometry mosaicGeometry;
        DataType dataType2 = dataType;
        if (dataType2 instanceof BinaryType) {
            mosaicGeometry = this.reader.fromWKB(inputData.getBinary(0));
        } else if (dataType2 instanceof StringType) {
            mosaicGeometry = this.reader.fromWKT(inputData.getString(0));
        } else if (dataType2 instanceof HexType) {
            mosaicGeometry = this.reader.fromHEX(((InternalRow)inputData.get(0, package$.MODULE$.HexType())).getString(0));
        } else if (dataType2 instanceof JSONType) {
            mosaicGeometry = this.reader.fromJSON(((InternalRow)inputData.get(0, package$.MODULE$.JSONType())).getString(0));
        } else if (dataType2 instanceof InternalGeometryType) {
            mosaicGeometry = this.reader.fromInternal((InternalRow)inputData.get(0, package$.MODULE$.InternalGeometryType()));
        } else {
            throw new Error(new StringBuilder(15).append(dataType).append(" not supported.").toString());
        }
        return mosaicGeometry;
    }

    public MosaicGeometry geometry(Object inputData, DataType dataType) {
        MosaicGeometry mosaicGeometry;
        DataType dataType2 = dataType;
        if (dataType2 instanceof BinaryType) {
            mosaicGeometry = this.reader.fromWKB((byte[])inputData);
        } else if (dataType2 instanceof StringType) {
            mosaicGeometry = this.reader.fromWKT(((UTF8String)inputData).toString());
        } else if (dataType2 instanceof HexType) {
            mosaicGeometry = this.reader.fromHEX(((InternalRow)inputData).getString(0));
        } else if (dataType2 instanceof JSONType) {
            mosaicGeometry = this.reader.fromJSON(((InternalRow)inputData).getString(0));
        } else if (dataType2 instanceof InternalGeometryType) {
            mosaicGeometry = this.reader.fromInternal((InternalRow)inputData);
        } else {
            throw new Error(new StringBuilder(15).append(dataType).append(" not supported.").toString());
        }
        return mosaicGeometry;
    }

    public Object serialize(MosaicGeometry geometry, DataType dataType) {
        return this.serialize(geometry, GeometryFormat$.MODULE$.getDefaultFormat(dataType));
    }

    public Object serialize(MosaicGeometry geometry, String dataFormatName) {
        Object object;
        String string = dataFormatName.toUpperCase(Locale.ROOT);
        if ("WKB".equals(string)) {
            object = geometry.toWKB();
        } else if ("WKT".equals(string)) {
            object = UTF8String.fromString((String)geometry.toWKT());
        } else if ("HEX".equals(string)) {
            object = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UTF8String[]{UTF8String.fromString((String)geometry.toHEX())})));
        } else if ("JSONOBJECT".equals(string)) {
            object = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UTF8String[]{UTF8String.fromString((String)geometry.toJSON())})));
        } else if ("GEOJSON".equals(string)) {
            object = UTF8String.fromString((String)geometry.toJSON());
        } else if ("COORDS".equals(string)) {
            object = geometry.toInternal().serialize();
        } else {
            throw new Error(new StringBuilder(15).append(dataFormatName).append(" not supported.").toString());
        }
        return object;
    }

    public MosaicPoint fromGeoCoord(Coordinates point) {
        throw new Error("Unimplemented");
    }

    public MosaicPoint fromCoords(Seq<Object> coords) {
        throw new Error("Unimplemented");
    }

    public GeometryIOCodeGen ioCodeGen() {
        throw new Error("Unimplemented");
    }

    public String codeGenTryWrap(String code) {
        throw new Error("Unimplemented");
    }

    public String geometryClass() {
        throw new Error("Unimplemented");
    }

    public String mosaicGeometryClass() {
        throw new Error("Unimplemented");
    }

    public String geometryAreaCode() {
        throw new Error("Unimplemented");
    }

    public String geometryTypeCode() {
        throw new Error("Unimplemented");
    }

    public String geometryIsValidCode() {
        throw new Error("Unimplemented");
    }

    public String geometryLengthCode() {
        throw new Error("Unimplemented");
    }

    public String geometrySRIDCode(String geomInRef) {
        throw new Error("Unimplemented");
    }

    public GeometryAPI(GeometryReader reader) {
        this.reader = reader;
    }
}

