/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.geometry;

import com.databricks.labs.mosaic.core.geometry.GeometryReader;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometryESRI$;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPointESRI$;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.esotericsoftware.kryo.Kryo;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorIntersection;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCMultiLineString;
import com.esri.core.geometry.ogc.OGCMultiPoint;
import com.esri.core.geometry.ogc.OGCMultiPolygon;
import org.apache.spark.sql.catalyst.InternalRow;
import org.locationtech.jts.io.WKBWriter;
import scala.Enumeration;
import scala.MatchError;
import scala.Option;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t\u0015e!B\u001a5\u0003\u0003\t\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u000b]\u0003A\u0011\u0001-\t\u000bm\u0003A\u0011\t/\t\u000b\u0001\u0004A\u0011I1\t\u000b%\u0004A\u0011\t6\t\u000b-\u0004A\u0011\t7\t\u000b=\u0004A\u0011\t9\t\u000bM\u0004A\u0011\t;\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003G\u0001A\u0011IA\u0013\u0011\u001d\tY\u0003\u0001C!\u0003[Aq!a\u000b\u0001\t\u0013\t\u0019\u0004C\u0004\u0002:\u0001!\t%a\u000f\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003bBA%\u0001\u0011\u0005\u00131\n\u0005\b\u0003#\u0002A\u0011IA\n\u0011\u0019\t\u0019\u0006\u0001C!i\"9\u0011Q\u000b\u0001\u0005B\u0005]\u0003bBA-\u0001\u0011\u0005\u00131\f\u0005\b\u00033\u0002A\u0011IA0\u0011\u0019\t\u0019\b\u0001C!9\"1\u0011Q\u000f\u0001\u0005B)Dq!!\t\u0001\t\u0003\n9\bC\u0004\u0002|\u0001!\t%! \t\r\u0005}\u0004\u0001\"\u0011k\u0011\u0019\t\t\t\u0001C!i\"1\u00111\u0011\u0001\u0005BQDa!!\"\u0001\t\u0003\"\bbBAD\u0001\u0011\u0005\u0013\u0011\u0012\u0005\u0007\u0003/\u0003A\u0011\t/\t\u000f\u0005e\u0005\u0001\"\u0011\u0002\u001c\u001e9\u0011q\u0015\u001b\t\u0002\u0005%fAB\u001a5\u0011\u0003\tY\u000b\u0003\u0004XI\u0011\u0005\u0011\u0011\u0018\u0005\n\u0003w##\u0019!C\u0001\u0003{C\u0001\"a2%A\u0003%\u0011q\u0018\u0005\n\u0003\u0013$#\u0019!C\u0001\u0003\u0017D\u0001\"a7%A\u0003%\u0011Q\u001a\u0005\b\u0003K$C\u0011IAt\u0011\u001d\ti\u000f\nC\u0001\u0003_Dq!a=%\t\u0003\n)\u0010C\u0004\u0002|\u0012\"\t%!@\t\u000f\t\rA\u0005\"\u0011\u0003\u0006!9!1\u0002\u0013\u0005B\t5\u0001b\u0002B+I\u0011\u0005!q\u000b\u0005\b\u0005;\"C\u0011\tB0\u0011%\u0011\t\tJA\u0001\n\u0013\u0011\u0019I\u0001\nN_N\f\u0017nY$f_6,GO]=F'JK%BA\u001b7\u0003!9Wm\\7fiJL(BA\u001c9\u0003\u0011\u0019wN]3\u000b\u0005eR\u0014AB7pg\u0006L7M\u0003\u0002<y\u0005!A.\u00192t\u0015\tid(\u0001\u0006eCR\f'M]5dWNT\u0011aP\u0001\u0004G>l7\u0001A\n\u0004\u0001\tC\u0005CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%AB!osJ+g\r\u0005\u0002J\u00156\tA'\u0003\u0002Li\tqQj\\:bS\u000e<Um\\7fiJL\u0018\u0001B4f_6\u0004\"AT+\u000e\u0003=S!\u0001U)\u0002\u0007=<7M\u0003\u00026%*\u0011qg\u0015\u0006\u0003)z\nA!Z:sS&\u0011ak\u0014\u0002\f\u001f\u001e\u001bu)Z8nKR\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u00033j\u0003\"!\u0013\u0001\t\u000b1\u0013\u0001\u0019A'\u0002!\u001d,GOT;n\u000f\u0016|W.\u001a;sS\u0016\u001cX#A/\u0011\u0005\rs\u0016BA0E\u0005\rIe\u000e^\u0001\niJ\fgn\u001d7bi\u0016$2\u0001\u00132h\u0011\u0015\u0019G\u00011\u0001e\u0003\tAH\r\u0005\u0002DK&\u0011a\r\u0012\u0002\u0007\t>,(\r\\3\t\u000b!$\u0001\u0019\u00013\u0002\u0005e$\u0017a\u0004:fIV\u001cWM\u0012:p[6+H\u000e^5\u0016\u0003!\u000bQa]2bY\u0016$2\u0001S7o\u0011\u0015\u0019g\u00011\u0001e\u0011\u0015Ag\u00011\u0001e\u0003\u0019\u0011x\u000e^1uKR\u0011\u0001*\u001d\u0005\u0006e\u001e\u0001\r\u0001Z\u0001\u0003i\u0012\faaZ3u\u0003BKU#A;\u0011\u0005YlhBA<|!\tAH)D\u0001z\u0015\tQ\b)\u0001\u0004=e>|GOP\u0005\u0003y\u0012\u000ba\u0001\u0015:fI\u00164\u0017B\u0001@\u0000\u0005\u0019\u0019FO]5oO*\u0011A\u0010R\u0001\fO\u0016$8)\u001a8ue>LG-\u0006\u0002\u0002\u0006A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\fQ\nQ\u0001]8j]RLA!a\u0004\u0002\n\tYQj\\:bS\u000e\u0004v.\u001b8u\u0003\u001dI7/R7qif,\"!!\u0006\u0011\u0007\r\u000b9\"C\u0002\u0002\u001a\u0011\u0013qAQ8pY\u0016\fg.\u0001\u0004ck\u001a4WM\u001d\u000b\u0004\u0011\u0006}\u0001BBA\u0011\u0017\u0001\u0007A-\u0001\u0005eSN$\u0018M\\2f\u0003!\u0019\u0018.\u001c9mS\u001aLHc\u0001%\u0002(!1\u0011\u0011\u0006\u0007A\u0002\u0011\f\u0011\u0002^8mKJ\fgnY3\u0002\u0019%tG/\u001a:tK\u000e$\u0018n\u001c8\u0015\u0007!\u000by\u0003\u0003\u0004\u000225\u0001\r\u0001S\u0001\u0006_RDWM\u001d\u000b\u0004\u001b\u0006U\u0002BBA\u001c\u001d\u0001\u0007Q*A\u0004b]>$\b.\u001a:\u0002\u0015%tG/\u001a:tK\u000e$8\u000f\u0006\u0003\u0002\u0016\u0005u\u0002BBA\u0019\u001f\u0001\u0007\u0001*A\u0003v]&|g\u000eF\u0002I\u0003\u0007Ba!!\r\u0011\u0001\u0004A\u0015aB4fi\u001e+w.\\\u000b\u0002\u001b\u0006A1m\u001c8uC&t7\u000f\u0006\u0003\u0002\u0016\u00055\u0003BBA(%\u0001\u0007\u0001*A\u0003hK>l''A\u0004jgZ\u000bG.\u001b3\u0002\u001f\u001d,GoR3p[\u0016$(/\u001f+za\u0016\fqaZ3u\u0003J,\u0017-F\u0001e\u0003\u0019)\u0017/^1mgR!\u0011QCA/\u0011\u0019\t\tD\u0006a\u0001\u0011R!\u0011QCA1\u0011\u001d\t\td\u0006a\u0001\u0003G\u0002B!!\u001a\u0002p5\u0011\u0011q\r\u0006\u0005\u0003S\nY'\u0001\u0003mC:<'BAA7\u0003\u0011Q\u0017M^1\n\t\u0005E\u0014q\r\u0002\u0007\u001f\nTWm\u0019;\u0002\u0011!\f7\u000f[\"pI\u0016\f\u0001BY8v]\u0012\f'/\u001f\u000b\u0004I\u0006e\u0004BBA(5\u0001\u0007\u0001*\u0001\u0006d_:4X\r\u001f%vY2,\u0012!W\u0001\u000bk:\f'/_+oS>t\u0017!\u0002;p/.#\u0016A\u0002;p\u0015N{e*A\u0003u_\"+\u0005,A\u0003u_^[%)\u0006\u0002\u0002\fB)1)!$\u0002\u0012&\u0019\u0011q\u0012#\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\r\u000b\u0019*C\u0002\u0002\u0016\u0012\u0013AAQ=uK\u0006\u0019r-\u001a;Ta\u0006$\u0018.\u00197SK\u001a,'/\u001a8dK\u0006\u00192/\u001a;Ta\u0006$\u0018.\u00197SK\u001a,'/\u001a8dKR!\u0011QTAR!\r\u0019\u0015qT\u0005\u0004\u0003C#%\u0001B+oSRDa!!*#\u0001\u0004i\u0016\u0001B:sS\u0012\f!#T8tC&\u001cw)Z8nKR\u0014\u00180R*S\u0013B\u0011\u0011\nJ\n\u0007I\t\u000bi+a-\u0011\u0007%\u000by+C\u0002\u00022R\u0012abR3p[\u0016$(/\u001f*fC\u0012,'\u000fE\u0002D\u0003kK1!a.E\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\tI+A\feK\u001a\fW\u000f\u001c;Ta\u0006$\u0018.\u00197SK\u001a,'/\u001a8dKV\u0011\u0011q\u0018\t\u0005\u0003\u0003\f\u0019-D\u0001R\u0013\r\t)-\u0015\u0002\u0011'B\fG/[1m%\u00164WM]3oG\u0016\f\u0001\u0004Z3gCVdGo\u00159bi&\fGNU3gKJ,gnY3!\u0003\u0011Y'/_8\u0016\u0005\u00055\u0007\u0003BAh\u0003/l!!!5\u000b\t\u0005%\u00171\u001b\u0006\u0004\u0003+t\u0014\u0001E3t_R,'/[2t_\u001a$x/\u0019:f\u0013\u0011\tI.!5\u0003\t-\u0013\u0018p\\\u0001\u0006WJLx\u000e\t\u0015\u0004S\u0005}\u0007cA\"\u0002b&\u0019\u00111\u001d#\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018a\u00024s_6<6\n\u0016\u000b\u0004\u0011\u0006%\bBBAvU\u0001\u0007Q/A\u0002xWR\fQ!\u00199qYf$2!WAy\u0011\u0015a5\u00061\u0001N\u0003\u001d1'o\\7I\u000bb#2\u0001SA|\u0011\u0019\tI\u0010\fa\u0001k\u0006\u0019\u0001.\u001a=\u0002\u000f\u0019\u0014x.\\,L\u0005R\u0019\u0011,a@\t\u000f\t\u0005Q\u00061\u0001\u0002\f\u0006\u0019qo\u001b2\u0002\u0011\u0019\u0014x.\u001c&T\u001f:#2\u0001\u0013B\u0004\u0011\u0019\u0011IA\fa\u0001k\u00069q-Z8Kg>t\u0017a\u00024s_6\u001cV-]\u000b\u0005\u0005\u001f\u0011Y\u0003F\u0003Z\u0005#\u00119\u0004C\u0004\u0003\u0014=\u0002\rA!\u0006\u0002\u000f\u001d,w.\\*fcB1!q\u0003B\u0011\u0005OqAA!\u0007\u0003\u001e9\u0019\u0001Pa\u0007\n\u0003\u0015K1Aa\bE\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\t\u0003&\t\u00191+Z9\u000b\u0007\t}A\t\u0005\u0003\u0003*\t-B\u0002\u0001\u0003\b\u0005[y#\u0019\u0001B\u0018\u0005\u0005!\u0016c\u0001B\u0019\u0011B\u00191Ia\r\n\u0007\tUBIA\u0004O_RD\u0017N\\4\t\u000f\ter\u00061\u0001\u0003<\u0005Aq-Z8n)f\u0004X\r\u0005\u0003\u0003>\t5c\u0002\u0002B \u0005\u0013j!A!\u0011\u000b\t\t\r#QI\u0001\u0006[>$W\r\u001c\u0006\u0004\u0005\u000f2\u0014!\u0002;za\u0016\u001c\u0018\u0002\u0002B&\u0005\u0003\n\u0001cR3p[\u0016$(/\u001f+za\u0016,e.^7\n\t\t=#\u0011\u000b\u0002\u0006-\u0006dW/Z\u0005\u0004\u0005'\"%aC#ok6,'/\u0019;j_:\faA]3bI\u0016\u0014H\u0003BAW\u00053BaAa\u00171\u0001\u0004i\u0016AC4f_6$\u0016\u0010]3JI\u0006aaM]8n\u0013:$XM\u001d8bYR\u0019\u0001J!\u0019\t\u000f\t\r\u0014\u00071\u0001\u0003f\u0005\u0019!o\\<\u0011\t\t\u001d$QP\u0007\u0003\u0005SRAAa\u001b\u0003n\u0005A1-\u0019;bYf\u001cHO\u0003\u0003\u0003p\tE\u0014aA:rY*!!1\u000fB;\u0003\u0015\u0019\b/\u0019:l\u0015\u0011\u00119H!\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\u0011Y(A\u0002pe\u001eLAAa \u0003j\tY\u0011J\u001c;fe:\fGNU8x\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\r\u0004")
public abstract class MosaicGeometryESRI
implements MosaicGeometry {
    private final OGCGeometry geom;

    public static MosaicGeometry fromInternal(InternalRow internalRow) {
        return MosaicGeometryESRI$.MODULE$.fromInternal(internalRow);
    }

    public static GeometryReader reader(int n) {
        return MosaicGeometryESRI$.MODULE$.reader(n);
    }

    public static <T extends MosaicGeometry> MosaicGeometryESRI fromSeq(Seq<T> seq, Enumeration.Value value) {
        return MosaicGeometryESRI$.MODULE$.fromSeq((Seq)seq, value);
    }

    public static MosaicGeometry fromJSON(String string) {
        return MosaicGeometryESRI$.MODULE$.fromJSON(string);
    }

    public static MosaicGeometryESRI fromWKB(byte[] byArray) {
        return MosaicGeometryESRI$.MODULE$.fromWKB(byArray);
    }

    public static MosaicGeometry fromHEX(String string) {
        return MosaicGeometryESRI$.MODULE$.fromHEX(string);
    }

    public static MosaicGeometryESRI apply(OGCGeometry oGCGeometry) {
        return MosaicGeometryESRI$.MODULE$.apply(oGCGeometry);
    }

    public static MosaicGeometry fromWKT(String string) {
        return MosaicGeometryESRI$.MODULE$.fromWKT(string);
    }

    public static Kryo kryo() {
        return MosaicGeometryESRI$.MODULE$.kryo();
    }

    public static SpatialReference defaultSpatialReference() {
        return MosaicGeometryESRI$.MODULE$.defaultSpatialReference();
    }

    public static int defaultSpatialReferenceId() {
        return MosaicGeometryESRI$.MODULE$.defaultSpatialReferenceId();
    }

    @Override
    public double minMaxCoord(String dimension, String func) {
        return MosaicGeometry.minMaxCoord$(this, dimension, func);
    }

    @Override
    public MosaicGeometry transformCRSXY(int sridTo, Option<Object> sridFrom) {
        return MosaicGeometry.transformCRSXY$(this, sridTo, sridFrom);
    }

    @Override
    public Option<Object> transformCRSXY$default$2() {
        return MosaicGeometry.transformCRSXY$default$2$(this);
    }

    @Override
    public int getNumGeometries() {
        int n;
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(this.geom.geometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.POINT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            n = 1;
        } else {
            Enumeration.Value value4 = GeometryTypeEnum$.MODULE$.MULTIPOINT();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                n = ((OGCMultiPoint)this.geom).numGeometries();
            } else {
                Enumeration.Value value6 = GeometryTypeEnum$.MODULE$.LINESTRING();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    n = 1;
                } else {
                    Enumeration.Value value8 = GeometryTypeEnum$.MODULE$.MULTILINESTRING();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        n = ((OGCMultiLineString)this.geom).numGeometries();
                    } else {
                        Enumeration.Value value10 = GeometryTypeEnum$.MODULE$.POLYGON();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            n = 1;
                        } else {
                            Enumeration.Value value12 = GeometryTypeEnum$.MODULE$.MULTIPOLYGON();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                n = ((OGCMultiPolygon)this.geom).numGeometries();
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public MosaicGeometry translate(double xd, double yd) {
        Transformation2D tr = new Transformation2D();
        tr.setShift(xd, yd);
        Geometry esriGeom = this.geom.getEsriGeometry();
        esriGeom.applyTransformation(tr);
        return MosaicGeometryESRI$.MODULE$.apply(OGCGeometry.createFromEsriGeometry((Geometry)esriGeom, (SpatialReference)this.geom.getEsriSpatialReference()));
    }

    @Override
    public MosaicGeometry reduceFromMulti() {
        return MosaicGeometryESRI$.MODULE$.apply(this.geom.reduceFromMulti());
    }

    @Override
    public MosaicGeometry scale(double xd, double yd) {
        Transformation2D tr = new Transformation2D();
        tr.setScale(xd, yd);
        Geometry esriGeom = this.geom.getEsriGeometry();
        esriGeom.applyTransformation(tr);
        return MosaicGeometryESRI$.MODULE$.apply(OGCGeometry.createFromEsriGeometry((Geometry)esriGeom, (SpatialReference)this.geom.getEsriSpatialReference()));
    }

    @Override
    public MosaicGeometry rotate(double td) {
        Transformation2D tr = new Transformation2D();
        tr.setRotate(td);
        Geometry esriGeom = this.geom.getEsriGeometry();
        esriGeom.applyTransformation(tr);
        return MosaicGeometryESRI$.MODULE$.apply(OGCGeometry.createFromEsriGeometry((Geometry)esriGeom, (SpatialReference)this.geom.getEsriSpatialReference()));
    }

    @Override
    public String getAPI() {
        return "OGC";
    }

    @Override
    public MosaicPoint getCentroid() {
        return MosaicPointESRI$.MODULE$.apply(this.geom.centroid());
    }

    @Override
    public boolean isEmpty() {
        return this.geom.isEmpty();
    }

    @Override
    public MosaicGeometry buffer(double distance) {
        return MosaicGeometryESRI$.MODULE$.apply(this.geom.buffer(distance));
    }

    @Override
    public MosaicGeometry simplify(double tolerance) {
        return MosaicGeometryESRI$.MODULE$.apply(this.geom.makeSimple());
    }

    @Override
    public MosaicGeometry intersection(MosaicGeometry other) {
        OGCGeometry otherGeom = ((MosaicGeometryESRI)other).getGeom();
        return MosaicGeometryESRI$.MODULE$.apply(this.intersection(otherGeom));
    }

    private OGCGeometry intersection(OGCGeometry another) {
        OperatorIntersection op = (OperatorIntersection)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Intersection);
        GeometryCursor cursor = op.execute(this.geom.getEsriGeometryCursor(), another.getEsriGeometryCursor(), this.geom.getEsriSpatialReference(), null, -1);
        return OGCGeometry.createFromEsriCursor((GeometryCursor)cursor, (SpatialReference)this.geom.getEsriSpatialReference(), (boolean)true);
    }

    @Override
    public boolean intersects(MosaicGeometry other) {
        OGCGeometry otherGeom = ((MosaicGeometryESRI)other).getGeom();
        return this.geom.intersects(otherGeom);
    }

    @Override
    public MosaicGeometry union(MosaicGeometry other) {
        OGCGeometry otherGeom = ((MosaicGeometryESRI)other).getGeom();
        return MosaicGeometryESRI$.MODULE$.apply(this.getGeom().union(otherGeom));
    }

    public OGCGeometry getGeom() {
        return this.geom;
    }

    @Override
    public boolean contains(MosaicGeometry geom2) {
        return this.geom.contains(((MosaicGeometryESRI)geom2).getGeom());
    }

    @Override
    public boolean isValid() {
        return this.geom.isSimple();
    }

    @Override
    public String getGeometryType() {
        return this.geom.geometryType();
    }

    @Override
    public double getArea() {
        return this.geom.getEsriGeometry().calculateArea2D();
    }

    @Override
    public boolean equals(MosaicGeometry other) {
        OGCGeometry otherGeom = ((MosaicGeometryESRI)other).getGeom();
        return this.getGeom().equals((Object)otherGeom) || this.getGeom().Equals(otherGeom);
    }

    @Override
    public boolean equals(Object other) {
        return false;
    }

    @Override
    public int hashCode() {
        return this.geom.hashCode();
    }

    @Override
    public MosaicGeometry boundary() {
        return MosaicGeometryESRI$.MODULE$.apply(this.geom.boundary());
    }

    @Override
    public double distance(MosaicGeometry geom2) {
        return this.getGeom().distance(((MosaicGeometryESRI)geom2).getGeom());
    }

    @Override
    public MosaicGeometryESRI convexHull() {
        return MosaicGeometryESRI$.MODULE$.apply(this.geom.convexHull());
    }

    @Override
    public MosaicGeometry unaryUnion() {
        return MosaicGeometryESRI$.MODULE$.apply(this.geom.union(this.geom));
    }

    @Override
    public String toWKT() {
        return this.geom.asText();
    }

    @Override
    public String toJSON() {
        return this.geom.asGeoJson();
    }

    @Override
    public String toHEX() {
        return WKBWriter.toHex((byte[])this.geom.asBinary().array());
    }

    @Override
    public byte[] toWKB() {
        return this.geom.asBinary().array();
    }

    @Override
    public int getSpatialReference() {
        return this.geom.esriSR == null ? 0 : this.geom.getEsriSpatialReference().getID();
    }

    @Override
    public void setSpatialReference(int srid) {
        SpatialReference sr = SpatialReference.create((int)srid);
        this.geom.setSpatialReference(sr);
    }

    public MosaicGeometryESRI(OGCGeometry geom) {
        this.geom = geom;
        MosaicGeometry.$init$(this);
    }
}

