/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.codegen.format;

import com.databricks.labs.mosaic.codegen.format.GeometryIOCodeGen;
import com.databricks.labs.mosaic.core.geometry.GeometryFormat$;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.types.package$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.StringOps;

public final class ConvertToCodeGen$ {
    public static ConvertToCodeGen$ MODULE$;

    static {
        new ConvertToCodeGen$();
    }

    public ExprCode doCodeGen(CodegenContext ctx, ExprCode ev, Function3<CodegenContext, ExprCode, Function1<String, String>, ExprCode> nullSafeCodeGen, DataType inputDataType, String outputDataTypeName, GeometryAPI geometryAPI) {
        return (ExprCode)nullSafeCodeGen.apply((Object)ctx, (Object)ev, (Function1 & java.io.Serializable & Serializable)eval -> {
            String string;
            String string2 = inputDataType.simpleString();
            String string3 = outputDataTypeName;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(50).append("\n                     |").append(ev.value()).append(" = ").append((String)eval).append(";\n                     |").toString())).stripMargin();
            } else {
                Tuple2<String, String> tuple2 = MODULE$.readGeometryCode(ctx, (String)eval, inputDataType, geometryAPI);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String inCode = (String)tuple2._1();
                String geomInRef = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)inCode, (Object)geomInRef);
                Tuple2 tuple23 = tuple22;
                String inCode2 = (String)tuple23._1();
                String geomInRef2 = (String)tuple23._2();
                Tuple2<String, String> tuple24 = MODULE$.writeGeometryCode(ctx, geomInRef2, outputDataTypeName, geometryAPI);
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                String outCode = (String)tuple24._1();
                String geomOutRef = (String)tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)outCode, (Object)geomOutRef);
                Tuple2 tuple26 = tuple25;
                String outCode2 = (String)tuple26._1();
                String geomOutRef2 = (String)tuple26._2();
                string = geometryAPI.codeGenTryWrap(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(204).append("\n                                                |").append(inCode2).append("\n                                                |").append(outCode2).append("\n                                                |").append(ev.value()).append(" = ").append(geomOutRef2).append(";\n                                                |").toString())).stripMargin());
            }
            return string;
        });
    }

    public Tuple2<String, String> readGeometryCode(CodegenContext ctx, String eval, DataType inputDataType, GeometryAPI geometryAPI) {
        Tuple2<String, String> tuple2;
        GeometryIOCodeGen geometryCodeGen = geometryAPI.ioCodeGen();
        DataType dataType = inputDataType;
        if (BinaryType$.MODULE$.equals(dataType)) {
            tuple2 = geometryCodeGen.fromWKB(ctx, eval, geometryAPI);
        } else if (StringType$.MODULE$.equals(dataType)) {
            tuple2 = geometryCodeGen.fromWKT(ctx, eval, geometryAPI);
        } else {
            DataType dataType2 = package$.MODULE$.HexType();
            DataType dataType3 = dataType;
            if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
                tuple2 = geometryCodeGen.fromHex(ctx, eval, geometryAPI);
            } else {
                DataType dataType4 = package$.MODULE$.JSONType();
                DataType dataType5 = dataType;
                if (!(dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null)) {
                    tuple2 = geometryCodeGen.fromJSON(ctx, eval, geometryAPI);
                } else {
                    DataType dataType6 = package$.MODULE$.InternalGeometryType();
                    DataType dataType7 = dataType;
                    if (!(dataType6 != null ? !dataType6.equals(dataType7) : dataType7 != null)) {
                        tuple2 = geometryCodeGen.fromInternal(ctx, eval, geometryAPI);
                    } else {
                        throw new Error(new StringBuilder(27).append("Geometry API unsupported: ").append(inputDataType.typeName()).append(".").toString());
                    }
                }
            }
        }
        return tuple2;
    }

    public Tuple2<String, String> writeGeometryCode(CodegenContext ctx, String eval, DataType outputDataType, GeometryAPI geometryAPI) {
        String outDataFormat = GeometryFormat$.MODULE$.getDefaultFormat(outputDataType);
        return this.writeGeometryCode(ctx, eval, outDataFormat, geometryAPI);
    }

    public Tuple2<String, String> writeGeometryCode(CodegenContext ctx, String eval, String outputDataFormatName, GeometryAPI geometryAPI) {
        Tuple2<String, String> tuple2;
        GeometryIOCodeGen geometryCodeGen = geometryAPI.ioCodeGen();
        String string = outputDataFormatName;
        if ("WKB".equals(string)) {
            tuple2 = geometryCodeGen.toWKB(ctx, eval, geometryAPI);
        } else if ("WKT".equals(string)) {
            tuple2 = geometryCodeGen.toWKT(ctx, eval, geometryAPI);
        } else if ("HEX".equals(string)) {
            tuple2 = geometryCodeGen.toHEX(ctx, eval, geometryAPI);
        } else if ("JSONOBJECT".equals(string)) {
            tuple2 = geometryCodeGen.toJSON(ctx, eval, geometryAPI);
        } else if ("GEOJSON".equals(string)) {
            tuple2 = geometryCodeGen.toGeoJSON(ctx, eval, geometryAPI);
        } else if ("COORDS".equals(string)) {
            tuple2 = geometryCodeGen.toInternal(ctx, eval, geometryAPI);
        } else {
            throw new Error(new StringBuilder(24).append("Data type unsupported: ").append(outputDataFormatName).append(".").toString());
        }
        return tuple2;
    }

    private ConvertToCodeGen$() {
        MODULE$ = this;
    }
}

