# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['client']

package_data = \
{'': ['*']}

install_requires = \
['aiodns>=3.0.0,<4.0.0',
 'aiohttp>=3.8.3,<4.0.0',
 'cchardet>=2.1.7,<3.0.0',
 'scramjet-client-utils>=1.0.1,<2.0.0']

setup_kwargs = {
    'name': 'scramjet-api-client',
    'version': '1.0.0',
    'description': '',
    'long_description': '<h1 align="center"><strong>Scramjet Transform Hub API Client</strong></h1>\n\n<p align="center">\n    <a href="https://github.com/scramjetorg/transform-hub/blob/HEAD/LICENSE"><img src="https://img.shields.io/github/license/scramjetorg/transform-hub?color=green&style=plastic" alt="GitHub license" /></a>\n    <a href="https://npmjs.org/package/@scramjet/sth"><img src="https://img.shields.io/github/v/tag/scramjetorg/transform-hub?label=version&color=blue&style=plastic" alt="STH version" /></a>\n    <a href="https://github.com/scramjetorg/transform-hub"><img src="https://img.shields.io/github/stars/scramjetorg/transform-hub?color=pink&style=plastic" alt="GitHub stars" /></a>\n    <a href="https://npmjs.org/package/@scramjet/sth"><img src="https://img.shields.io/npm/dt/@scramjet/sth?color=orange&style=plastic" alt="npm" /></a>\n    <a href="https://scr.je/join-community-mg1"><img alt="Discord" src="https://img.shields.io/discord/925384545342201896?label=discord&style=plastic"></a>\n    <a href="https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=7F7V65C43EBMW">\n        <img src="https://img.shields.io/badge/Donate-PayPal-green.svg?color=yellow&style=plastic" alt="Donate" />\n    </a>\n</p>\n<p align="center">⭐ Star us on GitHub — it motivates us a lot! 🚀 </p>\n<p align="center">\n    <img src="https://assets.scramjet.org/sth-logo.svg" alt="Scramjet Transform Hub Logo">\n</p>\n\n## About:\n\nThe package provides **Host, Sequence and Instance API clients** for use with Scramjet Platform.\n\n## Usage:\n\n```python\nimport asyncio\nimport json\nfrom client.host_client import HostClient\nfrom client_utils import ClientUtils\n\n\n# your middleware token\ntoken = \'\'\n\n# set the token\nClientUtils.setDefaultHeaders({\'Authorization\': f\'Bearer {token}\'})\n\n# middleware url\napi_base =\'https://api.scramjet.cloud/api/v1\' \n\n### Initialize host client\nhost = HostClient(f\'{api_base}/space/org-aa6be150-9e5c-489b-83e3-b1fu7f054f3c-manager/api/v1/sth/sth-0/api/v1\')\n# get a list of Sequences\nres = asyncio.run(host.list_sequences())\n# convert response to json\nsequences = json.loads(res)\n\n### sending a Sequence\nresp = asyncio.run(host.send_sequence(\'hello-snowman.tar.gz\'))\nresp = json.loads(resp)\n# creating a Sequence client with ID from the response\nsnowman_seq = SequenceClient(resp[\'id\'], host)\n# starting the Sequence\nresp = asyncio.run(snowman_seq.start())\n\n### working with the Instance\nresp = json.loads(resp)\n# creating an Instance client with ID from the response\nsnowman_inst = InstanceClient(resp[\'id\'], host)\n# kill the running Instance\nasyncio.run(snowman_inst.kill())\n\nprint(asyncio.run(host.list_instances()))\n```\n\n## More reading\n\nIn the link below you will find more information about our stream protocol and API usage.\n\nSee the code documentation here: [scramjetorg/transform-hub/docs/read-more/stream-and-api.md](https://github.com/scramjetorg/transform-hub/tree/HEAD/docs/read-more/stream-and-api.md)\n\n## Scramjet Transform Hub\n\nThis package is part of [Scramjet Transform Hub](https://www.npmjs.org/package/@scramjet/sth).\n\nScramjet Transform Hub is a deployment and execution platform. Once installed on a server, it will allow you to start your programs and keep them running on a remote machine. You will be able to start programs in the background or connect to them and see their output directly on your terminal. You will be able to pipe your local data to the program, as if it was running from your terminal. You can start your server in AWS, Google Cloud or Azure, start it on your local machine, install it on a Raspberry Pi or wherever else you\'d like.\n\n## Use cases\n\nThere\'s no limit what you can use it for. You want a stock checker? A chat bot? Maybe you\'d like to automate your home? Retrieve sensor data? Maybe you have a lot of data and want to transfer and wrangle it? You have a database of cities and you\'d like to enrich your data? You do machine learning and you want to train your set while the data is fetched in real time? Hey, you want to use it for something else and ask us if that\'s a good use? Ask us [via email](mailto:get@scramjet.org) or hop on our [Scramjet Discord](https://scr.je/join-community-mg1)!\n___\n\n### Host operations\n\n<details>\n<summary>\n    <strong class="get">[ GET ]</strong>  <code>/api/v1/version</code> <small>- show the Host version</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Successful operation code: `200`</small>\n\n```json\n{ "version" : "0.12.2" }\n```\n\n</details>\n\n<details>\n<summary>\n    <strong class="get">[ GET ]</strong>  <code>/api/v1/sequences</code> <small>- show all Sequences saved on the Host</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Successful operation code: `200`</small>\n\n```json\n[\n  {\n    "instances": [], // a list of all running Instances of this Sequence\n    "id": "eea8bc33-440f-4a17-8931-eb22a17d5d56", // Sequence ID\n    "config": {\n      "container": {\n        "image": "scramjetorg/runner:0.12.2",\n        "maxMem": 512,\n        "exposePortsRange": [\n          30000,\n          32767\n        ],\n        "hostIp": "0.0.0.0"\n      },\n      "name": "@scramjet/hello-alice-out",\n      "version": "0.12.2",\n      "engines": {\n        "node": ">=10"\n      },\n      "config": {},\n      "sequencePath": "index", // a path to file with a main function\n      "packageVolumeId": "eea8bc33-440f-4a17-8931-eb22a17d5d56"\n    }\n  },\n  {\n    "instances": [\n      "02381acf-cb16-4cff-aa9b-f22f04ada94f"\n    ],\n    "id": "3ec02b93-4ca9-4d23-baab-048dab5ffda4",\n    "config": {\n      "container": {\n        "image": "scramjetorg/runner:0.12.2",\n        "maxMem": 512,\n        "exposePortsRange": [\n          30000,\n          32767\n        ],\n        "hostIp": "0.0.0.0"\n      },\n      "name": "@scramjet/checksum-sequence",\n      "version": "0.12.2",\n      "engines": {},\n      "config": {},\n      "sequencePath": "index.js",\n      "packageVolumeId": "3ec02b93-4ca9-4d23-baab-048dab5ffda4"\n    }\n  }\n]\n```\n\n</details>\n\n<details>\n<summary>\n    <strong class="get">[ GET ]</strong>  <code>/api/v1/instances</code> <small>- show all Instances running on the Host</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Successful operation code: `200`</small>\n\n```json\n[\n  {\n    "id": "02381acf-cb16-4cff-aa9b-f22f04ada94f", // Instance ID\n    "sequence": "3ec02b93-4ca9-4d23-baab-048dab5ffda4" // Sequence ID\n  },\n  {\n    "id": "ab0272d8-c9b0-43f7-9e7e-bcac9ec0f21f",\n    "sequence": "e4ca555c-ced1-4a13-b531-f43016eaf4ed"\n  }\n]\n```\n\n</details>\n\n<details>\n<summary>\n    <strong class="get">[ GET ]</strong>  <code>/api/v1/load-check</code> <small>- monitor CPU, memory and disk usage metrics on the Host machine</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Successful operation code: `200`</small>\n\n```json\n{\n  "avgLoad": 0.08,\n  "currentLoad": 5.190776257704936,\n  "memFree": 4634816512,\n  "memUsed": 8050364416,\n  "fsSize": [\n    {\n      "fs": "/dev/sda1",\n      "type": "ext4",\n      "size": 20838993920,\n      "used": 14939455488,\n      "available": 5882761216,\n      "use": 71.75,\n      "mount": "/"\n    },\n    {\n      "fs": "/dev/sda15",\n      "type": "vfat",\n      "size": 109422592,\n      "used": 9621504,\n      "available": 99801088,\n      "use": 8.79,\n      "mount": "/boot/efi"\n    }\n  ]\n}\n\n```\n\n</details>\n\n<details>\n<summary>\n    <strong class="get">[ GET ]</strong>  <code>/api/v1/log</code> <small>- monitor CPU, memory and disk usage metrics on the Host machine</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Content-type: `application/octet-stream`</small>\n\n<small>Successful operation code: `200`</small>\n\n```bash\n2021-11-19T16:04:47.094Z log (object:Host) Host main called.\n2021-11-19T16:04:47.100Z info (object:SocketServer) Server on: /tmp/scramjet-socket-server-path\n2021-11-19T16:04:47.104Z info (object:Host) API listening on: 127.0.0.1:8000\n2021-11-19T16:05:08.228Z info (object:Host) New sequence incoming...\n2021-11-19T16:05:08.229Z log (object:LifecycleDockerAdapterSequence) Docker sequence adapter init.\n2021-11-19T16:05:08.229Z log (object:DockerodeDockerHelper) Checking image scramjetorg/pre-runner:0.12.2\n2021-11-19T16:05:12.234Z info (object:LifecycleDockerAdapterSequence) Docker sequence adapter done.\n2021-11-19T16:05:12.246Z log (object:LifecycleDockerAdapterSequence) Volume created. Id:  c50fe4d3-89cc-4685-a82a-16cbc744733d\n2021-11-19T16:05:12.246Z log (object:LifecycleDockerAdapterSequence) Starting PreRunner { image: \'scramjetorg/pre-runner:0.12.2\', maxMem: 128 }\n2021-11-19T16:05:13.536Z log (object:DockerodeDockerHelper) Checking image scramjetorg/runner:0.12.2\n2021-11-19T16:05:16.670Z info (object:SequenceStore) New sequence added: c50fe4d3-89cc-4685-a82a-16cbc744733d\n2021-11-19T16:05:16.672Z info (object:Host) Sequence identified: {\n  container: {\n    image: \'scramjetorg/runner:0.12.2\',\n    maxMem: 512,\n    exposePortsRange: [ 30000, 32767 ],\n    hostIp: \'0.0.0.0\'\n  },\n  name: \'@scramjet/multi-outputs\',\n  version: \'0.12.2\',\n  engines: {},\n  config: {},\n  sequencePath: \'index.js\',\n  packageVolumeId: \'c50fe4d3-89cc-4685-a82a-16cbc744733d\'\n}\n2021-11-19T16:05:16.691Z debug (object:Host) Request date: 2021-11-19T16:05:08.239Z, method: POST, url: /api/v1/sequence, status: 202\n```\n\n</details>\n\n___\n\n### Sequence operations\n\n<details>\n<summary>\n    <strong class="post">[ POST ]</strong> <code>/api/v1/sequence</code> <small>- add new sequence</small>\n</summary>\n\n<br><strong>Parameters</strong>\n\n| Name        | Type     | Description                         | Required |\n| ----------- | -------- | ----------------------------------- | -------- |\n| `file`      | `binary` | compressed package in tar.gz format | yes      |\n| `appConfig` | `json`   | additional package.json config file | no       |\n\n<strong>Responses</strong>\n\n<small>Accepted operation code: `202`</small>\n\n```json\n{\n  "id": "2c3068e5-7c74-45bb-a017-1979c41fc6d0" // sequence id\n}\n```\n\n</details>\n\n<details>\n<summary>\n    <strong class="get">[ GET ]</strong>  <code>/api/v1/sequences</code> <small>- show list of sequences</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Successful operation code: `200`</small>\n\n```json\n[\n  {\n    "instances": [\n      "742d2713-7ab6-4cde-82f3-a7beabdd4e98"       // list of sequence instances\n    ],\n    "id": "bdef63db-d3a0-45c8-85db-e94ebb96097f",  // sequence id\n    "config": {\n      "container": {\n        "image": "scramjetorg/runner:0.12.2",\n        "maxMem": 512\n      },\n      "name": "@scramjet/transform-hub",\n      "version": "0.12.2",\n      "engines": {},\n      "config": {},\n      "sequencePath": "index.js",\n      "packageVolumeId": "bdef63db-d3a0-45c8-85db-e94ebb96097f"\n    }\n  }\n]\n```\n\n</details>\n\n<details>\n<summary>\n    <strong class="post">[ POST ]</strong> <code>/api/v1/sequence/:id/start</code> <small>- start chosen sequence</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n| Name        | Type   | Description                                           | Required |\n| ----------- | ------ | ----------------------------------------------------- | -------- |\n| `appConfig` | `json` | additional package.json config file                   | no       |\n| `args`      | `json` | additional arguments that instance should starts with | no       |\n\n<strong>Responses</strong>\n\n<small>Successful operation code: `200`</small>\n\n```json\n{\n  "id": "681c856e-dfa4-46a1-951d-47b27345552e"\n}\n```\n\n</details>\n\n<details>\n<summary>\n    <strong class="delete">[ DELETE ]</strong> <code>/api/v1/sequence/:id</code> <small>- delete a sequence by id</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Successful operation code: `200`</small>\n\n```json\n{\n  "id": "2c3068e5-7c74-45bb-a017-1979c41fc6d0"\n}\n```\n\n<small>Conflict operation code: `409` - the instance is still running</small>\n\n```json\n{\n  "error": "Can\'t remove sequence in use."\n}\n```\n\n</details>\n\n___\n\n### Instance basic operations\n\n<details>\n<summary>\n    <strong class="get">[ GET ]</strong> <code>/api/v1/instances</code> <small>- list all instances</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Successful operation code: `200`</small>\n\n```json\n[\n  {\n    "id": "742d2713-7ab6-4cde-82f3-a7beabdd4e98",\n    "sequence": "bdef63db-d3a0-45c8-85db-e94ebb96097f"\n  },\n  {\n    "id": "681c856e-dfa4-46a1-951d-47b27345552e",\n    "sequence": "bdef63db-d3a0-45c8-85db-e94ebb96097f"\n  },\n  {\n    "id": "21f787ed-6b9e-4e9f-828e-afe428d84833",\n    "sequence": "bdef63db-d3a0-45c8-85db-e94ebb96097f"\n  }\n]\n```\n\n</details>\n\n<details>\n<summary>\n    <strong class="get">[ GET ]</strong> <code>/api/v1/instance/:id</code> <small>- show data of chosen instance</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n| Name                 | Code  | Description                                 |\n| :------------------- | :---- | :------------------------------------------ |\n| Successful operation | `200` | Returns JSON data                           |\n| Not Found operation  | `404` | For example if instance was already stopped |\n\n```json\n{\n  "created": "2021-10-29T16:08:36.524Z",\n  "started": "2021-10-29T16:08:38.701Z",\n  "sequenceId": "b0c02fdc-b05f-4f26-9d68-43a702eb7b44"\n}\n```\n\n</details>\n\n<details>\n<summary>\n    <strong class="post">[ POST ]</strong> <code>/api/v1/instance/:id/_stop</code> <small>- end instance gracefully and prolong operations or not for task completion\u200b</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n| Name               | Type      | Description                                                                     | Required |\n| ------------------ | --------- | ------------------------------------------------------------------------------- | -------- |\n| `timeout`          | `number`  | The number of milliseconds before the Instance will be killed. Default: 7000ms. | no       |\n| `canCallKeepalive` | `boolean` | If set to true, the instance will prolong the running. Default: false.          | no       |\n\n<strong>Responses</strong>\n\n<small>Successful operation code: `200`</small>\n\n```json\n{\n   "code": 0,\n   "type": "string",\n   "message": "string"\n}\n```\n\n</details>\n\n<details>\n<summary>\n    <strong class="post">[ POST ]</strong>  <code>api/v1/instance/:id/_kill</code> <small>- end instance gracefully waiting for unfinished tasks</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Accepted operation code: `202`</small>\n\n```text\nNo body returned\n```\n\n</details>\n\n<details>\n<summary>\n    <strong class="get">[ GET ]</strong>  <code>/api/v1/instance/:id/health</code> <small>- check status about instance health</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Successful operation code: `200`</small>\n\n```json\n{\n  "cpuTotalUsage": 529325247,\n  "healthy": true,\n  "limit": 536870912,\n  "memoryMaxUsage": 16117760,\n  "memoryUsage": 14155776,\n  "networkRx": 1086,\n  "networkTx": 0,\n  "containerId": "1c993c4ff774fac06185aa9554cf40c23b03e1479a7e0d14827708161b08ae51"\n}\n```\n\n</details>\n\n___\n\n### Instance advanced operation\n\n<details>\n<summary>\n    <strong class="post">[ POST ]</strong>  <code>/api/v1/instance/:id/_event</code> <small>- send event to the Instance</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n| Name        | Type     | Description                  | Required |\n| :---------- | :------- | ---------------------------- | -------- |\n| `eventName` | `string` | Name of an event             | true     |\n| `message`   | `string` | JSON formatted event payload | false    |\n\n<strong>Responses</strong>\n\n<small>Content-type: `application/octet-stream`</small>\n\n</details>\n\n<details>\n<summary>\n    <strong class="get">[ GET ]</strong>  <code>/api/v1/instance/:id/event</code> <small>- get the data stream with the events from the Instance</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Content-type: `application/octet-stream`</small>\n\n</details>\n\n<details>\n<summary>\n    <strong class="get">[ GET ]</strong>  <code>/api/v1/instance/:id/once</code> <small>- get the last event sent by the Instance</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Content-type: `application/octet-stream`</small>\n\n</details>\n\n<details>\n<summary>\n    <strong class="post">[ POST ]</strong>  <code>/api/v1/instance/:id/input</code> <small>- send data to the input stream of the Instance to consume it</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n| Name                     | Code  | Description                                                  |\n| :----------------------- | :---- | :----------------------------------------------------------- |\n| Successful operation     | `200` | -                                                            |\n| Not Acceptable operation | `406` | Instance expects the input to be provided from the Topic API |\n\n</details>\n\n<details>\n<summary>\n    <strong class="get">[ GET ]</strong>  <code>/api/v1/instance/:id/output</code> <small>- get stream data from an instance and consume it through the endpoint</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Content-type: `application/octet-stream`</small>\n\n</details>\n\n<details>\n<summary>\n    <strong class="post">[ POST ]</strong>  <code>/api/v1/instance/:id/stdin\u200b</code> <small>- process.stdin</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Successful operation code: `200`</small>\n\n</details>\n\n<details>\n<summary>\n    <strong class="get">[ GET ]</strong>  <code>/api/v1/instance/:id/stdout</code> <small>- process.stdout</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Content-type: `application/octet-stream`</small>\n\n</details>\n\n<details>\n<summary>\n    <strong class="get">[ GET ]</strong>  <code>/api/v1/instance/:id/stderr</code> <small>- process.stderr</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Content-type: `application/octet-stream`</small>\n\n</details>\n\n<details>\n<summary>\n    <strong class="get">[ GET ]</strong>  <code>/api/v1/instance/:id/log</code> <small>- stream all instance logs</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Content-type: `application/octet-stream`</small>\n\n<small>Successful operation code: `200`</small>\n\n```bash\n2021-11-19T16:12:22.948Z log (Sequence) 42\n2021-11-19T16:12:23.949Z log (Sequence) 41\n2021-11-19T16:12:24.950Z log (Sequence) 40\n2021-11-19T16:12:25.951Z log (Sequence) 39\n2021-11-19T16:12:26.952Z log (Sequence) 38\n2021-11-19T16:12:27.952Z log (Sequence) 37\n2021-11-19T16:12:28.953Z log (Sequence) 36\n2021-11-19T16:12:29.953Z log (Sequence) 35\n```\n\n</details>\n\n___\n\n### Service Discovery: Topics\n\nIf a given topic does not exist, Transform-Hub creates it and stores the sent data in the newly created topic. The data is stored in the topic until the data is not consumed (either by the Topic API or by the Instances subscribing to this topic). When the data are sent to the topic they are written to the returned stream.\n\n<details>\n<summary>\n    <strong class="post">[ POST ]</strong>  <code>/api/v1/topics/:name\u200b</code> <small>- sends data to the topic</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small><small>No parameters</small></small>\n\n<strong>Request Headers</strong>\n\n| Header         | Type                  | Description                                                             | Default                | Required |\n| -------------- | --------------------- | ----------------------------------------------------------------------- | ---------------------- | -------- |\n| `x-end-stream` | `boolean`             | If set to `true`, then close topic stream after processing the request. | false                  | no       |\n| `content-type` | `text`, `application` | Specifies data type of this topic                                       | `application/x-ndjson` | no       |\n\n<small> Supported types: `text/x-ndjson`, `application/x-ndjson`, `application/x-ndjson`, `text/plain`, `application/octet-stream`</small>\n\n<strong>Responses</strong>\n\n| Name                 | Code  | Description                                                           |\n| :------------------- | :---- | :-------------------------------------------------------------------- |\n| Successful operation | `200` | data was sent with the header indicating the end of data              |\n| Successful operation | `202` | data was sent without the header indicating the end of data (default) |\n\n</details>\n\n<details>\n<summary>\n    <strong class="get">[ GET ]</strong>  <code>/api/v1/topics/:name\u200b</code> <small>- get data from the topic</small>\n</summary>\n\n<br> <strong>Parameters</strong>\n\n<small>No parameters</small>\n\n<strong>Responses</strong>\n\n<small>Topic data stream.</small>\n\n<small>Successful operation code: `200`</small>\n\n```json\n{\n  "source": "Twitter",\n  "id": "850006245121695778",\n  "content": "Natural wetlands make up ~30% of global total CH4 emissions",\n  "user": {\n    "id": 1234994945,\n    "name": "Climate Change Conference",\n    "screen_name": "Climate Change",\n  }\n}\n```\n\n</details>\n\n___\n\n## Some important links\n\n* Scramjet, the company behind [Transform Hub](https://scramjet.org)\n* The [Scramjet Framework - functional reactive stream processing framework](https://framework.scramjet.org)\n* The [Transform Hub repo on github](https://github.com/scramjetorg/transform-hub)\n* You can see the [Scramjet Transform Hub API docs here](https://github.com/scramjetorg/transform-hub/tree/HEAD/docs/api-client/README.md)\n* You can see the [CLI documentation here](https://github.com/scramjetorg/transform-hub/tree/HEAD/packages/cli/README.md), but `si help` should also be quite effective.\n* Don\'t forget to ⭐ this repo if you like it, `subscribe` to releases and keep visiting us for new versions and updates.\n* You can [open an issue - file a bug report or a feature request here](https://github.com/scramjetorg/transform-hub/issues/new/choose)\n\n## License and contributions\n\nThis module is licensed under AGPL-3.0 license.\n\nThe Scramjet Transform Hub project is dual-licensed under the AGPL-3.0 and MIT licenses. Parts of the project that are linked with your programs are MIT licensed, the rest is AGPL.\n\n## Contributions\n\nWe accept valid contributions and we will be publishing a more specific project roadmap so contributors can propose features and also help us implement them. We kindly ask you that contributed commits are Signed-Off `git commit --sign-off`.\n\nWe provide support for contributors via test cases. If you expect a certain type of workflow to be officially supported, please specify and implement a test case in `Gherkin` format in `bdd` directory and include it in your pull request. More info about our BDD test you will find [here](https://github.com/scramjetorg/transform-hub/tree/HEAD/bdd/README.md).\n\n### Help wanted 👩\u200d🎓🧑👱\u200d♀️\n\nThe project need\'s your help! There\'s lots of work to do and we have a lot of plans. If you want to help and be part of the Scramjet team, please reach out to us, [on discord](https://scr.je/join-community-mg1) or email us: [opensource@scramjet.org](mailto:opensource@scramjet.org).\n\n### Donation 💸\n\nDo you like this project? It helped you to reduce time spent on delivering your solution? You are welcome to buy us a coffee ☕ Thanks a lot! 😉\n\n[You can sponsor us on github](https://github.com/sponsors/scramjetorg)\n\n* There\'s also a Paypal donation link if you prefer that:\n\n[![paypal](https://www.paypalobjects.com/en_US/i/btn/btn_donateCC_LG.gif)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=7F7V65C43EBMW)\n\n\n\n',
    'author': 'Scramjet',
    'author_email': 'open-source@scramjet.org',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
