# Copyright (C) 2021-2023 Trevor Bayless <trevorbayless1@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

UNICODE_PIECE_SYMBOLS = {
    "r": "♜",  # \u265C
    "n": "♞",  # \u265E
    "b": "♝",  # \u265D
    "q": "♛",  # \u265B
    "k": "♚",  # \u265A
    "p": "♙",  # \u2659 (avoid \u265F (♟) as it renders as emoji in most fonts)
}


def get_piece_unicode_symbol(symbol: str) -> str:
    """Returns the unicode symbol associated to the symbol passed in"""
    unicode_symbol = ""
    symbol = symbol.lower() if symbol else ""
    if symbol in UNICODE_PIECE_SYMBOLS:
        unicode_symbol = UNICODE_PIECE_SYMBOLS[symbol]

    return unicode_symbol
