"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ASSET_PREFIX_SEPARATOR = exports.ASSET_RESOURCE_METADATA_IS_BUNDLED_KEY = exports.ASSET_RESOURCE_METADATA_PROPERTY_KEY = exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_TARGET_KEY = exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_ARGS_KEY = exports.ASSET_RESOURCE_METADATA_DOCKERFILE_PATH_KEY = exports.ASSET_RESOURCE_METADATA_PATH_KEY = exports.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = void 0;
/**
 * If this is set in the context, the aws:asset:xxx metadata entries will not be
 * added to the template. This is used, for example, when we run integrationt
 * tests.
 */
exports.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = 'aws:cdk:enable-asset-metadata';
/**
 * Metadata added to the CloudFormation template entries that map local assets
 * to resources.
 */
exports.ASSET_RESOURCE_METADATA_PATH_KEY = 'aws:asset:path';
exports.ASSET_RESOURCE_METADATA_DOCKERFILE_PATH_KEY = 'aws:asset:dockerfile-path';
exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_ARGS_KEY = 'aws:asset:docker-build-args';
exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_TARGET_KEY = 'aws:asset:docker-build-target';
exports.ASSET_RESOURCE_METADATA_PROPERTY_KEY = 'aws:asset:property';
exports.ASSET_RESOURCE_METADATA_IS_BUNDLED_KEY = 'aws:asset:is-bundled';
/**
 * Separator string that separates the prefix separator from the object key separator.
 *
 * Asset keys will look like:
 *
 *    /assets/MyConstruct12345678/||abcdef12345.zip
 *
 * This allows us to encode both the prefix and the full location in a single
 * CloudFormation Template Parameter.
 */
exports.ASSET_PREFIX_SEPARATOR = '||';
//# sourceMappingURL=data:application/json;base64,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