import * as cxapi from '@aws-cdk/cx-api';
import * as constructs from 'constructs';
import { IConstruct, ISynthesisSession, SynthesisOptions } from '../construct-compat';
export declare function synthesize(root: IConstruct, options?: SynthesisOptions): cxapi.CloudAssembly;
/**
 * Interface for constructs that want to do something custom during synthesis
 *
 * This feature is intended for use by official AWS CDK libraries only; 3rd party
 * library authors and CDK users should not use this function.
 */
export interface ICustomSynthesis {
    /**
     * Called when the construct is synthesized
     */
    onSynthesize(session: ISynthesisSession): void;
}
export declare function addCustomSynthesis(construct: constructs.IConstruct, synthesis: ICustomSynthesis): void;
