"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.expect = void 0;
const cdk = require("@aws-cdk/core");
const api = require("@aws-cdk/cx-api");
const inspector_1 = require("./inspector");
const synth_utils_1 = require("./synth-utils");
function expect(stack, skipValidation = false) {
    // if this is already a synthesized stack, then just inspect it.
    const artifact = stack instanceof api.CloudFormationStackArtifact ? stack
        : cdk.Stack.isStack(stack) ? synth_utils_1.SynthUtils._synthesizeWithNested(stack, { skipValidation })
            : stack; // This is a template already
    return new inspector_1.StackInspector(artifact);
}
exports.expect = expect;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhwZWN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZXhwZWN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHFDQUFxQztBQUNyQyx1Q0FBdUM7QUFDdkMsMkNBQTZDO0FBQzdDLCtDQUEyQztBQUUzQyxTQUFnQixNQUFNLENBQUMsS0FBd0UsRUFBRSxjQUFjLEdBQUcsS0FBSztJQUNySCxnRUFBZ0U7SUFDaEUsTUFBTSxRQUFRLEdBQUcsS0FBSyxZQUFZLEdBQUcsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDLENBQUMsS0FBSztRQUN2RSxDQUFDLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLHdCQUFVLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFFLEVBQUUsY0FBYyxFQUFFLENBQUM7WUFDdEYsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLDZCQUE2QjtJQUMxQyxPQUFPLElBQUksMEJBQWMsQ0FBQyxRQUFRLENBQUMsQ0FBQztBQUN0QyxDQUFDO0FBTkQsd0JBTUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBhcGkgZnJvbSAnQGF3cy1jZGsvY3gtYXBpJztcbmltcG9ydCB7IFN0YWNrSW5zcGVjdG9yIH0gZnJvbSAnLi9pbnNwZWN0b3InO1xuaW1wb3J0IHsgU3ludGhVdGlscyB9IGZyb20gJy4vc3ludGgtdXRpbHMnO1xuXG5leHBvcnQgZnVuY3Rpb24gZXhwZWN0KHN0YWNrOiBhcGkuQ2xvdWRGb3JtYXRpb25TdGFja0FydGlmYWN0IHwgY2RrLlN0YWNrIHwgUmVjb3JkPHN0cmluZywgYW55Piwgc2tpcFZhbGlkYXRpb24gPSBmYWxzZSk6IFN0YWNrSW5zcGVjdG9yIHtcbiAgLy8gaWYgdGhpcyBpcyBhbHJlYWR5IGEgc3ludGhlc2l6ZWQgc3RhY2ssIHRoZW4ganVzdCBpbnNwZWN0IGl0LlxuICBjb25zdCBhcnRpZmFjdCA9IHN0YWNrIGluc3RhbmNlb2YgYXBpLkNsb3VkRm9ybWF0aW9uU3RhY2tBcnRpZmFjdCA/IHN0YWNrXG4gICAgOiBjZGsuU3RhY2suaXNTdGFjayhzdGFjaykgPyBTeW50aFV0aWxzLl9zeW50aGVzaXplV2l0aE5lc3RlZChzdGFjaywgeyBza2lwVmFsaWRhdGlvbiB9KVxuICAgICAgOiBzdGFjazsgLy8gVGhpcyBpcyBhIHRlbXBsYXRlIGFscmVhZHlcbiAgcmV0dXJuIG5ldyBTdGFja0luc3BlY3RvcihhcnRpZmFjdCk7XG59XG4iXX0=