# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['lido-node-operator-key-checker-cli']

package_data = \
{'': ['*'],
 'lido-node-operator-key-checker-cli': ['.git/*',
                                        '.git/hooks/*',
                                        '.git/info/*',
                                        '.git/logs/*',
                                        '.git/logs/refs/heads/*',
                                        '.git/logs/refs/heads/feature/*',
                                        '.git/logs/refs/remotes/origin/*',
                                        '.git/logs/refs/remotes/origin/feature/*',
                                        '.git/objects/02/*',
                                        '.git/objects/03/*',
                                        '.git/objects/06/*',
                                        '.git/objects/07/*',
                                        '.git/objects/08/*',
                                        '.git/objects/09/*',
                                        '.git/objects/0b/*',
                                        '.git/objects/0d/*',
                                        '.git/objects/0f/*',
                                        '.git/objects/12/*',
                                        '.git/objects/13/*',
                                        '.git/objects/14/*',
                                        '.git/objects/1a/*',
                                        '.git/objects/1b/*',
                                        '.git/objects/1c/*',
                                        '.git/objects/1e/*',
                                        '.git/objects/21/*',
                                        '.git/objects/22/*',
                                        '.git/objects/23/*',
                                        '.git/objects/24/*',
                                        '.git/objects/25/*',
                                        '.git/objects/26/*',
                                        '.git/objects/27/*',
                                        '.git/objects/2b/*',
                                        '.git/objects/2c/*',
                                        '.git/objects/2e/*',
                                        '.git/objects/2f/*',
                                        '.git/objects/30/*',
                                        '.git/objects/31/*',
                                        '.git/objects/35/*',
                                        '.git/objects/36/*',
                                        '.git/objects/37/*',
                                        '.git/objects/38/*',
                                        '.git/objects/39/*',
                                        '.git/objects/3a/*',
                                        '.git/objects/3b/*',
                                        '.git/objects/3c/*',
                                        '.git/objects/3e/*',
                                        '.git/objects/40/*',
                                        '.git/objects/42/*',
                                        '.git/objects/44/*',
                                        '.git/objects/46/*',
                                        '.git/objects/47/*',
                                        '.git/objects/48/*',
                                        '.git/objects/4c/*',
                                        '.git/objects/4d/*',
                                        '.git/objects/4f/*',
                                        '.git/objects/50/*',
                                        '.git/objects/56/*',
                                        '.git/objects/57/*',
                                        '.git/objects/5c/*',
                                        '.git/objects/61/*',
                                        '.git/objects/62/*',
                                        '.git/objects/65/*',
                                        '.git/objects/66/*',
                                        '.git/objects/67/*',
                                        '.git/objects/6a/*',
                                        '.git/objects/6c/*',
                                        '.git/objects/6f/*',
                                        '.git/objects/70/*',
                                        '.git/objects/72/*',
                                        '.git/objects/74/*',
                                        '.git/objects/76/*',
                                        '.git/objects/77/*',
                                        '.git/objects/7f/*',
                                        '.git/objects/80/*',
                                        '.git/objects/81/*',
                                        '.git/objects/82/*',
                                        '.git/objects/83/*',
                                        '.git/objects/84/*',
                                        '.git/objects/87/*',
                                        '.git/objects/8a/*',
                                        '.git/objects/8b/*',
                                        '.git/objects/8c/*',
                                        '.git/objects/8e/*',
                                        '.git/objects/8f/*',
                                        '.git/objects/92/*',
                                        '.git/objects/95/*',
                                        '.git/objects/97/*',
                                        '.git/objects/99/*',
                                        '.git/objects/9a/*',
                                        '.git/objects/9c/*',
                                        '.git/objects/9d/*',
                                        '.git/objects/9e/*',
                                        '.git/objects/a3/*',
                                        '.git/objects/a4/*',
                                        '.git/objects/a6/*',
                                        '.git/objects/a8/*',
                                        '.git/objects/aa/*',
                                        '.git/objects/ab/*',
                                        '.git/objects/ad/*',
                                        '.git/objects/af/*',
                                        '.git/objects/b3/*',
                                        '.git/objects/b6/*',
                                        '.git/objects/b7/*',
                                        '.git/objects/b8/*',
                                        '.git/objects/b9/*',
                                        '.git/objects/bb/*',
                                        '.git/objects/bc/*',
                                        '.git/objects/bd/*',
                                        '.git/objects/be/*',
                                        '.git/objects/c0/*',
                                        '.git/objects/c2/*',
                                        '.git/objects/c5/*',
                                        '.git/objects/cb/*',
                                        '.git/objects/ce/*',
                                        '.git/objects/d0/*',
                                        '.git/objects/d1/*',
                                        '.git/objects/d2/*',
                                        '.git/objects/d6/*',
                                        '.git/objects/d8/*',
                                        '.git/objects/d9/*',
                                        '.git/objects/dc/*',
                                        '.git/objects/dd/*',
                                        '.git/objects/df/*',
                                        '.git/objects/e2/*',
                                        '.git/objects/e3/*',
                                        '.git/objects/e8/*',
                                        '.git/objects/ec/*',
                                        '.git/objects/ed/*',
                                        '.git/objects/ee/*',
                                        '.git/objects/ef/*',
                                        '.git/objects/f3/*',
                                        '.git/objects/f4/*',
                                        '.git/objects/f5/*',
                                        '.git/objects/f7/*',
                                        '.git/objects/fb/*',
                                        '.git/objects/fc/*',
                                        '.git/objects/fd/*',
                                        '.git/objects/fe/*',
                                        '.git/objects/ff/*',
                                        '.git/objects/pack/*',
                                        '.git/refs/heads/*',
                                        '.git/refs/heads/feature/*',
                                        '.git/refs/remotes/origin/*',
                                        '.git/refs/remotes/origin/feature/*']}

install_requires = \
['click==8.0.1', 'colorama==0.4.4', 'lido==1.1.0']

entry_points = \
{'console_scripts': ['lido-cli = lido_validate_keys:cli']}

setup_kwargs = {
    'name': 'lido-cli',
    'version': '1.3.0',
    'description': 'Lido CLI tool for node operator key validation',
    'long_description': "# Node Operator Key Checker CLI\n\n## Installation\n\nYou can get this tool using `pip`:\n\n```\npip install lido-cli\n```\n\nOr if you cloned this repository, install Python dependencies via:\n\n```\n./init.sh\n```\n\nDepending on how it's installed use:\n\n`lido-cli ...opts command ...opts` or `python lido_validate_keys.py ...opts command ...opts`\n\n## Running\n\n### RPC Provider\n\nThis is the only thing required, the rest will be handled automatically unless overridden.\n\n```\nlido-cli --rpc https://mainnet.provider.io/v3/XXX validate_network_keys\n```\n\n### Optional Parameters\n\nBy default CLI will use embedded strings and ABIs, but you can specify your own arguments if needed. Make sure to use them on CLI itself and not on the command eg:\n\n```\nlido-cli --rpc https://mainnet.provider.io/v3/XXX --max_multicall 300 --lido_address 0x123 --lido_abi_path /Users/x/xx.json --registry_address 0x123 --registry_abi_path /Users/x/xx.json validate_network_keys\n```\n\n```\n--rpc                   RPC provider for network calls.\n--max_multicall         Batch amount of function calls to fit into one RPC call.\n--lido_address          Address of the main contract.\n--lido_abi_path         ABI file path for the main contract.\n--registry_address      Address of the operator contract.\n--registry_abi_path     ABI file path for operators contract.\n```\n\n### Checking Network Keys\n\nSlow version, but it does a full check.  \nCommand: `validate_network_keys`\n\nExample:\n\n```\nlido-cli --rpc https://mainnet.provider.io/v3/XXX validate_network_keys\n```\n\n### Fast Checking Network Keys\n\nA faster version of the previous command. It uses cache and excludes used keys from validating (the duplication check still runs for all loaded keys).  \nCommand: `validate_network_keys_fast`\n\nExample:\n\n```\nlido-cli --rpc https://mainnet.provider.io/v3/XXX validate_network_keys_fast\n```\n\nClear cache:\n\n```\nlido-cli --rpc https://mainnet.provider.io/v3/XXX validate_network_keys_fast --clear_cache\n```\n\n### Checking Keys from File\n\nCommand: `validate_file_keys`\nSpecify the input file via `--file` or copy it as `input.json` to the cli folder\n\nExample with default file location:\n\n```\nlido-cli --rpc https://mainnet.provider.io/v3/XXX validate_file_keys\n```\n\nExample with custom file path:\n\n```\nlido-cli --rpc https://mainnet.provider.io/v3/XXX validate_file_keys --file input.json\n```\n\nYou can also get all commands and options via `python lido_validate_keys.py --help`\n",
    'author': 'Lido',
    'author_email': 'info@lido.fi',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://lido.fi',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>3.7.1,<4',
}


setup(**setup_kwargs)
