# do not import all endpoints into this module because that uses a lot of memory and stack frames
# if you need the ability to import all endpoints from this module, import them with
# from synctera_client.apis.path_to_api import path_to_api

import enum


class PathValues(str, enum.Enum):
    ACCOUNTS = "/accounts"
    ACCOUNTS_PRODUCTS = "/accounts/products"
    ACCOUNTS_PRODUCTS_PRODUCT_ID = "/accounts/products/{product_id}"
    ACCOUNTS_TEMPLATES = "/accounts/templates"
    ACCOUNTS_TEMPLATES_TEMPLATE_ID = "/accounts/templates/{template_id}"
    ACCOUNTS_ACCOUNT_ID = "/accounts/{account_id}"
    ACCOUNTS_ACCOUNT_ID_RELATIONSHIPS = "/accounts/{account_id}/relationships"
    ACCOUNTS_ACCOUNT_ID_RELATIONSHIPS_RELATIONSHIP_ID = "/accounts/{account_id}/relationships/{relationship_id}"
    ACH = "/ach"
    ACH_TRANSACTION_SIMULATIONS_RECEIVING_RETURN = "/ach/transaction_simulations/receiving_return"
    ACH_TRANSACTION_SIMULATIONS_RECEIVING_TRANSACTION = "/ach/transaction_simulations/receiving_transaction"
    ACH_TRANSACTION_ID = "/ach/{transaction_id}"
    BUSINESSES = "/businesses"
    BUSINESSES_BUSINESS_ID = "/businesses/{business_id}"
    CARDS = "/cards"
    CARDS_ACTIVATE = "/cards/activate"
    CARDS_CARD_WIDGET_URL = "/cards/card_widget_url"
    CARDS_DIGITAL_WALLET_TOKENS = "/cards/digital_wallet_tokens"
    CARDS_DIGITAL_WALLET_TOKENS_DIGITAL_WALLET_TOKEN_ID = "/cards/digital_wallet_tokens/{digital_wallet_token_id}"
    CARDS_GATEWAYS = "/cards/gateways"
    CARDS_GATEWAYS_GATEWAY_ID = "/cards/gateways/{gateway_id}"
    CARDS_IMAGES = "/cards/images"
    CARDS_IMAGES_CARD_IMAGE_ID = "/cards/images/{card_image_id}"
    CARDS_IMAGES_CARD_IMAGE_ID_DATA = "/cards/images/{card_image_id}/data"
    CARDS_PRODUCTS = "/cards/products"
    CARDS_SINGLE_USE_TOKEN = "/cards/single_use_token"
    CARDS_TRANSACTION_SIMULATIONS_AUTHORIZATION = "/cards/transaction_simulations/authorization"
    CARDS_TRANSACTION_SIMULATIONS_AUTHORIZATION_ADVICE = "/cards/transaction_simulations/authorization/advice"
    CARDS_TRANSACTION_SIMULATIONS_CLEARING = "/cards/transaction_simulations/clearing"
    CARDS_TRANSACTION_SIMULATIONS_FINANCIAL = "/cards/transaction_simulations/financial"
    CARDS_TRANSACTION_SIMULATIONS_FINANCIAL_ADVICE = "/cards/transaction_simulations/financial/advice"
    CARDS_TRANSACTION_SIMULATIONS_FINANCIAL_BALANCE_INQUIRY = "/cards/transaction_simulations/financial/balance_inquiry"
    CARDS_TRANSACTION_SIMULATIONS_FINANCIAL_ORIGINAL_CREDIT = "/cards/transaction_simulations/financial/original_credit"
    CARDS_TRANSACTION_SIMULATIONS_FINANCIAL_WITHDRAWAL = "/cards/transaction_simulations/financial/withdrawal"
    CARDS_TRANSACTION_SIMULATIONS_REVERSAL = "/cards/transaction_simulations/reversal"
    CARDS_CARD_ID = "/cards/{card_id}"
    CARDS_CARD_ID_BARCODES = "/cards/{card_id}/barcodes"
    CARDS_CARD_ID_CHANGES = "/cards/{card_id}/changes"
    CARDS_CARD_ID_CLIENT_TOKEN = "/cards/{card_id}/client_token"
    CARDS_CARD_ID_DIGITAL_WALLET_TOKENS_APPLEPAY = "/cards/{card_id}/digital_wallet_tokens/applepay"
    CARDS_CARD_ID_DIGITAL_WALLET_TOKENS_GOOGLEPAY = "/cards/{card_id}/digital_wallet_tokens/googlepay"
    CARDS_CARD_ID_WEBHOOK_SIMULATIONS_FULFILLMENT = "/cards/{card_id}/webhook_simulations/fulfillment"
    CASH_PICKUPS = "/cash_pickups"
    CASH_PICKUPS_CASH_PICKUP_ID = "/cash_pickups/{cash_pickup_id}"
    CUSTOMERS = "/customers"
    CUSTOMERS_CUSTOMER_ID = "/customers/{customer_id}"
    CUSTOMERS_CUSTOMER_ID_DISCLOSURES = "/customers/{customer_id}/disclosures"
    CUSTOMERS_CUSTOMER_ID_EMPLOYMENT = "/customers/{customer_id}/employment"
    CUSTOMERS_CUSTOMER_ID_EMPLOYMENT_EMPLOYMENT_ID = "/customers/{customer_id}/employment/{employment_id}"
    CUSTOMERS_CUSTOMER_ID_PREFILL = "/customers/{customer_id}/prefill"
    CUSTOMERS_CUSTOMER_ID_RISK_RATINGS = "/customers/{customer_id}/risk_ratings"
    CUSTOMERS_CUSTOMER_ID_RISK_RATINGS_RISK_RATING_ID = "/customers/{customer_id}/risk_ratings/{risk_rating_id}"
    CUSTOMERS_CUSTOMER_ID_VERIFICATIONS = "/customers/{customer_id}/verifications"
    CUSTOMERS_CUSTOMER_ID_VERIFICATIONS_VERIFICATION_ID = "/customers/{customer_id}/verifications/{verification_id}"
    CUSTOMERS_CUSTOMER_ID_VERIFY = "/customers/{customer_id}/verify"
    CUSTOMERS_CUSTOMER_ID_WATCHLISTS_ALERTS = "/customers/{customer_id}/watchlists/alerts"
    CUSTOMERS_CUSTOMER_ID_WATCHLISTS_ALERTS_ALERT_ID = "/customers/{customer_id}/watchlists/alerts/{alert_id}"
    CUSTOMERS_CUSTOMER_ID_WATCHLISTS_SUBSCRIPTIONS = "/customers/{customer_id}/watchlists/subscriptions"
    CUSTOMERS_CUSTOMER_ID_WATCHLISTS_SUBSCRIPTIONS_SUBSCRIPTION_ID = "/customers/{customer_id}/watchlists/subscriptions/{subscription_id}"
    CUSTOMERS_CUSTOMER_ID_WATCHLISTS_SUPPRESSIONS = "/customers/{customer_id}/watchlists/suppressions"
    DISCLOSURES = "/disclosures"
    DISCLOSURES_DISCLOSURE_ID = "/disclosures/{disclosure_id}"
    DOCUMENTS = "/documents"
    DOCUMENTS_DOCUMENT_ID = "/documents/{document_id}"
    DOCUMENTS_DOCUMENT_ID_CONTENTS = "/documents/{document_id}/contents"
    DOCUMENTS_DOCUMENT_ID_VERSIONS = "/documents/{document_id}/versions"
    DOCUMENTS_DOCUMENT_ID_VERSIONS_DOCUMENT_VERSION = "/documents/{document_id}/versions/{document_version}"
    DOCUMENTS_DOCUMENT_ID_VERSIONS_DOCUMENT_VERSION_CONTENTS = "/documents/{document_id}/versions/{document_version}/contents"
    EXTERNAL_ACCOUNTS = "/external_accounts"
    EXTERNAL_ACCOUNTS_ACCESS_TOKENS = "/external_accounts/access_tokens"
    EXTERNAL_ACCOUNTS_ADD_VENDOR_ACCOUNTS = "/external_accounts/add_vendor_accounts"
    EXTERNAL_ACCOUNTS_LINK_TOKENS = "/external_accounts/link_tokens"
    EXTERNAL_ACCOUNTS_SYNC_VENDOR_ACCOUNTS = "/external_accounts/sync_vendor_accounts"
    EXTERNAL_ACCOUNTS_EXTERNAL_ACCOUNT_ID = "/external_accounts/{external_account_id}"
    EXTERNAL_ACCOUNTS_EXTERNAL_ACCOUNT_ID_BALANCE = "/external_accounts/{external_account_id}/balance"
    EXTERNAL_ACCOUNTS_EXTERNAL_ACCOUNT_ID_TRANSACTIONS = "/external_accounts/{external_account_id}/transactions"
    EXTERNAL_CARDS = "/external_cards"
    EXTERNAL_CARDS_TOKENS = "/external_cards/tokens"
    EXTERNAL_CARDS_TRANSFERS = "/external_cards/transfers"
    EXTERNAL_CARDS_TRANSFERS_TRANSFER_ID = "/external_cards/transfers/{transfer_id}"
    EXTERNAL_CARDS_TRANSFERS_TRANSFER_ID_REVERSALS = "/external_cards/transfers/{transfer_id}/reversals"
    EXTERNAL_CARDS_EXTERNAL_CARD_ID = "/external_cards/{external_card_id}"
    INTERNAL_ACCOUNTS = "/internal_accounts"
    INTERNAL_ACCOUNTS_INTERNAL_ACCOUNT_ID = "/internal_accounts/{internal_account_id}"
    MONITORING_ALERTS = "/monitoring/alerts"
    MONITORING_ALERTS_ALERT_ID = "/monitoring/alerts/{alert_id}"
    MONITORING_SUBSCRIPTIONS = "/monitoring/subscriptions"
    MONITORING_SUBSCRIPTIONS_SUBSCRIPTION_ID = "/monitoring/subscriptions/{subscription_id}"
    NOTES = "/notes"
    NOTES_NOTE_ID = "/notes/{note_id}"
    PAYMENT_SCHEDULES = "/payment_schedules"
    PAYMENT_SCHEDULES_PAYMENTS = "/payment_schedules/payments"
    PAYMENT_SCHEDULES_PAYMENT_SCHEDULE_ID = "/payment_schedules/{payment_schedule_id}"
    PERSONS = "/persons"
    PERSONS_PERSONAL_IDS = "/persons/personal_ids"
    PERSONS_PERSONAL_IDS_PERSONAL_ID_ID = "/persons/personal_ids/{personal_id_id}"
    PERSONS_PERSON_ID = "/persons/{person_id}"
    PERSONS_PERSON_ID_PREFILL = "/persons/{person_id}/prefill"
    RDC_DEPOSITS = "/rdc/deposits"
    RDC_DEPOSITS_DEPOSIT_ID = "/rdc/deposits/{deposit_id}"
    RECONCILIATIONS = "/reconciliations"
    RECONCILIATIONS_RECONCILIATION_ID = "/reconciliations/{reconciliation_id}"
    RELATIONSHIPS = "/relationships"
    RELATIONSHIPS_RELATIONSHIP_ID = "/relationships/{relationship_id}"
    SPEND_CONTROLS = "/spend_controls"
    SPEND_CONTROLS_SPEND_CONTROL_ID = "/spend_controls/{spend_control_id}"
    STATEMENTS = "/statements"
    STATEMENTS_STATEMENT_ID = "/statements/{statement_id}"
    STATEMENTS_STATEMENT_ID_TRANSACTIONS = "/statements/{statement_id}/transactions"
    TRANSACTIONS_INTERNAL_TRANSFER = "/transactions/internal_transfer"
    TRANSACTIONS_INTERNAL_TRANSFER_ID = "/transactions/internal_transfer/{id}"
    TRANSACTIONS_PENDING = "/transactions/pending"
    TRANSACTIONS_PENDING_ID = "/transactions/pending/{id}"
    TRANSACTIONS_POSTED = "/transactions/posted"
    TRANSACTIONS_POSTED_ID = "/transactions/posted/{id}"
    VERIFICATIONS = "/verifications"
    VERIFICATIONS_ADHOC = "/verifications/adhoc"
    VERIFICATIONS_VERIFY = "/verifications/verify"
    VERIFICATIONS_VERIFICATION_ID = "/verifications/{verification_id}"
    WEBHOOK_SECRETS = "/webhook_secrets"
    WEBHOOKS = "/webhooks"
    WEBHOOKS_TRIGGER = "/webhooks/trigger"
    WEBHOOKS_WEBHOOK_ID = "/webhooks/{webhook_id}"
    WEBHOOKS_WEBHOOK_ID_EVENTS = "/webhooks/{webhook_id}/events"
    WEBHOOKS_WEBHOOK_ID_EVENTS_EVENT_ID = "/webhooks/{webhook_id}/events/{event_id}"
    WEBHOOKS_WEBHOOK_ID_EVENTS_EVENT_ID_RESEND = "/webhooks/{webhook_id}/events/{event_id}/resend"
    WIPE = "/wipe"
    WIRES = "/wires"
    WIRES_WIRE_ID = "/wires/{wire_id}"
