# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['openkat',
 'openkat.account',
 'openkat.account.forms',
 'openkat.account.views',
 'openkat.boefjes.boefjes',
 'openkat.boefjes.boefjes.clients',
 'openkat.boefjes.boefjes.katalogus',
 'openkat.boefjes.boefjes.katalogus.dependencies',
 'openkat.boefjes.boefjes.katalogus.routers',
 'openkat.boefjes.boefjes.katalogus.storage',
 'openkat.boefjes.boefjes.lxd',
 'openkat.boefjes.boefjes.plugin_repository',
 'openkat.boefjes.boefjes.plugin_repository.api',
 'openkat.boefjes.boefjes.plugin_repository.api.routers',
 'openkat.boefjes.boefjes.plugin_repository.utils',
 'openkat.boefjes.boefjes.plugins',
 'openkat.boefjes.boefjes.plugins.kat_binaryedge',
 'openkat.boefjes.boefjes.plugins.kat_binaryedge.normalizers',
 'openkat.boefjes.boefjes.plugins.kat_crt_sh',
 'openkat.boefjes.boefjes.plugins.kat_dicom',
 'openkat.boefjes.boefjes.plugins.kat_dns',
 'openkat.boefjes.boefjes.plugins.kat_dns_zone',
 'openkat.boefjes.boefjes.plugins.kat_dnssec',
 'openkat.boefjes.boefjes.plugins.kat_fierce',
 'openkat.boefjes.boefjes.plugins.kat_green_hosting',
 'openkat.boefjes.boefjes.plugins.kat_leakix',
 'openkat.boefjes.boefjes.plugins.kat_log4shell',
 'openkat.boefjes.boefjes.plugins.kat_manyportsopen',
 'openkat.boefjes.boefjes.plugins.kat_nmap',
 'openkat.boefjes.boefjes.plugins.kat_shodan',
 'openkat.boefjes.boefjes.plugins.kat_snyk',
 'openkat.boefjes.boefjes.plugins.kat_ssl_certificates',
 'openkat.boefjes.boefjes.plugins.kat_ssl_scan',
 'openkat.boefjes.boefjes.plugins.kat_webpage_analysis',
 'openkat.boefjes.boefjes.plugins.kat_website_software',
 'openkat.boefjes.boefjes.plugins.kat_wpscan',
 'openkat.boefjes.boefjes.sql',
 'openkat.crisis_room',
 'openkat.fmea',
 'openkat.fmea.views',
 'openkat.katalogus',
 'openkat.katalogus.forms',
 'openkat.katalogus.views',
 'openkat.mula.scheduler',
 'openkat.mula.scheduler.config',
 'openkat.mula.scheduler.connectors',
 'openkat.mula.scheduler.connectors.listeners',
 'openkat.mula.scheduler.connectors.services',
 'openkat.mula.scheduler.context',
 'openkat.mula.scheduler.datastores',
 'openkat.mula.scheduler.models',
 'openkat.mula.scheduler.queues',
 'openkat.mula.scheduler.rankers',
 'openkat.mula.scheduler.schedulers',
 'openkat.mula.scheduler.server',
 'openkat.mula.scheduler.utils',
 'openkat.octopoes',
 'openkat.octopoes.bits',
 'openkat.octopoes.bits.check_csp_header',
 'openkat.octopoes.bits.check_cve_2021_41773',
 'openkat.octopoes.bits.check_hsts_header',
 'openkat.octopoes.bits.dns_alias_resolving',
 'openkat.octopoes.bits.dns_resolving',
 'openkat.octopoes.bits.https_availability',
 'openkat.octopoes.bits.https_redirect',
 'openkat.octopoes.bits.internetnl',
 'openkat.octopoes.bits.ipv6_nameservers',
 'openkat.octopoes.bits.ipv6_webservers',
 'openkat.octopoes.bits.missing_certificate',
 'openkat.octopoes.bits.missing_headers',
 'openkat.octopoes.bits.nxdomain_flag',
 'openkat.octopoes.bits.nxdomain_header_flag',
 'openkat.octopoes.bits.oois_in_headers',
 'openkat.octopoes.bits.port_classification',
 'openkat.octopoes.bits.resource_discovery',
 'openkat.octopoes.bits.retire_js',
 'openkat.octopoes.bits.ssl_certificate_hostname',
 'openkat.octopoes.bits.two_ipv6_nameservers',
 'openkat.octopoes.bits.url_classification',
 'openkat.octopoes.bits.url_discovery',
 'openkat.octopoes.bits.website_discovery',
 'openkat.octopoes.octopoes',
 'openkat.octopoes.octopoes.api',
 'openkat.octopoes.octopoes.config',
 'openkat.octopoes.octopoes.connector',
 'openkat.octopoes.octopoes.core',
 'openkat.octopoes.octopoes.events',
 'openkat.octopoes.octopoes.models',
 'openkat.octopoes.octopoes.models.ooi',
 'openkat.octopoes.octopoes.models.ooi.dns',
 'openkat.octopoes.octopoes.repositories',
 'openkat.octopoes.octopoes.tasks',
 'openkat.octopoes.octopoes.xtdb',
 'openkat.onboarding',
 'openkat.rocky',
 'openkat.rocky.middleware',
 'openkat.rocky.views',
 'openkat.tools',
 'openkat.tools.forms',
 'openkat.tools.management.commands',
 'openkat.tools.templatetags']

package_data = \
{'': ['*'],
 'openkat': ['assets/dist/*',
             'assets/img/*',
             'assets/img/loader/*',
             'assets/js/*',
             'assets/js/vendor/cytoscape-klay/3.1.4/*',
             'assets/js/vendor/cytoscape/3.18.2/*',
             'assets/js/vendor/klayjs/0.4.1/*',
             'assets/src/bundles/*',
             'assets/src/bundles/app/css/*',
             'assets/src/bundles/app/css/abstracts/*',
             'assets/src/bundles/app/css/base/*',
             'assets/src/bundles/app/css/components/*',
             'assets/src/bundles/app/css/layout/*',
             'assets/src/bundles/app/css/vendor/*',
             'assets/src/bundles/app/css/vendors/*',
             'assets/src/bundles/app/css/vendors/iconfont/fonts/*',
             'assets/src/bundles/app/css/vendors/iconfont/tabler-icons.scss',
             'assets/src/bundles/app/fonts/bertsansbold.ttf',
             'assets/src/bundles/app/fonts/bertsansbold.ttf',
             'assets/src/bundles/app/fonts/bertsansbold.ttf',
             'assets/src/bundles/app/fonts/bertsansbold.ttf',
             'assets/src/bundles/app/fonts/bertsansbold.ttf',
             'assets/src/bundles/app/fonts/bertsansbold.ttf',
             'assets/src/bundles/app/fonts/bertsansbolditalic.ttf',
             'assets/src/bundles/app/fonts/bertsansbolditalic.ttf',
             'assets/src/bundles/app/fonts/bertsansbolditalic.ttf',
             'assets/src/bundles/app/fonts/bertsansbolditalic.ttf',
             'assets/src/bundles/app/fonts/bertsansbolditalic.ttf',
             'assets/src/bundles/app/fonts/bertsansbolditalic.ttf',
             'assets/src/bundles/app/fonts/bertsansitalic.ttf',
             'assets/src/bundles/app/fonts/bertsansitalic.ttf',
             'assets/src/bundles/app/fonts/bertsansitalic.ttf',
             'assets/src/bundles/app/fonts/bertsansitalic.ttf',
             'assets/src/bundles/app/fonts/bertsansitalic.ttf',
             'assets/src/bundles/app/fonts/bertsansitalic.ttf',
             'assets/src/bundles/app/fonts/bertsanslight.ttf',
             'assets/src/bundles/app/fonts/bertsanslight.ttf',
             'assets/src/bundles/app/fonts/bertsanslight.ttf',
             'assets/src/bundles/app/fonts/bertsanslight.ttf',
             'assets/src/bundles/app/fonts/bertsanslight.ttf',
             'assets/src/bundles/app/fonts/bertsanslight.ttf',
             'assets/src/bundles/app/fonts/bertsanslightitalic.ttf',
             'assets/src/bundles/app/fonts/bertsanslightitalic.ttf',
             'assets/src/bundles/app/fonts/bertsanslightitalic.ttf',
             'assets/src/bundles/app/fonts/bertsanslightitalic.ttf',
             'assets/src/bundles/app/fonts/bertsanslightitalic.ttf',
             'assets/src/bundles/app/fonts/bertsanslightitalic.ttf',
             'assets/src/bundles/app/fonts/bertsansregular.ttf',
             'assets/src/bundles/app/fonts/bertsansregular.ttf',
             'assets/src/bundles/app/fonts/bertsansregular.ttf',
             'assets/src/bundles/app/fonts/bertsansregular.ttf',
             'assets/src/bundles/app/fonts/bertsansregular.ttf',
             'assets/src/bundles/app/fonts/bertsansregular.ttf',
             'assets/src/bundles/graph/css/*',
             'assets/src/bundles/graph/js/*',
             'boefjes/entrypoint.sh',
             'boefjes/entrypoint.sh',
             'boefjes/entrypoint.sh',
             'boefjes/katalogus.db',
             'boefjes/katalogus.db',
             'boefjes/katalogus.db',
             'boefjes/logging.json',
             'boefjes/logging.json',
             'boefjes/logging.json',
             'data/*',
             'locale/nl/LC_MESSAGES/*',
             'locale/pap/LC_MESSAGES/*',
             'mula/logging.json',
             'mula/logging.json',
             'mula/logging.json',
             'mula/logging.prod.json',
             'mula/logging.prod.json',
             'mula/logging.prod.json',
             'mula/pyproject.toml',
             'mula/pyproject.toml',
             'mula/pyproject.toml',
             'templates/*',
             'templates/crisis_room/*',
             'templates/findings/*',
             'templates/forms/widgets/*',
             'templates/katalogus/*',
             'templates/layouts/*',
             'templates/legal/*',
             'templates/oois/*',
             'templates/organizations/*',
             'templates/partials/*',
             'templates/partials/elements/*',
             'templates/partials/form/*',
             'templates/partials/notifications/*',
             'templates/scan_profiles/*',
             'templates/tasks/*',
             'templates/tasks/partials/*',
             'templates/two_factor/*',
             'templates/two_factor/core/*',
             'templates/two_factor/profile/*',
             'templates/two_factor/twilio/*'],
 'openkat.account': ['templates/*'],
 'openkat.boefjes.boefjes.katalogus': ['static/assets/*',
                                       'static/assets/kat_ssl_certificates/*'],
 'openkat.boefjes.boefjes.plugins.kat_fierce': ['lists/*'],
 'openkat.fmea': ['templates/fmea/*'],
 'openkat.katalogus': ['templates/*'],
 'openkat.onboarding': ['templates/*',
                        'templates/account/*',
                        'templates/partials/*']}

install_requires = \
['Django==3.2.15',
 'SQLAlchemy>=1.4.41,<2.0.0',
 'ares>=0.7.1',
 'beautifulsoup4>=4.11.1',
 'colorama>=0.4.5',
 'cryptography>=3.4.3',
 'cwe>=1.6',
 'django-csp>=3.7',
 'django-markdownify>=0.9.1',
 'django-otp>=1.1.3',
 'django-password-validators>=1.7.0',
 'django-two-factor-auth>=1.14.0',
 'dnspython>=2.1.0',
 'docker>=6.0.0,<7.0.0',
 'forcediphttpsadapter>=1.0.2',
 'mmh3>=3.0.0,<4.0.0',
 'phonenumbers>=8.12.55,<9.0.0',
 'pybinaryedge>=0.5',
 'pydantic>=1.8.2',
 'pynetdicom>=2.0.2,<3.0.0',
 'python-Wappalyzer>=0.3.1',
 'python-gettext>=4.1,<5.0',
 'python-libnmap>=0.7.3',
 'requests>=2.26.0,<3.0.0',
 'shodan>=1.25.0',
 'wpscan-out-parse>=1.9.3']

setup_kwargs = {
    'name': 'py-openkat',
    'version': '1.2.2',
    'description': 'A lightweight version of OpenKAT.',
    'long_description': '# Openkat\n\nAn experimental sandbox environment to easily experiment with (some) functionality of [openkat](https://openkat.nl/).\nThis version of openkat runs all services in a single process and replaces services such as\n[Bytes](https://github.com/minvws/nl-kat-bytes), Rabbitmq and Celery with an in-memory implementation.\nAs a consequence, the current version does not guarantee persistence beyond the lifetime of the process.\nIt speaks for itself that this library **should not be used in a production environment**.\nTo properly deploy an openkat instance,\nplease refer to the [official documentation](https://github.com/minvws/nl-kat-coordination) on Github.\n\n\n## Overview\n\n### Features\n\nThese features of openkat are currently present in this package\n- The Rocky interface: UI around reporting on Findings\n- The Octopoes models: for modelling the Objects Of Interest (OOIs)\n- The Boefjes/Normalizers: the python scripts that find OOIs (excluding the containerized versions)\n- The Scheduler: dispatching Boefjes and Normalizers automatically\n\n### Benefits\nThe benefits and extra features of this package are:\n- Lightweight: a single process for the app, reducing overhead of the official services and installation times\n- A default superuser and development organization\n- OTP disabled to optimize for restarting the service even after an update\n- Adding plugins by creating plugins in a custom `plugins` folder\n\n### Missing Features\n\nHowever, some features are excluded from this version on purpose:\n- Audit trailing using Bytes\n- Miscellaneous functionality in the interface, such as specifying a depth of an OOI tree and custom images in the KATalogus\n- Deletion Propagation: you have to manually delete every single OOI\n- ScanProfile inheritance: you have to manually add scan profiles to observed OOIs\n- Valid times: you cannot browse the OOI history through time\n\n\n### Coming Features\n\nSome missing features are still to be added:\n- Bits\n- Object persistence beyond server lifetime\n\n## Installation\n\n```shell\n$ pip install py-openkat\n```\n\n### Usage\n\nTo start the instance, run\n\n```shell\n$ python -m openkat\n```\n\nand navigate to http://localhost:8000.\nLogin with email `super@user.com` and password `superuser`.\nYou can start adding your objects now (see the official documentation).\nNote: restarting the service clears your object database.\n\n### Dependencies\n\nTo use the Dockerized boefjes, you must have Docker installed on your machine.\n\n\n## Contributing\n\nDependencies:\n- `poetry`\n- `yarn`\n\n\nTo setup a development environment, run\n```shell\n$ make init\n```\n\nTo build, run\n```shell\n$ make build\n```\n',
    'author': 'Donny Peeters',
    'author_email': 'donny.peeters@hotmail.com',
    'maintainer': 'Donny Peeters',
    'maintainer_email': 'donny.peeters@hotmail.com',
    'url': 'https://github.com/Donnype/py-openkat',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
