# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class DeviceType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the device.
    """

    UNKNOWN = "Unknown"
    AZURE_STACK_EDGE = "AzureStackEdge"

class DiskCreateOptionTypes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies how the virtual machine should be created.
    """

    UNKNOWN = "Unknown"
    EMPTY = "Empty"

class IPAllocationMethod(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """IP address allocation method.
    """

    UNKNOWN = "Unknown"
    STATIC = "Static"
    DYNAMIC = "Dynamic"

class IPVersion(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """IP address version.
    """

    UNKNOWN = "Unknown"
    I_PV4 = "IPv4"

class NetworkFunctionRoleConfigurationType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Role type.
    """

    UNKNOWN = "Unknown"
    VIRTUAL_MACHINE = "VirtualMachine"

class OperatingSystemTypes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The OS type.
    """

    UNKNOWN = "Unknown"
    WINDOWS = "Windows"
    LINUX = "Linux"

class OperationalState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The operational state of the role instance.
    """

    UNKNOWN = "Unknown"
    STOPPED = "Stopped"
    RUNNING = "Running"
    STOPPING = "Stopping"
    STARTING = "Starting"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The current provisioning state.
    """

    UNKNOWN = "Unknown"
    SUCCEEDED = "Succeeded"
    ACCEPTED = "Accepted"
    DELETING = "Deleting"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETED = "Deleted"

class SkuDeploymentMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The sku deployment mode.
    """

    UNKNOWN = "Unknown"
    AZURE = "Azure"
    PRIVATE_EDGE_ZONE = "PrivateEdgeZone"

class SkuType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Sku type.
    """

    UNKNOWN = "Unknown"
    EVOLVED_PACKET_CORE = "EvolvedPacketCore"
    SDWAN = "SDWAN"
    FIREWALL = "Firewall"

class Status(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The current device status.
    """

    UNKNOWN = "Unknown"
    NOT_REGISTERED = "NotRegistered"
    REGISTERED = "Registered"
    DELETED = "Deleted"

class VendorProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The current vendor provisioning state.
    """

    UNKNOWN = "Unknown"
    NOT_PROVISIONED = "NotProvisioned"
    PROVISIONING = "Provisioning"
    PROVISIONED = "Provisioned"
    DEPROVISIONED = "Deprovisioned"
    USER_DATA_VALIDATION_FAILED = "UserDataValidationFailed"

class VirtualMachineSizeTypes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The size of the virtual machine.
    """

    UNKNOWN = "Unknown"
    STANDARD_D1_V2 = "Standard_D1_v2"
    STANDARD_D2_V2 = "Standard_D2_v2"
    STANDARD_D3_V2 = "Standard_D3_v2"
    STANDARD_D4_V2 = "Standard_D4_v2"
    STANDARD_D5_V2 = "Standard_D5_v2"
    STANDARD_D11_V2 = "Standard_D11_v2"
    STANDARD_D12_V2 = "Standard_D12_v2"
    STANDARD_D13_V2 = "Standard_D13_v2"
    STANDARD_DS1_V2 = "Standard_DS1_v2"
    STANDARD_DS2_V2 = "Standard_DS2_v2"
    STANDARD_DS3_V2 = "Standard_DS3_v2"
    STANDARD_DS4_V2 = "Standard_DS4_v2"
    STANDARD_DS5_V2 = "Standard_DS5_v2"
    STANDARD_DS11_V2 = "Standard_DS11_v2"
    STANDARD_DS12_V2 = "Standard_DS12_v2"
    STANDARD_DS13_V2 = "Standard_DS13_v2"
    STANDARD_F1 = "Standard_F1"
    STANDARD_F2 = "Standard_F2"
    STANDARD_F4 = "Standard_F4"
    STANDARD_F8 = "Standard_F8"
    STANDARD_F16 = "Standard_F16"
    STANDARD_F1_S = "Standard_F1s"
    STANDARD_F2_S = "Standard_F2s"
    STANDARD_F4_S = "Standard_F4s"
    STANDARD_F8_S = "Standard_F8s"
    STANDARD_F16_S = "Standard_F16s"

class VMSwitchType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the VM switch.
    """

    UNKNOWN = "Unknown"
    MANAGEMENT = "Management"
    WAN = "Wan"
    LAN = "Lan"
