# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential

from ._configuration import HybridNetworkManagementClientConfiguration
from .operations import NetworkFunctionsOperations
from .operations import DevicesOperations
from .operations import Operations
from .operations import VendorsOperations
from .operations import VendorSkusOperations
from .operations import VendorSkuPreviewOperations
from .operations import NetworkFunctionVendorsOperations
from .operations import NetworkFunctionVendorSkusOperations
from .operations import VendorNetworkFunctionsOperations
from .operations import RoleInstancesOperations
from . import models


class HybridNetworkManagementClient(object):
    """The definitions in this swagger specification will be used to manage the Hybrid Network resources.

    :ivar network_functions: NetworkFunctionsOperations operations
    :vartype network_functions: hybrid_network_management_client.operations.NetworkFunctionsOperations
    :ivar devices: DevicesOperations operations
    :vartype devices: hybrid_network_management_client.operations.DevicesOperations
    :ivar operations: Operations operations
    :vartype operations: hybrid_network_management_client.operations.Operations
    :ivar vendors: VendorsOperations operations
    :vartype vendors: hybrid_network_management_client.operations.VendorsOperations
    :ivar vendor_skus: VendorSkusOperations operations
    :vartype vendor_skus: hybrid_network_management_client.operations.VendorSkusOperations
    :ivar vendor_sku_preview: VendorSkuPreviewOperations operations
    :vartype vendor_sku_preview: hybrid_network_management_client.operations.VendorSkuPreviewOperations
    :ivar network_function_vendors: NetworkFunctionVendorsOperations operations
    :vartype network_function_vendors: hybrid_network_management_client.operations.NetworkFunctionVendorsOperations
    :ivar network_function_vendor_skus: NetworkFunctionVendorSkusOperations operations
    :vartype network_function_vendor_skus: hybrid_network_management_client.operations.NetworkFunctionVendorSkusOperations
    :ivar vendor_network_functions: VendorNetworkFunctionsOperations operations
    :vartype vendor_network_functions: hybrid_network_management_client.operations.VendorNetworkFunctionsOperations
    :ivar role_instances: RoleInstancesOperations operations
    :vartype role_instances: hybrid_network_management_client.operations.RoleInstancesOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = HybridNetworkManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.network_functions = NetworkFunctionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.devices = DevicesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.vendors = VendorsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.vendor_skus = VendorSkusOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.vendor_sku_preview = VendorSkuPreviewOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.network_function_vendors = NetworkFunctionVendorsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.network_function_vendor_skus = NetworkFunctionVendorSkusOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.vendor_network_functions = VendorNetworkFunctionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.role_instances = RoleInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> HybridNetworkManagementClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
