# coding: utf-8

"""
    Intrinio API

    Welcome to the Intrinio API! Through our Financial Data Marketplace, we offer a wide selection of financial data feed APIs sourced by our own proprietary processes as well as from many data vendors. For a complete API request / response reference please view the [Intrinio API documentation](https://docs.intrinio.com/documentation/api_v2). If you need additional help in using the API, please visit the [Intrinio website](https://intrinio.com) and click on the chat icon in the lower right corner.  # noqa: E501

    OpenAPI spec version: 2.26.12
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from intrinio_sdk.models.etf_summary import ETFSummary  # noqa: F401,E501


class ETFStats(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'date': 'date',
        'net_asset_value': 'float',
        'beta_vs_spy': 'float',
        'trailing_one_month_return_split_and_dividend': 'float',
        'trailing_one_month_return_split_only': 'float',
        'trailing_one_year_return_split_and_dividend': 'float',
        'trailing_one_year_return_split_only': 'float',
        'trailing_one_year_volatility_annualized': 'float',
        'trailing_three_year_annualized_return_split_and_dividend': 'float',
        'trailing_three_year_annualized_return_split_only': 'float',
        'trailing_three_year_volatility_annualized': 'float',
        'trailing_five_year_annualized_return_split_and_dividend': 'float',
        'trailing_five_year_annualized_return_split_only': 'float',
        'trailing_five_year_volatility_annualized': 'float',
        'trailing_ten_year_annualized_return_split_and_dividend': 'float',
        'trailing_ten_year_annualized_return_split_only': 'float',
        'inception_annualized_return_split_and_dividend': 'float',
        'inception_annualized_return_split_only': 'float',
        'calendar_year_5_return_split_and_dividend': 'float',
        'calendar_year_5_return_split_only': 'float',
        'calendar_year_4_return_split_and_dividend': 'float',
        'calendar_year_4_return_split_only': 'float',
        'calendar_year_3_return_split_and_dividend': 'float',
        'calendar_year_3_return_split_only': 'float',
        'calendar_year_2_return_split_and_dividend': 'float',
        'calendar_year_2_return_split_only': 'float',
        'calendar_year_1_return_split_and_dividend': 'float',
        'calendar_year_1_return_split_only': 'float',
        'calendar_year_to_date_return_split_and_dividend': 'float',
        'calendar_year_to_date_return_split_only': 'float',
        'etf': 'ETFSummary'
    }

    attribute_map = {
        'date': 'date',
        'net_asset_value': 'net_asset_value',
        'beta_vs_spy': 'beta_vs_spy',
        'trailing_one_month_return_split_and_dividend': 'trailing_one_month_return_split_and_dividend',
        'trailing_one_month_return_split_only': 'trailing_one_month_return_split_only',
        'trailing_one_year_return_split_and_dividend': 'trailing_one_year_return_split_and_dividend',
        'trailing_one_year_return_split_only': 'trailing_one_year_return_split_only',
        'trailing_one_year_volatility_annualized': 'trailing_one_year_volatility_annualized',
        'trailing_three_year_annualized_return_split_and_dividend': 'trailing_three_year_annualized_return_split_and_dividend',
        'trailing_three_year_annualized_return_split_only': 'trailing_three_year_annualized_return_split_only',
        'trailing_three_year_volatility_annualized': 'trailing_three_year_volatility_annualized',
        'trailing_five_year_annualized_return_split_and_dividend': 'trailing_five_year_annualized_return_split_and_dividend',
        'trailing_five_year_annualized_return_split_only': 'trailing_five_year_annualized_return_split_only',
        'trailing_five_year_volatility_annualized': 'trailing_five_year_volatility_annualized',
        'trailing_ten_year_annualized_return_split_and_dividend': 'trailing_ten_year_annualized_return_split_and_dividend',
        'trailing_ten_year_annualized_return_split_only': 'trailing_ten_year_annualized_return_split_only',
        'inception_annualized_return_split_and_dividend': 'inception_annualized_return_split_and_dividend',
        'inception_annualized_return_split_only': 'inception_annualized_return_split_only',
        'calendar_year_5_return_split_and_dividend': 'calendar_year_5_return_split_and_dividend',
        'calendar_year_5_return_split_only': 'calendar_year_5_return_split_only',
        'calendar_year_4_return_split_and_dividend': 'calendar_year_4_return_split_and_dividend',
        'calendar_year_4_return_split_only': 'calendar_year_4_return_split_only',
        'calendar_year_3_return_split_and_dividend': 'calendar_year_3_return_split_and_dividend',
        'calendar_year_3_return_split_only': 'calendar_year_3_return_split_only',
        'calendar_year_2_return_split_and_dividend': 'calendar_year_2_return_split_and_dividend',
        'calendar_year_2_return_split_only': 'calendar_year_2_return_split_only',
        'calendar_year_1_return_split_and_dividend': 'calendar_year_1_return_split_and_dividend',
        'calendar_year_1_return_split_only': 'calendar_year_1_return_split_only',
        'calendar_year_to_date_return_split_and_dividend': 'calendar_year_to_date_return_split_and_dividend',
        'calendar_year_to_date_return_split_only': 'calendar_year_to_date_return_split_only',
        'etf': 'etf'
    }

    def __init__(self, date=None, net_asset_value=None, beta_vs_spy=None, trailing_one_month_return_split_and_dividend=None, trailing_one_month_return_split_only=None, trailing_one_year_return_split_and_dividend=None, trailing_one_year_return_split_only=None, trailing_one_year_volatility_annualized=None, trailing_three_year_annualized_return_split_and_dividend=None, trailing_three_year_annualized_return_split_only=None, trailing_three_year_volatility_annualized=None, trailing_five_year_annualized_return_split_and_dividend=None, trailing_five_year_annualized_return_split_only=None, trailing_five_year_volatility_annualized=None, trailing_ten_year_annualized_return_split_and_dividend=None, trailing_ten_year_annualized_return_split_only=None, inception_annualized_return_split_and_dividend=None, inception_annualized_return_split_only=None, calendar_year_5_return_split_and_dividend=None, calendar_year_5_return_split_only=None, calendar_year_4_return_split_and_dividend=None, calendar_year_4_return_split_only=None, calendar_year_3_return_split_and_dividend=None, calendar_year_3_return_split_only=None, calendar_year_2_return_split_and_dividend=None, calendar_year_2_return_split_only=None, calendar_year_1_return_split_and_dividend=None, calendar_year_1_return_split_only=None, calendar_year_to_date_return_split_and_dividend=None, calendar_year_to_date_return_split_only=None, etf=None):  # noqa: E501
        """ETFStats - a model defined in Swagger"""  # noqa: E501

        self._date = None
        self._net_asset_value = None
        self._beta_vs_spy = None
        self._trailing_one_month_return_split_and_dividend = None
        self._trailing_one_month_return_split_only = None
        self._trailing_one_year_return_split_and_dividend = None
        self._trailing_one_year_return_split_only = None
        self._trailing_one_year_volatility_annualized = None
        self._trailing_three_year_annualized_return_split_and_dividend = None
        self._trailing_three_year_annualized_return_split_only = None
        self._trailing_three_year_volatility_annualized = None
        self._trailing_five_year_annualized_return_split_and_dividend = None
        self._trailing_five_year_annualized_return_split_only = None
        self._trailing_five_year_volatility_annualized = None
        self._trailing_ten_year_annualized_return_split_and_dividend = None
        self._trailing_ten_year_annualized_return_split_only = None
        self._inception_annualized_return_split_and_dividend = None
        self._inception_annualized_return_split_only = None
        self._calendar_year_5_return_split_and_dividend = None
        self._calendar_year_5_return_split_only = None
        self._calendar_year_4_return_split_and_dividend = None
        self._calendar_year_4_return_split_only = None
        self._calendar_year_3_return_split_and_dividend = None
        self._calendar_year_3_return_split_only = None
        self._calendar_year_2_return_split_and_dividend = None
        self._calendar_year_2_return_split_only = None
        self._calendar_year_1_return_split_and_dividend = None
        self._calendar_year_1_return_split_only = None
        self._calendar_year_to_date_return_split_and_dividend = None
        self._calendar_year_to_date_return_split_only = None
        self._etf = None
        self.discriminator = None

        if date is not None:
            self.date = date
        if net_asset_value is not None:
            self.net_asset_value = net_asset_value
        if beta_vs_spy is not None:
            self.beta_vs_spy = beta_vs_spy
        if trailing_one_month_return_split_and_dividend is not None:
            self.trailing_one_month_return_split_and_dividend = trailing_one_month_return_split_and_dividend
        if trailing_one_month_return_split_only is not None:
            self.trailing_one_month_return_split_only = trailing_one_month_return_split_only
        if trailing_one_year_return_split_and_dividend is not None:
            self.trailing_one_year_return_split_and_dividend = trailing_one_year_return_split_and_dividend
        if trailing_one_year_return_split_only is not None:
            self.trailing_one_year_return_split_only = trailing_one_year_return_split_only
        if trailing_one_year_volatility_annualized is not None:
            self.trailing_one_year_volatility_annualized = trailing_one_year_volatility_annualized
        if trailing_three_year_annualized_return_split_and_dividend is not None:
            self.trailing_three_year_annualized_return_split_and_dividend = trailing_three_year_annualized_return_split_and_dividend
        if trailing_three_year_annualized_return_split_only is not None:
            self.trailing_three_year_annualized_return_split_only = trailing_three_year_annualized_return_split_only
        if trailing_three_year_volatility_annualized is not None:
            self.trailing_three_year_volatility_annualized = trailing_three_year_volatility_annualized
        if trailing_five_year_annualized_return_split_and_dividend is not None:
            self.trailing_five_year_annualized_return_split_and_dividend = trailing_five_year_annualized_return_split_and_dividend
        if trailing_five_year_annualized_return_split_only is not None:
            self.trailing_five_year_annualized_return_split_only = trailing_five_year_annualized_return_split_only
        if trailing_five_year_volatility_annualized is not None:
            self.trailing_five_year_volatility_annualized = trailing_five_year_volatility_annualized
        if trailing_ten_year_annualized_return_split_and_dividend is not None:
            self.trailing_ten_year_annualized_return_split_and_dividend = trailing_ten_year_annualized_return_split_and_dividend
        if trailing_ten_year_annualized_return_split_only is not None:
            self.trailing_ten_year_annualized_return_split_only = trailing_ten_year_annualized_return_split_only
        if inception_annualized_return_split_and_dividend is not None:
            self.inception_annualized_return_split_and_dividend = inception_annualized_return_split_and_dividend
        if inception_annualized_return_split_only is not None:
            self.inception_annualized_return_split_only = inception_annualized_return_split_only
        if calendar_year_5_return_split_and_dividend is not None:
            self.calendar_year_5_return_split_and_dividend = calendar_year_5_return_split_and_dividend
        if calendar_year_5_return_split_only is not None:
            self.calendar_year_5_return_split_only = calendar_year_5_return_split_only
        if calendar_year_4_return_split_and_dividend is not None:
            self.calendar_year_4_return_split_and_dividend = calendar_year_4_return_split_and_dividend
        if calendar_year_4_return_split_only is not None:
            self.calendar_year_4_return_split_only = calendar_year_4_return_split_only
        if calendar_year_3_return_split_and_dividend is not None:
            self.calendar_year_3_return_split_and_dividend = calendar_year_3_return_split_and_dividend
        if calendar_year_3_return_split_only is not None:
            self.calendar_year_3_return_split_only = calendar_year_3_return_split_only
        if calendar_year_2_return_split_and_dividend is not None:
            self.calendar_year_2_return_split_and_dividend = calendar_year_2_return_split_and_dividend
        if calendar_year_2_return_split_only is not None:
            self.calendar_year_2_return_split_only = calendar_year_2_return_split_only
        if calendar_year_1_return_split_and_dividend is not None:
            self.calendar_year_1_return_split_and_dividend = calendar_year_1_return_split_and_dividend
        if calendar_year_1_return_split_only is not None:
            self.calendar_year_1_return_split_only = calendar_year_1_return_split_only
        if calendar_year_to_date_return_split_and_dividend is not None:
            self.calendar_year_to_date_return_split_and_dividend = calendar_year_to_date_return_split_and_dividend
        if calendar_year_to_date_return_split_only is not None:
            self.calendar_year_to_date_return_split_only = calendar_year_to_date_return_split_only
        if etf is not None:
            self.etf = etf

    @property
    def date(self):
        """Gets the date of this ETFStats.  # noqa: E501


        :return: The date of this ETFStats.  # noqa: E501
        :rtype: date
        """
        return self._date
        
    @property
    def date_dict(self):
        """Gets the date of this ETFStats.  # noqa: E501


        :return: The date of this ETFStats.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'date': value }

        
        return result
        

    @date.setter
    def date(self, date):
        """Sets the date of this ETFStats.


        :param date: The date of this ETFStats.  # noqa: E501
        :type: date
        """

        self._date = date

    @property
    def net_asset_value(self):
        """Gets the net_asset_value of this ETFStats.  # noqa: E501

        The net asset value (NAV = Total Assets - Total Liabilities)  # noqa: E501

        :return: The net_asset_value of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._net_asset_value
        
    @property
    def net_asset_value_dict(self):
        """Gets the net_asset_value of this ETFStats.  # noqa: E501

        The net asset value (NAV = Total Assets - Total Liabilities) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The net_asset_value of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.net_asset_value
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'net_asset_value': value }

        
        return result
        

    @net_asset_value.setter
    def net_asset_value(self, net_asset_value):
        """Sets the net_asset_value of this ETFStats.

        The net asset value (NAV = Total Assets - Total Liabilities)  # noqa: E501

        :param net_asset_value: The net_asset_value of this ETFStats.  # noqa: E501
        :type: float
        """

        self._net_asset_value = net_asset_value

    @property
    def beta_vs_spy(self):
        """Gets the beta_vs_spy of this ETFStats.  # noqa: E501

        Volatility this ETF is versus the SPY ETF  # noqa: E501

        :return: The beta_vs_spy of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._beta_vs_spy
        
    @property
    def beta_vs_spy_dict(self):
        """Gets the beta_vs_spy of this ETFStats.  # noqa: E501

        Volatility this ETF is versus the SPY ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The beta_vs_spy of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.beta_vs_spy
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'beta_vs_spy': value }

        
        return result
        

    @beta_vs_spy.setter
    def beta_vs_spy(self, beta_vs_spy):
        """Sets the beta_vs_spy of this ETFStats.

        Volatility this ETF is versus the SPY ETF  # noqa: E501

        :param beta_vs_spy: The beta_vs_spy of this ETFStats.  # noqa: E501
        :type: float
        """

        self._beta_vs_spy = beta_vs_spy

    @property
    def trailing_one_month_return_split_and_dividend(self):
        """Gets the trailing_one_month_return_split_and_dividend of this ETFStats.  # noqa: E501

        Trailing one month return including dividends  # noqa: E501

        :return: The trailing_one_month_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._trailing_one_month_return_split_and_dividend
        
    @property
    def trailing_one_month_return_split_and_dividend_dict(self):
        """Gets the trailing_one_month_return_split_and_dividend of this ETFStats.  # noqa: E501

        Trailing one month return including dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The trailing_one_month_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.trailing_one_month_return_split_and_dividend
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'trailing_one_month_return_split_and_dividend': value }

        
        return result
        

    @trailing_one_month_return_split_and_dividend.setter
    def trailing_one_month_return_split_and_dividend(self, trailing_one_month_return_split_and_dividend):
        """Sets the trailing_one_month_return_split_and_dividend of this ETFStats.

        Trailing one month return including dividends  # noqa: E501

        :param trailing_one_month_return_split_and_dividend: The trailing_one_month_return_split_and_dividend of this ETFStats.  # noqa: E501
        :type: float
        """

        self._trailing_one_month_return_split_and_dividend = trailing_one_month_return_split_and_dividend

    @property
    def trailing_one_month_return_split_only(self):
        """Gets the trailing_one_month_return_split_only of this ETFStats.  # noqa: E501

        Trailing one month return excluding dividends  # noqa: E501

        :return: The trailing_one_month_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._trailing_one_month_return_split_only
        
    @property
    def trailing_one_month_return_split_only_dict(self):
        """Gets the trailing_one_month_return_split_only of this ETFStats.  # noqa: E501

        Trailing one month return excluding dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The trailing_one_month_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.trailing_one_month_return_split_only
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'trailing_one_month_return_split_only': value }

        
        return result
        

    @trailing_one_month_return_split_only.setter
    def trailing_one_month_return_split_only(self, trailing_one_month_return_split_only):
        """Sets the trailing_one_month_return_split_only of this ETFStats.

        Trailing one month return excluding dividends  # noqa: E501

        :param trailing_one_month_return_split_only: The trailing_one_month_return_split_only of this ETFStats.  # noqa: E501
        :type: float
        """

        self._trailing_one_month_return_split_only = trailing_one_month_return_split_only

    @property
    def trailing_one_year_return_split_and_dividend(self):
        """Gets the trailing_one_year_return_split_and_dividend of this ETFStats.  # noqa: E501

        Trailing one year return including dividends  # noqa: E501

        :return: The trailing_one_year_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._trailing_one_year_return_split_and_dividend
        
    @property
    def trailing_one_year_return_split_and_dividend_dict(self):
        """Gets the trailing_one_year_return_split_and_dividend of this ETFStats.  # noqa: E501

        Trailing one year return including dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The trailing_one_year_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.trailing_one_year_return_split_and_dividend
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'trailing_one_year_return_split_and_dividend': value }

        
        return result
        

    @trailing_one_year_return_split_and_dividend.setter
    def trailing_one_year_return_split_and_dividend(self, trailing_one_year_return_split_and_dividend):
        """Sets the trailing_one_year_return_split_and_dividend of this ETFStats.

        Trailing one year return including dividends  # noqa: E501

        :param trailing_one_year_return_split_and_dividend: The trailing_one_year_return_split_and_dividend of this ETFStats.  # noqa: E501
        :type: float
        """

        self._trailing_one_year_return_split_and_dividend = trailing_one_year_return_split_and_dividend

    @property
    def trailing_one_year_return_split_only(self):
        """Gets the trailing_one_year_return_split_only of this ETFStats.  # noqa: E501

        Trailing one year return excluding dividends  # noqa: E501

        :return: The trailing_one_year_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._trailing_one_year_return_split_only
        
    @property
    def trailing_one_year_return_split_only_dict(self):
        """Gets the trailing_one_year_return_split_only of this ETFStats.  # noqa: E501

        Trailing one year return excluding dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The trailing_one_year_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.trailing_one_year_return_split_only
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'trailing_one_year_return_split_only': value }

        
        return result
        

    @trailing_one_year_return_split_only.setter
    def trailing_one_year_return_split_only(self, trailing_one_year_return_split_only):
        """Sets the trailing_one_year_return_split_only of this ETFStats.

        Trailing one year return excluding dividends  # noqa: E501

        :param trailing_one_year_return_split_only: The trailing_one_year_return_split_only of this ETFStats.  # noqa: E501
        :type: float
        """

        self._trailing_one_year_return_split_only = trailing_one_year_return_split_only

    @property
    def trailing_one_year_volatility_annualized(self):
        """Gets the trailing_one_year_volatility_annualized of this ETFStats.  # noqa: E501

        Annualized standard deviation of daily price returns over trailing 252 trading days  # noqa: E501

        :return: The trailing_one_year_volatility_annualized of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._trailing_one_year_volatility_annualized
        
    @property
    def trailing_one_year_volatility_annualized_dict(self):
        """Gets the trailing_one_year_volatility_annualized of this ETFStats.  # noqa: E501

        Annualized standard deviation of daily price returns over trailing 252 trading days as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The trailing_one_year_volatility_annualized of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.trailing_one_year_volatility_annualized
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'trailing_one_year_volatility_annualized': value }

        
        return result
        

    @trailing_one_year_volatility_annualized.setter
    def trailing_one_year_volatility_annualized(self, trailing_one_year_volatility_annualized):
        """Sets the trailing_one_year_volatility_annualized of this ETFStats.

        Annualized standard deviation of daily price returns over trailing 252 trading days  # noqa: E501

        :param trailing_one_year_volatility_annualized: The trailing_one_year_volatility_annualized of this ETFStats.  # noqa: E501
        :type: float
        """

        self._trailing_one_year_volatility_annualized = trailing_one_year_volatility_annualized

    @property
    def trailing_three_year_annualized_return_split_and_dividend(self):
        """Gets the trailing_three_year_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501

        Trailing three year return including dividends  # noqa: E501

        :return: The trailing_three_year_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._trailing_three_year_annualized_return_split_and_dividend
        
    @property
    def trailing_three_year_annualized_return_split_and_dividend_dict(self):
        """Gets the trailing_three_year_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501

        Trailing three year return including dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The trailing_three_year_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.trailing_three_year_annualized_return_split_and_dividend
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'trailing_three_year_annualized_return_split_and_dividend': value }

        
        return result
        

    @trailing_three_year_annualized_return_split_and_dividend.setter
    def trailing_three_year_annualized_return_split_and_dividend(self, trailing_three_year_annualized_return_split_and_dividend):
        """Sets the trailing_three_year_annualized_return_split_and_dividend of this ETFStats.

        Trailing three year return including dividends  # noqa: E501

        :param trailing_three_year_annualized_return_split_and_dividend: The trailing_three_year_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501
        :type: float
        """

        self._trailing_three_year_annualized_return_split_and_dividend = trailing_three_year_annualized_return_split_and_dividend

    @property
    def trailing_three_year_annualized_return_split_only(self):
        """Gets the trailing_three_year_annualized_return_split_only of this ETFStats.  # noqa: E501

        Trailing three year return excluding dividends  # noqa: E501

        :return: The trailing_three_year_annualized_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._trailing_three_year_annualized_return_split_only
        
    @property
    def trailing_three_year_annualized_return_split_only_dict(self):
        """Gets the trailing_three_year_annualized_return_split_only of this ETFStats.  # noqa: E501

        Trailing three year return excluding dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The trailing_three_year_annualized_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.trailing_three_year_annualized_return_split_only
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'trailing_three_year_annualized_return_split_only': value }

        
        return result
        

    @trailing_three_year_annualized_return_split_only.setter
    def trailing_three_year_annualized_return_split_only(self, trailing_three_year_annualized_return_split_only):
        """Sets the trailing_three_year_annualized_return_split_only of this ETFStats.

        Trailing three year return excluding dividends  # noqa: E501

        :param trailing_three_year_annualized_return_split_only: The trailing_three_year_annualized_return_split_only of this ETFStats.  # noqa: E501
        :type: float
        """

        self._trailing_three_year_annualized_return_split_only = trailing_three_year_annualized_return_split_only

    @property
    def trailing_three_year_volatility_annualized(self):
        """Gets the trailing_three_year_volatility_annualized of this ETFStats.  # noqa: E501

        Annualized standard deviation of daily price returns over trailing 756 trading days  # noqa: E501

        :return: The trailing_three_year_volatility_annualized of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._trailing_three_year_volatility_annualized
        
    @property
    def trailing_three_year_volatility_annualized_dict(self):
        """Gets the trailing_three_year_volatility_annualized of this ETFStats.  # noqa: E501

        Annualized standard deviation of daily price returns over trailing 756 trading days as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The trailing_three_year_volatility_annualized of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.trailing_three_year_volatility_annualized
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'trailing_three_year_volatility_annualized': value }

        
        return result
        

    @trailing_three_year_volatility_annualized.setter
    def trailing_three_year_volatility_annualized(self, trailing_three_year_volatility_annualized):
        """Sets the trailing_three_year_volatility_annualized of this ETFStats.

        Annualized standard deviation of daily price returns over trailing 756 trading days  # noqa: E501

        :param trailing_three_year_volatility_annualized: The trailing_three_year_volatility_annualized of this ETFStats.  # noqa: E501
        :type: float
        """

        self._trailing_three_year_volatility_annualized = trailing_three_year_volatility_annualized

    @property
    def trailing_five_year_annualized_return_split_and_dividend(self):
        """Gets the trailing_five_year_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501

        Trailing five year return including dividends  # noqa: E501

        :return: The trailing_five_year_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._trailing_five_year_annualized_return_split_and_dividend
        
    @property
    def trailing_five_year_annualized_return_split_and_dividend_dict(self):
        """Gets the trailing_five_year_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501

        Trailing five year return including dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The trailing_five_year_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.trailing_five_year_annualized_return_split_and_dividend
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'trailing_five_year_annualized_return_split_and_dividend': value }

        
        return result
        

    @trailing_five_year_annualized_return_split_and_dividend.setter
    def trailing_five_year_annualized_return_split_and_dividend(self, trailing_five_year_annualized_return_split_and_dividend):
        """Sets the trailing_five_year_annualized_return_split_and_dividend of this ETFStats.

        Trailing five year return including dividends  # noqa: E501

        :param trailing_five_year_annualized_return_split_and_dividend: The trailing_five_year_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501
        :type: float
        """

        self._trailing_five_year_annualized_return_split_and_dividend = trailing_five_year_annualized_return_split_and_dividend

    @property
    def trailing_five_year_annualized_return_split_only(self):
        """Gets the trailing_five_year_annualized_return_split_only of this ETFStats.  # noqa: E501

        Trailing five year return excluding dividends  # noqa: E501

        :return: The trailing_five_year_annualized_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._trailing_five_year_annualized_return_split_only
        
    @property
    def trailing_five_year_annualized_return_split_only_dict(self):
        """Gets the trailing_five_year_annualized_return_split_only of this ETFStats.  # noqa: E501

        Trailing five year return excluding dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The trailing_five_year_annualized_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.trailing_five_year_annualized_return_split_only
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'trailing_five_year_annualized_return_split_only': value }

        
        return result
        

    @trailing_five_year_annualized_return_split_only.setter
    def trailing_five_year_annualized_return_split_only(self, trailing_five_year_annualized_return_split_only):
        """Sets the trailing_five_year_annualized_return_split_only of this ETFStats.

        Trailing five year return excluding dividends  # noqa: E501

        :param trailing_five_year_annualized_return_split_only: The trailing_five_year_annualized_return_split_only of this ETFStats.  # noqa: E501
        :type: float
        """

        self._trailing_five_year_annualized_return_split_only = trailing_five_year_annualized_return_split_only

    @property
    def trailing_five_year_volatility_annualized(self):
        """Gets the trailing_five_year_volatility_annualized of this ETFStats.  # noqa: E501

        Annualized standard  deviation  of  daily  price  returns  over  trailing 1260 trading days  # noqa: E501

        :return: The trailing_five_year_volatility_annualized of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._trailing_five_year_volatility_annualized
        
    @property
    def trailing_five_year_volatility_annualized_dict(self):
        """Gets the trailing_five_year_volatility_annualized of this ETFStats.  # noqa: E501

        Annualized standard  deviation  of  daily  price  returns  over  trailing 1260 trading days as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The trailing_five_year_volatility_annualized of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.trailing_five_year_volatility_annualized
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'trailing_five_year_volatility_annualized': value }

        
        return result
        

    @trailing_five_year_volatility_annualized.setter
    def trailing_five_year_volatility_annualized(self, trailing_five_year_volatility_annualized):
        """Sets the trailing_five_year_volatility_annualized of this ETFStats.

        Annualized standard  deviation  of  daily  price  returns  over  trailing 1260 trading days  # noqa: E501

        :param trailing_five_year_volatility_annualized: The trailing_five_year_volatility_annualized of this ETFStats.  # noqa: E501
        :type: float
        """

        self._trailing_five_year_volatility_annualized = trailing_five_year_volatility_annualized

    @property
    def trailing_ten_year_annualized_return_split_and_dividend(self):
        """Gets the trailing_ten_year_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501

        Trailing ten year return including dividends  # noqa: E501

        :return: The trailing_ten_year_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._trailing_ten_year_annualized_return_split_and_dividend
        
    @property
    def trailing_ten_year_annualized_return_split_and_dividend_dict(self):
        """Gets the trailing_ten_year_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501

        Trailing ten year return including dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The trailing_ten_year_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.trailing_ten_year_annualized_return_split_and_dividend
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'trailing_ten_year_annualized_return_split_and_dividend': value }

        
        return result
        

    @trailing_ten_year_annualized_return_split_and_dividend.setter
    def trailing_ten_year_annualized_return_split_and_dividend(self, trailing_ten_year_annualized_return_split_and_dividend):
        """Sets the trailing_ten_year_annualized_return_split_and_dividend of this ETFStats.

        Trailing ten year return including dividends  # noqa: E501

        :param trailing_ten_year_annualized_return_split_and_dividend: The trailing_ten_year_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501
        :type: float
        """

        self._trailing_ten_year_annualized_return_split_and_dividend = trailing_ten_year_annualized_return_split_and_dividend

    @property
    def trailing_ten_year_annualized_return_split_only(self):
        """Gets the trailing_ten_year_annualized_return_split_only of this ETFStats.  # noqa: E501

        Trailing ten year return excluding dividends  # noqa: E501

        :return: The trailing_ten_year_annualized_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._trailing_ten_year_annualized_return_split_only
        
    @property
    def trailing_ten_year_annualized_return_split_only_dict(self):
        """Gets the trailing_ten_year_annualized_return_split_only of this ETFStats.  # noqa: E501

        Trailing ten year return excluding dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The trailing_ten_year_annualized_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.trailing_ten_year_annualized_return_split_only
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'trailing_ten_year_annualized_return_split_only': value }

        
        return result
        

    @trailing_ten_year_annualized_return_split_only.setter
    def trailing_ten_year_annualized_return_split_only(self, trailing_ten_year_annualized_return_split_only):
        """Sets the trailing_ten_year_annualized_return_split_only of this ETFStats.

        Trailing ten year return excluding dividends  # noqa: E501

        :param trailing_ten_year_annualized_return_split_only: The trailing_ten_year_annualized_return_split_only of this ETFStats.  # noqa: E501
        :type: float
        """

        self._trailing_ten_year_annualized_return_split_only = trailing_ten_year_annualized_return_split_only

    @property
    def inception_annualized_return_split_and_dividend(self):
        """Gets the inception_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501

        Annualized return including dividends since inception  # noqa: E501

        :return: The inception_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._inception_annualized_return_split_and_dividend
        
    @property
    def inception_annualized_return_split_and_dividend_dict(self):
        """Gets the inception_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501

        Annualized return including dividends since inception as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The inception_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.inception_annualized_return_split_and_dividend
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'inception_annualized_return_split_and_dividend': value }

        
        return result
        

    @inception_annualized_return_split_and_dividend.setter
    def inception_annualized_return_split_and_dividend(self, inception_annualized_return_split_and_dividend):
        """Sets the inception_annualized_return_split_and_dividend of this ETFStats.

        Annualized return including dividends since inception  # noqa: E501

        :param inception_annualized_return_split_and_dividend: The inception_annualized_return_split_and_dividend of this ETFStats.  # noqa: E501
        :type: float
        """

        self._inception_annualized_return_split_and_dividend = inception_annualized_return_split_and_dividend

    @property
    def inception_annualized_return_split_only(self):
        """Gets the inception_annualized_return_split_only of this ETFStats.  # noqa: E501

        Annualized return excluding dividends since inception  # noqa: E501

        :return: The inception_annualized_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._inception_annualized_return_split_only
        
    @property
    def inception_annualized_return_split_only_dict(self):
        """Gets the inception_annualized_return_split_only of this ETFStats.  # noqa: E501

        Annualized return excluding dividends since inception as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The inception_annualized_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.inception_annualized_return_split_only
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'inception_annualized_return_split_only': value }

        
        return result
        

    @inception_annualized_return_split_only.setter
    def inception_annualized_return_split_only(self, inception_annualized_return_split_only):
        """Sets the inception_annualized_return_split_only of this ETFStats.

        Annualized return excluding dividends since inception  # noqa: E501

        :param inception_annualized_return_split_only: The inception_annualized_return_split_only of this ETFStats.  # noqa: E501
        :type: float
        """

        self._inception_annualized_return_split_only = inception_annualized_return_split_only

    @property
    def calendar_year_5_return_split_and_dividend(self):
        """Gets the calendar_year_5_return_split_and_dividend of this ETFStats.  # noqa: E501

        Five years ago calendar year return including dividends  # noqa: E501

        :return: The calendar_year_5_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._calendar_year_5_return_split_and_dividend
        
    @property
    def calendar_year_5_return_split_and_dividend_dict(self):
        """Gets the calendar_year_5_return_split_and_dividend of this ETFStats.  # noqa: E501

        Five years ago calendar year return including dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The calendar_year_5_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.calendar_year_5_return_split_and_dividend
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'calendar_year_5_return_split_and_dividend': value }

        
        return result
        

    @calendar_year_5_return_split_and_dividend.setter
    def calendar_year_5_return_split_and_dividend(self, calendar_year_5_return_split_and_dividend):
        """Sets the calendar_year_5_return_split_and_dividend of this ETFStats.

        Five years ago calendar year return including dividends  # noqa: E501

        :param calendar_year_5_return_split_and_dividend: The calendar_year_5_return_split_and_dividend of this ETFStats.  # noqa: E501
        :type: float
        """

        self._calendar_year_5_return_split_and_dividend = calendar_year_5_return_split_and_dividend

    @property
    def calendar_year_5_return_split_only(self):
        """Gets the calendar_year_5_return_split_only of this ETFStats.  # noqa: E501

        Five years ago calendar year return excluding dividends  # noqa: E501

        :return: The calendar_year_5_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._calendar_year_5_return_split_only
        
    @property
    def calendar_year_5_return_split_only_dict(self):
        """Gets the calendar_year_5_return_split_only of this ETFStats.  # noqa: E501

        Five years ago calendar year return excluding dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The calendar_year_5_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.calendar_year_5_return_split_only
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'calendar_year_5_return_split_only': value }

        
        return result
        

    @calendar_year_5_return_split_only.setter
    def calendar_year_5_return_split_only(self, calendar_year_5_return_split_only):
        """Sets the calendar_year_5_return_split_only of this ETFStats.

        Five years ago calendar year return excluding dividends  # noqa: E501

        :param calendar_year_5_return_split_only: The calendar_year_5_return_split_only of this ETFStats.  # noqa: E501
        :type: float
        """

        self._calendar_year_5_return_split_only = calendar_year_5_return_split_only

    @property
    def calendar_year_4_return_split_and_dividend(self):
        """Gets the calendar_year_4_return_split_and_dividend of this ETFStats.  # noqa: E501

        Four years ago calendar year return including dividends  # noqa: E501

        :return: The calendar_year_4_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._calendar_year_4_return_split_and_dividend
        
    @property
    def calendar_year_4_return_split_and_dividend_dict(self):
        """Gets the calendar_year_4_return_split_and_dividend of this ETFStats.  # noqa: E501

        Four years ago calendar year return including dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The calendar_year_4_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.calendar_year_4_return_split_and_dividend
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'calendar_year_4_return_split_and_dividend': value }

        
        return result
        

    @calendar_year_4_return_split_and_dividend.setter
    def calendar_year_4_return_split_and_dividend(self, calendar_year_4_return_split_and_dividend):
        """Sets the calendar_year_4_return_split_and_dividend of this ETFStats.

        Four years ago calendar year return including dividends  # noqa: E501

        :param calendar_year_4_return_split_and_dividend: The calendar_year_4_return_split_and_dividend of this ETFStats.  # noqa: E501
        :type: float
        """

        self._calendar_year_4_return_split_and_dividend = calendar_year_4_return_split_and_dividend

    @property
    def calendar_year_4_return_split_only(self):
        """Gets the calendar_year_4_return_split_only of this ETFStats.  # noqa: E501

        Four years ago calendar year return excluding dividends  # noqa: E501

        :return: The calendar_year_4_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._calendar_year_4_return_split_only
        
    @property
    def calendar_year_4_return_split_only_dict(self):
        """Gets the calendar_year_4_return_split_only of this ETFStats.  # noqa: E501

        Four years ago calendar year return excluding dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The calendar_year_4_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.calendar_year_4_return_split_only
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'calendar_year_4_return_split_only': value }

        
        return result
        

    @calendar_year_4_return_split_only.setter
    def calendar_year_4_return_split_only(self, calendar_year_4_return_split_only):
        """Sets the calendar_year_4_return_split_only of this ETFStats.

        Four years ago calendar year return excluding dividends  # noqa: E501

        :param calendar_year_4_return_split_only: The calendar_year_4_return_split_only of this ETFStats.  # noqa: E501
        :type: float
        """

        self._calendar_year_4_return_split_only = calendar_year_4_return_split_only

    @property
    def calendar_year_3_return_split_and_dividend(self):
        """Gets the calendar_year_3_return_split_and_dividend of this ETFStats.  # noqa: E501

        Three years ago calendar year return including dividends  # noqa: E501

        :return: The calendar_year_3_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._calendar_year_3_return_split_and_dividend
        
    @property
    def calendar_year_3_return_split_and_dividend_dict(self):
        """Gets the calendar_year_3_return_split_and_dividend of this ETFStats.  # noqa: E501

        Three years ago calendar year return including dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The calendar_year_3_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.calendar_year_3_return_split_and_dividend
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'calendar_year_3_return_split_and_dividend': value }

        
        return result
        

    @calendar_year_3_return_split_and_dividend.setter
    def calendar_year_3_return_split_and_dividend(self, calendar_year_3_return_split_and_dividend):
        """Sets the calendar_year_3_return_split_and_dividend of this ETFStats.

        Three years ago calendar year return including dividends  # noqa: E501

        :param calendar_year_3_return_split_and_dividend: The calendar_year_3_return_split_and_dividend of this ETFStats.  # noqa: E501
        :type: float
        """

        self._calendar_year_3_return_split_and_dividend = calendar_year_3_return_split_and_dividend

    @property
    def calendar_year_3_return_split_only(self):
        """Gets the calendar_year_3_return_split_only of this ETFStats.  # noqa: E501

        Three years ago calendar year return excluding dividends  # noqa: E501

        :return: The calendar_year_3_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._calendar_year_3_return_split_only
        
    @property
    def calendar_year_3_return_split_only_dict(self):
        """Gets the calendar_year_3_return_split_only of this ETFStats.  # noqa: E501

        Three years ago calendar year return excluding dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The calendar_year_3_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.calendar_year_3_return_split_only
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'calendar_year_3_return_split_only': value }

        
        return result
        

    @calendar_year_3_return_split_only.setter
    def calendar_year_3_return_split_only(self, calendar_year_3_return_split_only):
        """Sets the calendar_year_3_return_split_only of this ETFStats.

        Three years ago calendar year return excluding dividends  # noqa: E501

        :param calendar_year_3_return_split_only: The calendar_year_3_return_split_only of this ETFStats.  # noqa: E501
        :type: float
        """

        self._calendar_year_3_return_split_only = calendar_year_3_return_split_only

    @property
    def calendar_year_2_return_split_and_dividend(self):
        """Gets the calendar_year_2_return_split_and_dividend of this ETFStats.  # noqa: E501

        Two years ago calendar year return including dividends  # noqa: E501

        :return: The calendar_year_2_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._calendar_year_2_return_split_and_dividend
        
    @property
    def calendar_year_2_return_split_and_dividend_dict(self):
        """Gets the calendar_year_2_return_split_and_dividend of this ETFStats.  # noqa: E501

        Two years ago calendar year return including dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The calendar_year_2_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.calendar_year_2_return_split_and_dividend
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'calendar_year_2_return_split_and_dividend': value }

        
        return result
        

    @calendar_year_2_return_split_and_dividend.setter
    def calendar_year_2_return_split_and_dividend(self, calendar_year_2_return_split_and_dividend):
        """Sets the calendar_year_2_return_split_and_dividend of this ETFStats.

        Two years ago calendar year return including dividends  # noqa: E501

        :param calendar_year_2_return_split_and_dividend: The calendar_year_2_return_split_and_dividend of this ETFStats.  # noqa: E501
        :type: float
        """

        self._calendar_year_2_return_split_and_dividend = calendar_year_2_return_split_and_dividend

    @property
    def calendar_year_2_return_split_only(self):
        """Gets the calendar_year_2_return_split_only of this ETFStats.  # noqa: E501

        Two years ago calendar year return excluding dividends  # noqa: E501

        :return: The calendar_year_2_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._calendar_year_2_return_split_only
        
    @property
    def calendar_year_2_return_split_only_dict(self):
        """Gets the calendar_year_2_return_split_only of this ETFStats.  # noqa: E501

        Two years ago calendar year return excluding dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The calendar_year_2_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.calendar_year_2_return_split_only
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'calendar_year_2_return_split_only': value }

        
        return result
        

    @calendar_year_2_return_split_only.setter
    def calendar_year_2_return_split_only(self, calendar_year_2_return_split_only):
        """Sets the calendar_year_2_return_split_only of this ETFStats.

        Two years ago calendar year return excluding dividends  # noqa: E501

        :param calendar_year_2_return_split_only: The calendar_year_2_return_split_only of this ETFStats.  # noqa: E501
        :type: float
        """

        self._calendar_year_2_return_split_only = calendar_year_2_return_split_only

    @property
    def calendar_year_1_return_split_and_dividend(self):
        """Gets the calendar_year_1_return_split_and_dividend of this ETFStats.  # noqa: E501

        One year ago calendar year return including dividends  # noqa: E501

        :return: The calendar_year_1_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._calendar_year_1_return_split_and_dividend
        
    @property
    def calendar_year_1_return_split_and_dividend_dict(self):
        """Gets the calendar_year_1_return_split_and_dividend of this ETFStats.  # noqa: E501

        One year ago calendar year return including dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The calendar_year_1_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.calendar_year_1_return_split_and_dividend
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'calendar_year_1_return_split_and_dividend': value }

        
        return result
        

    @calendar_year_1_return_split_and_dividend.setter
    def calendar_year_1_return_split_and_dividend(self, calendar_year_1_return_split_and_dividend):
        """Sets the calendar_year_1_return_split_and_dividend of this ETFStats.

        One year ago calendar year return including dividends  # noqa: E501

        :param calendar_year_1_return_split_and_dividend: The calendar_year_1_return_split_and_dividend of this ETFStats.  # noqa: E501
        :type: float
        """

        self._calendar_year_1_return_split_and_dividend = calendar_year_1_return_split_and_dividend

    @property
    def calendar_year_1_return_split_only(self):
        """Gets the calendar_year_1_return_split_only of this ETFStats.  # noqa: E501

        One year ago calendar year return excluding dividends  # noqa: E501

        :return: The calendar_year_1_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._calendar_year_1_return_split_only
        
    @property
    def calendar_year_1_return_split_only_dict(self):
        """Gets the calendar_year_1_return_split_only of this ETFStats.  # noqa: E501

        One year ago calendar year return excluding dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The calendar_year_1_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.calendar_year_1_return_split_only
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'calendar_year_1_return_split_only': value }

        
        return result
        

    @calendar_year_1_return_split_only.setter
    def calendar_year_1_return_split_only(self, calendar_year_1_return_split_only):
        """Sets the calendar_year_1_return_split_only of this ETFStats.

        One year ago calendar year return excluding dividends  # noqa: E501

        :param calendar_year_1_return_split_only: The calendar_year_1_return_split_only of this ETFStats.  # noqa: E501
        :type: float
        """

        self._calendar_year_1_return_split_only = calendar_year_1_return_split_only

    @property
    def calendar_year_to_date_return_split_and_dividend(self):
        """Gets the calendar_year_to_date_return_split_and_dividend of this ETFStats.  # noqa: E501

        Calendar year to date (YTD) return including dividends  # noqa: E501

        :return: The calendar_year_to_date_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._calendar_year_to_date_return_split_and_dividend
        
    @property
    def calendar_year_to_date_return_split_and_dividend_dict(self):
        """Gets the calendar_year_to_date_return_split_and_dividend of this ETFStats.  # noqa: E501

        Calendar year to date (YTD) return including dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The calendar_year_to_date_return_split_and_dividend of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.calendar_year_to_date_return_split_and_dividend
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'calendar_year_to_date_return_split_and_dividend': value }

        
        return result
        

    @calendar_year_to_date_return_split_and_dividend.setter
    def calendar_year_to_date_return_split_and_dividend(self, calendar_year_to_date_return_split_and_dividend):
        """Sets the calendar_year_to_date_return_split_and_dividend of this ETFStats.

        Calendar year to date (YTD) return including dividends  # noqa: E501

        :param calendar_year_to_date_return_split_and_dividend: The calendar_year_to_date_return_split_and_dividend of this ETFStats.  # noqa: E501
        :type: float
        """

        self._calendar_year_to_date_return_split_and_dividend = calendar_year_to_date_return_split_and_dividend

    @property
    def calendar_year_to_date_return_split_only(self):
        """Gets the calendar_year_to_date_return_split_only of this ETFStats.  # noqa: E501

        Calendar year to date (YTD) return excluding dividends  # noqa: E501

        :return: The calendar_year_to_date_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """
        return self._calendar_year_to_date_return_split_only
        
    @property
    def calendar_year_to_date_return_split_only_dict(self):
        """Gets the calendar_year_to_date_return_split_only of this ETFStats.  # noqa: E501

        Calendar year to date (YTD) return excluding dividends as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The calendar_year_to_date_return_split_only of this ETFStats.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.calendar_year_to_date_return_split_only
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'calendar_year_to_date_return_split_only': value }

        
        return result
        

    @calendar_year_to_date_return_split_only.setter
    def calendar_year_to_date_return_split_only(self, calendar_year_to_date_return_split_only):
        """Sets the calendar_year_to_date_return_split_only of this ETFStats.

        Calendar year to date (YTD) return excluding dividends  # noqa: E501

        :param calendar_year_to_date_return_split_only: The calendar_year_to_date_return_split_only of this ETFStats.  # noqa: E501
        :type: float
        """

        self._calendar_year_to_date_return_split_only = calendar_year_to_date_return_split_only

    @property
    def etf(self):
        """Gets the etf of this ETFStats.  # noqa: E501


        :return: The etf of this ETFStats.  # noqa: E501
        :rtype: ETFSummary
        """
        return self._etf
        
    @property
    def etf_dict(self):
        """Gets the etf of this ETFStats.  # noqa: E501


        :return: The etf of this ETFStats.  # noqa: E501
        :rtype: ETFSummary
        """

        result = None

        value = self.etf
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'etf': value }

        
        return result
        

    @etf.setter
    def etf(self, etf):
        """Sets the etf of this ETFStats.


        :param etf: The etf of this ETFStats.  # noqa: E501
        :type: ETFSummary
        """

        self._etf = etf

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ETFStats):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
