# coding: utf-8

"""
    Intrinio API

    Welcome to the Intrinio API! Through our Financial Data Marketplace, we offer a wide selection of financial data feed APIs sourced by our own proprietary processes as well as from many data vendors. For a complete API request / response reference please view the [Intrinio API documentation](https://docs.intrinio.com/documentation/api_v2). If you need additional help in using the API, please visit the [Intrinio website](https://intrinio.com) and click on the chat icon in the lower right corner.  # noqa: E501

    OpenAPI spec version: 2.26.12
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from intrinio_sdk.api_client import ApiClient


class SecurityApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_all_securities(self, **kwargs):  # noqa: E501
        """All Securities  # noqa: E501

        Returns all Securities to which you have access. When parameters are specified, returns matching Securities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_all_securities(_async=True)
        >>> result = thread.get()

        :param async bool
        :param bool active: When true, return securities that are active. When false, return securities that are not active. A security is considered active if it has traded or has had a corporate action in the past 30 days, and has not been merged into another security (such as due to ticker changes or corporate restructurings).
        :param bool delisted: When true, return securities that have been delisted from their exchange. Note that there may be a newer security for the same company that has been relisted on a differente exchange. When false, return securities that have not been delisted.
        :param str code: Return securities classified with the given code (<a href=\"https://docs.intrinio.com/documentation/security_codes\" target=\"_blank\">reference</a>).
        :param str currency: Return securities traded in the given 3-digit ISO 4217 currency code (<a href=\"https://en.wikipedia.org/wiki/ISO_4217\" target=\"_blank\">reference</a>).
        :param str ticker: Return securities traded with the given ticker. Note that securities across the world (and through time) may trade with the same ticker but represent different companies. Use this in conjuction with other parameters for more specificity.
        :param str name: Return securities with the given text in their name (not case sensitive).
        :param str composite_mic: Return securities classified under the composite exchange with the given Market Identification Code (MIC). A composite exchange may or may not be a real exchange.  For example, the USCOMP exchange (our only composite exchange to date) is a combination of exchanges with the following MICs: ARCX, XASE, XPOR, FINR, XCIS, XNAS, XNYS, BATS.  This composite grouping is done for user convenience.  At this time, all US securities are classified under the composite exchange with MIC USCOMP.  To query for specific US exchanges, use the exchange_mic parameter below. 
        :param str exchange_mic: The MIC code of the exchange where the security is actually traded.
        :param date stock_prices_after: Return securities with end-of-day stock prices on or after this date.
        :param date stock_prices_before: Return securities with end-of-day stock prices on or before this date.
        :param str cik: Return securities belonging to the company with the given Central Index Key (CIK).
        :param str figi: Return securities with the given Exchange Level FIGI (<a href=\"https://www.openfigi.com/about\" target=\"_blank\">reference</a>).
        :param str composite_figi: Return securities with the given Country Composite FIGI (<a href=\"https://www.openfigi.com/about\" target=\"_blank\">reference</a>).
        :param str share_class_figi: Return securities with the given Global Share Class FIGI (<a href=\"https://www.openfigi.com/about\" target=\"_blank\">reference</a>).
        :param str figi_unique_id: Return securities with the given FIGI Unique ID (<a href=\"https://www.openfigi.com/about\" target=\"_blank\">reference</a>).
        :param bool include_non_figi: When true, include securities that do not have a FIGI. By default, this is false. If this parameter is not specified, only securities with a FIGI are returned.
        :param int page_size: The number of results to return
        :param bool primary_listing: If true, the Security is the primary issue for the company, otherwise it is a secondary issue on a secondary stock exchange.  Returns both if omitted.
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurities
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_all_securities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_securities_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_securities_with_http_info(self, **kwargs):  # noqa: E501
        """All Securities  # noqa: E501

        Returns all Securities to which you have access. When parameters are specified, returns matching Securities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_all_securities_with_http_info(_async=True)
        >>> result = thread.get()

        :param async bool
        :param bool active: When true, return securities that are active. When false, return securities that are not active. A security is considered active if it has traded or has had a corporate action in the past 30 days, and has not been merged into another security (such as due to ticker changes or corporate restructurings).
        :param bool delisted: When true, return securities that have been delisted from their exchange. Note that there may be a newer security for the same company that has been relisted on a differente exchange. When false, return securities that have not been delisted.
        :param str code: Return securities classified with the given code (<a href=\"https://docs.intrinio.com/documentation/security_codes\" target=\"_blank\">reference</a>).
        :param str currency: Return securities traded in the given 3-digit ISO 4217 currency code (<a href=\"https://en.wikipedia.org/wiki/ISO_4217\" target=\"_blank\">reference</a>).
        :param str ticker: Return securities traded with the given ticker. Note that securities across the world (and through time) may trade with the same ticker but represent different companies. Use this in conjuction with other parameters for more specificity.
        :param str name: Return securities with the given text in their name (not case sensitive).
        :param str composite_mic: Return securities classified under the composite exchange with the given Market Identification Code (MIC). A composite exchange may or may not be a real exchange.  For example, the USCOMP exchange (our only composite exchange to date) is a combination of exchanges with the following MICs: ARCX, XASE, XPOR, FINR, XCIS, XNAS, XNYS, BATS.  This composite grouping is done for user convenience.  At this time, all US securities are classified under the composite exchange with MIC USCOMP.  To query for specific US exchanges, use the exchange_mic parameter below. 
        :param str exchange_mic: The MIC code of the exchange where the security is actually traded.
        :param date stock_prices_after: Return securities with end-of-day stock prices on or after this date.
        :param date stock_prices_before: Return securities with end-of-day stock prices on or before this date.
        :param str cik: Return securities belonging to the company with the given Central Index Key (CIK).
        :param str figi: Return securities with the given Exchange Level FIGI (<a href=\"https://www.openfigi.com/about\" target=\"_blank\">reference</a>).
        :param str composite_figi: Return securities with the given Country Composite FIGI (<a href=\"https://www.openfigi.com/about\" target=\"_blank\">reference</a>).
        :param str share_class_figi: Return securities with the given Global Share Class FIGI (<a href=\"https://www.openfigi.com/about\" target=\"_blank\">reference</a>).
        :param str figi_unique_id: Return securities with the given FIGI Unique ID (<a href=\"https://www.openfigi.com/about\" target=\"_blank\">reference</a>).
        :param bool include_non_figi: When true, include securities that do not have a FIGI. By default, this is false. If this parameter is not specified, only securities with a FIGI are returned.
        :param int page_size: The number of results to return
        :param bool primary_listing: If true, the Security is the primary issue for the company, otherwise it is a secondary issue on a secondary stock exchange.  Returns both if omitted.
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurities
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['active', 'delisted', 'code', 'currency', 'ticker', 'name', 'composite_mic', 'exchange_mic', 'stock_prices_after', 'stock_prices_before', 'cik', 'figi', 'composite_figi', 'share_class_figi', 'figi_unique_id', 'include_non_figi', 'page_size', 'primary_listing', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_securities" % key
                )
            params[key] = val
        del params['kwargs']

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_all_securities`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'active' in params:
            query_params.append(('active', params['active']))  # noqa: E501
        if 'delisted' in params:
            query_params.append(('delisted', params['delisted']))  # noqa: E501
        if 'code' in params:
            query_params.append(('code', params['code']))  # noqa: E501
        if 'currency' in params:
            query_params.append(('currency', params['currency']))  # noqa: E501
        if 'ticker' in params:
            query_params.append(('ticker', params['ticker']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'composite_mic' in params:
            query_params.append(('composite_mic', params['composite_mic']))  # noqa: E501
        if 'exchange_mic' in params:
            query_params.append(('exchange_mic', params['exchange_mic']))  # noqa: E501
        if 'stock_prices_after' in params:
            query_params.append(('stock_prices_after', params['stock_prices_after']))  # noqa: E501
        if 'stock_prices_before' in params:
            query_params.append(('stock_prices_before', params['stock_prices_before']))  # noqa: E501
        if 'cik' in params:
            query_params.append(('cik', params['cik']))  # noqa: E501
        if 'figi' in params:
            query_params.append(('figi', params['figi']))  # noqa: E501
        if 'composite_figi' in params:
            query_params.append(('composite_figi', params['composite_figi']))  # noqa: E501
        if 'share_class_figi' in params:
            query_params.append(('share_class_figi', params['share_class_figi']))  # noqa: E501
        if 'figi_unique_id' in params:
            query_params.append(('figi_unique_id', params['figi_unique_id']))  # noqa: E501
        if 'include_non_figi' in params:
            query_params.append(('include_non_figi', params['include_non_figi']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'primary_listing' in params:
            query_params.append(('primary_listing', params['primary_listing']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurities',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_by_id(self, identifier, **kwargs):  # noqa: E501
        """Lookup Security  # noqa: E501

        Returns the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_by_id(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :return: Security
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_by_id_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_by_id_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_by_id_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Lookup Security  # noqa: E501

        Returns the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_by_id_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :return: Security
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Security',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_data_point_number(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Number) for Security  # noqa: E501

        Returns a numeric value for the given `tag` for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_data_point_number(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code (<a href='https://data.intrinio.com/data-tags'>reference</a>) (required)
        :return: float
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_data_point_number_with_http_info(identifier, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_data_point_number_with_http_info(identifier, tag, **kwargs)  # noqa: E501
            return data

    def get_security_data_point_number_with_http_info(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Number) for Security  # noqa: E501

        Returns a numeric value for the given `tag` for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_data_point_number_with_http_info(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code (<a href='https://data.intrinio.com/data-tags'>reference</a>) (required)
        :return: float
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tag']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_data_point_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_data_point_number`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `get_security_data_point_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/data_point/{tag}/number', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='float',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_data_point_text(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Text) for Security  # noqa: E501

        Returns a text value for the given `tag` for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_data_point_text(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code-name (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_data_point_text_with_http_info(identifier, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_data_point_text_with_http_info(identifier, tag, **kwargs)  # noqa: E501
            return data

    def get_security_data_point_text_with_http_info(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Text) for Security  # noqa: E501

        Returns a text value for the given `tag` for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_data_point_text_with_http_info(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code-name (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tag']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_data_point_text" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_data_point_text`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `get_security_data_point_text`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/data_point/{tag}/text', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_historical_data(self, identifier, tag, **kwargs):  # noqa: E501
        """Historical Data for Security  # noqa: E501

        Returns historical values for the given `tag` and the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_historical_data(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code (<a href='https://data.intrinio.com/data-tags'>reference</a>) (required)
        :param str frequency: Return historical data in the given frequency
        :param str type: Filter by type, when applicable
        :param date start_date: Get historical data on or after this date
        :param date end_date: Get historical date on or before this date
        :param str sort_order: Sort by date `asc` or `desc`
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityHistoricalData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_historical_data_with_http_info(identifier, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_historical_data_with_http_info(identifier, tag, **kwargs)  # noqa: E501
            return data

    def get_security_historical_data_with_http_info(self, identifier, tag, **kwargs):  # noqa: E501
        """Historical Data for Security  # noqa: E501

        Returns historical values for the given `tag` and the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_historical_data_with_http_info(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code (<a href='https://data.intrinio.com/data-tags'>reference</a>) (required)
        :param str frequency: Return historical data in the given frequency
        :param str type: Filter by type, when applicable
        :param date start_date: Get historical data on or after this date
        :param date end_date: Get historical date on or before this date
        :param str sort_order: Sort by date `asc` or `desc`
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityHistoricalData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tag', 'frequency', 'type', 'start_date', 'end_date', 'sort_order', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_historical_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_historical_data`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `get_security_historical_data`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_historical_data`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []
        if 'frequency' in params:
            query_params.append(('frequency', params['frequency']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sort_order', params['sort_order']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/historical_data/{tag}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityHistoricalData',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_insider_ownership(self, identifier, **kwargs):  # noqa: E501
        """Institutional Ownership by Security  # noqa: E501

        Returns a list of all institutional owners of a given security.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_insider_ownership(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :return: ApiResponseSecurityInstitutionalOwnership
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_insider_ownership_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_insider_ownership_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_insider_ownership_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Institutional Ownership by Security  # noqa: E501

        Returns a list of all institutional owners of a given security.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_insider_ownership_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :return: ApiResponseSecurityInstitutionalOwnership
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_insider_ownership" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_insider_ownership`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/institutional_ownership', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityInstitutionalOwnership',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_interval_prices(self, identifier, **kwargs):  # noqa: E501
        """Interval Stock Prices for Security  # noqa: E501

        Return Open, High, Low, Close, and Volume for a particular interval for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_interval_prices(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str source: Return intervals from the specified data source
        :param date start_date: Return intervals starting at the specified date
        :param str start_time: Return intervals starting at the specified time on the `start_date` (24-hour in 'hh:mm' format, UTC timezone)
        :param date end_date: Return intervals stopping at the specified date
        :param str end_time: Return intervals stopping at the specified time on the `end_date` (24-hour in 'hh:mm' format, UTC timezone)
        :param str timezone: Returns trading times in this timezone
        :param str interval_size: The interval for which to return stock prices
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityIntervalPrices
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_interval_prices_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_interval_prices_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_interval_prices_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Interval Stock Prices for Security  # noqa: E501

        Return Open, High, Low, Close, and Volume for a particular interval for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_interval_prices_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str source: Return intervals from the specified data source
        :param date start_date: Return intervals starting at the specified date
        :param str start_time: Return intervals starting at the specified time on the `start_date` (24-hour in 'hh:mm' format, UTC timezone)
        :param date end_date: Return intervals stopping at the specified date
        :param str end_time: Return intervals stopping at the specified time on the `end_date` (24-hour in 'hh:mm' format, UTC timezone)
        :param str timezone: Returns trading times in this timezone
        :param str interval_size: The interval for which to return stock prices
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityIntervalPrices
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'source', 'start_date', 'start_time', 'end_date', 'end_time', 'timezone', 'interval_size', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_interval_prices" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_interval_prices`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'source' in params:
            query_params.append(('source', params['source']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'start_time' in params:
            query_params.append(('start_time', params['start_time']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'end_time' in params:
            query_params.append(('end_time', params['end_time']))  # noqa: E501
        if 'timezone' in params:
            query_params.append(('timezone', params['timezone']))  # noqa: E501
        if 'interval_size' in params:
            query_params.append(('interval_size', params['interval_size']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/intervals', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityIntervalPrices',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_intraday_prices(self, identifier, **kwargs):  # noqa: E501
        """Intraday Stock Prices for Security  # noqa: E501

        Return intraday stock prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_intraday_prices(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str source: Return intraday prices from the specified data source
        :param date start_date: Return intraday prices starting at the specified date
        :param str start_time: Return intraday prices starting at the specified time on the `start_date` (24-hour in 'hh:mm' format, UTC timezone)
        :param date end_date: Return intraday prices stopping at the specified date
        :param str end_time: Return intraday prices stopping at the specified time on the `end_date` (24-hour in 'hh:mm' format, UTC timezone)
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityIntradayPrices
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_intraday_prices_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_intraday_prices_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_intraday_prices_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Intraday Stock Prices for Security  # noqa: E501

        Return intraday stock prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_intraday_prices_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str source: Return intraday prices from the specified data source
        :param date start_date: Return intraday prices starting at the specified date
        :param str start_time: Return intraday prices starting at the specified time on the `start_date` (24-hour in 'hh:mm' format, UTC timezone)
        :param date end_date: Return intraday prices stopping at the specified date
        :param str end_time: Return intraday prices stopping at the specified time on the `end_date` (24-hour in 'hh:mm' format, UTC timezone)
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityIntradayPrices
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'source', 'start_date', 'start_time', 'end_date', 'end_time', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_intraday_prices" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_intraday_prices`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_intraday_prices`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'source' in params:
            query_params.append(('source', params['source']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'start_time' in params:
            query_params.append(('start_time', params['start_time']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'end_time' in params:
            query_params.append(('end_time', params['end_time']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/intraday', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityIntradayPrices',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_latest_dividend_record(self, identifier, **kwargs):  # noqa: E501
        """Latest Dividend Record for Security  # noqa: E501

        Returns the latest available dividend information for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_latest_dividend_record(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :return: DividendRecord
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_latest_dividend_record_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_latest_dividend_record_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_latest_dividend_record_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Latest Dividend Record for Security  # noqa: E501

        Returns the latest available dividend information for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_latest_dividend_record_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :return: DividendRecord
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_latest_dividend_record" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_latest_dividend_record`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/dividends/latest', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DividendRecord',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_latest_earnings_record(self, identifier, **kwargs):  # noqa: E501
        """Latest Earnings Record for Security  # noqa: E501

        Returns latest available earnings information for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_latest_earnings_record(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :return: EarningsRecord
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_latest_earnings_record_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_latest_earnings_record_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_latest_earnings_record_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Latest Earnings Record for Security  # noqa: E501

        Returns latest available earnings information for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_latest_earnings_record_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :return: EarningsRecord
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_latest_earnings_record" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_latest_earnings_record`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/earnings/latest', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EarningsRecord',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_adi(self, identifier, **kwargs):  # noqa: E501
        """Accumulation/Distribution Index  # noqa: E501

        Returns the Accumulation/Distribution Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_adi(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAccumulationDistributionIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_adi_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_adi_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_adi_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Accumulation/Distribution Index  # noqa: E501

        Returns the Accumulation/Distribution Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_adi_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAccumulationDistributionIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_adi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_adi`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_adi`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/adi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityAccumulationDistributionIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_adtv(self, identifier, **kwargs):  # noqa: E501
        """Average Daily Trading Volume  # noqa: E501

        Returns the Average Daily Trading Volume values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_adtv(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Average Daily Trading Volume
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAverageDailyTradingVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_adtv_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_adtv_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_adtv_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Average Daily Trading Volume  # noqa: E501

        Returns the Average Daily Trading Volume values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_adtv_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Average Daily Trading Volume
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAverageDailyTradingVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_adtv" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_adtv`")  # noqa: E501

        if 'period' in params and params['period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_adtv`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_adtv`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/adtv', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityAverageDailyTradingVolume',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_adx(self, identifier, **kwargs):  # noqa: E501
        """Average Directional Index  # noqa: E501

        Returns the Average Directional Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_adx(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Average Directional Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAverageDirectionalIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_adx_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_adx_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_adx_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Average Directional Index  # noqa: E501

        Returns the Average Directional Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_adx_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Average Directional Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAverageDirectionalIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_adx" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_adx`")  # noqa: E501

        if 'period' in params and params['period'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_adx`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_adx`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/adx', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityAverageDirectionalIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_ao(self, identifier, **kwargs):  # noqa: E501
        """Awesome Oscillator  # noqa: E501

        Returns the Awesome Oscillator values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_ao(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int short_period: The number of observations, per period, to calculate short period Simple Moving Average of the Awesome Oscillator
        :param int long_period: The number of observations, per period, to calculate long period Simple Moving Average of the Awesome Oscillator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAwesomeOscillator
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_ao_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_ao_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_ao_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Awesome Oscillator  # noqa: E501

        Returns the Awesome Oscillator values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_ao_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int short_period: The number of observations, per period, to calculate short period Simple Moving Average of the Awesome Oscillator
        :param int long_period: The number of observations, per period, to calculate long period Simple Moving Average of the Awesome Oscillator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAwesomeOscillator
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'short_period', 'long_period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_ao" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_ao`")  # noqa: E501

        if 'long_period' in params and params['long_period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `long_period` when calling `get_security_price_technicals_ao`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_ao`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'short_period' in params:
            query_params.append(('short_period', params['short_period']))  # noqa: E501
        if 'long_period' in params:
            query_params.append(('long_period', params['long_period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/ao', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityAwesomeOscillator',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_atr(self, identifier, **kwargs):  # noqa: E501
        """Average True Range  # noqa: E501

        Returns the Average True Range values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_atr(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Average True Range
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAverageTrueRange
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_atr_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_atr_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_atr_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Average True Range  # noqa: E501

        Returns the Average True Range values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_atr_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Average True Range
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityAverageTrueRange
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_atr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_atr`")  # noqa: E501

        if 'period' in params and params['period'] < 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_atr`, must be a value greater than or equal to `4`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_atr`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/atr', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityAverageTrueRange',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_bb(self, identifier, **kwargs):  # noqa: E501
        """Bollinger Bands  # noqa: E501

        Returns the Bollinger Bands values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_bb(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Bollinger Bands
        :param float standard_deviations: The number of standard deviations to calculate the upper and lower bands of the Bollinger Bands
        :param str price_key: The Stock Price field to use when calculating Bollinger Bands
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityBollingerBands
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_bb_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_bb_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_bb_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Bollinger Bands  # noqa: E501

        Returns the Bollinger Bands values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_bb_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Bollinger Bands
        :param float standard_deviations: The number of standard deviations to calculate the upper and lower bands of the Bollinger Bands
        :param str price_key: The Stock Price field to use when calculating Bollinger Bands
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityBollingerBands
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'standard_deviations', 'price_key', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_bb" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_bb`")  # noqa: E501

        if 'period' in params and params['period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_bb`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_bb`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'standard_deviations' in params:
            query_params.append(('standard_deviations', params['standard_deviations']))  # noqa: E501
        if 'price_key' in params:
            query_params.append(('price_key', params['price_key']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/bb', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityBollingerBands',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_cci(self, identifier, **kwargs):  # noqa: E501
        """Commodity Channel Index  # noqa: E501

        Returns the Commodity Channel Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_cci(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Commodity Channel Index
        :param float constant: The number of observations, per period, to calculate Commodity Channel Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityCommodityChannelIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_cci_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_cci_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_cci_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Commodity Channel Index  # noqa: E501

        Returns the Commodity Channel Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_cci_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Commodity Channel Index
        :param float constant: The number of observations, per period, to calculate Commodity Channel Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityCommodityChannelIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'constant', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_cci" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_cci`")  # noqa: E501

        if 'period' in params and params['period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_cci`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_cci`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'constant' in params:
            query_params.append(('constant', params['constant']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/cci', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityCommodityChannelIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_cmf(self, identifier, **kwargs):  # noqa: E501
        """Chaikin Money Flow  # noqa: E501

        Returns the Chaikin Money Flow values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_cmf(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Chaikin Money Flow
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityChaikinMoneyFlow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_cmf_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_cmf_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_cmf_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Chaikin Money Flow  # noqa: E501

        Returns the Chaikin Money Flow values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_cmf_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Chaikin Money Flow
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityChaikinMoneyFlow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_cmf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_cmf`")  # noqa: E501

        if 'period' in params and params['period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_cmf`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_cmf`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/cmf', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityChaikinMoneyFlow',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_dc(self, identifier, **kwargs):  # noqa: E501
        """Donchian Channel  # noqa: E501

        Returns the Donchian Channel values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_dc(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Donchian Channel
        :param str price_key: The Stock Price field to use when calculating Donchian Channel
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityDonchianChannel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_dc_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_dc_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_dc_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Donchian Channel  # noqa: E501

        Returns the Donchian Channel values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_dc_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Donchian Channel
        :param str price_key: The Stock Price field to use when calculating Donchian Channel
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityDonchianChannel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'price_key', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_dc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_dc`")  # noqa: E501

        if 'period' in params and params['period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_dc`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_dc`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'price_key' in params:
            query_params.append(('price_key', params['price_key']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/dc', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityDonchianChannel',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_dpo(self, identifier, **kwargs):  # noqa: E501
        """Detrended Price Oscillator  # noqa: E501

        Returns the Detrended Price Oscillator values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_dpo(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Detrended Price Oscillator
        :param str price_key: The Stock Price field to use when calculating Detrended Price Oscillator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityDetrendedPriceOscillator
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_dpo_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_dpo_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_dpo_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Detrended Price Oscillator  # noqa: E501

        Returns the Detrended Price Oscillator values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_dpo_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Detrended Price Oscillator
        :param str price_key: The Stock Price field to use when calculating Detrended Price Oscillator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityDetrendedPriceOscillator
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'price_key', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_dpo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_dpo`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_dpo`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'price_key' in params:
            query_params.append(('price_key', params['price_key']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/dpo', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityDetrendedPriceOscillator',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_eom(self, identifier, **kwargs):  # noqa: E501
        """Ease of Movement  # noqa: E501

        Returns the Ease of Movement values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_eom(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Ease of Movement
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityEaseOfMovement
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_eom_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_eom_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_eom_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Ease of Movement  # noqa: E501

        Returns the Ease of Movement values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_eom_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Ease of Movement
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityEaseOfMovement
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_eom" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_eom`")  # noqa: E501

        if 'period' in params and params['period'] < 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_eom`, must be a value greater than or equal to `4`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_eom`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/eom', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityEaseOfMovement',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_fi(self, identifier, **kwargs):  # noqa: E501
        """Force Index  # noqa: E501

        Returns the Force Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_fi(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityForceIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_fi_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_fi_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_fi_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Force Index  # noqa: E501

        Returns the Force Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_fi_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityForceIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_fi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_fi`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_fi`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/fi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityForceIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_ichimoku(self, identifier, **kwargs):  # noqa: E501
        """Ichimoku Kinko Hyo  # noqa: E501

        Returns the Ichimoku Kinko Hyo values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_ichimoku(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int low_period: The number of observations, per period, to calculate Tenkan Sen (Conversion Line) of Ichimoku Kinko Hyo
        :param int medium_period: The number of observations, per period, to calculate Kijun Sen (Base Line), Senkou Span A (Leading Span A), and Chikou Span (Lagging Span) of Ichimoku Kinko Hyo
        :param int high_period: The number of observations, per period, to calculate Senkou Span B (Leading Span B) of Ichimoku Kinko Hyo
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityIchimokuKinkoHyo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_ichimoku_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_ichimoku_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_ichimoku_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Ichimoku Kinko Hyo  # noqa: E501

        Returns the Ichimoku Kinko Hyo values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_ichimoku_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int low_period: The number of observations, per period, to calculate Tenkan Sen (Conversion Line) of Ichimoku Kinko Hyo
        :param int medium_period: The number of observations, per period, to calculate Kijun Sen (Base Line), Senkou Span A (Leading Span A), and Chikou Span (Lagging Span) of Ichimoku Kinko Hyo
        :param int high_period: The number of observations, per period, to calculate Senkou Span B (Leading Span B) of Ichimoku Kinko Hyo
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityIchimokuKinkoHyo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'low_period', 'medium_period', 'high_period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_ichimoku" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_ichimoku`")  # noqa: E501

        if 'medium_period' in params and params['medium_period'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `medium_period` when calling `get_security_price_technicals_ichimoku`, must be a value greater than or equal to `2`")  # noqa: E501
        if 'high_period' in params and params['high_period'] < 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `high_period` when calling `get_security_price_technicals_ichimoku`, must be a value greater than or equal to `4`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_ichimoku`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'low_period' in params:
            query_params.append(('low_period', params['low_period']))  # noqa: E501
        if 'medium_period' in params:
            query_params.append(('medium_period', params['medium_period']))  # noqa: E501
        if 'high_period' in params:
            query_params.append(('high_period', params['high_period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/ichimoku', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityIchimokuKinkoHyo',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_kc(self, identifier, **kwargs):  # noqa: E501
        """Keltner Channel  # noqa: E501

        Returns the Keltner Channel values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_kc(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Kelter Channel
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityKeltnerChannel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_kc_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_kc_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_kc_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Keltner Channel  # noqa: E501

        Returns the Keltner Channel values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_kc_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Kelter Channel
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityKeltnerChannel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_kc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_kc`")  # noqa: E501

        if 'period' in params and params['period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_kc`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_kc`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/kc', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityKeltnerChannel',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_kst(self, identifier, **kwargs):  # noqa: E501
        """Know Sure Thing  # noqa: E501

        Returns the Know Sure Thing values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_kst(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int roc1: The number of observations, per period, to calculate the rate-of-change for RCMA1
        :param int roc2: The number of observations, per period, to calculate the rate-of-change for RCMA2
        :param int roc3: The number of observations, per period, to calculate the rate-of-change for RCMA3
        :param int roc4: The number of observations, per period, to calculate the rate-of-change for RCMA4
        :param int sma1: The number of observations, per period, to calculate the Simple Moving Average of the rate-of-change for RCMA1
        :param int sma2: The number of observations, per period, to calculate the Simple Moving Average of the rate-of-change for RCMA2
        :param int sma3: The number of observations, per period, to calculate the Simple Moving Average of the rate-of-change for RCMA3
        :param int sma4: The number of observations, per period, to calculate the Simple Moving Average of the rate-of-change for RCMA4
        :param str price_key: The Stock Price field to use when calculating Know Sure Thing
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityKnowSureThing
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_kst_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_kst_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_kst_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Know Sure Thing  # noqa: E501

        Returns the Know Sure Thing values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_kst_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int roc1: The number of observations, per period, to calculate the rate-of-change for RCMA1
        :param int roc2: The number of observations, per period, to calculate the rate-of-change for RCMA2
        :param int roc3: The number of observations, per period, to calculate the rate-of-change for RCMA3
        :param int roc4: The number of observations, per period, to calculate the rate-of-change for RCMA4
        :param int sma1: The number of observations, per period, to calculate the Simple Moving Average of the rate-of-change for RCMA1
        :param int sma2: The number of observations, per period, to calculate the Simple Moving Average of the rate-of-change for RCMA2
        :param int sma3: The number of observations, per period, to calculate the Simple Moving Average of the rate-of-change for RCMA3
        :param int sma4: The number of observations, per period, to calculate the Simple Moving Average of the rate-of-change for RCMA4
        :param str price_key: The Stock Price field to use when calculating Know Sure Thing
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityKnowSureThing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'roc1', 'roc2', 'roc3', 'roc4', 'sma1', 'sma2', 'sma3', 'sma4', 'price_key', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_kst" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_kst`")  # noqa: E501

        if 'roc4' in params and params['roc4'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `roc4` when calling `get_security_price_technicals_kst`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'sma4' in params and params['sma4'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `sma4` when calling `get_security_price_technicals_kst`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_kst`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'roc1' in params:
            query_params.append(('roc1', params['roc1']))  # noqa: E501
        if 'roc2' in params:
            query_params.append(('roc2', params['roc2']))  # noqa: E501
        if 'roc3' in params:
            query_params.append(('roc3', params['roc3']))  # noqa: E501
        if 'roc4' in params:
            query_params.append(('roc4', params['roc4']))  # noqa: E501
        if 'sma1' in params:
            query_params.append(('sma1', params['sma1']))  # noqa: E501
        if 'sma2' in params:
            query_params.append(('sma2', params['sma2']))  # noqa: E501
        if 'sma3' in params:
            query_params.append(('sma3', params['sma3']))  # noqa: E501
        if 'sma4' in params:
            query_params.append(('sma4', params['sma4']))  # noqa: E501
        if 'price_key' in params:
            query_params.append(('price_key', params['price_key']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/kst', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityKnowSureThing',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_macd(self, identifier, **kwargs):  # noqa: E501
        """Moving Average Convergence Divergence  # noqa: E501

        Returns the Moving Average Convergence Divergence values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_macd(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int fast_period: The number of observations, per period, to calculate the fast moving Exponential Moving Average for Moving Average Convergence Divergence
        :param int slow_period: The number of observations, per period, to calculate the slow moving Exponential Moving Average for Moving Average Convergence Divergence
        :param int signal_period: The number of observations, per period, to calculate the signal line for Moving Average Convergence Divergence
        :param str price_key: The Stock Price field to use when calculating Moving Average Convergence Divergence
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityMovingAverageConvergenceDivergence
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_macd_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_macd_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_macd_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Moving Average Convergence Divergence  # noqa: E501

        Returns the Moving Average Convergence Divergence values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_macd_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int fast_period: The number of observations, per period, to calculate the fast moving Exponential Moving Average for Moving Average Convergence Divergence
        :param int slow_period: The number of observations, per period, to calculate the slow moving Exponential Moving Average for Moving Average Convergence Divergence
        :param int signal_period: The number of observations, per period, to calculate the signal line for Moving Average Convergence Divergence
        :param str price_key: The Stock Price field to use when calculating Moving Average Convergence Divergence
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityMovingAverageConvergenceDivergence
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'fast_period', 'slow_period', 'signal_period', 'price_key', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_macd" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_macd`")  # noqa: E501

        if 'slow_period' in params and params['slow_period'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `slow_period` when calling `get_security_price_technicals_macd`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'signal_period' in params and params['signal_period'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `signal_period` when calling `get_security_price_technicals_macd`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_macd`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'fast_period' in params:
            query_params.append(('fast_period', params['fast_period']))  # noqa: E501
        if 'slow_period' in params:
            query_params.append(('slow_period', params['slow_period']))  # noqa: E501
        if 'signal_period' in params:
            query_params.append(('signal_period', params['signal_period']))  # noqa: E501
        if 'price_key' in params:
            query_params.append(('price_key', params['price_key']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/macd', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityMovingAverageConvergenceDivergence',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_mfi(self, identifier, **kwargs):  # noqa: E501
        """Money Flow Index  # noqa: E501

        Returns the Money Flow Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_mfi(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Money Flow Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityMoneyFlowIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_mfi_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_mfi_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_mfi_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Money Flow Index  # noqa: E501

        Returns the Money Flow Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_mfi_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Money Flow Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityMoneyFlowIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_mfi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_mfi`")  # noqa: E501

        if 'period' in params and params['period'] < 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_mfi`, must be a value greater than or equal to `4`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_mfi`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/mfi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityMoneyFlowIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_mi(self, identifier, **kwargs):  # noqa: E501
        """Mass Index  # noqa: E501

        Returns the Mass Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_mi(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int ema_period: The number of observations, per period, to calculate the single Exponential Moving Average and the Double Exponential Moving Average for Mass Index
        :param int sum_period: The number of observations, per period, to calculate the sum of the Exponetinal Moving Average Ratios for Mass Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityMassIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_mi_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_mi_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_mi_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Mass Index  # noqa: E501

        Returns the Mass Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_mi_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int ema_period: The number of observations, per period, to calculate the single Exponential Moving Average and the Double Exponential Moving Average for Mass Index
        :param int sum_period: The number of observations, per period, to calculate the sum of the Exponetinal Moving Average Ratios for Mass Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityMassIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'ema_period', 'sum_period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_mi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_mi`")  # noqa: E501

        if 'ema_period' in params and params['ema_period'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `ema_period` when calling `get_security_price_technicals_mi`, must be a value greater than or equal to `2`")  # noqa: E501
        if 'sum_period' in params and params['sum_period'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `sum_period` when calling `get_security_price_technicals_mi`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_mi`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'ema_period' in params:
            query_params.append(('ema_period', params['ema_period']))  # noqa: E501
        if 'sum_period' in params:
            query_params.append(('sum_period', params['sum_period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/mi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityMassIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_nvi(self, identifier, **kwargs):  # noqa: E501
        """Negative Volume Index  # noqa: E501

        Returns the Negative Volume Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_nvi(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityNegativeVolumeIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_nvi_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_nvi_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_nvi_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Negative Volume Index  # noqa: E501

        Returns the Negative Volume Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_nvi_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityNegativeVolumeIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_nvi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_nvi`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_nvi`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/nvi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityNegativeVolumeIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_obv(self, identifier, **kwargs):  # noqa: E501
        """On-balance Volume  # noqa: E501

        Returns the On-balance Volume values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_obv(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityOnBalanceVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_obv_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_obv_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_obv_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """On-balance Volume  # noqa: E501

        Returns the On-balance Volume values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_obv_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityOnBalanceVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_obv" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_obv`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_obv`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/obv', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityOnBalanceVolume',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_obv_mean(self, identifier, **kwargs):  # noqa: E501
        """On-balance Volume Mean  # noqa: E501

        Returns the On-balance Volume Mean values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_obv_mean(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate On-balance Volume Mean
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityOnBalanceVolumeMean
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_obv_mean_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_obv_mean_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_obv_mean_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """On-balance Volume Mean  # noqa: E501

        Returns the On-balance Volume Mean values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_obv_mean_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate On-balance Volume Mean
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityOnBalanceVolumeMean
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_obv_mean" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_obv_mean`")  # noqa: E501

        if 'period' in params and params['period'] < 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_obv_mean`, must be a value greater than or equal to `4`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_obv_mean`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/obv_mean', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityOnBalanceVolumeMean',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_rsi(self, identifier, **kwargs):  # noqa: E501
        """Relative Strength Index  # noqa: E501

        Returns the Relative Strength Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_rsi(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Relative Strength Index
        :param str price_key: The Stock Price field to use when calculating Relative Strength Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityRelativeStrengthIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_rsi_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_rsi_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_rsi_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Relative Strength Index  # noqa: E501

        Returns the Relative Strength Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_rsi_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Relative Strength Index
        :param str price_key: The Stock Price field to use when calculating Relative Strength Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityRelativeStrengthIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'price_key', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_rsi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_rsi`")  # noqa: E501

        if 'period' in params and params['period'] < 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_rsi`, must be a value greater than or equal to `4`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_rsi`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'price_key' in params:
            query_params.append(('price_key', params['price_key']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/rsi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityRelativeStrengthIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_sma(self, identifier, **kwargs):  # noqa: E501
        """Simple Moving Average  # noqa: E501

        Returns the Simple Moving Average values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_sma(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Simple Moving Average
        :param str price_key: The Stock Price field to use when calculating Simple Moving Average
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecuritySimpleMovingAverage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_sma_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_sma_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_sma_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Simple Moving Average  # noqa: E501

        Returns the Simple Moving Average values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_sma_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Simple Moving Average
        :param str price_key: The Stock Price field to use when calculating Simple Moving Average
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecuritySimpleMovingAverage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'price_key', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_sma" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_sma`")  # noqa: E501

        if 'period' in params and params['period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_sma`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_sma`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'price_key' in params:
            query_params.append(('price_key', params['price_key']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/sma', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecuritySimpleMovingAverage',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_sr(self, identifier, **kwargs):  # noqa: E501
        """Stochastic Oscillator  # noqa: E501

        Returns the Stochastic Oscillator values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_sr(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate %K of Stochastic Oscillator
        :param int signal_period: The number of observations, per period, to calculate the %D (the Simple Moving Average of %K) as a signal line for Stochastic Oscillator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityStochasticOscillator
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_sr_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_sr_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_sr_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Stochastic Oscillator  # noqa: E501

        Returns the Stochastic Oscillator values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_sr_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate %K of Stochastic Oscillator
        :param int signal_period: The number of observations, per period, to calculate the %D (the Simple Moving Average of %K) as a signal line for Stochastic Oscillator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityStochasticOscillator
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'signal_period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_sr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_sr`")  # noqa: E501

        if 'period' in params and params['period'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_sr`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'signal_period' in params and params['signal_period'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `signal_period` when calling `get_security_price_technicals_sr`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_sr`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'signal_period' in params:
            query_params.append(('signal_period', params['signal_period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/sr', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityStochasticOscillator',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_trix(self, identifier, **kwargs):  # noqa: E501
        """Triple Exponential Average  # noqa: E501

        Returns the Simple Moving Average values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_trix(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Exponential Moving Average for Triple Exponential Average
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityTripleExponentialAverage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_trix_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_trix_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_trix_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Triple Exponential Average  # noqa: E501

        Returns the Simple Moving Average values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_trix_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Exponential Moving Average for Triple Exponential Average
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityTripleExponentialAverage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_trix" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_trix`")  # noqa: E501

        if 'period' in params and params['period'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_trix`, must be a value greater than or equal to `2`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_trix`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/trix', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityTripleExponentialAverage',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_tsi(self, identifier, **kwargs):  # noqa: E501
        """True Strength Index  # noqa: E501

        Returns the True Strength Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_tsi(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int low_period: The number of observations, per period, to calculate low period Exponential Moving Average for smoothing in True Strength Index
        :param int high_period: The number of observations, per period, to calculate high period Exponential Moving Average for smoothing in True Strength Index
        :param str price_key: The Stock Price field to use when calculating True Strength Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityTrueStrengthIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_tsi_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_tsi_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_tsi_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """True Strength Index  # noqa: E501

        Returns the True Strength Index values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_tsi_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int low_period: The number of observations, per period, to calculate low period Exponential Moving Average for smoothing in True Strength Index
        :param int high_period: The number of observations, per period, to calculate high period Exponential Moving Average for smoothing in True Strength Index
        :param str price_key: The Stock Price field to use when calculating True Strength Index
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityTrueStrengthIndex
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'low_period', 'high_period', 'price_key', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_tsi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_tsi`")  # noqa: E501

        if 'low_period' in params and params['low_period'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `low_period` when calling `get_security_price_technicals_tsi`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'high_period' in params and params['high_period'] < 3:  # noqa: E501
            raise ValueError("Invalid value for parameter `high_period` when calling `get_security_price_technicals_tsi`, must be a value greater than or equal to `3`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_tsi`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'low_period' in params:
            query_params.append(('low_period', params['low_period']))  # noqa: E501
        if 'high_period' in params:
            query_params.append(('high_period', params['high_period']))  # noqa: E501
        if 'price_key' in params:
            query_params.append(('price_key', params['price_key']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/tsi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityTrueStrengthIndex',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_uo(self, identifier, **kwargs):  # noqa: E501
        """Ultimate Oscillator  # noqa: E501

        Returns the Ultimate Oscillator values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_uo(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int short_period: The number of observations, per period, to calculate the short period for Ultimate Oscillator
        :param int medium_period: The number of observations, per period, to calculate the medium period for Ultimate Oscillator
        :param int long_period: The number of observations, per period, to calculate the long period for Ultimate Oscillator
        :param float short_weight: The weight of short Buying Pressure average for Ultimate Oscillator
        :param float medium_weight: The weight of medium Buying Pressure average for Ultimate Oscillator
        :param float long_weight: The weight of long Buying Pressure average for Ultimate Oscillator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityUltimateOscillator
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_uo_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_uo_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_uo_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Ultimate Oscillator  # noqa: E501

        Returns the Ultimate Oscillator values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_uo_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int short_period: The number of observations, per period, to calculate the short period for Ultimate Oscillator
        :param int medium_period: The number of observations, per period, to calculate the medium period for Ultimate Oscillator
        :param int long_period: The number of observations, per period, to calculate the long period for Ultimate Oscillator
        :param float short_weight: The weight of short Buying Pressure average for Ultimate Oscillator
        :param float medium_weight: The weight of medium Buying Pressure average for Ultimate Oscillator
        :param float long_weight: The weight of long Buying Pressure average for Ultimate Oscillator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityUltimateOscillator
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'short_period', 'medium_period', 'long_period', 'short_weight', 'medium_weight', 'long_weight', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_uo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_uo`")  # noqa: E501

        if 'long_period' in params and params['long_period'] < 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `long_period` when calling `get_security_price_technicals_uo`, must be a value greater than or equal to `4`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_uo`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'short_period' in params:
            query_params.append(('short_period', params['short_period']))  # noqa: E501
        if 'medium_period' in params:
            query_params.append(('medium_period', params['medium_period']))  # noqa: E501
        if 'long_period' in params:
            query_params.append(('long_period', params['long_period']))  # noqa: E501
        if 'short_weight' in params:
            query_params.append(('short_weight', params['short_weight']))  # noqa: E501
        if 'medium_weight' in params:
            query_params.append(('medium_weight', params['medium_weight']))  # noqa: E501
        if 'long_weight' in params:
            query_params.append(('long_weight', params['long_weight']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/uo', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityUltimateOscillator',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_vi(self, identifier, **kwargs):  # noqa: E501
        """Vortex Indicator  # noqa: E501

        Returns the Vortex Indicator values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_vi(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Vortex Indicator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityVortexIndicator
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_vi_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_vi_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_vi_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Vortex Indicator  # noqa: E501

        Returns the Vortex Indicator values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_vi_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to calculate Vortex Indicator
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityVortexIndicator
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_vi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_vi`")  # noqa: E501

        if 'period' in params and params['period'] < 4:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_vi`, must be a value greater than or equal to `4`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_vi`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/vi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityVortexIndicator',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_vpt(self, identifier, **kwargs):  # noqa: E501
        """Volume-price Trend  # noqa: E501

        Returns the Volume-price Trend values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_vpt(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityVolumePriceTrend
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_vpt_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_vpt_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_vpt_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Volume-price Trend  # noqa: E501

        Returns the Volume-price Trend values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_vpt_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityVolumePriceTrend
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_vpt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_vpt`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_vpt`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/vpt', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityVolumePriceTrend',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_vwap(self, identifier, **kwargs):  # noqa: E501
        """Volume Weighted Average Price  # noqa: E501

        Returns the Volume Weighted Average Price values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_vwap(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityVolumeWeightedAveragePrice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_vwap_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_vwap_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_vwap_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Volume Weighted Average Price  # noqa: E501

        Returns the Volume Weighted Average Price values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_vwap_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityVolumeWeightedAveragePrice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_vwap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_vwap`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_vwap`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/vwap', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityVolumeWeightedAveragePrice',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_technicals_wr(self, identifier, **kwargs):  # noqa: E501
        """Williams %R  # noqa: E501

        Returns the Williams %R values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_wr(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to look-back when calculating Williams %R
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param float page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityWilliamsR
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_price_technicals_wr_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_technicals_wr_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_price_technicals_wr_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Williams %R  # noqa: E501

        Returns the Williams %R values of Stock Prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_price_technicals_wr_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int period: The number of observations, per period, to look-back when calculating Williams %R
        :param str start_date: Return technical indicator values on or after the date
        :param str end_date: Return technical indicator values on or before the date
        :param float page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityWilliamsR
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'period', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_technicals_wr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_price_technicals_wr`")  # noqa: E501

        if 'period' in params and params['period'] < 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `period` when calling `get_security_price_technicals_wr`, must be a value greater than or equal to `5`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_price_technicals_wr`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/technicals/wr', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityWilliamsR',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_realtime_price(self, identifier, **kwargs):  # noqa: E501
        """Realtime Stock Price for Security  # noqa: E501

        Return the realtime stock price for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_realtime_price(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str source: Return the realtime price from the specified data source. If no source is specified, the best source available is used.
        :return: RealtimeStockPrice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_realtime_price_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_realtime_price_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_realtime_price_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Realtime Stock Price for Security  # noqa: E501

        Return the realtime stock price for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_realtime_price_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str source: Return the realtime price from the specified data source. If no source is specified, the best source available is used.
        :return: RealtimeStockPrice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'source']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_realtime_price" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_realtime_price`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'source' in params:
            query_params.append(('source', params['source']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/realtime', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RealtimeStockPrice',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_stock_price_adjustments(self, identifier, **kwargs):  # noqa: E501
        """Stock Price Adjustments by Security  # noqa: E501

        Returns stock price adjustments for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_stock_price_adjustments(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param date start_date: Return price adjustments on or after the date
        :param date end_date: Return price adjustments on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityStockPriceAdjustments
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_stock_price_adjustments_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_stock_price_adjustments_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_stock_price_adjustments_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Stock Price Adjustments by Security  # noqa: E501

        Returns stock price adjustments for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_stock_price_adjustments_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param date start_date: Return price adjustments on or after the date
        :param date end_date: Return price adjustments on or before the date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityStockPriceAdjustments
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_stock_price_adjustments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_stock_price_adjustments`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_stock_price_adjustments`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices/adjustments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityStockPriceAdjustments',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_stock_prices(self, identifier, **kwargs):  # noqa: E501
        """Stock Prices by Security  # noqa: E501

        Return end-of-day stock prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_stock_prices(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param date start_date: Return prices on or after the date
        :param date end_date: Return prices on or before the date
        :param str frequency: Return stock prices in the given frequency
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityStockPrices
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_stock_prices_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_stock_prices_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_stock_prices_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Stock Prices by Security  # noqa: E501

        Return end-of-day stock prices for the Security with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_stock_prices_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param date start_date: Return prices on or after the date
        :param date end_date: Return prices on or before the date
        :param str frequency: Return stock prices in the given frequency
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityStockPrices
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'start_date', 'end_date', 'frequency', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_stock_prices" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_stock_prices`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_stock_prices`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'frequency' in params:
            query_params.append(('frequency', params['frequency']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/prices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityStockPrices',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_zacks_analyst_ratings(self, identifier, **kwargs):  # noqa: E501
        """Zacks Analyst Ratings for Security  # noqa: E501

        This database offers consensus analyst recommendations for over 5,000 US and Canadian listed companies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_zacks_analyst_ratings(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Limit ratings to those on or after this date
        :param str end_date: Limit ratings to those on or before this date
        :param float mean_greater: Return only records with a mean (average) higher than this value
        :param float mean_less: Return only records with a mean (average) lower than this value
        :param int strong_buys_greater: Return only records with more than this many Strong Buy recommendations
        :param int strong_buys_less: Return only records with fewer than this many Strong Buy recommendations
        :param int buys_greater: Return only records with more than this many Buy recommendations
        :param int buys_less: Return only records with fewer than this many Buy recommendations
        :param int holds_greater: Return only records with more than this many Hold recommendations
        :param int holds_less: Return only records with fewer than this many Hold recommendations
        :param int sells_greater: Return only records with more than this many Sell recommendations
        :param int sells_less: Return only records with fewer than this many Sell recommendations
        :param int strong_sells_greater: Return only records with more than this many Strong Sell recommendations
        :param int strong_sells_less: Return only records with fewer than this many Strong Sell recommendations
        :param int total_greater: Return only records with more than this many recommendations, regardless of type
        :param int total_less: Return only records with fewer than this many recommendations, regardless of type
        :param int page_size: The number of results to return
        :return: ApiResponseSecurityZacksAnalystRatings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_zacks_analyst_ratings_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_zacks_analyst_ratings_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_zacks_analyst_ratings_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Zacks Analyst Ratings for Security  # noqa: E501

        This database offers consensus analyst recommendations for over 5,000 US and Canadian listed companies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_zacks_analyst_ratings_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str start_date: Limit ratings to those on or after this date
        :param str end_date: Limit ratings to those on or before this date
        :param float mean_greater: Return only records with a mean (average) higher than this value
        :param float mean_less: Return only records with a mean (average) lower than this value
        :param int strong_buys_greater: Return only records with more than this many Strong Buy recommendations
        :param int strong_buys_less: Return only records with fewer than this many Strong Buy recommendations
        :param int buys_greater: Return only records with more than this many Buy recommendations
        :param int buys_less: Return only records with fewer than this many Buy recommendations
        :param int holds_greater: Return only records with more than this many Hold recommendations
        :param int holds_less: Return only records with fewer than this many Hold recommendations
        :param int sells_greater: Return only records with more than this many Sell recommendations
        :param int sells_less: Return only records with fewer than this many Sell recommendations
        :param int strong_sells_greater: Return only records with more than this many Strong Sell recommendations
        :param int strong_sells_less: Return only records with fewer than this many Strong Sell recommendations
        :param int total_greater: Return only records with more than this many recommendations, regardless of type
        :param int total_less: Return only records with fewer than this many recommendations, regardless of type
        :param int page_size: The number of results to return
        :return: ApiResponseSecurityZacksAnalystRatings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'start_date', 'end_date', 'mean_greater', 'mean_less', 'strong_buys_greater', 'strong_buys_less', 'buys_greater', 'buys_less', 'holds_greater', 'holds_less', 'sells_greater', 'sells_less', 'strong_sells_greater', 'strong_sells_less', 'total_greater', 'total_less', 'page_size']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_zacks_analyst_ratings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_zacks_analyst_ratings`")  # noqa: E501

        if 'mean_greater' in params and params['mean_greater'] > 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `mean_greater` when calling `get_security_zacks_analyst_ratings`, must be a value less than or equal to `5`")  # noqa: E501
        if 'mean_greater' in params and params['mean_greater'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `mean_greater` when calling `get_security_zacks_analyst_ratings`, must be a value greater than or equal to `1`")  # noqa: E501
        if 'mean_less' in params and params['mean_less'] > 5:  # noqa: E501
            raise ValueError("Invalid value for parameter `mean_less` when calling `get_security_zacks_analyst_ratings`, must be a value less than or equal to `5`")  # noqa: E501
        if 'mean_less' in params and params['mean_less'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `mean_less` when calling `get_security_zacks_analyst_ratings`, must be a value greater than or equal to `1`")  # noqa: E501
        if 'strong_buys_greater' in params and params['strong_buys_greater'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `strong_buys_greater` when calling `get_security_zacks_analyst_ratings`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'strong_buys_less' in params and params['strong_buys_less'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `strong_buys_less` when calling `get_security_zacks_analyst_ratings`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'buys_greater' in params and params['buys_greater'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `buys_greater` when calling `get_security_zacks_analyst_ratings`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'buys_less' in params and params['buys_less'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `buys_less` when calling `get_security_zacks_analyst_ratings`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'holds_greater' in params and params['holds_greater'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `holds_greater` when calling `get_security_zacks_analyst_ratings`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'holds_less' in params and params['holds_less'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `holds_less` when calling `get_security_zacks_analyst_ratings`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'sells_greater' in params and params['sells_greater'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `sells_greater` when calling `get_security_zacks_analyst_ratings`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'sells_less' in params and params['sells_less'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `sells_less` when calling `get_security_zacks_analyst_ratings`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'strong_sells_greater' in params and params['strong_sells_greater'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `strong_sells_greater` when calling `get_security_zacks_analyst_ratings`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'strong_sells_less' in params and params['strong_sells_less'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `strong_sells_less` when calling `get_security_zacks_analyst_ratings`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'total_greater' in params and params['total_greater'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `total_greater` when calling `get_security_zacks_analyst_ratings`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'total_less' in params and params['total_less'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `total_less` when calling `get_security_zacks_analyst_ratings`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_zacks_analyst_ratings`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'mean_greater' in params:
            query_params.append(('mean_greater', params['mean_greater']))  # noqa: E501
        if 'mean_less' in params:
            query_params.append(('mean_less', params['mean_less']))  # noqa: E501
        if 'strong_buys_greater' in params:
            query_params.append(('strong_buys_greater', params['strong_buys_greater']))  # noqa: E501
        if 'strong_buys_less' in params:
            query_params.append(('strong_buys_less', params['strong_buys_less']))  # noqa: E501
        if 'buys_greater' in params:
            query_params.append(('buys_greater', params['buys_greater']))  # noqa: E501
        if 'buys_less' in params:
            query_params.append(('buys_less', params['buys_less']))  # noqa: E501
        if 'holds_greater' in params:
            query_params.append(('holds_greater', params['holds_greater']))  # noqa: E501
        if 'holds_less' in params:
            query_params.append(('holds_less', params['holds_less']))  # noqa: E501
        if 'sells_greater' in params:
            query_params.append(('sells_greater', params['sells_greater']))  # noqa: E501
        if 'sells_less' in params:
            query_params.append(('sells_less', params['sells_less']))  # noqa: E501
        if 'strong_sells_greater' in params:
            query_params.append(('strong_sells_greater', params['strong_sells_greater']))  # noqa: E501
        if 'strong_sells_less' in params:
            query_params.append(('strong_sells_less', params['strong_sells_less']))  # noqa: E501
        if 'total_greater' in params:
            query_params.append(('total_greater', params['total_greater']))  # noqa: E501
        if 'total_less' in params:
            query_params.append(('total_less', params['total_less']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/zacks/analyst_ratings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityZacksAnalystRatings',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_zacks_analyst_ratings_snapshot(self, identifier, **kwargs):  # noqa: E501
        """Zacks Analyst Ratings Snapshot  # noqa: E501

        This database offers current and historical consensus analyst recommendation snapshots for over 5,000 US and Canadian listed companies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_zacks_analyst_ratings_snapshot(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str date: Lookup a historical snapshot on the given date
        :return: ApiResponseSecurityZacksAnalystRatingsSnapshot
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_zacks_analyst_ratings_snapshot_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_zacks_analyst_ratings_snapshot_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_zacks_analyst_ratings_snapshot_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Zacks Analyst Ratings Snapshot  # noqa: E501

        This database offers current and historical consensus analyst recommendation snapshots for over 5,000 US and Canadian listed companies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_zacks_analyst_ratings_snapshot_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param str date: Lookup a historical snapshot on the given date
        :return: ApiResponseSecurityZacksAnalystRatingsSnapshot
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'date']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_zacks_analyst_ratings_snapshot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_zacks_analyst_ratings_snapshot`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'date' in params:
            query_params.append(('date', params['date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/zacks/analyst_ratings/snapshot', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityZacksAnalystRatingsSnapshot',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_zacks_eps_surprises(self, identifier, **kwargs):  # noqa: E501
        """Zacks EPS Surprises for Security  # noqa: E501

        Returns historical estimated and actual earnings, guidance, and announcement dates for a specified symbol.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_zacks_eps_surprises(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityZacksEPSSurprises
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_zacks_eps_surprises_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_zacks_eps_surprises_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_zacks_eps_surprises_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Zacks EPS Surprises for Security  # noqa: E501

        Returns historical estimated and actual earnings, guidance, and announcement dates for a specified symbol.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_zacks_eps_surprises_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityZacksEPSSurprises
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_zacks_eps_surprises" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_zacks_eps_surprises`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_zacks_eps_surprises`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/zacks/eps_surprises', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityZacksEPSSurprises',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_zacks_sales_surprises(self, identifier, **kwargs):  # noqa: E501
        """Zacks Sales Surprises for Security  # noqa: E501

        This database returns historical estimated and actual sales, guidance, and announcement dates for a specified US or Canadian company.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_zacks_sales_surprises(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityZacksSalesSurprises
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_security_zacks_sales_surprises_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_zacks_sales_surprises_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_security_zacks_sales_surprises_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Zacks Sales Surprises for Security  # noqa: E501

        This database returns historical estimated and actual sales, guidance, and announcement dates for a specified US or Canadian company.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_security_zacks_sales_surprises_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Security identifier (Ticker, FIGI, ISIN, CUSIP, Intrinio ID) (required)
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseSecurityZacksSalesSurprises
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_zacks_sales_surprises" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_security_zacks_sales_surprises`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_security_zacks_sales_surprises`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/{identifier}/zacks/sales_surprises', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecurityZacksSalesSurprises',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def screen_securities(self, **kwargs):  # noqa: E501
        """Screen Securities  # noqa: E501

        Screen Securities using complex logic. Use POST only. See <a href=\"https://docs.intrinio.com/documentation/screener_v2\" target=\"_blank\">screener documentation</a> for details on how to construct conditions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.screen_securities(_async=True)
        >>> result = thread.get()

        :param async bool
        :param SecurityScreenGroup logic: The logic to screen with, consisting of operators, clauses, and nested groups. </br> See <a href=\"https://docs.intrinio.com/documentation/screener_v2\" target=\"_blank\">screener documentation</a> for details on how to construct conditions.
        :param str order_column: Results returned sorted by this column
        :param str order_direction: Sort order to use with the order_column
        :param bool primary_only: Return only primary securities
        :param int page_size: The number of results to return. Maximum for this endpoint is 50000.
        :return: list[SecurityScreenResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.screen_securities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.screen_securities_with_http_info(**kwargs)  # noqa: E501
            return data

    def screen_securities_with_http_info(self, **kwargs):  # noqa: E501
        """Screen Securities  # noqa: E501

        Screen Securities using complex logic. Use POST only. See <a href=\"https://docs.intrinio.com/documentation/screener_v2\" target=\"_blank\">screener documentation</a> for details on how to construct conditions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.screen_securities_with_http_info(_async=True)
        >>> result = thread.get()

        :param async bool
        :param SecurityScreenGroup logic: The logic to screen with, consisting of operators, clauses, and nested groups. </br> See <a href=\"https://docs.intrinio.com/documentation/screener_v2\" target=\"_blank\">screener documentation</a> for details on how to construct conditions.
        :param str order_column: Results returned sorted by this column
        :param str order_direction: Sort order to use with the order_column
        :param bool primary_only: Return only primary securities
        :param int page_size: The number of results to return. Maximum for this endpoint is 50000.
        :return: list[SecurityScreenResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['logic', 'order_column', 'order_direction', 'primary_only', 'page_size']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method screen_securities" % key
                )
            params[key] = val
        del params['kwargs']

        if 'page_size' in params and params['page_size'] > 50000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `screen_securities`, must be a value less than or equal to `50000`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'order_column' in params:
            query_params.append(('order_column', params['order_column']))  # noqa: E501
        if 'order_direction' in params:
            query_params.append(('order_direction', params['order_direction']))  # noqa: E501
        if 'primary_only' in params:
            query_params.append(('primary_only', params['primary_only']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'logic' in params:
            body_params = params['logic']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/screen', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SecurityScreenResult]',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_securities(self, query, **kwargs):  # noqa: E501
        """Search Securities  # noqa: E501

        Searches for Securities matching the text `query`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.search_securities(query, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str query: (required)
        :param int page_size: The number of results to return
        :return: ApiResponseSecuritiesSearch
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.search_securities_with_http_info(query, **kwargs)  # noqa: E501
        else:
            (data) = self.search_securities_with_http_info(query, **kwargs)  # noqa: E501
            return data

    def search_securities_with_http_info(self, query, **kwargs):  # noqa: E501
        """Search Securities  # noqa: E501

        Searches for Securities matching the text `query`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.search_securities_with_http_info(query, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str query: (required)
        :param int page_size: The number of results to return
        :return: ApiResponseSecuritiesSearch
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query', 'page_size']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_securities" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query' is set
        if ('query' not in params or
                params['query'] is None):
            raise ValueError("Missing the required parameter `query` when calling `search_securities`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `search_securities`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/securities/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseSecuritiesSearch',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
